/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.gprsconverter.convert;

import android.text.TextUtils;
import com.xdja.gprsconverter.convert.ConvertInterface;
import com.xdja.gprsconverter.protocol.EntryRequest;
import com.xdja.gprsconverter.protocol.EntryResponse;
import com.xdja.gprsconverter.resolver.EntryResponseResolver;

public class EntryProtocolConvert
implements ConvertInterface<EntryRequest, EntryResponse> {
    @Override
    public String convertBean2XML(EntryRequest entryRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        if (!TextUtils.isEmpty((CharSequence)entryRequest.getAppKey())) {
            sb.append("<AppKey>" + entryRequest.getAppKey() + "</AppKey>");
        }
        sb.append("<ReqType>" + entryRequest.getReqType() + "</ReqType>");
        if (!TextUtils.isEmpty((CharSequence)entryRequest.getVersion())) {
            sb.append("<Version>20130101</Version>");
        }
        sb.append("<Version>20130101</Version>");
        sb.append("<SessionID>" + entryRequest.getSessionID() + "</SessionID>");
        if (TextUtils.isEmpty((CharSequence)entryRequest.getTransactionType())) {
            sb.append("<TransactionType>1</TransactionType>");
        } else {
            sb.append("<TransactionType>" + entryRequest.getTransactionType() + "</TransactionType>");
        }
        sb.append("<Tables>");
        if (entryRequest.getTableList() != null && entryRequest.getTableList().size() > 0) {
            for (EntryRequest.Table table : entryRequest.getTableList()) {
                sb.append("<Table>");
                sb.append("<Name>" + table.getTableName() + "</Name>");
                if (table.isMain()) {
                    sb.append("<IsMain>1</IsMain>");
                } else {
                    sb.append("<IsMain>0</IsMain>");
                }
                if (table.getTableDataList() != null && table.getTableDataList().size() > 0) {
                    for (EntryRequest.TableData tableData : table.getTableDataList()) {
                        sb.append("<Row>");
                        sb.append("<Operate>" + tableData.getOperate() + "</Operate>");
                        if (!TextUtils.isEmpty((CharSequence)tableData.getCondition())) {
                            sb.append("<Condition><![CDATA[" + tableData.getCondition() + "]]></Condition>");
                        }
                        sb.append("<Data>");
                        if (tableData.getEntryDataList() != null && tableData.getEntryDataList().size() > 0) {
                            for (EntryRequest.EntryData entryData : tableData.getEntryDataList()) {
                                if (entryData.isSpecial()) {
                                    sb.append("<" + entryData.getKey() + "><![CDATA[");
                                    sb.append(entryData.getValue());
                                    sb.append("]]></" + entryData.getKey() + ">");
                                    continue;
                                }
                                sb.append("<" + entryData.getKey() + ">");
                                sb.append(entryData.getValue());
                                sb.append("</" + entryData.getKey() + ">");
                            }
                        }
                        sb.append("</Data>");
                        sb.append("</Row>");
                    }
                }
                sb.append("</Table>");
            }
        }
        sb.append("</Tables>");
        sb.append("</Root>");
        return sb.toString();
    }

    @Override
    public EntryResponse convertXML2Bean(String string) {
        return EntryResponseResolver.resolverFromXML(string);
    }
}

