/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.gprsconverter.convert;

import com.xdja.gprsconverter.convert.ChangePwdProtocolConvert;
import com.xdja.gprsconverter.convert.EntryProtocolConvert;
import com.xdja.gprsconverter.convert.LoginProtocolConvert;
import com.xdja.gprsconverter.convert.LogoutProtocolConvert;
import com.xdja.gprsconverter.convert.QueryProtocolConvert;
import com.xdja.gprsconverter.protocol.ChangePwdRequest;
import com.xdja.gprsconverter.protocol.ChangePwdResponse;
import com.xdja.gprsconverter.protocol.EntryRequest;
import com.xdja.gprsconverter.protocol.EntryResponse;
import com.xdja.gprsconverter.protocol.LoginRequest;
import com.xdja.gprsconverter.protocol.LoginResponse;
import com.xdja.gprsconverter.protocol.LogoutRequest;
import com.xdja.gprsconverter.protocol.LogoutResponse;
import com.xdja.gprsconverter.protocol.QueryRequest;
import com.xdja.gprsconverter.protocol.QueryResponse;

public class ConvertFactory {
    public static String generateXML(Object obj) {
        if (obj instanceof QueryRequest) {
            return ConvertFactory.generateQueryXML((QueryRequest)obj);
        }
        if (obj instanceof EntryRequest) {
            return ConvertFactory.generateEntryXML((EntryRequest)obj);
        }
        if (obj instanceof LoginRequest) {
            return ConvertFactory.generateLoginXML((LoginRequest)obj);
        }
        if (obj instanceof LogoutResponse) {
            return ConvertFactory.generateLogoutXML((LogoutRequest)obj);
        }
        if (obj instanceof ChangePwdRequest) {
            return ConvertFactory.generateChangePwdXML((ChangePwdRequest)obj);
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public <T> T parserResponse(String response, Class<T> tClass) {
        Object t = null;
        try {
            t = tClass.newInstance();
            if (t instanceof LoginResponse) {
                t = ConvertFactory.parserLoginResponse(response);
            } else if (t instanceof LogoutResponse) {
                t = ConvertFactory.parserLogoutResponse(response);
            } else if (t instanceof QueryResponse) {
                t = ConvertFactory.parserQueryResponse(response);
            } else if (t instanceof EntryResponse) {
                t = ConvertFactory.parserEnterResponse(response);
            } else if (t instanceof ChangePwdResponse) {
                t = ConvertFactory.parserChangePwdResponse(response);
            } else if (t instanceof String) {
                t = response;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static String generateQueryXML(QueryRequest queryRequest) {
        return new QueryProtocolConvert().convertBean2XML(queryRequest);
    }

    public static String generateEntryXML(EntryRequest entryRequest) {
        return new EntryProtocolConvert().convertBean2XML(entryRequest);
    }

    public static String generateChangePwdXML(ChangePwdRequest changePwdRequest) {
        return new ChangePwdProtocolConvert().convertBean2XML(changePwdRequest);
    }

    public static String generateLoginXML(LoginRequest loginRequest) {
        return new LoginProtocolConvert().convertBean2XML(loginRequest);
    }

    public static String generateLogoutXML(LogoutRequest logoutRequest) {
        return new LogoutProtocolConvert().convertBean2XML(logoutRequest);
    }

    public static QueryResponse parserQueryResponse(String queryResponse) {
        return new QueryProtocolConvert().convertXML2Bean(queryResponse);
    }

    public static EntryResponse parserEnterResponse(String queryResponse) {
        return new EntryProtocolConvert().convertXML2Bean(queryResponse);
    }

    public static ChangePwdResponse parserChangePwdResponse(String changePwdResponse) {
        return new ChangePwdProtocolConvert().convertXML2Bean(changePwdResponse);
    }

    public static LoginResponse parserLoginResponse(String loginResponse) {
        return new LoginProtocolConvert().convertXML2Bean(loginResponse);
    }

    public static LogoutResponse parserLogoutResponse(String logoutResponse) {
        return new LogoutProtocolConvert().convertXML2Bean(logoutResponse);
    }
}

