/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.gprsconverter.protocol;

import android.support.annotation.NonNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class EntryRequest
implements Serializable {
    private String appKey;
    private String policeNo;
    private String reqType;
    private String sessionID;
    private String version;
    private String transactionType;
    private List<Table> tableList;

    public String getPoliceNo() {
        return this.policeNo;
    }

    public void setPoliceNo(String policeNo) {
        this.policeNo = policeNo;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getReqType() {
        return this.reqType;
    }

    public void setReqType(@NonNull String reqType) {
        this.reqType = reqType;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(@NonNull String sessionID) {
        this.sessionID = sessionID;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public List<Table> getTableList() {
        return this.tableList;
    }

    @Deprecated
    private void setTableList(List<Table> tableList) {
        this.tableList = tableList;
    }

    public void addTable(@NonNull String tableName, boolean isMain, List<TableData> tableDataList) {
        if (this.tableList == null) {
            this.tableList = new ArrayList<Table>();
        }
        Table table = new Table();
        table.setTableName(tableName);
        table.setMain(isMain);
        table.setTableDataList(tableDataList);
        this.tableList.add(table);
    }

    public static class EntryData
    implements Serializable {
        private String key;
        private String value;
        private boolean isSpecial;

        public EntryData() {
        }

        public EntryData(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public EntryData(@NonNull String key, @NonNull String value, boolean isSpecial) {
            this.key = key;
            this.value = value;
            this.isSpecial = isSpecial;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isSpecial() {
            return this.isSpecial;
        }

        public void setSpecial(boolean special) {
            this.isSpecial = special;
        }
    }

    public static class TableData
    implements Serializable {
        private String operate;
        private String condition;
        private List<EntryData> entryDataList;

        public TableData(String operate) {
            this.operate = operate;
        }

        public String getOperate() {
            return this.operate;
        }

        public void setOperate(@NonNull String operate) {
            this.operate = operate;
        }

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public List<EntryData> getEntryDataList() {
            return this.entryDataList;
        }

        public void addEntryData(@NonNull String key, @NonNull String value) {
            this.addEntryData(key, value, false);
        }

        public void addEntryData(@NonNull String key, @NonNull String value, boolean isSpecial) {
            if (this.entryDataList == null) {
                this.entryDataList = new ArrayList<EntryData>();
            }
            this.entryDataList.add(new EntryData(key, value, isSpecial));
        }

        public void addSpecialEntryData(@NonNull String key, @NonNull String value) {
            this.addEntryData(key, value, true);
        }

        public void addEntryDataList(@NonNull List<EntryData> entryDataList) {
            if (entryDataList == null) {
                entryDataList = new ArrayList<EntryData>();
            }
            entryDataList.addAll(entryDataList);
        }

        public void setEntryDataList(@NonNull List<EntryData> entryDataList) {
            this.entryDataList = entryDataList;
        }
    }

    public static class Table
    implements Serializable {
        private String tableName;
        private boolean isMain;
        private List<TableData> tableDataList;

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public boolean isMain() {
            return this.isMain;
        }

        public void setMain(boolean main) {
            this.isMain = main;
        }

        public List<TableData> getTableDataList() {
            return this.tableDataList;
        }

        public void setTableDataList(List<TableData> tableDataList) {
            this.tableDataList = tableDataList;
        }
    }
}

