package com.xdja.gprsconverter.convert;

import android.text.TextUtils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xdja.gprsconverter.extension.LoginExtension;
import com.xdja.gprsconverter.protocol.LoginFailBean;
import com.xdja.gprsconverter.protocol.LoginRequest;
import com.xdja.gprsconverter.protocol.LoginResponse;
import com.xdja.gprsconverter.resolver.XMLResolver;

import java.util.List;

/**
 *
 * @author Guojie
 * @date 2017/8/31
 */

public class LoginProtocolConvert implements ConvertInterface<LoginRequest, LoginResponse> {

    @Override
    public String convertBean2XML(LoginRequest loginRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        if (!TextUtils.isEmpty(loginRequest.getPoliceNo())){
            sb.append("<PoliceNo>" + loginRequest.getPoliceNo() + "</PoliceNo>");
        }
        sb.append("<ReqType>" + loginRequest.getReqType() + "</ReqType>");
        sb.append("<ValidateType>" + loginRequest.getValiDataType() + "</ValidateType>");
        sb.append("<ValidateValue><![CDATA[" + loginRequest.getValiDataValue() + "]]>" + "</ValidateValue>");
        if (!TextUtils.isEmpty(loginRequest.getValiDataPass())) {
            sb.append("<ValidatePass>" + loginRequest.getValiDataPass() + "</ValidatePass>");
        } else {
            sb.append("<ValidatePass></ValidatePass>");
        }
        sb.append("<CurrentVersion>" + loginRequest.getCurrentVersion() + "</CurrentVersion>");
        sb.append("<ClientType>" + loginRequest.getClientType() + "</ClientType>");
        sb.append("<CardType>" + loginRequest.getCardType() + "</CardType>");
        sb.append("<IMSI>" + loginRequest.getImsi() + "</IMSI>");
        sb.append("<IMEI>" + loginRequest.getImei() + "</IMEI>");
        if (!TextUtils.isEmpty(loginRequest.getIccid())) {
            sb.append("<ICCID>" + loginRequest.getIccid() + "</ICCID>");
        }
        if (TextUtils.isEmpty(loginRequest.getPver())) {
            sb.append("<Pver>20140501</Pver>");
        } else {
            sb.append("<Pver>" + loginRequest.getPver() + "</Pver>");
        }
        if (!TextUtils.isEmpty(loginRequest.getAppKey())){
            sb.append("<AppKey>"+loginRequest.getAppKey()+"</AppKey>");
        }
        if (!TextUtils.isEmpty(loginRequest.getReqDigest())){
            sb.append("<ReqDigest>" + loginRequest.getReqDigest() + "</ReqDigest>");
        }
        sb.append("</Root>");
        return sb.toString();
    }

    @Override
    public LoginResponse convertXML2Bean(String string) {
        XMLResolver xmlResolver = new XMLResolver(string);
        if (xmlResolver.getDoc() != null) {
            LoginResponse loginResponse = new LoginResponse();
            loginResponse.setResponse(string);
            loginResponse.setPower(xmlResolver.getElementValue(LoginExtension.LoginField.POWER));
            loginResponse.setUnitsCoding(xmlResolver.getElementValue(LoginExtension.LoginField.UNITSCODING));
            loginResponse.setPoliceName(xmlResolver.getElementValue(LoginExtension.LoginField.POLICENAME));
            loginResponse.setUnitName(xmlResolver.getElementValue(LoginExtension.LoginField.UNITNAME));
            loginResponse.setMobileNo(xmlResolver.getElementValue(LoginExtension.LoginField.MOBILENO));
            loginResponse.setPoliceID(xmlResolver.getElementValue(LoginExtension.LoginField.POLICEID));
            loginResponse.setPoliceNo(xmlResolver.getElementValue(LoginExtension.LoginField.POLICENO));
            loginResponse.setIdCard(xmlResolver.getElementValue(LoginExtension.LoginField.IDCARD));
            loginResponse.setSessionID(xmlResolver.getElementValue(LoginExtension.LoginField.SESSIONID));
            loginResponse.setMonth3Pwd("0".equals(xmlResolver.getElementValue(LoginExtension.LoginField.MONTH3WPD)));
            loginResponse.setDateTime(xmlResolver.getElementValue(LoginExtension.LoginField.DATETIME));
            loginResponse.setLimits(xmlResolver.getElementValue(LoginExtension.LoginField.LIMITS));
            loginResponse.setAuxiliaryPoliceLeader(xmlResolver.getElementValue(LoginExtension.LoginField.XJSSJH));
            loginResponse.setLastLoginTime(xmlResolver.getElementValue(LoginExtension.LoginField.LAST_LOGIN_TIME));
            loginResponse.setLastLoginSource(xmlResolver.getElementValue(LoginExtension.LoginField.LAST_LOGIN_SOURCE));
            loginResponse.setLoginSource(xmlResolver.getElementValue(LoginExtension.LoginField.LOGIN_SOURCE));
            List<LoginFailBean> loginFailBeanList=new Gson().fromJson(xmlResolver.getElementValue(LoginExtension.LoginField.LAST_LOGIN_FAIL_LOG),
                    new TypeToken<List<LoginFailBean>>(){}.getType());
            loginResponse.setLastLoginFailLog(loginFailBeanList);
            loginResponse.setUserNameExpireDays(xmlResolver.getElementValue(LoginExtension.LoginField.USNER_NAME_EXPIRE_DAYS));
            loginResponse.setPwdExpireDays(xmlResolver.getElementValue(LoginExtension.LoginField.PWD_EXPIRE_DAYS));
            return loginResponse;
        }
        return null;
    }
}
