package com.xdja.gprsconverter.convert;

import android.text.TextUtils;
import android.util.Log;

import com.xdja.gprsconverter.protocol.LogoutRequest;
import com.xdja.gprsconverter.protocol.LogoutResponse;

/**
 * Created by Guojie on 2017/8/31.
 */

public class LogoutProtocolConvert implements ConvertInterface<LogoutRequest, LogoutResponse> {


    @Override
    public String convertBean2XML(LogoutRequest logoutRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        if (!TextUtils.isEmpty(logoutRequest.getAppKey())){
            sb.append("<AppKey>" + logoutRequest.getAppKey() + "</AppKey>");
        }
        if (!TextUtils.isEmpty(logoutRequest.getReqDigest())){
            sb.append("<ReqDigest>" + logoutRequest.getReqDigest() + "</ReqDigest>");
        }
        if (!TextUtils.isEmpty(logoutRequest.getPoliceNo())){
            sb.append("<PoliceNo>" + logoutRequest.getPoliceNo() + "</PoliceNo>");
        }
        sb.append("<ReqType>" + logoutRequest.getReqType() + "</ReqType>");
        sb.append("<SessionID>" + logoutRequest.getSessionID() + "</SessionID>");
        sb.append("</Root>");
        return sb.toString();
    }

    @Override
    public LogoutResponse convertXML2Bean(String string) {
        if (!TextUtils.isEmpty(string) && string.equals(LogoutResponse.SUCCESS)) {
            return new LogoutResponse(true);
        } else {
            return new LogoutResponse(false);
        }
    }
}
