package com.xdja.gprsconverter.convert;

import android.text.TextUtils;

import com.xdja.gprsconverter.protocol.QueryRequest;
import com.xdja.gprsconverter.protocol.QueryResponse;
import com.xdja.gprsconverter.resolver.QueryResponseResolver;

/**
 * Created by Guojie on 2017/8/28.
 */

public class QueryProtocolConvert implements ConvertInterface<QueryRequest, QueryResponse> {

    @Override
    public String convertBean2XML(QueryRequest queryRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        if (!TextUtils.isEmpty(queryRequest.getAppKey())){
            sb.append("<AppKey>" + queryRequest.getAppKey() + "</AppKey>");
        }
        if (!TextUtils.isEmpty(queryRequest.getReqDigest())){
            sb.append("<ReqDigest>" + queryRequest.getReqDigest() + "</ReqDigest>");
        }
        if (!TextUtils.isEmpty(queryRequest.getPoliceNo())){
            sb.append("<PoliceNo>" + queryRequest.getPoliceNo() + "</PoliceNo>");
        }
        sb.append("<ReqType>" + queryRequest.getReqType() + "</ReqType>");
        sb.append("<SessionID>" + queryRequest.getSessionID() + "</SessionID>");
        if (TextUtils.isEmpty(queryRequest.getBeginNo())) {
            sb.append("<BeginNo>1</BeginNo>");
        } else {
            sb.append("<BeginNo>" + queryRequest.getBeginNo() + "</BeginNo>");
        }
        if (!TextUtils.isEmpty(queryRequest.getReqTable())) {
            sb.append("<ReqTable>" + queryRequest.getReqTable() + "</ReqTable>");
        }
        if (!TextUtils.isEmpty(queryRequest.getFieldList())) {
            sb.append("<FieldList>" + queryRequest.getFieldList() + "</FieldList>");
        }
        if (TextUtils.isEmpty(queryRequest.getDataSource())) {
            sb.append("<DataSource>1</DataSource>");
        } else {
            sb.append("<DataSource>" + queryRequest.getDataSource() + "</DataSource>");
        }
        sb.append("<Condition>");
        if (!TextUtils.isEmpty(queryRequest.getCondation())){
            //关联查询
            if (queryRequest.isRelation()){
                sb.append("<![CDATA["+queryRequest.getCondation()+"]]>");
            }else {
                sb.append(queryRequest.getCondation());
            }
        }else {
            if (queryRequest.getConditionList() != null && queryRequest.getConditionList().size() > 0) {
                for (QueryRequest.Condition condition : queryRequest.getConditionList()) {
                    sb.append("<" + condition.getKey());
                    if (!TextUtils.isEmpty(condition.getType())) {
                        sb.append(" Type='" + condition.getType() + "'");
                    }
                    if (!TextUtils.isEmpty(condition.getRelation())) {
                        sb.append(" Relation='" + condition.getRelation() + "'");
                    }
                    if (!TextUtils.isEmpty(condition.getSplitJoint())) {
                        sb.append(" SplitJoint='" + condition.getSplitJoint() + "'");
                    }
                    sb.append(">");
                    sb.append(condition.getValue());
                    sb.append("</" + condition.getKey() + ">");
                }
            } else {
                sb.append("1=1");
            }
        }
        sb.append("</Condition>");
        if (queryRequest.getOrder() != null) {
            sb.append("<Order>");
            QueryRequest.Order order = queryRequest.getOrder();
            if (!TextUtils.isEmpty(order.getAsc())) {
                sb.append("<asc>" + order.getAsc() + "</asc>");
            }
            if (!TextUtils.isEmpty(order.getDesc())) {
                sb.append("<desc>" + order.getDesc() + "</desc>");
            }
            if (!TextUtils.isEmpty(order.getMix())) {
                sb.append("<mix>" + order.getMix() + "</mix>");
            }
            sb.append("</Order>");
        }

        sb.append("</Root>");
        return sb.toString();
    }

    @Override
    public QueryResponse convertXML2Bean(String string) {
        return QueryResponseResolver.resolverFromXML(string);
    }
}
