package com.xdja.gprsconverter.protocol;

import android.support.annotation.NonNull;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 录入请求协议
 */

public class EntryRequest implements Serializable {

    /**
     * 应用ID，对接集中管控
     */
    private String appKey;
    /**
     * 摘要，对接集中管控
     */
    private String reqDigest;

    private String policeNo;
    /**
     * 请求类别,不能为空
     */
    private String reqType;
    /**
     * 回话ID，不能为空
     */
    private String sessionID;
    /**
     * 协议版本
     */
    private String version;
    /**
     * 业务类型，一般为1
     */
    private String transactionType;

    /**
     * 操作表及数据list
     */
    private List<Table> tableList;

    public String getPoliceNo() {
        return policeNo;
    }

    public void setPoliceNo(String policeNo) {
        this.policeNo = policeNo;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getReqType() {
        return reqType;
    }

    public void setReqType(@NonNull String reqType) {
        this.reqType = reqType;
    }

    public String getSessionID() {
        return sessionID;
    }

    public void setSessionID(@NonNull String sessionID) {
        this.sessionID = sessionID;
    }

    public String getTransactionType() {
        return transactionType;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getReqDigest() {
        return reqDigest;
    }

    public void setReqDigest(String reqDigest) {
        this.reqDigest = reqDigest;
    }

    /**
     * 不知道这个是干嘛用的，建议不要设置该值
     *
     * @param transactionType
     */
    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public List<Table> getTableList() {
        return tableList;
    }

    /**
     * 一般情况下一个请求类别不会只会操作一到两个表，为了方便构造数据
     * 统一使用{@link #addTable(String, boolean, List)}方法添加数据
     *
     * @param tableList 操作表list
     */
    @Deprecated
    private void setTableList(List<Table> tableList) {
        this.tableList = tableList;
    }

    /**
     * 添加要操作的表信息，及数据
     *
     * @param tableName     要操作的表名称
     * @param isMain        是否是主表，同时添加多个表操作，只允许其中一个表示主表
     * @param tableDataList 插入，删除，更新操作的数据list
     */
    public void addTable(@NonNull String tableName, boolean isMain, List<TableData> tableDataList) {
        if (tableList == null) {
            tableList = new ArrayList<>();
        }
        Table table = new Table();
        table.setTableName(tableName);
        table.setMain(isMain);
        table.setTableDataList(tableDataList);
        tableList.add(table);
    }

    /**
     * 要操作的表信息
     */
    public static class Table implements Serializable{
        /**
         * 表名称
         */
        private String tableName;
        /**
         * 是否是主表
         */
        private boolean isMain;
        /**
         * 存放要插入，删除，更新操作的数据list
         */
        private List<TableData> tableDataList;

        public String getTableName() {
            return tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public boolean isMain() {
            return isMain;
        }

        public void setMain(boolean main) {
            isMain = main;
        }

        public List<TableData> getTableDataList() {
            return tableDataList;
        }

        public void setTableDataList(List<TableData> tableDataList) {
            this.tableDataList = tableDataList;
        }
    }

    /**
     * 对用数据库表中的一条数据
     * 更新操作dataList数据不能为空，condition可为空
     * 删除、更新操作，dataList数据可以是空的，但是condition条件不能为空
     */
    public static class TableData implements Serializable{
        /**
         * 操作类型
         */
        private String operate;
        /**
         * 操作条件，例如：c_xm='张三' and c_xb='1'
         */
        private String condition;
        /**
         * 存放操作数据，一个Data代表数据库中一条数据某一列的中的值
         */
        private List<EntryData> entryDataList;

        public TableData(String operate) {
            this.operate = operate;
        }

        public String getOperate() {
            return operate;
        }

        /**
         * 设置操作类型，其值必须为{@link com.xdja.gprsconverter.extension.OperateExtension}中的值
         *
         * @param operate
         */
        public void setOperate(@NonNull String operate) {
            this.operate = operate;
        }

        public String getCondition() {
            return condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public List<EntryData> getEntryDataList() {
            return entryDataList;
        }

        /**
         * 将数据为vaule，添加到column名为key的一条数据中
         *
         * @param key   对应数据库中column名称
         * @param value column中存放的数据
         */
        public void addEntryData(@NonNull String key, @NonNull String value) {
            addEntryData(key, value, false);
        }

        /**
         * 将数据为vaule，添加到column名为key的一条数据中
         *
         * @param key       对应数据库中column名称
         * @param value     column中存放的数据
         * @param isSpecial 包含特殊字符的字段，需要使用CDATA包含的数据
         */
        public void addEntryData(@NonNull String key, @NonNull String value, boolean isSpecial) {
            if (entryDataList == null) {
                entryDataList = new ArrayList<>();
            }
            entryDataList.add(new EntryData(key, value, isSpecial));
        }

        /**
         * 添加一个包含特殊字符的字段，需要使用CDATA包含的数据
         *
         * @param key   对应数据库中column名称
         * @param value column中存放的数据
         */
        public void addSpecialEntryData(@NonNull String key, @NonNull String value) {
            addEntryData(key, value, true);
        }

        /**
         * 添加一个dataList列表，不会清除掉通过{@link #addEntryData(String, String)}
         * 方法添加的数据
         *
         * @param entryDataList
         */
        public void addEntryDataList(@NonNull List<EntryData> entryDataList) {
            if (this.entryDataList == null) {
                this.entryDataList = new ArrayList<>();
            }
            this.entryDataList.addAll(entryDataList);
        }

        /**
         * 添加一个dataList列表，会清除掉通过{@link #addEntryData(String, String)}
         * 方法添加的数据
         *
         * @param entryDataList
         */
        public void setEntryDataList(@NonNull List<EntryData> entryDataList) {
            this.entryDataList = entryDataList;
        }
    }

    /**
     * 代表一个字段，若{@link #isSpecial 为true，该字段需要使用CADTA包含}
     */
    public static class EntryData implements Serializable{
        /**
         * 字段key
         */
        private String key;
        /**
         * 字段值
         */
        private String value;
        /**
         * 是否包含特殊字符
         */
        private boolean isSpecial;

        public EntryData() {

        }

        /**
         * 构造函数
         *
         * @param key   字段key
         * @param value 字段值
         */
        public EntryData(String key, String value) {
            this.key = key;
            this.value = value;
        }

        /**
         * 构造函数
         *
         * @param key       字段key
         * @param value     字段值
         * @param isSpecial 是否包含特殊字符
         */
        public EntryData(@NonNull String key, @NonNull String value, boolean isSpecial) {
            this.key = key;
            this.value = value;
            this.isSpecial = isSpecial;
        }

        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isSpecial() {
            return isSpecial;
        }

        public void setSpecial(boolean special) {
            isSpecial = special;
        }
    }
}
