package com.xdja.gprsconverter.protocol;

import java.io.Serializable;
import java.util.List;

/**
 * 登录返回协议
 */

public class LoginResponse implements Serializable {
    private String response;
    /**
     * 会话id
     */
    private String sessionID;
    /**
     * 警号
     */
    private String policeNo;
    /**
     * 单位编码
     */
    private String unitsCoding;
    /**
     * 手机号
     */
    private String mobileNo;
    /**
     * 模块权限，以警号分隔
     */
    private String power;
    /**
     * 密码
     */
    private String password;
    /**
     * 服务器当前时间 yyyy-MM-dd HH:mm:ss
     */
    private String dateTime;
    /**
     * 警员身份证号
     */
    private String idCard;
    /**
     * 警员姓名
     */
    private String policeName;
    /**
     * 警员id
     */
    private String policeID;
    /**
     * 单位名称
     */
    private String unitName;
    /**
     * 三个月份是否修改了密码
     */
    private boolean month3Pwd;
    /**
     * 应用权限
     */
    private String limits;
    /**
     * 协警上级警号
     */
    private String auxiliaryPoliceLeader;
    /**
     * 上次登录成功时间
     */
    private String lastLoginTime;
    private String lastLoginSource;
    /**
     * 登录来源
     */
    private String loginSource;
    /**
     * 上次登录失败情况
     */
    private List<LoginFailBean> lastLoginFailLog;
    /**
     * 用户名到期天数
     */
    private String userNameExpireDays;
    /**
     * 密码距离到期天数
     */
    private String pwdExpireDays;

    public String getSessionID() {
        return sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getPoliceNo() {
        return policeNo;
    }

    public void setPoliceNo(String policeNo) {
        this.policeNo = policeNo;
    }

    public String getUnitsCoding() {
        return unitsCoding;
    }

    public void setUnitsCoding(String unitsCoding) {
        this.unitsCoding = unitsCoding;
    }

    public String getMobileNo() {
        return mobileNo;
    }

    public void setMobileNo(String mobileNo) {
        this.mobileNo = mobileNo;
    }

    public String getPower() {
        return power;
    }

    public void setPower(String power) {
        this.power = power;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDateTime() {
        return dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public String getIdCard() {
        return idCard;
    }

    public void setIdCard(String idCard) {
        this.idCard = idCard;
    }

    public String getPoliceName() {
        return policeName;
    }

    public void setPoliceName(String policeName) {
        this.policeName = policeName;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public boolean isMonth3Pwd() {
        return month3Pwd;
    }

    public void setMonth3Pwd(boolean month3Pwd) {
        this.month3Pwd = month3Pwd;
    }

    public String getPoliceID() {
        return policeID;
    }

    public void setPoliceID(String policeID) {
        this.policeID = policeID;
    }

    public String getLimits() {
        return limits;
    }

    public void setLimits(String limits) {
        this.limits = limits;
    }

    public String getAuxiliaryPoliceLeader() {
        return auxiliaryPoliceLeader;
    }

    public void setAuxiliaryPoliceLeader(String auxiliaryPoliceLeader) {
        this.auxiliaryPoliceLeader = auxiliaryPoliceLeader;
    }

    public String getLastLoginTime() {
        return lastLoginTime;
    }

    public void setLastLoginTime(String lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    public String getLastLoginSource() {
        return lastLoginSource;
    }

    public void setLastLoginSource(String lastLoginSource) {
        this.lastLoginSource = lastLoginSource;
    }

    public String getPwdExpireDays() {
        return pwdExpireDays;
    }

    public void setPwdExpireDays(String pwdExpireDays) {
        this.pwdExpireDays = pwdExpireDays;
    }

    public String getLoginSource() {
        return loginSource;
    }

    public void setLoginSource(String loginSource) {
        this.loginSource = loginSource;
    }

    public List<LoginFailBean> getLastLoginFailLog() {
        return lastLoginFailLog;
    }

    public void setLastLoginFailLog(List<LoginFailBean> lastLoginFailLog) {
        this.lastLoginFailLog = lastLoginFailLog;
    }

    public String getUserNameExpireDays() {
        return userNameExpireDays;
    }

    public void setUserNameExpireDays(String userNameExpireDays) {
        this.userNameExpireDays = userNameExpireDays;
    }

    public String getResponse() {
        return response;
    }

    public void setResponse(String response) {
        this.response = response;
    }
}
