package com.xdja.gprsconverter.protocol;

import android.text.TextUtils;

import java.io.Serializable;
import java.util.List;

/**
 * 查询返回协议
 */

public class QueryResponse implements Serializable {
    private String response;
    /**
     * 如果后台开启了综查单条返回详细信息，才会返回Rsdc节点
     */
    private String rsdc;
    /**
     * 请求类别
     */
    private String type;
    /**
     * 数据项
     */
    private List<RowData> rowDataList;
    /**
     * 关联查询节点
     */
    private List<Relation> relationList;
    /**
     * 照片节点
     */
    private GetPhoto getPhoto;
    /**
     * 分页信息
     */
    private PageInfo pageInfo;

    public String getRsdc() {
        return rsdc;
    }

    public void setRsdc(String rsdc) {
        this.rsdc = rsdc;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<RowData> getRowDataList() {
        return rowDataList;
    }

    public void setRowDataList(List<RowData> rowDataList) {
        this.rowDataList = rowDataList;
    }

    public List<Relation> getRelationList() {
        return relationList;
    }

    public void setRelationList(List<Relation> relationList) {
        this.relationList = relationList;
    }

    public GetPhoto getGetPhoto() {
        return getPhoto;
    }

    public void setGetPhoto(GetPhoto getPhoto) {
        this.getPhoto = getPhoto;
    }

    public PageInfo getPageInfo() {
        return pageInfo;
    }

    public void setPageInfo(PageInfo pageInfo) {
        this.pageInfo = pageInfo;
    }

    public String getResponse() {
        return response;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    /**
     * 对应一条查询结果，每一条数据包含了一个FieldData数据list
     * 每一个FieldData包含一个字段的key、alias、code、value
     */

    public static class RowData implements Serializable {
        /**
         * 字段list
         */
        private List<FieldData> fieldDataList;

        /**
         * 获取所有字段list
         *
         * @return 字段list
         */
        public List<FieldData> getFieldDataList() {
            return fieldDataList;
        }

        public void setFieldDataList(List<FieldData> fieldDataList) {
            this.fieldDataList = fieldDataList;
        }

        /**
         * 根据某字段key获取该字段字典值
         *
         * @param key 字段key
         * @return 字典值
         */
        public String getFieldCodeByKey(String key) {
            return getOther(key, ENUMFIELDDATA.CODE);
        }

        /**
         * 根据耨字段key获取该字段值
         *
         * @param key 字段key
         * @return
         */
        public String getFieldValueByKey(String key) {
            return getOther(key, ENUMFIELDDATA.VALUE);
        }

        /**
         * 根据某字段key获取该字段中文名称
         *
         * @param key 字段key
         * @return 字段中文名称（别名）
         */
        public String getFieldAliasByKey(String key) {
            return getOther(key, ENUMFIELDDATA.ALIAS);
        }

        /**
         * 根据字段key获取该字段所有数据
         *
         * @param key 字段key
         * @return
         */
        public FieldData getFieldByKey(String key) {
            FieldData defaultFieldData = null;
            if (TextUtils.isEmpty(key)
                    || fieldDataList == null
                    || fieldDataList.isEmpty()) {
                return defaultFieldData;
            }
            for (FieldData fieldData : fieldDataList) {
                if (TextUtils.equals(key, fieldData.getKey())) {
                    defaultFieldData = fieldData;
                    break;
                }
            }
            return defaultFieldData;
        }

        private String getOther(String key, ENUMFIELDDATA item) {
            String defaultStr = "";
            if (TextUtils.isEmpty(key)
                    || fieldDataList == null
                    || fieldDataList.isEmpty()) {
                return defaultStr;
            }

            if (item == ENUMFIELDDATA.CODE) {
                for (FieldData fieldData : fieldDataList) {
                    if (TextUtils.equals(key, fieldData.getKey())) {
                        defaultStr = fieldData.getCode();
                        break;
                    }
                }
            } else if (item == ENUMFIELDDATA.ALIAS) {
                for (FieldData fieldData : fieldDataList) {
                    if (TextUtils.equals(key, fieldData.getKey())) {
                        defaultStr = fieldData.getAlias();
                        break;
                    }
                }
            } else if (item == ENUMFIELDDATA.VALUE) {
                for (FieldData fieldData : fieldDataList) {
                    if (TextUtils.equals(key, fieldData.getKey())) {
                        defaultStr = fieldData.getValue();
                        break;
                    }
                }
            }
            return defaultStr;
        }

        private enum ENUMFIELDDATA {
            ALIAS, VALUE, CODE
        }

        /**
         * 一个字段对应的数据
         */
        public static class FieldData implements Serializable {
            /**
             * 字段key，例如：c_xb
             */
            String key;
            /**
             * 字段别名，例如：性别
             */
            String alias;
            /**
             * 字段值，例如：男
             */
            String value;
            /**
             * 字段属性 例如：1（此字段一般只有有对应的有字典翻译时才有值，value对用中文翻译，code对应字典代码）
             */
            String code;

            public String getKey() {
                return key;
            }

            public void setKey(String key) {
                this.key = key;
            }

            public String getAlias() {
                return alias;
            }

            public void setAlias(String alias) {
                this.alias = alias;
            }

            public String getValue() {
                return value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public String getCode() {
                return code;
            }

            public void setCode(String code) {
                this.code = code;
            }
        }
    }

    /**
     * 照片节点
     */
    public static class GetPhoto implements Serializable {
        /**
         * 请求类别
         */
        private String reqType;
        /**
         * 照片所在的表
         */
        private String reqTable;
        /**
         * 查询条件
         */
        private String condition;
        /**
         * 当前照片数据源
         */
        private String dbSource;
        /**
         * 照片字段
         */
        private String fieldList;

        public String getReqType() {
            return reqType;
        }

        public void setReqType(String reqType) {
            this.reqType = reqType;
        }

        public String getReqTable() {
            return reqTable;
        }

        public void setReqTable(String reqTable) {
            this.reqTable = reqTable;
        }

        public String getCondition() {
            return condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public String getDbSource() {
            return dbSource;
        }

        public void setDbSource(String dbSource) {
            this.dbSource = dbSource;
        }

        public String getFieldList() {
            return fieldList;
        }

        public void setFieldList(String fieldList) {
            this.fieldList = fieldList;
        }
    }

    /**
     * 关联查询节点
     */
    public static class Relation implements Serializable {
        /**
         * 关联请求类别
         */
        private String sort;
        /**
         * 对应中文名称
         */
        private String name;
        /**
         * 关联查询条件
         */
        private String condition;
        /**
         * 关联业务对应数据源
         */
        private String dbSource;
        /**
         * 报警信息
         */
        private String alert;
        /**
         * 是否报警
         */
        private boolean isAlert;

        public String getSort() {
            return sort;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCondition() {
            return condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public String getDbSource() {
            return dbSource;
        }

        public void setDbSource(String dbSource) {
            this.dbSource = dbSource;
        }

        public String getAlert() {
            return alert;
        }

        public void setAlert(String alert) {
            this.alert = alert;
        }

        public boolean isAlert() {
            return isAlert;
        }

        public void setIsAlert(boolean alert) {
            isAlert = alert;
        }
    }

    /**
     * 分页信息
     */
    public static class PageInfo implements Serializable {
        /**
         * 分页大小
         */
        private int size;
        /**
         * 总记录数
         */
        private int totalLen;
        /**
         * 当前页记录数
         */
        private int currentLen;
        /**
         * 起始记录数
         */
        private int beginNo;
        /**
         * 总页数
         */
        private int totalPage;
        /**
         * 原始查询条件
         */
        private String sourceCondition;
        /**
         * 原始数据源
         */
        private String sourceDbSource;

        /**
         * 获取分页大小
         *
         * @return 分页大小
         */
        public int getSize() {
            return size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        /**
         * 获取总记录数
         *
         * @return 总记录数
         */
        public int getTotalLen() {
            return totalLen;
        }

        public void setTotalLen(int totalLen) {
            this.totalLen = totalLen;
        }

        /**
         * 获取当前页记录数
         *
         * @return 当前页记录数
         */
        public int getCurrentLen() {
            return currentLen;
        }

        public void setCurrentLen(int currentLen) {
            this.currentLen = currentLen;
        }

        /**
         * 获取起始记录数
         *
         * @return 起始记录数
         */
        public int getBeginNo() {
            return beginNo;
        }

        public void setBeginNo(int beginNo) {
            this.beginNo = beginNo;
        }

        /**
         * 获取总页数
         *
         * @return 总页数
         */
        public int getTotalPage() {
            return totalPage;
        }

        public void setTotalPage(int totalPage) {
            this.totalPage = totalPage;
        }

        /**
         * 获取原始查询条件
         *
         * @return 原始查询条件
         */
        public String getSourceCondition() {
            return sourceCondition;
        }

        public void setSourceCondition(String sourceCondition) {
            this.sourceCondition = sourceCondition;
        }

        /**
         * 获取原始数据源
         *
         * @return 原始数据源
         */
        public String getSourceDbSource() {
            return sourceDbSource;
        }

        public void setSourceDbSource(String sourceDbSource) {
            this.sourceDbSource = sourceDbSource;
        }
    }
}
