/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.gprsconverter.convert;

import android.text.TextUtils;
import com.xdja.gprsconverter.convert.ConvertInterface;
import com.xdja.gprsconverter.protocol.GetDataSourceRequest;
import com.xdja.gprsconverter.protocol.GetDataSourceResponse;
import com.xdja.gprsconverter.resolver.XMLResolver;
import java.util.ArrayList;
import org.w3c.dom.NodeList;

public class GetDataSourceConvert
implements ConvertInterface<GetDataSourceRequest, GetDataSourceResponse> {
    @Override
    public String convertBean2XML(GetDataSourceRequest getDataSourceRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        if (!TextUtils.isEmpty((CharSequence)getDataSourceRequest.getAppKey())) {
            sb.append("<AppKey>" + getDataSourceRequest.getAppKey() + "</AppKey>");
        }
        if (!TextUtils.isEmpty((CharSequence)getDataSourceRequest.getReqDigest())) {
            sb.append("<ReqDigest>" + getDataSourceRequest.getReqDigest() + "</ReqDigest>");
        }
        if (TextUtils.isEmpty((CharSequence)getDataSourceRequest.getReqType())) {
            sb.append("<ReqType>getdbsource</ReqType>");
        } else {
            sb.append("<ReqType>" + getDataSourceRequest.getReqType() + "</ReqType>");
        }
        sb.append("<SessionID>" + getDataSourceRequest.getSessionID() + "</SessionID>");
        sb.append("<ReqSort>" + getDataSourceRequest.getReqSort() + "</ReqSort>");
        sb.append("</Root>");
        return sb.toString();
    }

    @Override
    public GetDataSourceResponse convertXML2Bean(String string) {
        GetDataSourceResponse getDataSourceResponse = new GetDataSourceResponse();
        ArrayList<GetDataSourceResponse.DataSource> dataSourceList = new ArrayList<GetDataSourceResponse.DataSource>();
        XMLResolver xmlResolver = new XMLResolver(string);
        if (xmlResolver.getDoc() != null) {
            NodeList nl = xmlResolver.getDoc().getElementsByTagName("DbSource");
            for (int i = 0; i < nl.getLength(); ++i) {
                GetDataSourceResponse.DataSource dataSource = new GetDataSourceResponse.DataSource();
                dataSource.setSource(nl.item(i).getFirstChild().getNodeValue());
                dataSource.setSourceName(nl.item(i).getAttributes().getNamedItem("name").getNodeValue());
                dataSourceList.add(dataSource);
            }
        }
        getDataSourceResponse.setDataSourceList(dataSourceList);
        return getDataSourceResponse;
    }
}

