/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.gprsconverter.convert;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.xdja.gprsconverter.convert.ConvertInterface;
import com.xdja.gprsconverter.protocol.LoginFailBean;
import com.xdja.gprsconverter.protocol.LoginRequest;
import com.xdja.gprsconverter.protocol.LoginResponse;
import com.xdja.gprsconverter.resolver.XMLResolver;
import java.util.List;

public class LoginProtocolConvert
implements ConvertInterface<LoginRequest, LoginResponse> {
    @Override
    public String convertBean2XML(LoginRequest loginRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        if (!TextUtils.isEmpty((CharSequence)loginRequest.getPoliceNo())) {
            sb.append("<PoliceNo>" + loginRequest.getPoliceNo() + "</PoliceNo>");
        }
        sb.append("<ReqType>" + loginRequest.getReqType() + "</ReqType>");
        sb.append("<ValidateType>" + loginRequest.getValiDataType() + "</ValidateType>");
        sb.append("<ValidateValue><![CDATA[" + loginRequest.getValiDataValue() + "]]></ValidateValue>");
        if (!TextUtils.isEmpty((CharSequence)loginRequest.getValiDataPass())) {
            sb.append("<ValidatePass>" + loginRequest.getValiDataPass() + "</ValidatePass>");
        } else {
            sb.append("<ValidatePass></ValidatePass>");
        }
        sb.append("<CurrentVersion>" + loginRequest.getCurrentVersion() + "</CurrentVersion>");
        sb.append("<ClientType>" + loginRequest.getClientType() + "</ClientType>");
        sb.append("<CardType>" + loginRequest.getCardType() + "</CardType>");
        sb.append("<IMSI>" + loginRequest.getImsi() + "</IMSI>");
        sb.append("<IMEI>" + loginRequest.getImei() + "</IMEI>");
        if (!TextUtils.isEmpty((CharSequence)loginRequest.getIccid())) {
            sb.append("<ICCID>" + loginRequest.getIccid() + "</ICCID>");
        }
        if (TextUtils.isEmpty((CharSequence)loginRequest.getPver())) {
            sb.append("<Pver>20140501</Pver>");
        } else {
            sb.append("<Pver>" + loginRequest.getPver() + "</Pver>");
        }
        if (!TextUtils.isEmpty((CharSequence)loginRequest.getAppKey())) {
            sb.append("<AppKey>" + loginRequest.getAppKey() + "</AppKey>");
        }
        if (!TextUtils.isEmpty((CharSequence)loginRequest.getReqDigest())) {
            sb.append("<ReqDigest>" + loginRequest.getReqDigest() + "</ReqDigest>");
        }
        sb.append("</Root>");
        return sb.toString();
    }

    @Override
    public LoginResponse convertXML2Bean(String string) {
        XMLResolver xmlResolver = new XMLResolver(string);
        if (xmlResolver.getDoc() != null) {
            LoginResponse loginResponse = new LoginResponse();
            loginResponse.setResponse(string);
            loginResponse.setPower(xmlResolver.getElementValue("Power"));
            loginResponse.setUnitsCoding(xmlResolver.getElementValue("UnitsCoding"));
            loginResponse.setPoliceName(xmlResolver.getElementValue("PoliceName"));
            loginResponse.setUnitName(xmlResolver.getElementValue("UnitName"));
            loginResponse.setMobileNo(xmlResolver.getElementValue("MobileNo"));
            loginResponse.setPoliceID(xmlResolver.getElementValue("PoliceID"));
            loginResponse.setPoliceNo(xmlResolver.getElementValue("PoliceNo"));
            loginResponse.setIdCard(xmlResolver.getElementValue("IDCard"));
            loginResponse.setSessionID(xmlResolver.getElementValue("SessionID"));
            loginResponse.setMonth3Pwd("0".equals(xmlResolver.getElementValue("Month3Pwd")));
            loginResponse.setDateTime(xmlResolver.getElementValue("DateTime"));
            loginResponse.setLimits(xmlResolver.getElementValue("Limits"));
            loginResponse.setAuxiliaryPoliceLeader(xmlResolver.getElementValue("Xjssjh"));
            loginResponse.setLastLoginTime(xmlResolver.getElementValue("LastSuccLoginTime"));
            loginResponse.setLastLoginSource(xmlResolver.getElementValue("LastLoginSource"));
            loginResponse.setLoginSource(xmlResolver.getElementValue("LoginSource"));
            List loginFailBeanList = (List)new Gson().fromJson(xmlResolver.getElementValue("SuccAfterFailDesc"), new TypeToken<List<LoginFailBean>>(){}.getType());
            loginResponse.setLastLoginFailLog(loginFailBeanList);
            loginResponse.setUserNameExpireDays(xmlResolver.getElementValue("UserNameExpireDays"));
            loginResponse.setPwdExpireDays(xmlResolver.getElementValue("PwdExpireDays"));
            return loginResponse;
        }
        return null;
    }
}

