/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.gprsconverter.convert;

import com.xdja.gprsconverter.convert.ChangePwdProtocolConvert;
import com.xdja.gprsconverter.convert.EntryProtocolConvert;
import com.xdja.gprsconverter.convert.GetDataSourceConvert;
import com.xdja.gprsconverter.convert.LoginProtocolConvert;
import com.xdja.gprsconverter.convert.LogoutProtocolConvert;
import com.xdja.gprsconverter.convert.QueryProtocolConvert;
import com.xdja.gprsconverter.protocol.ChangePwdRequest;
import com.xdja.gprsconverter.protocol.ChangePwdResponse;
import com.xdja.gprsconverter.protocol.EntryRequest;
import com.xdja.gprsconverter.protocol.EntryResponse;
import com.xdja.gprsconverter.protocol.GetDataSourceRequest;
import com.xdja.gprsconverter.protocol.GetDataSourceResponse;
import com.xdja.gprsconverter.protocol.LoginRequest;
import com.xdja.gprsconverter.protocol.LoginResponse;
import com.xdja.gprsconverter.protocol.LogoutRequest;
import com.xdja.gprsconverter.protocol.LogoutResponse;
import com.xdja.gprsconverter.protocol.QueryRequest;
import com.xdja.gprsconverter.protocol.QueryResponse;

public class ConvertFactory {
    public static <T> String generateXML(T t) {
        if (t instanceof QueryRequest) {
            return ConvertFactory.generateQueryXML((QueryRequest)t);
        }
        if (t instanceof EntryRequest) {
            return ConvertFactory.generateEntryXML((EntryRequest)t);
        }
        if (t instanceof LoginRequest) {
            return ConvertFactory.generateLoginXML((LoginRequest)t);
        }
        if (t instanceof LogoutResponse) {
            return ConvertFactory.generateLogoutXML((LogoutRequest)t);
        }
        if (t instanceof ChangePwdRequest) {
            return ConvertFactory.generateChangePwdXML((ChangePwdRequest)t);
        }
        if (t instanceof GetDataSourceRequest) {
            return ConvertFactory.generateGetDataSourceXML((GetDataSourceRequest)t);
        }
        if (t instanceof String) {
            return (String)t;
        }
        return null;
    }

    public static <T> T parserResponse(String response, Class<T> tClass) {
        return ConvertFactory.parserResponse(response, tClass, false);
    }

    public static <T> T parserResponse(String response, Class<T> tClass, boolean isGetPhoto) {
        Object t = null;
        try {
            t = tClass.newInstance();
            if (t instanceof LoginResponse) {
                t = ConvertFactory.parserLoginResponse(response);
            } else if (t instanceof LogoutResponse) {
                t = ConvertFactory.parserLogoutResponse(response);
            } else if (t instanceof QueryResponse) {
                t = ConvertFactory.parserQueryResponse(response, isGetPhoto);
            } else if (t instanceof EntryResponse) {
                t = ConvertFactory.parserEnterResponse(response);
            } else if (t instanceof ChangePwdResponse) {
                t = ConvertFactory.parserChangePwdResponse(response);
            } else if (t instanceof GetDataSourceResponse) {
                t = ConvertFactory.parserGetDataSourceResponse(response);
            } else if (t instanceof String) {
                t = response;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return (T)t;
    }

    public static String generateQueryXML(QueryRequest queryRequest) {
        return new QueryProtocolConvert().convertBean2XML(queryRequest);
    }

    public static String generateEntryXML(EntryRequest entryRequest) {
        return new EntryProtocolConvert().convertBean2XML(entryRequest);
    }

    public static String generateChangePwdXML(ChangePwdRequest changePwdRequest) {
        return new ChangePwdProtocolConvert().convertBean2XML(changePwdRequest);
    }

    public static String generateLoginXML(LoginRequest loginRequest) {
        return new LoginProtocolConvert().convertBean2XML(loginRequest);
    }

    public static String generateLogoutXML(LogoutRequest logoutRequest) {
        return new LogoutProtocolConvert().convertBean2XML(logoutRequest);
    }

    public static String generateGetDataSourceXML(GetDataSourceRequest getDataSourceRequest) {
        return new GetDataSourceConvert().convertBean2XML(getDataSourceRequest);
    }

    public static QueryResponse parserQueryResponse(String queryResponse) {
        return ConvertFactory.parserQueryResponse(queryResponse, false);
    }

    public static QueryResponse parserQueryResponse(String queryResponse, boolean isGetPhoto) {
        return new QueryProtocolConvert().convertXML2Bean(queryResponse, isGetPhoto);
    }

    public static EntryResponse parserEnterResponse(String queryResponse) {
        return new EntryProtocolConvert().convertXML2Bean(queryResponse);
    }

    public static ChangePwdResponse parserChangePwdResponse(String changePwdResponse) {
        return new ChangePwdProtocolConvert().convertXML2Bean(changePwdResponse);
    }

    public static LoginResponse parserLoginResponse(String loginResponse) {
        return new LoginProtocolConvert().convertXML2Bean(loginResponse);
    }

    public static LogoutResponse parserLogoutResponse(String logoutResponse) {
        return new LogoutProtocolConvert().convertXML2Bean(logoutResponse);
    }

    public static GetDataSourceResponse parserGetDataSourceResponse(String response) {
        return new GetDataSourceConvert().convertXML2Bean(response);
    }
}

