/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.gprsconverter.resolver;

import com.xdja.gprsconverter.extension.ErrorInfoExtension;
import com.xdja.gprsconverter.protocol.EntryResponse;
import com.xdja.gprsconverter.resolver.XMLResolver;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NodeList;

public class EntryResponseResolver {
    public static EntryResponse resolverFromXML(String xmlResponse) {
        EntryResponse entryResponse = new EntryResponse();
        entryResponse.setResponse(xmlResponse);
        ErrorInfoExtension.parseErrorMsg(xmlResponse);
        if (ErrorInfoExtension.isError) {
            entryResponse.setResult(false);
            entryResponse.setErrorCode(ErrorInfoExtension.code);
            entryResponse.setErrorMessage(ErrorInfoExtension.message);
        } else {
            XMLResolver xmlResolver = new XMLResolver(xmlResponse);
            if (xmlResolver.getDoc() != null) {
                boolean isSuccess = xmlResolver.getElementValue("Type").equals("0");
                String message = xmlResolver.getElementValue("Result");
                entryResponse.setSuccess(isSuccess);
                entryResponse.setMessage(message);
            } else if (xmlResponse.startsWith("0")) {
                entryResponse.setSuccess(true);
                String[] response = xmlResponse.split("\\|\\|");
                if (response.length >= 2) {
                    entryResponse.setMessage(response[1]);
                }
            } else if (xmlResponse.startsWith("-1")) {
                entryResponse.setSuccess(false);
                String[] response = xmlResponse.split(" ");
                if (response.length >= 2) {
                    entryResponse.setErrorCode(response[0]);
                    entryResponse.setMessage(response[1]);
                    entryResponse.setErrorMessage(response[1]);
                }
            } else {
                entryResponse.setSuccess(false);
                entryResponse.setErrorMessage(xmlResponse);
                entryResponse.setMessage(xmlResponse);
            }
        }
        return entryResponse;
    }

    private static List<EntryResponse.ReturnItem> getReturnItemList(NodeList nodeList) {
        ArrayList<EntryResponse.ReturnItem> returnItems = new ArrayList<EntryResponse.ReturnItem>();
        if (nodeList != null && nodeList.getLength() > 0) {
            NodeList itemNodeList = nodeList.item(0).getChildNodes();
            for (int i = 0; i < itemNodeList.getLength(); ++i) {
                EntryResponse.ReturnItem returnItem = new EntryResponse.ReturnItem();
                returnItem.setKey(itemNodeList.item(0).getFirstChild().getNodeName());
                returnItem.setValue(itemNodeList.item(0).getFirstChild().getNodeValue());
                returnItems.add(returnItem);
            }
        }
        return returnItems;
    }

    private static List<EntryResponse.AlertInfo> getAlertInfoList(NodeList relNodeList) {
        ArrayList<EntryResponse.AlertInfo> relationList = new ArrayList<EntryResponse.AlertInfo>();
        if (relNodeList != null && relNodeList.getLength() > 0) {
            for (int i = 0; i < relNodeList.getLength(); ++i) {
                NodeList relationNode = relNodeList.item(i).getChildNodes();
                if (relationNode == null) continue;
                EntryResponse.AlertInfo relation = new EntryResponse.AlertInfo();
                relation.setSort(relationNode.item(0).getFirstChild().getNodeValue());
                relation.setName(relationNode.item(1).getFirstChild().getNodeValue());
                relation.setCondition(relationNode.item(2).getFirstChild().getNodeValue());
                relation.setDbSource(relationNode.item(3).getFirstChild().getNodeValue());
                relation.setXML(relationNode.item(4).getFirstChild().getNodeValue().equals("1"));
                relation.setAlert(relationNode.item(5).getFirstChild().getNodeValue());
                relationList.add(relation);
            }
        }
        return relationList;
    }
}

