package com.xdja.gprsconverter.extension;

/**
 * 查询字段Relation属性，逻辑关系扩展（区分大小写）
 * 包含数字表示和字符表示两种方式，不区分大小写
 * 考虑到字符表示形式容易记忆，建议传递字符表示
 * 默认值 1或EQ
 *
 * 规则：
 * 当Relation为8、12或IN、NI时，多个值中间使用英文逗号进行分割，值两边不需要 添加任何单引号或双引号。
 *
 * 当Relation为5、6、7、11或RL、LL、AL、NL时,终端不用在值上追加%,后台系统会自动添加
 *
 * 当Relation为14或CR时字符替换，根据后台配置文件中的配置，将查询值中的字符践行替换
 * 如配置为【*，%】，查询内容【张*三】，则替换为【张%三】
 */

public class RelationExtension {
    /**
     * 数字表示
     */
    public static class NumberExpression {
        /**
         * 等于 =关系（默认值）
         */
        public static final String EQUAL = "1";
        /**
         * != 或 <>
         */
        public static final String NOT_EQUAL = "2";
        /**
         * 大于等于 >=
         */
        public static final String GREAT_EQUAL = "3";
        /**
         * 小于等于 <=
         */
        public static final String LESS_EQUAL = "4";
        /**
         * 右like，终端不用在值上追加%，后台系统会自动添加
         */
        public static final String RIGHT_LIKE = "5";
        /**
         * 左like，终端不用在值上追加%，后台系统会自动添加
         */
        public static final String LEFT_LIKE = "6";
        /**
         * 全like，终端不用在值上追加%，后台系统会自动添加
         */
        public static final String ALL_LIKE = "7";
        /**
         * in，多个值中间使用英文逗号进行分割，值两边不需要添加任何单引号或者双引号
         */
        public static final String IN = "8";
        /**
         * 大于 >
         */
        public static final String GREAT_THAN = "9";
        /**
         * 小于 <
         */
        public static final String LESS_THAN = "10";
        /**
         * not like(DRS 2.0支持)，终端不用在值上追加%，后台系统会自动添加
         */
        public static final String NOT_LIKE = "11";
        /**
         * not in(DRS 2.0支持) 多个值中间使用英文逗号进行分割，值两边不需要添加任何单引号或者双引号
         */
        public static final String NOT_IN = "12";
        /**
         * between (DRS 2.0支持)
         */
        public static final String BETWEEN = "13";
        /**
         * like 字符替换，根据后台配置文件中的配置，将查询值中的字符践行替换
         * 如配置为【*，%】，查询内容【张*三】，则替换为【张%三】
         */
        public static final String LIKE = "14";
    }

    /**
     * 字符表示
     */
    public static class CharExpression {
        /**
         *
         * 等于 =关系（默认值）
         */
        public static final String EQUAL = "EQ";
        /**
         * != 或 <>
         */
        public static final String NOT_EQUAL = "NE";
        /**
         * 大于等于 >=
         */
        public static final String GREAT_EQUAL = "GE";
        /**
         * 小于等于 <=
         */
        public static final String LESS_EQUAL = "LE";
        /**
         * 右like，终端不用在值上追加%，后台系统会自动添加
         */
        public static final String RIGHT_LIKE = "RL";
        /**
         * 左like，终端不用在值上追加%，后台系统会自动添加
         */
        public static final String LEFT_LIKE = "LL";
        /**
         * 全like，终端不用在值上追加%，后台系统会自动添加
         */
        public static final String ALL_LIKE = "AI";
        /**
         * in，多个值中间使用英文逗号进行分割，值两边不需要添加任何单引号或者双引号
         */
        public static final String IN = "IN";
        /**
         * 大于 >
         */
        public static final String GREAT_THAN = "GT";
        /**
         * 小于 <
         */
        public static final String LESS_THAN = "LT";
        /**
         * not like(DRS 2.0支持)，终端不用在值上追加%，后台系统会自动添加
         */
        public static final String NOT_LIKE = "NL";
        /**
         * not in(DRS 2.0支持)，多个值中间使用英文逗号进行分割，值两边不需要添加任何单引号或者双引号
         */
        public static final String NOT_IN = "NI";
        /**
         * between (DRS 2.0支持)
         */
        public static final String BETWEEN = "BT";
        /**
         * like 字符替换，根据后台配置文件中的配置，将查询值中的字符践行替换
         * 如配置为【*，%】，查询内容【张*三】，则替换为【张%三】
         */
        public static final String LIKE = "CR";
    }
}
