package com.xdja.gprsconverter.extension;

/**
 * 查询字段SplitJoint属性，与前一个条件的拼接关系扩展（区分大小写）
 * 包含数字表示和字符表示两种方式，不区分大小写
 * 考虑到字符表示形式容易记忆，建议传递字符表示
 * 不写SplitJoint属性时，默认各字段间关系为and
 * 默认值 1或and
 */

public class SplitJointExtension {
    /**
     * 数字表示
     */
    public static class NumberExpression {
        /**
         * and关系（默认值）
         */
        public static final String AND = "1";
        /**
         * or关系
         */
        public static final String OR = "2";

    }

    /**
     * 字符表示
     */
    public static class CharExpression {
        /**
         * and关系（默认值）
         */
        public static final String AND = "and";
        /**
         * or关系
         */
        public static final String OR = "or";
    }
}
