package com.xdja.gprsconverter.protocol;

import java.io.Serializable;

/**
 * 登录请求协议，一般登录使用已经封装好的gprs_login库，建议只使用返回协议
 */

public class LoginRequest implements Serializable {
    /**
     * 应用ID，对接集中管控
     */
    private String appKey;
    /**
     * 摘要，对接集中管控
     */
    private String reqDigest;

    /**
     * 请求类别
     */
    private String reqType;
    /**
     * 登录认证方式0-警号，1-身份证，2-手机号，3-票据
     */
    private String valiDataType;
    /**
     * 登录所有证件号码，如果使用票据验验证，为票据信息
     */
    private String valiDataValue;
    /**
     * 登录密码，如果是票据验证密码不填
     */
    private String valiDataPass;
    /**
     * 终端程序当前版本
     */
    private String currentVersion;
    /**
     * 终端设备类型
     */
    private String clientType;
    private String imsi;
    private String imei;
    private String iccid;
    private String cardType;
    private String pver;

    private String policeNo;


    public String getReqType() {
        return reqType;
    }

    public void setReqType(String reqType) {
        this.reqType = reqType;
    }

    public String getValiDataType() {
        return valiDataType;
    }

    /**
     * 设置操作类型，其值必须为{@link com.xdja.gprsconverter.extension.LoginExtension}中的值
     *
     * @param valiDataType
     */
    public void setValiDataType(String valiDataType) {
        this.valiDataType = valiDataType;
    }

    public String getValiDataValue() {
        return valiDataValue;
    }

    /**
     * 登录所有证件号码，如果使用票据验验证，为票据信息
     *
     * @param valiDataValue
     */
    public void setValiDataValue(String valiDataValue) {
        this.valiDataValue = valiDataValue;
    }

    public String getValiDataPass() {
        return valiDataPass;
    }

    public void setValiDataPass(String valiDataPass) {
        this.valiDataPass = valiDataPass;
    }

    public String getCurrentVersion() {
        return currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getImsi() {
        return imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getIccid() {
        return iccid;
    }

    public void setIccid(String iccid) {
        this.iccid = iccid;
    }

    public String getPver() {
        return pver;
    }

    public void setPver(String pver) {
        this.pver = pver;
    }

    public String getClientType() {
        return clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getCardType() {
        return cardType;
    }

    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    /**
     * 应用id
     * @return
     */
    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getReqDigest() {
        return reqDigest;
    }

    public void setReqDigest(String reqDigest) {
        this.reqDigest = reqDigest;
    }

    public String getPoliceNo() {
        return policeNo;
    }

    public void setPoliceNo(String policeNo) {
        this.policeNo = policeNo;
    }

}
