package com.xdja.gprsconverter.protocol;

import android.support.annotation.NonNull;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 查询请求协议
 * 标注为可选字段的可以不设值，未标注的不能为空
 * 否则后台会报错
 */

public class QueryRequest implements Serializable {
    /**
     * 应用ID，对接集中管控
     */
    private String appKey;
    /**
     * 摘要，对接集中管控
     */
    private String reqDigest;
    private String policeNo;
    /**
     * 请求类别
     */
    private String reqType;
    /**
     * 会话ID
     */
    private String sessionID;
    /**
     * 起始记录数,默认为"1"
     */
    private String beginNo = "1";
    /**
     * 请求的表名（可选字段）
     */
    private String reqTable;
    /**
     * 请求的字段（可选字段）
     */
    private String fieldList;
    /**
     * 数据源，默认一般为1（可选字段，可填*号）
     */
    private String dataSource = "*";
    /**
     * 查询字段，每一个查询正常情况应至少包含一个查询字段
     * 若未添加任何查询条件，未避免后台报错，默认条件为：1=1(查询所有数据)
     */
    private List<Condition> conditionList;
    /**
     * 查询条件condition(拼接字符串,与conditionList二选一)
     */
    private String condition;
    /**
     * 是否是关联查询
     */
    private boolean isRelation;
    /**
     * 排序节点
     */
    private Order order;


    public String getPoliceNo() {
        return policeNo;
    }

    public void setPoliceNo(String policeNo) {
        this.policeNo = policeNo;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getReqDigest() {
        return reqDigest;
    }

    public void setReqDigest(String reqDigest) {
        this.reqDigest = reqDigest;
    }

    public String getReqType() {
        return reqType;
    }

    public void setReqType(@NonNull String reqType) {
        this.reqType = reqType;
    }

    public String getSessionID() {
        return sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getBeginNo() {
        return beginNo;
    }

    public void setBeginNo(String beginNo) {
        this.beginNo = beginNo;
    }

    public String getReqTable() {
        return reqTable;
    }

    public void setReqTable(String reqTable) {
        this.reqTable = reqTable;
    }

    public String getFieldList() {
        return fieldList;
    }

    public void setFieldList(String fieldList) {
        this.fieldList = fieldList;
    }

    public String getDataSource() {
        return dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public List<Condition> getConditionList() {
        return conditionList;
    }

    /**
     * 若调用此方法前已经通过{@link #addCondition(String, String)}方式添加查询条件，
     * 此方法会清除掉之前添加的条件，请保证传入的条件不为空，且长度大于0
     *
     * @param conditionList 查询条件
     */
    public void setConditionList(@NonNull List<Condition> conditionList) {
        this.conditionList = conditionList;
    }

    /**
     * 若调用此方法前已经通过{@link #addCondition(String, String)}方式添加查询条件，
     * 此方法不会清除掉之前添加的条件，担请保证新传入的查询条件与之前通过{@link #addCondition(String, String)}方式
     * 添加的条件不重复
     *
     * @param conditionList 查询条件
     */
    public void addConditionList(@NonNull List<Condition> conditionList) {
        if (this.conditionList != null) {
            this.conditionList.addAll(conditionList);
        } else {
            setConditionList(conditionList);
        }
    }

    /**
     * 添加查询条件
     *
     * @param key   查询字段key
     * @param value 查询字段值
     */
    public void addCondition(@NonNull String key, @NonNull String value) {
        addCondition(key, value, "");
    }

    /**
     * 添加查询条件
     *
     * @param key   查询字段key
     * @param value 查询字段值
     * @param type  查询字段类型，其值必须为{@link com.xdja.gprsconverter.extension.TypeExtension}中的值
     */
    public void addCondition(@NonNull String key, @NonNull String value, @NonNull String type) {
        addCondition(key, value, type, "");
    }

    /**
     * 添加查询条件
     *
     * @param key      查询字段key
     * @param value    查询字段值
     * @param type     查询字段类型，其值必须为{@link com.xdja.gprsconverter.extension.TypeExtension}中的值
     * @param relation 查询字段逻辑关系，其值必须为{@link com.xdja.gprsconverter.extension.RelationExtension}中的值
     */
    public void addCondition(@NonNull String key, @NonNull String value, @NonNull String type, @NonNull String relation) {
        addCondition(key, value, type, relation, "");
    }

    /**
     * 添加查询条件
     *
     * @param key        查询字段key
     * @param value      查询字段值
     * @param type       查询字段类型，其值必须为{@link com.xdja.gprsconverter.extension.TypeExtension}中的值
     * @param relation   查询字段逻辑关系，其值必须为{@link com.xdja.gprsconverter.extension.RelationExtension}中的值
     * @param splitJoint 与前一个查询条件关系 其值必须为{@link com.xdja.gprsconverter.extension.SplitJointExtension}中的值
     */
    public void addCondition(@NonNull String key, @NonNull String value, @NonNull String type, @NonNull String relation, @NonNull String splitJoint) {
        if (conditionList == null) {
            conditionList = new ArrayList<>();
        }
        Condition condition = new Condition();
        condition.setKey(key);
        condition.setValue(value);
        condition.setType(type);
        condition.setRelation(relation);
        condition.setSplitJoint(splitJoint);
        conditionList.add(condition);
    }

    public String getCondition() {
        return condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public boolean isRelation() {
        return isRelation;
    }

    public void setRelation(boolean relation) {
        isRelation = relation;
    }

    public Order getOrder() {
        return order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    /**
     * 查询条件，每一个查询正常情况应至少包含一个查询字段
     * 若未添加任何查询条件，未避免后台报错，默认条件为：1=1(查询所有数据)
     * 如果要避免查询所有数据请在查询前做校验
     * 查询举例：查询姓名叫"张三"，性别是男的，年龄在18-20之间的人
     * <Condition>
     * <c_xm>张三</c_xm>
     * <c_xb>1</c_xb>
     * <n_age Type='number' Relation='GE'>18</n_age>
     * <n_age Type='number' Relation='LE'>20</n_age>
     * </Condition>
     */
    public static class Condition implements Serializable {
        /**
         * 查询字段key,不可空
         */
        private String key;
        /**
         * 查询字段value 不可空
         */
        private String value;
        /**
         * 查询字段类型，可空
         * 后台默认按{@link com.xdja.gprsconverter.extension.TypeExtension}中char或1类型
         */
        private String type;
        /**
         * 查询字段逻辑关系，可空
         * 后台默认按{@link com.xdja.gprsconverter.extension.RelationExtension}中EQ或1类型
         */
        private String relation;
        /**
         * 与前一个查询条件关系，可空
         * 后台默认按{@link com.xdja.gprsconverter.extension.SplitJointExtension}中and或1类型
         */
        private String splitJoint;


        public String getKey() {
            return key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getRelation() {
            return relation;
        }

        public void setRelation(String relation) {
            this.relation = relation;
        }

        public String getSplitJoint() {
            return splitJoint;
        }

        public void setSplitJoint(String splitJoint) {
            this.splitJoint = splitJoint;
        }

        public String getValue() {
            return value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    /**
     * 查询结果排序方式
     * mix与asc、desc不可共存，请避免同时设置
     * asc、desc标签和字段出现的前后顺序会影响排序结果
     */
    public static class Order implements Serializable {
        /**
         * 根据正序排列的字段列表，中间用英文逗号分隔
         */
        private String asc;
        /**
         * 根据倒叙排列的字段列表，中间用英文逗号分隔
         */
        private String desc;
        /**
         * 混合排序模式，此种模式或忽略asc和desc标签
         */
        private String mix;

        public String getAsc() {
            return asc;
        }

        public void setAsc(String asc) {
            this.asc = asc;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getMix() {
            return mix;
        }

        public void setMix(String mix) {
            this.mix = mix;
        }
    }
}
