package com.xdja.gprsconverter.resolver;

import com.xdja.gprsconverter.extension.ErrorInfoExtension;
import com.xdja.gprsconverter.protocol.EntryResponse;

import org.w3c.dom.NodeList;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Guojie
 * @date 2017/8/30
 */

public class EntryResponseResolver {
    public static EntryResponse resolverFromXML(String xmlResponse) {
        EntryResponse entryResponse = new EntryResponse();
        entryResponse.setResponse(xmlResponse);
        ErrorInfoExtension.parseErrorMsg(xmlResponse);
        if (ErrorInfoExtension.isError) {
            entryResponse.setResult(false);
            entryResponse.setErrorCode(ErrorInfoExtension.code);
            entryResponse.setErrorMessage(ErrorInfoExtension.message);
        } else {
            XMLResolver xmlResolver = new XMLResolver(xmlResponse);
            if (xmlResolver.getDoc() != null) {
                boolean isSuccess = xmlResolver.getElementValue("Type").equals("0");
                String message = xmlResolver.getElementValue("Result");
                entryResponse.setSuccess(isSuccess);
                entryResponse.setMessage(message);
//            entryResponse.setReturnItemList(getReturnItemList(xmlResolver.getDoc().getElementsByTagName("ReturnItems")));
//            entryResponse.setAlertInfoList(getAlertInfoList(xmlResolver.getDoc().getElementsByTagName("RelNode")));
            } else {
                if (xmlResponse.startsWith("0")) {
                    entryResponse.setSuccess(true);
                    String[] response = xmlResponse.split("\\|\\|");
                    if (response.length >= 2) {
                        entryResponse.setMessage(response[1]);
                    }
                } else if (xmlResponse.startsWith("-")) {
                    entryResponse.setSuccess(false);
                    int index = xmlResponse.indexOf(" ");
                    if (index > -1) {
                        entryResponse.setErrorCode(xmlResponse.substring(0, index));
                        entryResponse.setMessage(xmlResponse.substring(index + 1));
                    } else {
                        entryResponse.setErrorCode(xmlResponse);
                        entryResponse.setMessage(xmlResponse);
                    }
                } else {
                    entryResponse.setSuccess(false);
                    entryResponse.setErrorMessage(xmlResponse);
                    entryResponse.setMessage(xmlResponse);
                }
            }
        }
        return entryResponse;
    }

    private static List<EntryResponse.ReturnItem> getReturnItemList(NodeList nodeList) {
        List<EntryResponse.ReturnItem> returnItems = new ArrayList<>();
        if (nodeList != null && nodeList.getLength() > 0) {
            NodeList itemNodeList = nodeList.item(0).getChildNodes();
            EntryResponse.ReturnItem returnItem;
            for (int i = 0; i < itemNodeList.getLength(); i++) {
                returnItem = new EntryResponse.ReturnItem();
                returnItem.setKey(itemNodeList.item(0).getFirstChild().getNodeName());
                returnItem.setValue(itemNodeList.item(0).getFirstChild().getNodeValue());
                returnItems.add(returnItem);
            }
        }
        return returnItems;
    }

    private static List<EntryResponse.AlertInfo> getAlertInfoList(NodeList relNodeList) {
        List<EntryResponse.AlertInfo> relationList = new ArrayList<>();
        if (relNodeList != null && relNodeList.getLength() > 0) {
            NodeList relationNode;
            for (int i = 0; i < relNodeList.getLength(); i++) {
                relationNode = relNodeList.item(i).getChildNodes();
                if (relationNode != null) {
                    EntryResponse.AlertInfo relation = new EntryResponse.AlertInfo();
                    relation.setSort(relationNode.item(0).getFirstChild().getNodeValue());//关联请求类别
                    relation.setName(relationNode.item(1).getFirstChild().getNodeValue());//中文名称
                    relation.setCondition(relationNode.item(2).getFirstChild().getNodeValue());//关联查询条件
                    relation.setDbSource(relationNode.item(3).getFirstChild().getNodeValue());//关联业务数据源
                    relation.setXML(relationNode.item(4).getFirstChild().getNodeValue().equals("1"));
                    relation.setAlert(relationNode.item(5).getFirstChild().getNodeValue());
                    relationList.add(relation);
                }
            }
        }
        return relationList;
    }
}
