/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.gprsconverter.convert;

import android.text.TextUtils;
import com.xdja.gprsconverter.convert.ConvertInterface;
import com.xdja.gprsconverter.extension.ErrorInfoExtension;
import com.xdja.gprsconverter.protocol.LogoutRequest;
import com.xdja.gprsconverter.protocol.LogoutResponse;

public class LogoutProtocolConvert
implements ConvertInterface<LogoutRequest, LogoutResponse> {
    @Override
    public String convertBean2XML(LogoutRequest logoutRequest) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<Root>");
        if (!TextUtils.isEmpty((CharSequence)logoutRequest.getAppKey())) {
            sb.append("<AppKey>" + logoutRequest.getAppKey() + "</AppKey>");
        }
        if (!TextUtils.isEmpty((CharSequence)logoutRequest.getReqDigest())) {
            sb.append("<ReqDigest>" + logoutRequest.getReqDigest() + "</ReqDigest>");
        }
        if (!TextUtils.isEmpty((CharSequence)logoutRequest.getPoliceNo())) {
            sb.append("<PoliceNo>" + logoutRequest.getPoliceNo() + "</PoliceNo>");
        }
        sb.append("<ReqType>" + logoutRequest.getReqType() + "</ReqType>");
        sb.append("<SessionID>" + logoutRequest.getSessionID() + "</SessionID>");
        sb.append("</Root>");
        return sb.toString();
    }

    @Override
    public LogoutResponse convertXML2Bean(String string) {
        LogoutResponse logoutResponse = new LogoutResponse();
        logoutResponse.setResponse(string);
        ErrorInfoExtension.parseErrorMsg(string);
        if (ErrorInfoExtension.isError) {
            logoutResponse.setResult(false);
            logoutResponse.setErrorCode(ErrorInfoExtension.code);
            logoutResponse.setErrorMessage(ErrorInfoExtension.message);
        } else {
            logoutResponse.setResult(true);
            if (!TextUtils.isEmpty((CharSequence)string) && string.startsWith("-9 \u7528\u6237\u9000\u51fa")) {
                logoutResponse.setSuccess(true);
            } else {
                logoutResponse.setSuccess(false);
            }
        }
        return logoutResponse;
    }
}

