/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.logingprs;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.mpt.aidlservice.IApnAndSafeKey;
import com.xdja.Exception.CErrorInfo;
import com.xdja.logingprs.LoginGPRSConfig;
import com.xdja.logingprs.LoginGPRSHandler;
import com.xdja.publicclass.DeviceInfo;
import com.xdja.publicclass.DeviceManager;
import com.xdja.publicclass.SocketManager;
import com.xdja.publicclass.XMLParser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LoginGPRSOperation {
    private static final String TAG = "LoginGPRSOperation";
    private Context context;
    private LoginGPRSHandler handle;
    private IApnAndSafeKey iApnAndSafeKey;
    boolean flag = false;
    Object lock = new Object();
    private LoginTask loginTask;
    private ServiceConnection conn = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.v((String)"AidlClient", (String)" ---------onServiceConnected------------ ");
            LoginGPRSOperation.this.iApnAndSafeKey = IApnAndSafeKey.Stub.asInterface(service);
            Object object = LoginGPRSOperation.this.lock;
            synchronized (object) {
                LoginGPRSOperation.this.lock.notifyAll();
            }
            LoginGPRSOperation.this.flag = true;
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.v((String)"AidlClient", (String)" ---------onServiceDisconnected------------ ");
            LoginGPRSOperation.this.iApnAndSafeKey = null;
        }
    };

    public LoginGPRSOperation(Context _context, LoginGPRSHandler _handle) {
        this.context = _context.getApplicationContext();
        this.handle = _handle;
    }

    public void start(String billString) {
        if (!TextUtils.isEmpty((CharSequence)billString)) {
            this.loginTask = new LoginTask();
            this.loginTask.execute(new Object[]{billString});
        } else {
            Log.e((String)TAG, (String)"\u83b7\u53d6\u7968\u636e\u4fe1\u606f\u5931\u8d25");
        }
    }

    public void cancel() {
        if (null != this.loginTask) {
            this.loginTask.cancel(true);
        }
    }

    private void socketAction(String msgData) {
        CErrorInfo.paserErrorMsg((String)msgData);
        if (CErrorInfo.isError) {
            this.handle.onGPRSErrorHandle(CErrorInfo.code, CErrorInfo.message);
            return;
        }
        XMLParser xmlParser = new XMLParser(msgData);
        this.handle.onGPRSOKHandle(msgData);
        if (this.iApnAndSafeKey != null && this.flag) {
            this.flag = false;
        }
    }

    private class LoginTask
    extends AsyncTask {
        private String cardid = "";

        private LoginTask() {
        }

        protected void onPreExecute() {
            Intent intent = new Intent("com.mpt.aidlservice.AidlService");
            intent.setAction("com.mpt.aidlservice.AidlService");
            intent.setPackage("com.xdja.safeclient");
            Log.v((String)"AidlClient", (String)" ---------onBindService------------ ");
            LoginGPRSOperation.this.flag = LoginGPRSOperation.this.context.bindService(intent, LoginGPRSOperation.this.conn, 1);
            if (LoginGPRSOperation.this.handle != null) {
                LoginGPRSOperation.this.handle.onPreGPRSHandle();
            }
        }

        protected void onCancelled() {
            super.onCancelled();
        }

        protected void onPostExecute(Object obj) {
            if (!this.isCancelled()) {
                if (LoginGPRSOperation.this.flag) {
                    LoginGPRSOperation.this.context.unbindService(LoginGPRSOperation.this.conn);
                }
                LoginGPRSOperation.this.socketAction((String)obj);
            } else {
                LoginGPRSOperation.this.context.unbindService(LoginGPRSOperation.this.conn);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground(Object ... params) {
            if (!this.isCancelled()) {
                block15: {
                    try {
                        if (LoginGPRSOperation.this.iApnAndSafeKey != null) {
                            this.cardid = LoginGPRSOperation.this.iApnAndSafeKey.XKF_GetCardID();
                            break block15;
                        }
                        Object object = LoginGPRSOperation.this.lock;
                        synchronized (object) {
                            LoginGPRSOperation.this.lock.wait(5000L);
                            if (LoginGPRSOperation.this.iApnAndSafeKey != null) {
                                this.cardid = LoginGPRSOperation.this.iApnAndSafeKey.XKF_GetCardID();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
                String billString = (String)params[0];
                StringBuffer reqstr = new StringBuffer();
                reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                reqstr.append("<Root>");
                reqstr.append("<ReqType>login</ReqType>");
                reqstr.append("<Pver>20140101</Pver>");
                reqstr.append("<ValidateType>3</ValidateType>");
                reqstr.append("<ValidateValue><![CDATA[ " + billString + "]]></ValidateValue>");
                reqstr.append("<ValidatePass></ValidatePass>");
                TelephonyManager tm = (TelephonyManager)LoginGPRSOperation.this.context.getSystemService("phone");
                String imeiStr = "";
                Method getImei = null;
                try {
                    getImei = tm.getClass().getDeclaredMethod("getImei", new Class[0]);
                    if (getImei != null) {
                        imeiStr = (String)getImei.invoke((Object)tm, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                DeviceInfo deviceInfo = DeviceManager.getDeviceInfo((Context)LoginGPRSOperation.this.context);
                reqstr.append("<IMSI>" + deviceInfo.getImsi() + "</IMSI>");
                reqstr.append("<IMEI>" + imeiStr + "</IMEI>");
                reqstr.append("<CurrentVersion>" + deviceInfo.getVersion() + "</CurrentVersion>");
                reqstr.append("<ClientType>" + deviceInfo.getSystem() + "</ClientType>");
                if (!TextUtils.isEmpty((CharSequence)this.cardid)) {
                    reqstr.append("<ICCID>" + this.cardid + "</ICCID>");
                }
                reqstr.append("<Cardtype>3</Cardtype>");
                reqstr.append("</Root>");
                SocketManager cs = new SocketManager(0, LoginGPRSConfig.SERVER_IP, LoginGPRSConfig.SERVER_PORT);
                String retMsg = cs.execute(reqstr.toString());
                Log.i((String)"retMsg", (String)retMsg);
                return retMsg;
            }
            return null;
        }
    }
}

