package com.xdja.logingprs;

import android.app.Dialog;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;

import com.mpt.aidlservice.IApnAndSafeKey;
import com.xdja.Exception.CErrorInfo;
import com.xdja.publicclass.DeviceInfo;
import com.xdja.publicclass.DeviceManager;
import com.xdja.publicclass.SocketManager;
import com.xdja.publicclass.XMLParser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LoginGPRSOperation {

    private static final String TAG = "LoginGPRSOperation";
    /**
     * UI层句柄
     */
    private Context context;
    /**
     * GPRSERVER处理接口
     */
    private LoginGPRSHandler handle;
    /**
     * 取消操作
     */
    private IApnAndSafeKey iApnAndSafeKey;
    boolean flag = false;
    Object lock = new Object();
    private LoginTask loginTask;

    public LoginGPRSOperation(Context _context, LoginGPRSHandler _handle) {
        context = _context.getApplicationContext();
        handle = _handle;
    }

    /**
     * 开始登录
     */
    public void start(String billString) {
        if (!TextUtils.isEmpty(billString)) {
            loginTask = new LoginTask();
            loginTask.execute(billString);
        } else {
            Log.e(TAG, "获取票据信息失败");
        }
    }

    public void cancel() {
        if (null != loginTask) {
            loginTask.cancel(true);
        }
    }

    /**
     * 后台任务，完成安全客户端启动，发送登录请求，和接收登录消息的功能
     */
    private class LoginTask extends AsyncTask {
        private String cardid = "";

        @Override
        protected void onPreExecute() {
            Intent intent = new Intent("com.mpt.aidlservice.AidlService");
            intent.setAction("com.mpt.aidlservice.AidlService");
            intent.setPackage("com.xdja.uaac");
            // 绑定远程服务
            Log.v("AidlClient", " ---------onBindService------------ ");
            flag = context.bindService(intent, conn, Service.BIND_AUTO_CREATE);
            if (handle != null) {
                handle.onPreGPRSHandle();
            }
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
        }

        @Override
        protected void onPostExecute(Object obj) {
            if (!isCancelled()) {
                if (flag) {
                    context.unbindService(conn);
                }
                socketAction((String) obj);
            } else {
                context.unbindService(conn);
            }
        }

        @Override
        protected Object doInBackground(Object... params) {
            if (!isCancelled()) {
                try {
                    if (iApnAndSafeKey != null) {
                        cardid = iApnAndSafeKey.XKF_GetCardID();
                    } else {
                        synchronized (lock) {
                            lock.wait(5000);
                            if (iApnAndSafeKey != null) {
                                cardid = iApnAndSafeKey.XKF_GetCardID();
                            }
                        }
                    }

                } catch (InterruptedException e) {
                    e.printStackTrace();
                } catch (RemoteException e) {
                    e.printStackTrace();
                }

                String billString = (String) params[0];
                StringBuffer reqstr = new StringBuffer();
                reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                reqstr.append("<Root>");
                reqstr.append("<ReqType>login</ReqType>");
                reqstr.append("<Pver>20140101</Pver>");// ------记住删掉
                reqstr.append("<ValidateType>3</ValidateType>");
                reqstr.append("<ValidateValue><![CDATA[ " + billString + "]]>"
                        + "</ValidateValue>");
                reqstr.append("<ValidatePass>" + "</ValidatePass>");
                TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
                String imeiStr = "";
                Method getImei = null;
                try {
                    getImei = tm.getClass().getDeclaredMethod("getImei");
                    if (getImei != null) {
                        imeiStr = (String) getImei.invoke(tm);
                    }
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }

                DeviceInfo deviceInfo = DeviceManager.getDeviceInfo(context);
                // 有些手机获取的事imid的值
                // 根据吉林警务通需求，不足15位时，不需要补足15位；wxq upd 2015-8-10 begin
                // if (imeiStr.length() < 15) {
                // int tempInt = 15 - imeiStr.length();
                // for (int i = 0; i < tempInt; i++) {
                // imeiStr += "0";
                // }
                // }
                // wxq upd 2015-8-10 end
                reqstr.append("<IMSI>" + deviceInfo.getImsi() + "</IMSI>");
                reqstr.append("<IMEI>" + imeiStr + "</IMEI>");
                reqstr.append("<CurrentVersion>" + deviceInfo.getVersion()
                        + "</CurrentVersion>"); //
                reqstr.append("<ClientType>" + deviceInfo.getSystem()
                        + "</ClientType>"); //
                if (!TextUtils.isEmpty(cardid)) {
                    reqstr.append("<ICCID>" + cardid + "</ICCID>");
                }
                reqstr.append("<Cardtype>3</Cardtype>");

                reqstr.append("</Root>");
                // 发送登录请求

                SocketManager cs = new SocketManager(0, LoginGPRSConfig.SERVER_IP, LoginGPRSConfig.SERVER_PORT);
                String retMsg = cs.execute(reqstr.toString());
                Log.i("retMsg", retMsg);
                return retMsg;
            }
            return null;
        }
    }

    /**
     * 解析登录返回信息
     *
     * @param msgData
     */
    private void socketAction(String msgData) {
        CErrorInfo.paserErrorMsg(msgData);
        if (CErrorInfo.isError) {
            handle.onGPRSErrorHandle(CErrorInfo.code, CErrorInfo.message);
            return;
        }
        XMLParser xmlParser = new XMLParser(msgData);
        handle.onGPRSOKHandle(msgData);
        if (iApnAndSafeKey != null && flag) {
            flag = false;
        }
    }

    private ServiceConnection conn = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            // 获取远程Service的onBind方法返回的对象的代理
            Log.v("AidlClient", " ---------onServiceConnected------------ ");
            iApnAndSafeKey = IApnAndSafeKey.Stub.asInterface(service);
            synchronized (lock) {
                lock.notifyAll();
            }
            flag = true;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Log.v("AidlClient", " ---------onServiceDisconnected------------ ");
            iApnAndSafeKey = null;
        }
    };

}
