/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.logingprs;

import android.content.Context;
import android.os.AsyncTask;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.Exception.CErrorInfo;
import com.xdja.logingprs.LoginGPRSConfig;
import com.xdja.logingprs.LoginGPRSHandler;
import com.xdja.logingprs.SafeCardHelper;
import com.xdja.publicclass.DeviceInfo;
import com.xdja.publicclass.DeviceManager;
import com.xdja.publicclass.SocketManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LoginGPRSOperation {
    private static LoginGPRSOperation instance;
    private static final String TAG = "LoginGPRSOperation";
    private Context context;
    private LoginGPRSHandler handler;
    private LoginTask loginTask;
    private boolean isLogin;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoginGPRSOperation getInstance() {
        if (instance != null) return instance;
        Class<LoginGPRSOperation> clazz = LoginGPRSOperation.class;
        synchronized (LoginGPRSOperation.class) {
            if (instance != null) return instance;
            instance = new LoginGPRSOperation();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public LoginGPRSOperation init(Context context, LoginGPRSHandler handle) {
        this.context = context.getApplicationContext();
        this.handler = handle;
        this.isLogin = false;
        return instance;
    }

    public void start(final String billString) {
        if (!TextUtils.isEmpty((CharSequence)billString)) {
            if (!this.isLogin) {
                this.isLogin = true;
                SafeCardHelper safeCardHelper = new SafeCardHelper(this.context);
                safeCardHelper.getCardIDByContentProvide(new SafeCardHelper.SafeCardIDListener(){

                    @Override
                    public void onSuccess(String cardID) {
                        if (!LoginGPRSOperation.this.isLogin) {
                            LoginGPRSOperation.this.loginTask = new LoginTask();
                            LoginGPRSOperation.this.loginTask.execute(new String[]{billString, cardID});
                        }
                    }

                    @Override
                    public void onFail(String error) {
                        LoginGPRSOperation.this.loginTask = new LoginTask();
                        LoginGPRSOperation.this.loginTask.execute(new String[]{billString});
                    }
                });
            }
        } else {
            Log.e((String)TAG, (String)"\u83b7\u53d6\u7968\u636e\u4fe1\u606f\u5931\u8d25");
        }
    }

    public void cancel() {
        if (null != this.loginTask) {
            this.loginTask.cancel(true);
        }
    }

    private void socketAction(String msgData) {
        CErrorInfo.paserErrorMsg((String)msgData);
        if (CErrorInfo.isError) {
            this.handler.onGPRSErrorHandle(CErrorInfo.code, CErrorInfo.message);
            return;
        }
        this.handler.onGPRSOKHandle(msgData);
    }

    private class LoginTask
    extends AsyncTask<String, Integer, String> {
        private LoginTask() {
        }

        protected void onPreExecute() {
            LoginGPRSOperation.this.isLogin = true;
            if (LoginGPRSOperation.this.handler != null) {
                LoginGPRSOperation.this.handler.onPreGPRSHandle();
            }
        }

        protected void onCancelled() {
            super.onCancelled();
            LoginGPRSOperation.this.isLogin = false;
        }

        protected void onPostExecute(String string) {
            if (!this.isCancelled()) {
                LoginGPRSOperation.this.socketAction(string);
                LoginGPRSOperation.this.isLogin = false;
            }
        }

        protected String doInBackground(String ... params) {
            if (!this.isCancelled()) {
                String billString = params[0];
                StringBuffer reqstr = new StringBuffer();
                reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                reqstr.append("<Root>");
                reqstr.append("<ReqType>login</ReqType>");
                reqstr.append("<Pver>20140101</Pver>");
                reqstr.append("<ValidateType>3</ValidateType>");
                reqstr.append("<ValidateValue><![CDATA[ " + billString + "]]></ValidateValue>");
                reqstr.append("<ValidatePass></ValidatePass>");
                TelephonyManager tm = (TelephonyManager)LoginGPRSOperation.this.context.getSystemService("phone");
                String imeiStr = "";
                Method getImei = null;
                try {
                    getImei = tm.getClass().getDeclaredMethod("getImei", new Class[0]);
                    if (getImei != null) {
                        imeiStr = (String)getImei.invoke((Object)tm, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                DeviceInfo deviceInfo = DeviceManager.getDeviceInfo((Context)LoginGPRSOperation.this.context);
                reqstr.append("<IMSI>" + deviceInfo.getImsi() + "</IMSI>");
                reqstr.append("<IMEI>" + imeiStr + "</IMEI>");
                reqstr.append("<CurrentVersion>" + deviceInfo.getVersion() + "</CurrentVersion>");
                reqstr.append("<ClientType>" + deviceInfo.getSystem() + "</ClientType>");
                if (params.length > 1 && !TextUtils.isEmpty((CharSequence)params[1])) {
                    reqstr.append("<ICCID>" + params[1] + "</ICCID>");
                }
                reqstr.append("<Cardtype>3</Cardtype>");
                reqstr.append("</Root>");
                SocketManager cs = new SocketManager(0, LoginGPRSConfig.SERVER_IP, LoginGPRSConfig.SERVER_PORT);
                String retMsg = cs.execute(reqstr.toString());
                Log.i((String)"retMsg", (String)retMsg);
                return retMsg;
            }
            return null;
        }
    }
}

