package com.xdja.logingprs;

import android.content.Context;
import android.os.AsyncTask;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.Exception.CErrorInfo;
import com.xdja.publicclass.DeviceInfo;
import com.xdja.publicclass.DeviceManager;
import com.xdja.publicclass.SocketManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class LoginGPRSOperation {
    private static LoginGPRSOperation instance;
    private static final String TAG = "LoginGPRSOperation";
    /**
     * UI层句柄
     */
    private Context context;
    /**
     * GPRSERVER处理接口
     */
    private LoginGPRSHandler handler;
    private LoginTask loginTask;
    private boolean isLogin;

    private LoginGPRSOperation() {

    }

    public static LoginGPRSOperation getInstance() {
        if (instance == null) {
            synchronized (LoginGPRSOperation.class) {
                if (instance == null) {
                    instance = new LoginGPRSOperation();
                }
            }
        }
        return instance;
    }

    public LoginGPRSOperation init(Context context, LoginGPRSHandler handle) {
        this.context = context.getApplicationContext();
        handler = handle;
        isLogin = false;
        return instance;
    }

    /**
     * 开始登录
     */
    public LoginGPRSOperation start(final String billString) {
        if (!TextUtils.isEmpty(billString)) {
            if (!isLogin) {
                SafeCardHelper safeCardHelper = new SafeCardHelper(context);
                safeCardHelper.getCardIDByContentProvide(new SafeCardHelper.SafeCardIDListener() {
                    @Override
                    public void onSuccess(String cardID) {
                        loginTask = new LoginTask();
                        loginTask.execute(billString, cardID);
                    }

                    @Override
                    public void onFail(String error) {
                        loginTask = new LoginTask();
                        loginTask.execute(billString);
                    }
                });
            }
        } else {
            Log.e(TAG, "获取票据信息失败");
        }
        return instance;
    }
    /**
     * 开始登录
     */
    public LoginGPRSOperation startByAIDL(final String billString) {
        if (!TextUtils.isEmpty(billString)) {
            if (!isLogin) {
                SafeCardHelper safeCardHelper = new SafeCardHelper(context);
                safeCardHelper.getCardIDByAIDL(new SafeCardHelper.SafeCardIDListener() {
                    @Override
                    public void onSuccess(String cardID) {
                        loginTask = new LoginTask();
                        loginTask.execute(billString, cardID);
                    }

                    @Override
                    public void onFail(String error) {
                        loginTask = new LoginTask();
                        loginTask.execute(billString);
                    }
                });
            }
        } else {
            Log.e(TAG, "获取票据信息失败");
        }
        return instance;
    }
    public void cancel() {
        if (null != loginTask) {
            loginTask.cancel(true);
        }
        isLogin = false;
    }

    /**
     * 后台任务，完成安全客户端启动，发送登录请求，和接收登录消息的功能
     */

    private class LoginTask extends AsyncTask<String, Integer, String> {
        @Override
        protected void onPreExecute() {
            isLogin = true;
            if (handler != null) {
                handler.onPreGPRSHandle();
            }
        }

        @Override
        protected void onCancelled() {
            super.onCancelled();
            isLogin = false;
        }

        @Override
        protected void onPostExecute(String string) {
            if (!isCancelled()) {
                socketAction(string);
            }
        }

        @Override
        protected String doInBackground(String... params) {
            if (!isCancelled()) {
                String billString = (String) params[0];
                StringBuffer reqstr = new StringBuffer();
                reqstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                reqstr.append("<Root>");
                reqstr.append("<ReqType>login</ReqType>");
                reqstr.append("<Pver>20140101</Pver>");// ------记住删掉
                reqstr.append("<ValidateType>3</ValidateType>");
                reqstr.append("<ValidateValue><![CDATA[ " + billString + "]]>"
                        + "</ValidateValue>");
                reqstr.append("<ValidatePass>" + "</ValidatePass>");
                TelephonyManager tm = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
                String imeiStr = "";
                Method getImei = null;
                try {
                    getImei = tm.getClass().getDeclaredMethod("getImei");
                    if (getImei != null) {
                        imeiStr = (String) getImei.invoke(tm);
                    }
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                DeviceInfo deviceInfo = DeviceManager.getDeviceInfo(context);
                reqstr.append("<IMSI>" + deviceInfo.getImsi() + "</IMSI>");
                reqstr.append("<IMEI>" + imeiStr + "</IMEI>");
                reqstr.append("<CurrentVersion>" + deviceInfo.getVersion()
                        + "</CurrentVersion>"); //
                reqstr.append("<ClientType>" + deviceInfo.getSystem()
                        + "</ClientType>"); //
                if (params.length > 1 && !TextUtils.isEmpty(params[1])) {
                    reqstr.append("<ICCID>" + params[1] + "</ICCID>");
                }
                reqstr.append("<Cardtype>3</Cardtype>");

                reqstr.append("</Root>");
                // 发送登录请求

                SocketManager cs = new SocketManager(0, LoginGPRSConfig.SERVER_IP, LoginGPRSConfig.SERVER_PORT);
                String retMsg = cs.execute(reqstr.toString());
                Log.i("retMsg", retMsg);
                return retMsg;
            }
            return null;
        }
    }

    /**
     * 解析登录返回信息
     *
     * @param msgData
     */
    private void socketAction(String msgData) {
        CErrorInfo.paserErrorMsg(msgData);
        if (CErrorInfo.isError) {
            isLogin = false;
            handler.onGPRSErrorHandle(CErrorInfo.code, CErrorInfo.message);
            return;
        }
        handler.onGPRSOKHandle(msgData);
        isLogin = false;
    }

}
