package com.xdja.logingprs;

import android.app.Service;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Observable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

import com.mpt.aidlservice.IApnAndSafeKey;

/**
 * 读取安全卡id操作类
 * <p>
 * Created by Guojie on 2017/9/8.
 */

public class SafeCardHelper {
    //获取安全卡id
    public static final String METHOD_GETSAFECARDID = "getSafeCardID";
    //获取警员id
    public static final String METHOD_GETPOLICEMANID = "getPolicemanID";
    //ContentProvide URI
    public static final Uri SAFETF_URI = Uri.parse("content://" + "com.xdja.providers.safetfprovider");

    public static final String SAFE_CLIENT_PACKAGE_NAME = "com.xdja.safeclient";

    public static final String AUTH_PACKAGE = "com.xdja.uaac";

    private IApnAndSafeKey iApnAndSafeKey;
    private ContentResolver contentResolver = null;
    boolean flag = false;
    Object lock = new Object();
    private Context context;

    public SafeCardHelper(Context context) {
        this.context = context;
    }

    /**
     * 读取警员id
     *
     * @return observable
     */
    public void getPolicemanID(final SafeCardIDListener safeCardIDListener) {
        AsyncTask<String, Integer, String> asyncTask = new AsyncTask<String, Integer, String>() {
            @Override
            protected String doInBackground(String... strings) {
                Bundle resBundle = null;
                String policemanID = null;
                contentResolver = context.getContentResolver();
                resBundle = contentResolver.call(SAFETF_URI, METHOD_GETPOLICEMANID, null, null);
                if (resBundle != null) {
                    policemanID = resBundle.getString("result");
                    return policemanID;
                }
                return null;
            }

            @Override
            protected void onPostExecute(String policemanID) {
                super.onPostExecute(policemanID);
                if (safeCardIDListener != null) {
                    if (policemanID != null) {
                        safeCardIDListener.onSuccess(policemanID);
                    } else {
                        safeCardIDListener.onFail("获取警员id失败");
                    }
                }

            }
        };
        asyncTask.execute();
    }

    /**
     * contentProvide方式获取安全卡id
     *
     * @return
     */
    public void getCardIDByContentProvide(final SafeCardIDListener safeCardIDListener) {
        AsyncTask<String, Integer, String> asyncTask = new AsyncTask<String, Integer, String>() {
            @Override
            protected String doInBackground(String... strings) {
                Bundle resBundle = null;
                String cardID = null;
                contentResolver = context.getContentResolver();
                resBundle = contentResolver.call(SAFETF_URI, METHOD_GETSAFECARDID, null, null);
                if (resBundle != null) {
                    cardID = resBundle.getString("result");
                    return cardID;
                }
                return null;
            }

            @Override
            protected void onPostExecute(String cardID) {
                super.onPostExecute(cardID);
                if (safeCardIDListener != null) {
                    if (cardID != null) {
                        safeCardIDListener.onSuccess(cardID);
                    } else {
                        safeCardIDListener.onFail("获取安全卡id失败");
                    }
                }

            }
        };
        asyncTask.execute();
    }

    /**
     * AIDL方式获取安全卡id
     *
     * @param safeCardIDListener
     */
    public void getCardIDByAIDL(SafeCardIDListener safeCardIDListener) {
        getCardIDByAIDL("", safeCardIDListener);
    }

    /**
     * AIDL方式获取安全卡id
     *
     * @return
     */
    private void getCardIDByAIDL(final String packageName, final SafeCardIDListener safeCardIDListener) {
        AsyncTask<String, Integer, String> asyncTask = new AsyncTask<String, Integer, String>() {
            @Override
            protected String doInBackground(String... strings) {
                String cardID = null;
                Intent intent = new Intent("com.mpt.aidlservice.AidlService");
                intent.setAction("com.mpt.aidlservice.AidlService");
                if (TextUtils.isEmpty(packageName)) {
                    intent.setPackage(SAFE_CLIENT_PACKAGE_NAME);
                } else {
                    intent.setPackage(packageName);
                }

                // 绑定远程服务
                Log.v("AidlClient", " ---------onBindService------------ ");
                flag = context.bindService(intent, conn, Service.BIND_AUTO_CREATE);
                try {
                    if (iApnAndSafeKey != null) {
                        cardID = iApnAndSafeKey.XKF_GetCardID();
                    } else {
                        synchronized (lock) {
                            lock.wait(5000);
                            if (iApnAndSafeKey != null) {
                                cardID = iApnAndSafeKey.XKF_GetCardID();
                            }
                        }
                    }

                } catch (InterruptedException e) {
                    e.printStackTrace();
                } catch (RemoteException e) {
                    e.printStackTrace();
                }
                if (flag) {
                    context.unbindService(conn);
                }
                if (iApnAndSafeKey != null && flag) {
                    flag = false;
                }
                return cardID;
            }

            @Override
            protected void onPostExecute(String cardID) {
                super.onPostExecute(cardID);
                if (safeCardIDListener != null) {
                    if (cardID != null) {
                        safeCardIDListener.onSuccess(cardID);
                    } else {
                        safeCardIDListener.onFail("获取安全卡id失败");
                    }
                }

            }
        };
        asyncTask.execute();
    }

    private ServiceConnection conn = new ServiceConnection() {
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            // 获取远程Service的onBind方法返回的对象的代理
            Log.v("AidlClient", " ---------onServiceConnected------------ ");
            iApnAndSafeKey = IApnAndSafeKey.Stub.asInterface(service);
            synchronized (lock) {
                lock.notifyAll();
            }
            flag = true;
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Log.v("AidlClient", " ---------onServiceDisconnected------------ ");
            iApnAndSafeKey = null;
        }
    };

    public interface SafeCardIDListener {
        void onSuccess(String cardID);

        void onFail(String error);
    }
}
