/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.logingprs;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.mpt.aidlservice.IApnAndSafeKey;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class SafeCardHelper {
    public static final String METHOD_GETSAFECARDID = "getSafeCardID";
    public static final String METHOD_GETPOLICEMANID = "getPolicemanID";
    public static final Uri SAFETF_URI = Uri.parse((String)"content://com.xdja.providers.safetfprovider");
    public static final String SAFE_CLIENT_PACKAGE_NAME = "com.xdja.safeclient";
    public static final String AUTH_PACKAGE = "com.xdja.uaac";
    private IApnAndSafeKey iApnAndSafeKey;
    private ContentResolver contentResolver = null;
    boolean flag = false;
    Object lock = new Object();
    private Context context;
    private Executor exec;
    private ServiceConnection conn = new ServiceConnection(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.v((String)"AidlClient", (String)" ---------onServiceConnected------------ ");
            SafeCardHelper.this.iApnAndSafeKey = IApnAndSafeKey.Stub.asInterface(service);
            Object object = SafeCardHelper.this.lock;
            synchronized (object) {
                SafeCardHelper.this.lock.notifyAll();
            }
            SafeCardHelper.this.flag = true;
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.v((String)"AidlClient", (String)" ---------onServiceDisconnected------------ ");
            SafeCardHelper.this.iApnAndSafeKey = null;
        }
    };

    public SafeCardHelper(Context context) {
        this.context = context;
        this.exec = Executors.newSingleThreadScheduledExecutor();
    }

    public void getPolicemanID(final SafeCardIDListener safeCardIDListener) {
        AsyncTask<String, Integer, String> asyncTask = new AsyncTask<String, Integer, String>(){

            protected String doInBackground(String ... strings) {
                Bundle resBundle = null;
                String policemanID = null;
                SafeCardHelper.this.contentResolver = SafeCardHelper.this.context.getContentResolver();
                resBundle = SafeCardHelper.this.contentResolver.call(SAFETF_URI, SafeCardHelper.METHOD_GETPOLICEMANID, null, null);
                if (resBundle != null) {
                    policemanID = resBundle.getString("result");
                    return policemanID;
                }
                return null;
            }

            protected void onPostExecute(String policemanID) {
                super.onPostExecute((Object)policemanID);
                if (safeCardIDListener != null) {
                    if (policemanID != null) {
                        safeCardIDListener.onSuccess(policemanID);
                    } else {
                        safeCardIDListener.onFail("\u83b7\u53d6\u8b66\u5458id\u5931\u8d25");
                    }
                }
            }
        };
        asyncTask.executeOnExecutor(this.exec, (Object[])new String[0]);
    }

    public void getCardIDByContentProvide(final SafeCardIDListener safeCardIDListener) {
        AsyncTask<String, Integer, String> asyncTask = new AsyncTask<String, Integer, String>(){

            protected String doInBackground(String ... strings) {
                Bundle resBundle = null;
                String cardID = null;
                SafeCardHelper.this.contentResolver = SafeCardHelper.this.context.getContentResolver();
                resBundle = SafeCardHelper.this.contentResolver.call(SAFETF_URI, SafeCardHelper.METHOD_GETSAFECARDID, null, null);
                if (resBundle != null) {
                    cardID = resBundle.getString("result");
                    return cardID;
                }
                return null;
            }

            protected void onPostExecute(String cardID) {
                super.onPostExecute((Object)cardID);
                if (safeCardIDListener != null) {
                    if (cardID != null) {
                        safeCardIDListener.onSuccess(cardID);
                    } else {
                        safeCardIDListener.onFail("\u83b7\u53d6\u5b89\u5168\u5361id\u5931\u8d25");
                    }
                }
            }
        };
        asyncTask.executeOnExecutor(this.exec, (Object[])new String[0]);
    }

    public void getCardIDByAIDL(SafeCardIDListener safeCardIDListener) {
        this.getCardIDByAIDL("", safeCardIDListener);
    }

    private void getCardIDByAIDL(final String packageName, final SafeCardIDListener safeCardIDListener) {
        AsyncTask<String, Integer, String> asyncTask = new AsyncTask<String, Integer, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String doInBackground(String ... strings) {
                String cardID;
                block12: {
                    cardID = null;
                    Intent intent = new Intent("com.mpt.aidlservice.AidlService");
                    intent.setAction("com.mpt.aidlservice.AidlService");
                    if (TextUtils.isEmpty((CharSequence)packageName)) {
                        intent.setPackage(SafeCardHelper.SAFE_CLIENT_PACKAGE_NAME);
                    } else {
                        intent.setPackage(packageName);
                    }
                    Log.v((String)"AidlClient", (String)" ---------onBindService------------ ");
                    SafeCardHelper.this.flag = SafeCardHelper.this.context.bindService(intent, SafeCardHelper.this.conn, 1);
                    try {
                        if (SafeCardHelper.this.iApnAndSafeKey != null) {
                            cardID = SafeCardHelper.this.iApnAndSafeKey.XKF_GetCardID();
                            break block12;
                        }
                        Object object = SafeCardHelper.this.lock;
                        synchronized (object) {
                            SafeCardHelper.this.lock.wait(5000L);
                            if (SafeCardHelper.this.iApnAndSafeKey != null) {
                                cardID = SafeCardHelper.this.iApnAndSafeKey.XKF_GetCardID();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
                if (SafeCardHelper.this.flag) {
                    SafeCardHelper.this.context.unbindService(SafeCardHelper.this.conn);
                }
                if (SafeCardHelper.this.iApnAndSafeKey != null && SafeCardHelper.this.flag) {
                    SafeCardHelper.this.flag = false;
                }
                return cardID;
            }

            protected void onPostExecute(String cardID) {
                super.onPostExecute((Object)cardID);
                if (safeCardIDListener != null) {
                    if (cardID != null) {
                        safeCardIDListener.onSuccess(cardID);
                    } else {
                        safeCardIDListener.onFail("\u83b7\u53d6\u5b89\u5168\u5361id\u5931\u8d25");
                    }
                }
            }
        };
        asyncTask.executeOnExecutor(this.exec, (Object[])new String[0]);
    }

    public static interface SafeCardIDListener {
        public void onSuccess(String var1);

        public void onFail(String var1);
    }
}

