package com.xdja.autoupdate;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.AsyncTask;
import android.os.Environment;
import android.text.TextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;


public class AutoUpdate {

    private String mFileDir = null;
    // 本地版本信息
    private String mServerIP = ""; // 升级服务器IP
    private String mServerPort = "";// 升级服务端端口
    private String mFactory = ""; // 手机厂商
    private String mMod = ""; // 手机型号
    private String mOS = ""; // 手机操作系统
    private String mSoft = ""; // 升级软件名称
    private String mUserName = "";// 用户
    // 版本历史升级列表
    private ArrayList<VersionInfo> mVersionList = new ArrayList<VersionInfo>();
    // 升级配置信息
    private String mVersion = ""; // 最新版本号
    private String mDate = ""; // 版本发布时间
    private String mComment = ""; // 注释信息
    private String mUpdatetag = "";// 更新类型
    private String mDeleteDb = "";// 是否删除数据库checkCode
    private String mCheckCode = "";// 版本内容校验码
    private String mTempVersion = "";
    private String mTempUpdatetag = "";// 更新类型
    private String mTempDeleteDb = "";// 是否删除数据库checkCode
    private String mTempCheckCode = "";// 版本内容校验码
    private ArrayList<FileInfo> mFileList = new ArrayList<FileInfo>();
    UpdateSocket sl = null;// 网络监听
    //调用方句柄
    public Context mContext = null;
    private UpdateListener mUpdateListener = null;
    private static final String SHARED_DATA = "AutoUpdate";

    private String mBillStr;// 统一认证票据

    private static final String UPDATE_FILE_NAME = "ClientVer.xml";
    private static final String PACT_VERSION = "4.2";
    private static final String REQUEST_TYPE = "checkver";
    private static final String DOWNLOAD_FILE = Environment.getExternalStorageDirectory().getAbsolutePath()
            + "/xdja/downloads/";

    public AutoUpdate(Context context, String fileDir, String billStr, UpdateListener updateListener
    ) {
        mUpdateListener = updateListener;
        mContext = context;
        mFileDir = fileDir;
        mBillStr = billStr;
    }

    public AutoUpdate(Context context, String fileDir, UpdateListener uplisten) {
        this(context, fileDir, null, uplisten);
    }

    public AutoUpdate(Context context, String fileDir) {
        this(context, fileDir, null, null);
    }

    public AutoUpdate() {
        super();
    }

    /**
     * 调用升级程序入口
     */
    public void updateStart() {
        CheckVerTask checktask = new CheckVerTask();
        checktask.execute();
    }

    /**
     * 升级检测信息任务
     */
    private class CheckVerTask extends AsyncTask<String, Integer, String> {

        protected void onPreExecute() {
            if (mUpdateListener != null) {
                mUpdateListener.handlePreCheck();
            }
        }

        protected String doInBackground(String... params) {
            // 生成客服端文件
            createVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);
            // 解析文件
            parseVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);
            // 修正记录的版本升级列表，如果版本相等不修正，若不等就删除最后一个节点
            String verName = "";
            try {
                verName = mContext.getPackageManager().getPackageInfo(
                        mContext.getPackageName(), 0).versionName;
            } catch (NameNotFoundException e) {
                e.printStackTrace();
                if (mUpdateListener != null) {
                    mUpdateListener.handleError(e.getMessage());
                }
            }
            //用当前APK包的版本修正ClientVer中记录的版本
            if (mVersionList.size() > 0) {
                VersionInfo versionInfo = mVersionList.get((mVersionList.size() - 1));
                if (!verName.equals(versionInfo.getVersion())) {
                    mVersionList.remove(mVersionList.size() - 1);
                    reWriteVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);
                }
            }
            StringBuilder checkVer = new StringBuilder();
            checkVer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            checkVer.append("<Root>");
            checkVer.append("<PactVersion>" + PACT_VERSION + "</PactVersion>");
            checkVer.append("<Req>" + REQUEST_TYPE + "</Req>");
            checkVer.append("<Factory>" + mFactory + "</Factory>");
            checkVer.append("<OS>" + mOS + "</OS>");
            checkVer.append("<Mod>" + mMod + "</Mod>");
            checkVer.append("<Soft>" + mSoft + "</Soft>");
            checkVer.append("<UserName>" + mUserName + "</UserName>");
            checkVer.append("<Power/>");
            checkVer.append("<Vers>");
            checkVer.append("<Ver>");
            checkVer.append("<VerType>" + mContext.getPackageName()
                    + "</VerType>");
            checkVer.append("<Version>" + verName + "</Version>");
            checkVer.append("<Date>" + getCurrentDate() + "</Date>");
            checkVer.append("</Ver>");
            checkVer.append("</Vers>");
            checkVer.append("</Root>");

            if (mServerIP.equals("")) {
                return "升级服务器地址设置不正确";
            }

            if (mServerPort.equals("")) {
                return "升级服务器端口设置不正确";
            }

            sl = new UpdateSocket(mServerIP, Integer.parseInt(mServerPort));

            int nres = sl.connect();
            if (nres != 0) {
                sl = null;
                return "连接网络失败";
            }

            nres = sl.sendData(checkVer.toString());
            if (nres != 0) {
                return "发送数据失败";
            }

            String result = sl.recvData();
            if (result == null) {
                return "接收升级确认信息超时";
            } else {
                nres = parseConfirmInfo(result);
                switch (nres) {
                    case 0:
                        result = sl.recvData();
                        if (result == null) {
                            return "接收升级配置信息超时";
                        } else {
                            // 解决断点续传停止后，跨版本无法升级问题
                            if (new File(mFileDir + "/update_s.xml").exists()) {
                                UpdateFunc.writeFile(mFileDir + "/update_temp.xml",
                                        result, false);
                            } else {
                                UpdateFunc.writeFile(mFileDir + "/update_s.xml",
                                        result, false);// 把升级配置信息写入本地文件update_s.xml
                            }

                        }
                        break;
                    case 1:
                        return "无升级版本";
                    case 2:
                        return "当前终端无配置信息";
                    case 3:
                        return "查询升级配置失败";
                    case 4:
                        return "升级配置文件不存在";
                    case -1:
                        return "无法解析升级确认信息";
                }
            }
            return null;
        }

        protected void onPostExecute(String obj) {
            if (obj != null) {// 申请验证或下载升级信息失败
                if (sl != null) {
                    sl.close();
                }
                if (obj.contains("无升级版本")){
                    if (mUpdateListener != null) {
                        mUpdateListener.handleNoVersion();
                    }
                }else {
                    if (mUpdateListener != null) {
                        mUpdateListener.handleError(obj);
                    }
                }
                return;
            }
            // 申请验证和下载升级信息成功
            File file = new File(mFileDir + "/update_s.xml");
            File tempfile = new File(mFileDir + "/update_temp.xml");
            boolean res = parseConfigInfo("update_s.xml");// 解析升级配置信息
            if (!res) {
                // 删除update_s.xml文件
                file.delete();
                if (mUpdateListener != null) {
                    mUpdateListener.handleError("解析升级配置信息失败");
                }
                return;
            }
            // 解决断点续传停止后，跨版本无法升级问题
            if (tempfile.exists()) {
                if (parseTempInfo("update_temp.xml")) {

                    if (!mTempVersion.equals(mVersion)
                            || !TextUtils.equals(mCheckCode, mTempCheckCode)
                            || !TextUtils.equals(mDeleteDb, mTempDeleteDb)
                            || !TextUtils.equals(mUpdatetag, mTempUpdatetag)) {
                        file.delete();
                        SharedPreferences sharePre = mContext
                                .getSharedPreferences(SHARED_DATA, 0);
                        String fname = sharePre.getString("MainFileName",
                                "");
                        if (!TextUtils.isEmpty(fname)) {
                            File tfile = new File(mFileDir + "/" + fname);
                            if (tfile.exists()) {
                                boolean msg = tfile.delete();
                            }
                        }
                        tempfile.renameTo(file);

                        boolean rbool = parseConfigInfo("update_s.xml");// 解析升级配置信息
                        if (!rbool) {
                            // 删除update_s.xml文件
                            file.delete();
                            if (mUpdateListener != null) {
                                mUpdateListener.handleError("解析升级配置信息失败");
                            }
                            return;
                        }
                    } else {
                        tempfile.delete();
                    }
                } else {
                    // 删除update_temp.xml文件
                    tempfile.delete();
                    if (mUpdateListener != null) {
                        mUpdateListener.handleError("解析升级配置信息失败");
                    }
                    return;
                }
            }
            if (mUpdateListener != null) {
                if (sl != null) {// 关闭本次连接
                    sl.close();
                    sl = null;
                }
                mUpdateListener.handleHasVersion(AutoUpdate.this, mUpdatetag, mVersion, mComment);
            }
        }
    }

    /**
     * 不升级
     */
    public void stopUpdate(){

    }

    /**
     * 执行升级
     */
    public void continueUpdate(){
        GetFileTask getfiletask = new GetFileTask();
        getfiletask.execute();
    }
    /**
     * 下载升级文件任务
     */
    private class GetFileTask extends AsyncTask<String, Integer, String> {
        private String fName = null;

        protected void onPreExecute() {
            if (mUpdateListener != null) {
                mUpdateListener.handlePreUpdate();
            }
        }

        @Override
        protected String doInBackground(String... params) {
            int fileListNum = mFileList.size();
            // 如果update_s.xml文件，更新文件信息为空，就删除掉，认为是无效的update_s.xml文件。
            // 写update_s.xml文件没有写完全会出现该情况。
            if (fileListNum == 0) {
                File file = new File(mFileDir + "/update_s.xml");
                file.delete();
                return "无文件更新";
            }

            for (int i = 0; i < fileListNum; i++) {
                FileInfo fi = mFileList.get(i);
                fName = fi.getFilename();

                if (i == fileListNum - 1) {
                    Editor share = mContext
                            .getSharedPreferences(SHARED_DATA, 0).edit();
                    share.putString("MainFileName", fi.getFilename()); // 识别程序的文件名，以后删除用，否则会永久不删除
                    share.putString("DeleteDb", mDeleteDb); // 是否删除数据库文件
                    share.commit();
                }
                // 防止连续追加文件
                if (fi.getCsize() == 0 || fi.getCsize() == fi.getFilesize()) {
                    File fileDir=new File(DOWNLOAD_FILE);
                    if (!fileDir.exists()){
                        fileDir.mkdirs();
                    }
                    File file = new File(DOWNLOAD_FILE + fi.getFilename());
                    // 后台现在完毕没有安装的情形，第二次登陆进行安装
                    if (file.exists()) {
                        try {
                            String code = UpdateFunc.getHash(mFileDir + "/" + fi.getFilename(),
                                    "MD5");
                            if (!code.equals(mCheckCode)) {
                                file.delete();
                                return "文件内容校验失败，请重新下载！";
                            }
                            return null;
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }

                if (fi.getCsize() < fi.getFilesize()) {
                    // 得到文件大小，与update_s.xml记录的已经下载的文件进行比较，如果不一致
                    // 按照实际大小计算
                    File dF = new File(DOWNLOAD_FILE + fi.getFilename());
                    if (dF.exists()) {
                        if (dF.length() != fi.getCsize()) {
                            fi.setCsize((int) dF.length());
                        }
                    }

                    StringBuilder getfile = new StringBuilder();
                    getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    getfile.append("<Root>");

                    getfile.append("<Req>getfile</Req>");
                    getfile.append("<RPath>" + fi.getRpath() + "</RPath>");
                    getfile.append("<LPath>" + fi.getLpath() + "</LPath>");
                    getfile.append("<FName>" + fi.getFilename() + "</FName>");

                    getfile.append("<FSize>" + fi.getFilesize() + "</FSize>");
                    getfile.append("<FPos>" + fi.getCsize() + "</FPos>");
                    if (!TextUtils.isEmpty(mBillStr)) {
                        getfile.append("<Version>4.0</Version>");
                        getfile.append("<BillInfo>" + mBillStr + "</BillInfo>");
                    }
                    getfile.append("</Root>");

                    int nres = -1;
                    if (sl == null) {// 未连接网络

                        if (mServerIP.equals("")) {
                            return "升级服务器地址设置不正确";
                        }
                        if (mServerPort.equals("")) {
                            return "升级服务器端口设置不正确";
                        }

                        sl = new UpdateSocket(mServerIP,
                                Integer.parseInt(mServerPort));
                        nres = sl.connect();
                        if (nres != 0) {
                            sl = null;
                            reWriteConfigInfo(mFileDir + "/update_s.xml");// 重写版本升级配置信息
                            return "连接网络失败";
                        }
                    }

                    nres = sl.sendData(getfile.toString());
                    if (nres != 0) {
                        reWriteConfigInfo(mFileDir + "/update_s.xml");// 重写版本升级配置信息
                        return "发送下载升级文件请求失败";
                    }

                    String result = sl.recvData();
                    if (result == null) {
                        reWriteConfigInfo(mFileDir + "/update_s.xml");// 重写版本升级配置信息
                        return "接收升级文件配置参数超时";
                    } else {
                        int res = parseConfirmInfo(result);
                        boolean flag = true;
                        File file = new File(mFileDir + "/update_s.xml");
                        File tfile = new File(DOWNLOAD_FILE + fi.getFilename());
                        switch (res) {
                            case 0:
                                long startTime = System.currentTimeMillis();
                                while (fi.getCsize() < fi.getFilesize()) {
                                    // 当后台部署的升级文件比较大时socket通道容易充爆，不断的出现下载失败的问题 start
                                    byte[] buf = new byte[10240];// 每次读取10K
                                    int currentLen = 0;

                                    try {
                                        if (sl == null) {
                                            return "socket关闭";
                                        }
                                        // 当后台部署的升级文件比较大时socket通道容易充爆，不断的出现下载失败的问题
                                        // start
                                        currentLen = sl.sin.read(buf, 0, 10240);// 通过socket流读取数据
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                        return "接收升级文件数据超时";
                                    }

                                    if (currentLen == 0) {
                                        reWriteConfigInfo(mFileDir
                                                + "/update_s.xml");// 重写版本升级配置信息
                                        return "接收升级文件数据超时";
                                    } else {
                                        fi.setCsize(fi.getCsize() + currentLen);
                                        long endTime = System.currentTimeMillis();
                                        if (endTime - startTime > 1000) {
                                            startTime = endTime;
                                            publishProgress((int) ((fi.getCsize() / (float) fi.getFilesize()) * 100));
                                        }
                                        FileOutputStream out = null;
                                        try {
                                            String tempStr = DOWNLOAD_FILE
                                                    + fi.getFilename();
                                            out = new FileOutputStream(tempStr,
                                                    true);
                                            // 当后台部署的升级文件比较大时socket通道容易充爆，不断的出现下载失败的问题
                                            out.write(buf, 0, currentLen);
                                            out.flush();
                                            out.close();
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                            tfile.delete();
                                            fi.setState(0);
                                            fi.setCsize(0);
                                            reWriteConfigInfo(mFileDir
                                                    + "/update_s.xml");// 重写版本升级配置信息
                                            return "升级文件写入错误";
                                        }

                                        // 修改文件给与其他包读的权限
//                                        if ((flag)
//                                                && (tfile.exists())) {
//
//                                            try {
//                                                Runtime.getRuntime()
//                                                        .exec("chmod 644 "
//                                                                + DOWNLOAD_FILE
//                                                                + fi.getFilename());
//                                                flag = false;
//                                            } catch (Exception e) {
//                                                flag = true;
//                                                e.printStackTrace();
//                                            }
//
//                                        }

                                        if (fi.getCsize() >= fi.getFilesize()) {
                                            // 文件处理完毕
                                            fi.setState(2);
                                            reWriteConfigInfo(mFileDir
                                                    + "/update_s.xml");// 重写版本升级配置信息
                                            // 利用校验码进行校验证
                                            try {
                                                String Code = UpdateFunc.getHash(DOWNLOAD_FILE
                                                        + fi.getFilename(), "MD5");
                                                if (!Code.equals(mCheckCode)) {

                                                    tfile.delete();
                                                    fi.setState(0);
                                                    fi.setCsize(0);
                                                    reWriteConfigInfo(mFileDir
                                                            + "/update_s.xml");// 重写版本升级配置信息
                                                    return "文件内容校验失败，请重新下载！";

                                                }
                                            } catch (Exception e) {
                                                e.printStackTrace();
                                            }

                                            break;
                                        } else {
                                            // 文件正在处理
                                            fi.setState(1);
                                            reWriteConfigInfo(mFileDir
                                                    + "/update_s.xml");// 重写版本升级配置信息
                                        }
                                    }
                                }

                                break;
                            case 1:
                                // 删除update_s.xml文件,否则一次不成功就保留该文件无法更新。
                                file.delete();
                                return "文件不存在";
                            case 2:
                                file.delete();
                                return "读取文件失败";
                            case 3:
                                file.delete();
                                return "文件大小不附";
                            case 4:
                                file.delete();
                                return "指定偏移量无效";
                            case 5:
                                file.delete();
                                return "参数不完整";
                            case -1:
                                return "解析返回升级失败";
                        }

                    }
                }
            }

            return null;
        }

        protected void onPostExecute(String obj) {
            if (sl != null) {// 关闭本次连接
                sl.close();
                sl = null;
            }
            String result = obj;
            if (!TextUtils.isEmpty(result)) {// 下载升级文件失败
                if (mUpdateListener != null) {
                    mUpdateListener.handleError(result);
                }
                return;
            }
            //下载成功
            if (mUpdateListener != null) {
                mUpdateListener.handleUpdateSuccess();
            }
            // 执行升级文件
            for (int i = 0; i < mFileList.size(); i++) {
                final FileInfo fi = mFileList.get(i);

//                Intent intent = new Intent(Intent.ACTION_VIEW);
//                intent.setDataAndType(
//                        Uri.fromFile(new File(mFileDir + "/"
//                                + fi.getFilename())),
//                        "application/vnd.android.package-archive");
//                intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//                mContext.startActivity(intent);

                PackageManager pm = mContext.getPackageManager();
                PackageInfo info = pm.getPackageArchiveInfo(DOWNLOAD_FILE
                        + fi.getFilename(), PackageManager.GET_ACTIVITIES);
                ApplicationInfo appInfo = null;
                String packageName = "";
                if (info != null) {
                    appInfo = info.applicationInfo;
                    packageName = appInfo.packageName;
                }

                PackageUtils.installNormal(mContext, DOWNLOAD_FILE
                        + fi.getFilename(),packageName);

            }

            // 删除update_s.xml文件
            File file = new File(mFileDir + "/update_s.xml");
            file.delete();
            // 写入版本升级文件
            VersionInfo ver = new VersionInfo();
            ver.setVersion(mVersion);
            ver.setDate(mDate);
            ver.setNote(mComment);
            mVersionList.add(ver);
            reWriteVersionInfo(mFileDir + "/ClientVer.xml");

        }

        protected void onProgressUpdate(Integer... values) {
            // 更新进度
            if (mUpdateListener != null) {
                mUpdateListener.handleProgressUpdate(fName, values[0]);
            }

        }


    }

    /**
     * 创建本地版本信息
     */
    private void createVersionInfo(String filename) {
        if (!(new File(filename).exists())) {
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = mContext.getResources().getAssets()
                        .open(UPDATE_FILE_NAME);
                out = mContext.openFileOutput(UPDATE_FILE_NAME,
                        Context.MODE_PRIVATE);
                byte[] buffer = new byte[8192];
                int count = 0;
                // 开始复制文件
                while ((count = in.read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                    out.flush();
                }
                in.close();
                out.close();
            } catch (Exception ioe) {
                ioe.printStackTrace();
            }

        }

    }

    public void delUserdata(Context context) {
        String verName = "";
        try {
            verName = context.getPackageManager().getPackageInfo(
                    context.getPackageName(), 0).versionName;
        } catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        createVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);// 生成客服端文件

        SharedPreferences sharePre = context.getSharedPreferences(SHARED_DATA,
                0);
        String versionCode = sharePre.getString("versionCode", "");
        if (verName.equals(versionCode)) {
            return;
        }
        // 解析文件
        parseVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);
        if (mVersionList.size() > 0) {
            VersionInfo vi = mVersionList.get((mVersionList.size() - 1));
            if (verName.equals(vi.getVersion())) {
                // 记录版本号，保证升级一个版本只删除一次数据库，删除安装程序
                try {
                    Editor share = context.getSharedPreferences(SHARED_DATA, 0)
                            .edit();
                    share.putString("versionCode", verName);
                    share.commit();
                    String delDb = sharePre.getString("DeleteDb", "");

                    String fname = sharePre.getString("MainFileName", "");
                    if (!TextUtils.isEmpty(fname)) {
                        File tfile = new File(mFileDir + "/" + fname);
                        if (tfile.exists()) {
                            boolean msg = tfile.delete();
                        }
                    }
                    if (!TextUtils.isEmpty(delDb)) {
                        if (delDb.equals("1")) {
//                            clearTempDate(mFileDir);
//                            deleteDataBases(context,databases);
                            if (mUpdateListener != null){
                                mUpdateListener.deleteDataBase(vi.getVersion());
                            }
                        }
                    }

                } catch (Exception e) {
                    e.printStackTrace();
                }

            }
        }

    }

    private void deleteDataBases(Context context,ArrayList<String> databases){
        for (int i = 0;i<databases.size();i++){
            context.deleteDatabase(databases.get(i));
        }
    }

    /**
     * 清除所有临时文件
     *
     * @param fileDir 配置信息存放路径，为客户端私有目录：/data/data/应用包名/files
     */
    private void clearTempDate(String fileDir) {
        File dir = new File(fileDir);
        // 删除文件夹下的文件
        deleteDir(dir);
    }

    /**
     * 删除文件夹
     *
     * @return true删除文件夹成功，false删除文件夹失败
     */
    private boolean deleteDir(File dirFile) {
        // System.out.println("entry " + dirFile.getAbsolutePath());
        boolean flag = false;
        File fileArray[] = dirFile.listFiles();
        if (fileArray == null) {// 文件夹为空，删除文件夹
            return dirFile.delete();
        } else {// 文件不为空
            for (File fp : fileArray) {
                if (fp.isFile()) {// 删除文件夹中文件
                    if (!fp.delete()) {
                        return false;
                    }
                } else {// 删除文件夹中文件夹
                    flag = deleteDir(fp);
                    if (!flag) {// 删除文件夹失败
                        return false;
                    } else {// 删除文件夹中文件和文件夹成功
                        flag = fp.delete();// 删除文件夹本身
                        if (!flag) {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * 解析版本信息
     */
    private void parseVersionInfo(String filename) {

        mVersionList.clear(); // 在未配置升级信息强进入升级程序会有数据，故清空数据。
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (nodeList.item(0).getFirstChild() != null) {
                mServerIP = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器IP
            }

            nodeList = root.getElementsByTagName("ServerPort");
            if (nodeList.item(0).getFirstChild() != null) {
                mServerPort = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器Port
            }

            nodeList = root.getElementsByTagName("Factory");
            if (nodeList.item(0).getFirstChild() != null) {
                mFactory = nodeList.item(0).getFirstChild().getNodeValue();// 取手机厂商
            }

            nodeList = root.getElementsByTagName("Mod");
            if (nodeList.item(0).getFirstChild() != null) {
                mMod = nodeList.item(0).getFirstChild().getNodeValue();// 取手机型号
            }

            nodeList = root.getElementsByTagName("OS");
            if (nodeList.item(0).getFirstChild() != null) {
                mOS = nodeList.item(0).getFirstChild().getNodeValue();// 取手机系统
            }

            nodeList = root.getElementsByTagName("Soft");
            if (nodeList.item(0).getFirstChild() != null) {
                mSoft = nodeList.item(0).getFirstChild().getNodeValue();// 取升级软件名称
            }

            nodeList = root.getElementsByTagName("UserName");
            if (nodeList.item(0).getFirstChild() != null) {
                mUserName = nodeList.item(0).getFirstChild().getNodeValue();// 取用户名
            }

            nodeList = root.getElementsByTagName("Ver");// 取升级版本历史信息
            int nodeNum = nodeList.getLength();

            Element childElement = null;
            NodeList childList = null;

            for (int i = 0; i < nodeNum; i++) {
                VersionInfo versionInfo = new VersionInfo();
                childElement = (Element) nodeList.item(i);
                childList = childElement.getElementsByTagName("Version");
                // 取版本信息
                versionInfo.setVersion(childList.item(0).getFirstChild().getNodeValue());

                childList = childElement.getElementsByTagName("Date");
                // 取版本信息
                versionInfo.setDate(childList.item(0).getFirstChild().getNodeValue());

                childList = childElement.getElementsByTagName("Note");
                if (childList.item(0).getFirstChild() != null) {
                    // 取版本信息
                    versionInfo.setNote(childList.item(0).getFirstChild().getNodeValue());
                }
                mVersionList.add(versionInfo);// 添加版本信息到链表中
            }

        } catch (Exception ex) {
            ex.printStackTrace();

        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /*
     * 解析版本升级确认信息
     */
    private int parseConfirmInfo(String confirmInfo) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(
                    confirmInfo.getBytes());
            doc = docBuilder.parse(stream);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Result");
            if (nodeList.item(0).getFirstChild() != null) {
                String result = nodeList.item(0).getFirstChild().getNodeValue();// 取版本升级确认信息
                return Integer.parseInt(result);
            } else {
                return -1;
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /*
     * 解析版本升级配置信息
     */
    private boolean parseConfigInfo(String filename) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        boolean res = false;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(mFileDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Version");
            if (nodeList.item(0).getFirstChild() != null) {
                mVersion = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本号
            }

            nodeList = root.getElementsByTagName("DeleteDb");
            if (nodeList.item(0).getFirstChild() != null) {
                mDeleteDb = nodeList.item(0).getFirstChild().getNodeValue();// 是否删除数据库
                // 0
                // 不删除，1删除
            }

            nodeList = root.getElementsByTagName("CheckCode");
            if (nodeList.item(0).getFirstChild() != null) {
                mCheckCode = nodeList.item(0).getFirstChild().getNodeValue();// 版本内容校验码
            }

            nodeList = root.getElementsByTagName("Date");
            if (nodeList.item(0).getFirstChild() != null) {
                mDate = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本发布时间
            }

            nodeList = root.getElementsByTagName("Comment");
            if (nodeList.item(0).getFirstChild() != null) {
                mComment = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本注释信息
            }

            nodeList = root.getElementsByTagName("UpdateTag");
            if (nodeList.item(0).getFirstChild() != null) {
                mUpdatetag = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本更新类型
            }

            nodeList = root.getElementsByTagName("File");// 取升级版本文件列表
            int nodeNum = nodeList.getLength();

            Element childElement = null;
            NodeList childList = null;
            for (int i = 0; i < nodeNum; i++) {
                FileInfo fileInfo = new FileInfo();
                childElement = (Element) nodeList.item(i);
                childList = childElement.getElementsByTagName("RPath");
                // 远程文件所在路径
                fileInfo.setRpath(childList.item(0).getFirstChild().getNodeValue());

                childList = childElement.getElementsByTagName("LPath");
                // 本地文件所在路径
                fileInfo.setLpath(childList.item(0).getFirstChild().getNodeValue());

                childList = childElement.getElementsByTagName("FName");
                if (childList.item(0).getFirstChild() != null) {
                    fileInfo.setFilename(childList.item(0).getFirstChild()
                            .getNodeValue());
                }

                childList = childElement.getElementsByTagName("FSize");
                if (childList.item(0).getFirstChild() != null) {
                    //文件大小
                    fileInfo.setFilesize(Integer.parseInt(childList.item(0)
                            .getFirstChild().getNodeValue()));
                }

                childList = childElement.getElementsByTagName("Action");
                if (childList.item(0).getFirstChild() != null) {
                    // 动作类型
                    fileInfo.setAction(Integer.parseInt(childList.item(0)
                            .getFirstChild().getNodeValue()));
                }

                childList = childElement.getElementsByTagName("State");
                if (childList.item(0).getFirstChild() != null) {
                    // 当前状态
                    fileInfo.setState(Integer.parseInt(childList.item(0)
                            .getFirstChild().getNodeValue()));
                }

                childList = childElement.getElementsByTagName("CSize");
                if (childList.item(0).getFirstChild() != null) {
                    // 当前已经下载大小
                    fileInfo.setCsize(Integer.parseInt(childList.item(0)
                            .getFirstChild().getNodeValue()));
                }
                mFileList.clear();
                mFileList.add(fileInfo);// 添加文件信息到链表中
            }
            res = true;

        } catch (Exception ex) {
            ex.printStackTrace();
            res = false;

        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return res;

    }

    /*
     * 解析版本临时配置信息
     */
    private boolean parseTempInfo(String filename) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        boolean res = false;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(mFileDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();

            NodeList nodeList = root.getElementsByTagName("Version");
            if (nodeList.item(0).getFirstChild() != null) {
                mTempVersion = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本号
            }

            nodeList = root.getElementsByTagName("DeleteDb");
            if (nodeList.item(0).getFirstChild() != null) {
                mTempDeleteDb = nodeList.item(0).getFirstChild().getNodeValue();// 是否删除数据库
                // 0
                // 不删除，1删除
            }

            nodeList = root.getElementsByTagName("UpdateTag");
            if (nodeList.item(0).getFirstChild() != null) {
                mTempUpdatetag = nodeList.item(0).getFirstChild().getNodeValue();// 取升级版本更新类型
            }

            nodeList = root.getElementsByTagName("CheckCode");
            if (nodeList.item(0).getFirstChild() != null) {
                mTempCheckCode = nodeList.item(0).getFirstChild().getNodeValue();// 版本内容校验码
            }

            res = true;

        } catch (Exception ex) {
            ex.printStackTrace();
            res = false;

        } finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return res;

    }

    /**
     * 重写版本信息
     */
    private void reWriteVersionInfo(String filename) {
        StringBuffer verstr = new StringBuffer();
        verstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        verstr.append("<Root>");
        verstr.append("<ServerIP>" + mServerIP + "</ServerIP>");
        verstr.append("<ServerPort>" + mServerPort + "</ServerPort>");
        verstr.append("<Factory>" + mFactory + "</Factory>");
        verstr.append("<Mod>" + mMod + "</Mod>");
        verstr.append("<OS>" + mOS + "</OS>");
        verstr.append("<Soft>" + mSoft + "</Soft>");
        verstr.append("<UserName>" + mUserName + "</UserName>");
        int verListNum = mVersionList.size();
        VersionInfo versionInfo = null;
        for (int i = 0; i < verListNum; i++) {// 版本升级历史信息
            versionInfo = mVersionList.get(i);
            verstr.append("<Ver>");
            verstr.append("<Version>" + versionInfo.getVersion() + "</Version>");
            verstr.append("<Date>" + versionInfo.getDate() + "</Date>");
            verstr.append("<Note>" + versionInfo.getNote() + "</Note>");
            verstr.append("</Ver>");
        }
        verstr.append("</Root>");
        UpdateFunc.writeFile(filename, verstr.toString(), false);// 初始化客户端版本信息
    }

    /**
     * 重写版本升级配置信息
     */
    private void reWriteConfigInfo(String filename) {
        StringBuffer getfile = new StringBuffer();
        getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        getfile.append("<Root>");
        getfile.append("<Version>" + mVersion + "</Version>");
        getfile.append("<Date>" + mDate + "</Date>");
        getfile.append("<Comment>" + mComment + "</Comment>");
        getfile.append("<UpdateTag>" + mUpdatetag + "</UpdateTag>");
        getfile.append("<DeleteDb>" + mDeleteDb + "</DeleteDb>");
        getfile.append("<CheckCode>" + mCheckCode + "</CheckCode>");
        getfile.append("<Files>");
        int fileListNum = mFileList.size();
        FileInfo fi = null;
        for (int i = 0; i < fileListNum; i++) {// 文件列表
            fi = mFileList.get(i);
            getfile.append("<File>");
            getfile.append("<RPath>" + fi.getRpath() + "</RPath>");
            getfile.append("<LPath>" + fi.getLpath() + "</LPath>");
            getfile.append("<FName>" + fi.getFilename() + "</FName>");
            getfile.append("<FSize>" + fi.getFilesize() + "</FSize>");
            getfile.append("<Action>" + fi.getAction() + "</Action>");
            getfile.append("<State>" + fi.getState() + "</State>");
            getfile.append("<CSize>" + fi.getCsize() + "</CSize>");
            getfile.append("</File>");
        }
        getfile.append("</Files>");
        getfile.append("</Root>");
        UpdateFunc.writeFile(filename, getfile.toString(), false);// 重写版本升级配置信息
    }

    /**
     * 获取当前日期
     */
    private String getCurrentDate() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy-MM-dd");
        return sdf.format(new java.util.Date());
    }


    /**
     * 获取升级服务器配置
     */
    public ArrayList<String> getUpdateConfig() {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        ArrayList<String> IP_Port = new ArrayList<String>();
        String updateIP = "";
        String updatePort = "";

        createVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);

        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(mFileDir + "/"
                    + UPDATE_FILE_NAME);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (nodeList.item(0).getFirstChild() != null) {
                updateIP = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器IP
            }
            nodeList = root.getElementsByTagName("ServerPort");
            if (nodeList.item(0).getFirstChild() != null) {
                updatePort = nodeList.item(0).getFirstChild().getNodeValue();// 取升级服务器Port
            }
            IP_Port.add(updateIP);
            IP_Port.add(updatePort);
            in.close();
        } catch (Exception ex) {
            ex.printStackTrace();

        } finally {

            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return IP_Port;

    }


    /**
     * 修改升级服务器配置
     */
    public void setUpdateConfig(String updateIP,
                                String updatePort) {
        // 解析文件
        try {
            parseVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);
            mServerIP = updateIP;
            mServerPort = updatePort;
            reWriteVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);
        } catch (Exception ex) {
            ex.printStackTrace();

        }

    }

    public void updateConfig(String updateIP, String updatePort) {

        // 解析文件
        try {
            createVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);// 生成客服端文件
            parseVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);
            if(!TextUtils.equals(updateIP, mServerIP)
                    || !TextUtils.equals(updatePort, mServerPort)) {
                mServerIP = updateIP;
                mServerPort = updatePort;
                reWriteVersionInfo(mFileDir + "/" + UPDATE_FILE_NAME);
            }
        } catch (Exception ex) {
            ex.printStackTrace();

        }

    }

}