package com.xdja.autoupdate;

import android.app.ActivityManager;
import android.app.ActivityManager.RunningTaskInfo;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;

import com.justsy.android.sdk.JustsyAppHelper;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/**
 * PackageUtils
 *
 * @author <a href="http://www.trinea.cn" target="_blank">Trinea</a> 2013-5-15
 */
public class PackageUtils {
    /**
     * 安装模式
     */
    public static final class INSTALLTYPE {

        public static int SYSTEM = 0;//默认安装，调用系统安装
        public static int SILENCE_XIAN = 1;//西安警务通，使用第三方包实现静默安装

    }

    public static final String TAG = "PackageUtils";
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int APP_INSTALL_EXTERNAL = 2;

    public interface OnInstallListener {
        void onFinished(int res);
    }

    public static boolean installNormal(Context context, String filePath, String packageName) {
        return installNormal(context, filePath, packageName, INSTALLTYPE.SYSTEM);
    }

    public static boolean installNormal(Context context, String filePath, String packageName, int installType) {

        //调用系统安装方式
        if (installType == INSTALLTYPE.SYSTEM) {
            Intent i = new Intent(Intent.ACTION_VIEW);
            File file = new File(filePath);
            if (file == null || !file.exists() || !file.isFile()
                    || file.length() <= 0) {
                return false;
            }

            i.setDataAndType(Uri.fromFile(file),
                    "application/vnd.android.package-archive");
            i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(i);
        } else if (installType == INSTALLTYPE.SILENCE_XIAN) {
            //西安警务通安装方式
            JustsyAppHelper.install(context, packageName, filePath);
        }


        return true;
    }

    /**
     * 第三方应用程序的过滤器,
     *
     * @param info
     * @return true 三方应用 false 系统应用.
     */
    public static boolean filterApp(ApplicationInfo info) {

        if ((info.flags & ApplicationInfo.FLAG_UPDATED_SYSTEM_APP) != 0) {
            return true;
        } else if ((info.flags & ApplicationInfo.FLAG_SYSTEM) == 0) {
            return true;
        }
        return false;
    }

    public static int getLaunchCount(Context context, String packageName) {
        int aLaunchCount = 0;
        PackageManager pm = context.getPackageManager();
        Intent i = pm.getLaunchIntentForPackage(packageName);
        ComponentName aName = i.getComponent();
        try {
            // 获得ServiceManager类
            Class<?> ServiceManager = Class
                    .forName("android.os.ServiceManager");
            // 获得ServiceManager的getService方法
            Method getService = ServiceManager.getMethod("getService",
                    String.class);
            // 调用getService获取RemoteService
            Object oRemoteService = getService.invoke(null, "usagestats");
            // 获得IUsageStats.Stub类
            Class<?> cStub = Class
                    .forName("com.android.internal.app.IUsageStats$Stub");
            // 获得asInterface方法
            Method asInterface = cStub.getMethod("asInterface",
                    android.os.IBinder.class);
            // 调用asInterface方法获取IUsageStats对象
            Object oIUsageStats = asInterface.invoke(null, oRemoteService);
            // 获得getPkgUsageStats(ComponentName)方法
            Method getPkgUsageStats = oIUsageStats.getClass().getMethod(
                    "getPkgUsageStats", ComponentName.class);
            // 调用getPkgUsageStats 获取PkgUsageStats对象
            Object aStats = getPkgUsageStats.invoke(oIUsageStats, aName);
            // 获得PkgUsageStats类
            Class<?> PkgUsageStats = Class
                    .forName("com.android.internal.os.PkgUsageStats");
            aLaunchCount = PkgUsageStats.getDeclaredField("launchCount")
                    .getInt(aStats);
            //                         aUseTime =
            // PkgUsageStats.getDeclaredField("usageTime").getLong(
            //                                         aStats);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return aLaunchCount;
    }

    /**
     * 通过versionName比较两个版本号的大小
     *
     * @param oldVersion 旧版本
     * @param curVersion 当前版本
     * @return
     */
    public static boolean compareVersionByName(String oldVersion, String curVersion) {
        long oldVersion_ = 0;
        long curVersion_ = 0;
        try {
            oldVersion_ = Long.decode(oldVersion.replace(".", ""));
            curVersion_ = Long.decode(curVersion.replace(".", ""));
            return curVersion_ > oldVersion_;
        } catch (Exception e) {
        }
        return false;
    }

    /**
     * 通过VersionCode比较版本大小
     *
     * @param oldVersion
     * @param curVersion
     * @return
     */
    public static boolean compareVersionByCode(int oldVersion, int curVersion) {
        return curVersion > oldVersion;
    }

    /**
     * uninstall according conditions
     * <ul>
     * <li>if system application or rooted, see
     * <li>else see {@link #uninstallNormal(android.content.Context, String)}</li>
     * </ul>
     *
     * @param context
     * @param packageName package name of app
     * @return
     */
    public static final int uninstall(Context context, String packageName) {
//		if (PackageUtils.isSystemApplication(context)
//				|| ShellUtils.checkRootPermission()) {
//			return uninstallSilent(context, packageName);
//		}
        return uninstallNormal(context, packageName) ? DELETE_SUCCEEDED
                : DELETE_FAILED_INVALID_PACKAGE;
    }

    /**
     * uninstall package normal by system intent
     *
     * @param context
     * @param packageName package name of app
     * @return whether package name is empty
     */
    public static boolean uninstallNormal(Context context, String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return false;
        }

        Intent i = new Intent(Intent.ACTION_DELETE,
                Uri.parse(new StringBuilder(32).append("package:")
                        .append(packageName).toString()));
        i.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(i);
        return true;
    }

    /**
     * whether context is system application
     *
     * @param context
     * @return
     */
    public static boolean isSystemApplication(Context context) {
        if (context == null) {
            return false;
        }

        return isSystemApplication(context, context.getPackageName());
    }

    /**
     * whether packageName is system application
     *
     * @param context
     * @param packageName
     * @return
     */
    public static boolean isSystemApplication(Context context,
                                              String packageName) {
        if (context == null) {
            return false;
        }

        return isSystemApplication(context.getPackageManager(), packageName);
    }

    /**
     * whether packageName is system application
     *
     * @param packageManager
     * @param packageName
     * @return <ul>
     * <li>if packageManager is null, return false</li>
     * <li>if package name is null or is empty, return false</li>
     * <li>if package name not exit, return false</li>
     * <li>if package name exit, but not system app, return false</li>
     * <li>else return true</li>
     * </ul>
     */
    public static boolean isSystemApplication(PackageManager packageManager,
                                              String packageName) {
        if (packageManager == null || packageName == null
                || packageName.length() == 0) {
            return false;
        }

        try {
            ApplicationInfo app = packageManager.getApplicationInfo(
                    packageName, 0);
            return (app != null && (app.flags & ApplicationInfo.FLAG_SYSTEM) > 0);
        } catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    /**
     * whether the app whost package's name is packageName is on the top of the
     * stack
     * <ul>
     * <strong>Attentions:</strong>
     * <li>You should add <strong>android.permission.GET_TASKS</strong> in
     * manifest</li>
     * </ul>
     *
     * @param context
     * @param packageName
     * @return if params error or task stack is null, return null, otherwise
     * retun whether the app is on the top of stack
     */
    public static Boolean isTopActivity(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty(packageName)) {
            return false;
        }

        ActivityManager activityManager = (ActivityManager) context
                .getSystemService(Context.ACTIVITY_SERVICE);
        List<RunningTaskInfo> tasksInfo = activityManager.getRunningTasks(1);
        if (tasksInfo == null || tasksInfo.size() == 0) {
            return false;
        }
        try {
            return packageName.equals(tasksInfo.get(0).topActivity
                    .getPackageName());
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * get app version code
     *
     * @param context
     * @return
     */
    public static int getAppVersionCode(Context context) {
        if (context != null) {
            PackageManager pm = context.getPackageManager();
            if (pm != null) {
                PackageInfo pi;
                try {
                    pi = pm.getPackageInfo(context.getPackageName(), 0);
                    if (pi != null) {
                        return pi.versionCode;
                    }
                } catch (NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return -1;
    }


    public static String getAppVersionName(Context context) {
        if (context != null) {
            PackageManager pm = context.getPackageManager();
            if (pm != null) {
                PackageInfo pi;
                try {
                    pi = pm.getPackageInfo(context.getPackageName(), 0);
                    if (pi != null) {
                        return pi.versionName;
                    }
                } catch (NameNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    /**
     * 判断应用是否安装在SD卡
     *
     * @param context
     * @param packageName
     * @return
     * @description
     * @author hkb
     * @since 2014-4-8下午8:21:58
     */
    public static boolean isInstallInSDCard(Context context, String packageName) {
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 0);
            if ((appInfo.flags & ApplicationInfo.FLAG_EXTERNAL_STORAGE) != 0) {
                return true;
            } else {
                return false;
            }
        } catch (NameNotFoundException e) {
            return false;
        }
    }

    /**
     * 判断应用是否已安装
     *
     * @param context
     * @param packageName
     * @return
     * @description
     * @author hkb
     * @since 2014-4-8下午8:23:22
     */
    public static boolean isInstalled(Context context, String packageName) {
        PackageInfo packageInfo;

        try {
            packageInfo = context.getPackageManager().getPackageInfo(
                    packageName, 0);
        } catch (NameNotFoundException e) {
            packageInfo = null;
//			e.printStackTrace();
        }
        if (packageInfo == null) {
            return false;
        } else {
            return true;
        }

    }

    /**
     * start InstalledAppDetails Activity
     *
     * @param context
     * @param packageName
     */
    public static void startInstalledAppDetails(Context context,
                                                String packageName) {
        Intent intent = new Intent();
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion >= 9) {
            intent.setAction(Settings.ACTION_APPLICATION_DETAILS_SETTINGS);
            intent.setData(Uri.fromParts("package", packageName, null));
        } else {
            intent.setAction(Intent.ACTION_VIEW);
            intent.setClassName("com.android.settings",
                    "com.android.settings.InstalledAppDetails");
            intent.putExtra((sdkVersion == 8 ? "pkg"
                    : "com.android.settings.ApplicationPkgName"), packageName);
        }
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    /**
     * 获取已安装的应用
     *
     * @param context 句柄
     * @return 已经安装的应用
     */
    public static List<ApplicationInfo> getInstalledApp(Context context) {
        List<ApplicationInfo> installedAppList = new ArrayList<>();
        //modify by dut at 20150306将0改为GET_UNINSTALLED_PACKAGES
//        List<PackageInfo> packages = context.getPackageManager().getInstalledPackages(0);
        List<PackageInfo> packages = context.getPackageManager().
                getInstalledPackages(PackageManager.GET_UNINSTALLED_PACKAGES);
        //end modify
        for (PackageInfo pkg : packages) {
            if ((pkg.applicationInfo.flags & ApplicationInfo.FLAG_SYSTEM) == 0) {
                ApplicationInfo info = pkg.applicationInfo;
                installedAppList.add(info);
            }
        }
        return installedAppList;
    }

    /**
     * Uninstall return code<br/>
     * uninstall success.
     */
    public static final int DELETE_SUCCEEDED = 1;

    /**
     * Uninstall return code<br/>
     * uninstall fail if pcakge name is invalid
     */
    public static final int DELETE_FAILED_INVALID_PACKAGE = -3;

}
