package com.xdja.autoupdate;

public interface UpdateListener {
	/**
	 * 执行升级检测前回调
	 */
	public void handlePreCheck();

	/**
	 * 升级过程错误
	 * @param msg 错误信息
	 */
	public void handleError(String msg);

	/**
	 * 无升级版本
	 */
	public void handleNoVersion();

	/**
	 * 发现升级版本
	 * @param updateTag 后台配制“0”普通升级“1”强制升级
	 * @param version 新版本
	 * @param comment 升级信息
	 * @return true需要升级false暂不升级
	 */
	public void handleHasVersion(AutoUpdate autoUpdate, String updateTag, String version, String comment);

	/**
	 * 执行升级前回调
	 */
	public void handlePreUpdate();

	/**
	 * 升级时文件下载回调
	 * @param fileName 当前下载的文件名
	 * @param position 当前下载的百分比
	 */
	public void handleProgressUpdate(String fileName, int position);

	/**
	 * 升级成功
	 */
	public void handleUpdateSuccess();

	/**
	 * 后台配制需要删除数据库
	 * @param version apk版本
	 */
	public void deleteDataBase(String version);

}
