package com.xdja.autoupdate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

public class UpdateSocket {
    private String ip = null;
    private int port = 0;
    private Socket conn = null;
    public InputStream sin = null; // 网络输入流
    private OutputStream sou = null;// 网络输出流
    private int mConnectTimeOut = 5000;// 超时时长(5秒)
    private int mSoTimeOut = 60000;//数据收发超时（60秒）

    public UpdateSocket(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public void setConnectTimeOut(int timeOut) {
        mConnectTimeOut = timeOut;
    }

    public void setTimeOut(int timeOut){
        mSoTimeOut = timeOut;
    }


    public boolean isConnected() {
        return conn.isConnected();
    }

    /**
     * 连接服务器
     *
     * @return 成功返回0 不成功返回-1 errmsg中包含错误信息
     */
    public int connect() {
        try {
            conn = new Socket();
            SocketAddress address = new InetSocketAddress(ip, port);
            conn.connect(address, mConnectTimeOut);
            conn.setSoTimeout(mSoTimeOut);
            sin = conn.getInputStream();
            sou = conn.getOutputStream();
            return 0;
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }

    }

    public int sendData(String reqstr) {
        int dataLen = 0;
        byte[] data = null;
        try {
            dataLen = reqstr.getBytes("UTF-8").length;
            data = new byte[dataLen + 2];
            data[0] = (byte) (dataLen >> 8 & 0xff);
            data[1] = (byte) (dataLen & 0xff);// 两个字节数据长度
            System.arraycopy(reqstr.getBytes("UTF-8"), 0, data, 2, dataLen);// 数据内容

            sou.write(data);
            sou.flush();
            return 0;
        } catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String recvData() {
        try {
            byte[] data = null;
            int dataLen = 0;
            int currentLen = 0;

            byte[] len = new byte[2];// 头2个字节是数据长度+ 后面数据内容

            int headlen = sin.read(len);
            while (headlen < 2) {
                int tempLen = sin.read(len, headlen, 2 - headlen);
                if (tempLen == -1) {
                    return null;
                }
                headlen += tempLen;
            }
            dataLen = Bytes2ToInt(len);// (len[0]&0xff)<<8 + len[1]&0xff;
            data = new byte[dataLen];
            int tempLen = 0;
            while (currentLen < dataLen) {
                tempLen = sin.read(data, currentLen, dataLen - currentLen);
                if (tempLen == -1) {
                    break;
                }
                currentLen += tempLen;
            }

            return new String(data, "utf-8");
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] recvDataNolength(int dataLen) {
        try {
            byte[] data = new byte[dataLen];

            int currentLen = 0;

            while (currentLen < dataLen) {
                currentLen += sin.read(data, currentLen, dataLen - currentLen);
            }
            return data;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int Bytes2ToInt(byte[] b) {
        int mask = 0xff;
        int temp = 0;
        int res = 0;
        for (int i = 0; i < 2; i++) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
        }
        return res;
    }

    public static byte[] IntToBytes2(int num) {
        byte[] b = new byte[2];
        for (int i = 0; i < 2; i++) {
            b[i] = (byte) (num >> (8 - i * 8) & 0xff);
        }
        return b;
    }

    public void close() {
        try {
            sin.close();
            sou.close();
            conn.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
