/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.autoupdate;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.AsyncTask;
import android.os.Environment;
import android.text.TextUtils;
import com.xdja.autoupdate.FileInfo;
import com.xdja.autoupdate.PackageUtils;
import com.xdja.autoupdate.UpdateFunc;
import com.xdja.autoupdate.UpdateListener;
import com.xdja.autoupdate.UpdateSocket;
import com.xdja.autoupdate.VersionInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AutoUpdate {
    private String mFileDir = null;
    private String mServerIP = "";
    private String mServerPort = "";
    private String mFactory = "";
    private String mMod = "";
    private String mOS = "";
    private String mSoft = "";
    private String mUserName = "";
    private ArrayList<VersionInfo> mVersionList = new ArrayList();
    private String mVersion = "";
    private String mDate = "";
    private String mComment = "";
    private String mUpdatetag = "";
    private String mDeleteDb = "";
    private String mCheckCode = "";
    private String mTempVersion = "";
    private String mTempUpdatetag = "";
    private String mTempDeleteDb = "";
    private String mTempCheckCode = "";
    private ArrayList<FileInfo> mFileList = new ArrayList();
    UpdateSocket sl = null;
    public Context mContext = null;
    private UpdateListener mUpdateListener = null;
    private static final String SHARED_DATA = "AutoUpdate";
    private String mBillStr;
    private static final String UPDATE_FILE_NAME = "ClientVer.xml";
    private static final String PACT_VERSION = "4.2";
    private static final String REQUEST_TYPE = "checkver";
    private static final String DOWNLOAD_FILE = Environment.getExternalStorageDirectory().getAbsolutePath() + "/xdja/downloads/";

    public AutoUpdate(Context context, String fileDir, String billStr, UpdateListener updateListener) {
        this.mUpdateListener = updateListener;
        this.mContext = context;
        this.mFileDir = fileDir;
        this.mBillStr = billStr;
    }

    public AutoUpdate(Context context, String fileDir, UpdateListener uplisten) {
        this(context, fileDir, null, uplisten);
    }

    public AutoUpdate(Context context, String fileDir) {
        this(context, fileDir, null, null);
    }

    public AutoUpdate() {
    }

    public void updateStart() {
        CheckVerTask checktask = new CheckVerTask();
        checktask.execute(new String[0]);
    }

    public void stopUpdate() {
    }

    public void continueUpdate() {
        GetFileTask getfiletask = new GetFileTask();
        getfiletask.execute(new String[0]);
    }

    private void createVersionInfo(String filename) {
        if (!new File(filename).exists()) {
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = this.mContext.getResources().getAssets().open(UPDATE_FILE_NAME);
                out = this.mContext.openFileOutput(UPDATE_FILE_NAME, 0);
                byte[] buffer = new byte[8192];
                int count = 0;
                while ((count = in.read(buffer)) > 0) {
                    out.write(buffer, 0, count);
                    out.flush();
                }
                in.close();
                out.close();
            }
            catch (Exception ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void delUserdata(Context context) {
        VersionInfo vi;
        String verName = "";
        try {
            verName = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        this.createVersionInfo(this.mFileDir + "/" + UPDATE_FILE_NAME);
        SharedPreferences sharePre = context.getSharedPreferences(SHARED_DATA, 0);
        String versionCode = sharePre.getString("versionCode", "");
        if (verName.equals(versionCode)) {
            return;
        }
        this.parseVersionInfo(this.mFileDir + "/" + UPDATE_FILE_NAME);
        if (this.mVersionList.size() > 0 && verName.equals((vi = this.mVersionList.get(this.mVersionList.size() - 1)).getVersion())) {
            try {
                File tfile;
                SharedPreferences.Editor share = context.getSharedPreferences(SHARED_DATA, 0).edit();
                share.putString("versionCode", verName);
                share.commit();
                String delDb = sharePre.getString("DeleteDb", "");
                String fname = sharePre.getString("MainFileName", "");
                if (!TextUtils.isEmpty((CharSequence)fname) && (tfile = new File(this.mFileDir + "/" + fname)).exists()) {
                    boolean bl = tfile.delete();
                }
                if (!TextUtils.isEmpty((CharSequence)delDb) && delDb.equals("1") && this.mUpdateListener != null) {
                    this.mUpdateListener.deleteDataBase(vi.getVersion());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void deleteDataBases(Context context, ArrayList<String> databases) {
        for (int i = 0; i < databases.size(); ++i) {
            context.deleteDatabase(databases.get(i));
        }
    }

    private void clearTempDate(String fileDir) {
        File dir = new File(fileDir);
        this.deleteDir(dir);
    }

    private boolean deleteDir(File dirFile) {
        boolean flag = false;
        File[] fileArray = dirFile.listFiles();
        if (fileArray == null) {
            return dirFile.delete();
        }
        for (File fp : fileArray) {
            if (fp.isFile()) {
                if (fp.delete()) continue;
                return false;
            }
            flag = this.deleteDir(fp);
            if (!flag) {
                return false;
            }
            flag = fp.delete();
            if (flag) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseVersionInfo(String filename) {
        this.mVersionList.clear();
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (nodeList.item(0).getFirstChild() != null) {
                this.mServerIP = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("ServerPort")).item(0).getFirstChild() != null) {
                this.mServerPort = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Factory")).item(0).getFirstChild() != null) {
                this.mFactory = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Mod")).item(0).getFirstChild() != null) {
                this.mMod = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("OS")).item(0).getFirstChild() != null) {
                this.mOS = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Soft")).item(0).getFirstChild() != null) {
                this.mSoft = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("UserName")).item(0).getFirstChild() != null) {
                this.mUserName = nodeList.item(0).getFirstChild().getNodeValue();
            }
            nodeList = root.getElementsByTagName("Ver");
            int nodeNum = nodeList.getLength();
            Element childElement = null;
            NodeList childList = null;
            for (int i = 0; i < nodeNum; ++i) {
                VersionInfo versionInfo = new VersionInfo();
                childElement = (Element)nodeList.item(i);
                childList = childElement.getElementsByTagName("Version");
                versionInfo.setVersion(childList.item(0).getFirstChild().getNodeValue());
                childList = childElement.getElementsByTagName("Date");
                versionInfo.setDate(childList.item(0).getFirstChild().getNodeValue());
                childList = childElement.getElementsByTagName("Note");
                if (childList.item(0).getFirstChild() != null) {
                    versionInfo.setNote(childList.item(0).getFirstChild().getNodeValue());
                }
                this.mVersionList.add(versionInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int parseConfirmInfo(String confirmInfo) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(confirmInfo.getBytes());
            doc = docBuilder.parse(stream);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("Result");
            if (nodeList.item(0).getFirstChild() != null) {
                String result = nodeList.item(0).getFirstChild().getNodeValue();
                int n = Integer.parseInt(result);
                return n;
            }
            int n = -1;
            return n;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            int n = -1;
            return n;
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseConfigInfo(String filename) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        boolean res = false;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(this.mFileDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("Version");
            if (nodeList.item(0).getFirstChild() != null) {
                this.mVersion = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("DeleteDb")).item(0).getFirstChild() != null) {
                this.mDeleteDb = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("CheckCode")).item(0).getFirstChild() != null) {
                this.mCheckCode = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Date")).item(0).getFirstChild() != null) {
                this.mDate = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("Comment")).item(0).getFirstChild() != null) {
                this.mComment = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("UpdateTag")).item(0).getFirstChild() != null) {
                this.mUpdatetag = nodeList.item(0).getFirstChild().getNodeValue();
            }
            nodeList = root.getElementsByTagName("File");
            int nodeNum = nodeList.getLength();
            Element childElement = null;
            NodeList childList = null;
            for (int i = 0; i < nodeNum; ++i) {
                FileInfo fileInfo = new FileInfo();
                childElement = (Element)nodeList.item(i);
                childList = childElement.getElementsByTagName("RPath");
                fileInfo.setRpath(childList.item(0).getFirstChild().getNodeValue());
                childList = childElement.getElementsByTagName("LPath");
                fileInfo.setLpath(childList.item(0).getFirstChild().getNodeValue());
                childList = childElement.getElementsByTagName("FName");
                if (childList.item(0).getFirstChild() != null) {
                    fileInfo.setFilename(childList.item(0).getFirstChild().getNodeValue());
                }
                if ((childList = childElement.getElementsByTagName("FSize")).item(0).getFirstChild() != null) {
                    fileInfo.setFilesize(Integer.parseInt(childList.item(0).getFirstChild().getNodeValue()));
                }
                if ((childList = childElement.getElementsByTagName("Action")).item(0).getFirstChild() != null) {
                    fileInfo.setAction(Integer.parseInt(childList.item(0).getFirstChild().getNodeValue()));
                }
                if ((childList = childElement.getElementsByTagName("State")).item(0).getFirstChild() != null) {
                    fileInfo.setState(Integer.parseInt(childList.item(0).getFirstChild().getNodeValue()));
                }
                if ((childList = childElement.getElementsByTagName("CSize")).item(0).getFirstChild() != null) {
                    fileInfo.setCsize(Integer.parseInt(childList.item(0).getFirstChild().getNodeValue()));
                }
                this.mFileList.clear();
                this.mFileList.add(fileInfo);
            }
            res = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            res = false;
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseTempInfo(String filename) {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        boolean res = false;
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(this.mFileDir + "/" + filename);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("Version");
            if (nodeList.item(0).getFirstChild() != null) {
                this.mTempVersion = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("DeleteDb")).item(0).getFirstChild() != null) {
                this.mTempDeleteDb = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("UpdateTag")).item(0).getFirstChild() != null) {
                this.mTempUpdatetag = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("CheckCode")).item(0).getFirstChild() != null) {
                this.mTempCheckCode = nodeList.item(0).getFirstChild().getNodeValue();
            }
            res = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            res = false;
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return res;
    }

    private void reWriteVersionInfo(String filename) {
        StringBuffer verstr = new StringBuffer();
        verstr.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        verstr.append("<Root>");
        verstr.append("<ServerIP>" + this.mServerIP + "</ServerIP>");
        verstr.append("<ServerPort>" + this.mServerPort + "</ServerPort>");
        verstr.append("<Factory>" + this.mFactory + "</Factory>");
        verstr.append("<Mod>" + this.mMod + "</Mod>");
        verstr.append("<OS>" + this.mOS + "</OS>");
        verstr.append("<Soft>" + this.mSoft + "</Soft>");
        verstr.append("<UserName>" + this.mUserName + "</UserName>");
        int verListNum = this.mVersionList.size();
        VersionInfo versionInfo = null;
        for (int i = 0; i < verListNum; ++i) {
            versionInfo = this.mVersionList.get(i);
            verstr.append("<Ver>");
            verstr.append("<Version>" + versionInfo.getVersion() + "</Version>");
            verstr.append("<Date>" + versionInfo.getDate() + "</Date>");
            verstr.append("<Note>" + versionInfo.getNote() + "</Note>");
            verstr.append("</Ver>");
        }
        verstr.append("</Root>");
        UpdateFunc.writeFile(filename, verstr.toString(), false);
    }

    private void reWriteConfigInfo(String filename) {
        StringBuffer getfile = new StringBuffer();
        getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        getfile.append("<Root>");
        getfile.append("<Version>" + this.mVersion + "</Version>");
        getfile.append("<Date>" + this.mDate + "</Date>");
        getfile.append("<Comment>" + this.mComment + "</Comment>");
        getfile.append("<UpdateTag>" + this.mUpdatetag + "</UpdateTag>");
        getfile.append("<DeleteDb>" + this.mDeleteDb + "</DeleteDb>");
        getfile.append("<CheckCode>" + this.mCheckCode + "</CheckCode>");
        getfile.append("<Files>");
        int fileListNum = this.mFileList.size();
        FileInfo fi = null;
        for (int i = 0; i < fileListNum; ++i) {
            fi = this.mFileList.get(i);
            getfile.append("<File>");
            getfile.append("<RPath>" + fi.getRpath() + "</RPath>");
            getfile.append("<LPath>" + fi.getLpath() + "</LPath>");
            getfile.append("<FName>" + fi.getFilename() + "</FName>");
            getfile.append("<FSize>" + fi.getFilesize() + "</FSize>");
            getfile.append("<Action>" + fi.getAction() + "</Action>");
            getfile.append("<State>" + fi.getState() + "</State>");
            getfile.append("<CSize>" + fi.getCsize() + "</CSize>");
            getfile.append("</File>");
        }
        getfile.append("</Files>");
        getfile.append("</Root>");
        UpdateFunc.writeFile(filename, getfile.toString(), false);
    }

    private String getCurrentDate() {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyy-MM-dd");
        return sdf.format(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getUpdateConfig() {
        DocumentBuilderFactory docBuilderFactory = null;
        DocumentBuilder docBuilder = null;
        Document doc = null;
        ArrayList<String> IP_Port = new ArrayList<String>();
        String updateIP = "";
        String updatePort = "";
        this.createVersionInfo(this.mFileDir + "/" + UPDATE_FILE_NAME);
        try {
            docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilder = docBuilderFactory.newDocumentBuilder();
            FileInputStream in = new FileInputStream(this.mFileDir + "/" + UPDATE_FILE_NAME);
            doc = docBuilder.parse(in);
            Element root = doc.getDocumentElement();
            NodeList nodeList = root.getElementsByTagName("ServerIP");
            if (nodeList.item(0).getFirstChild() != null) {
                updateIP = nodeList.item(0).getFirstChild().getNodeValue();
            }
            if ((nodeList = root.getElementsByTagName("ServerPort")).item(0).getFirstChild() != null) {
                updatePort = nodeList.item(0).getFirstChild().getNodeValue();
            }
            IP_Port.add(updateIP);
            IP_Port.add(updatePort);
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            doc = null;
            docBuilder = null;
            docBuilderFactory = null;
        }
        return IP_Port;
    }

    public void setUpdateConfig(String updateIP, String updatePort) {
        try {
            this.parseVersionInfo(this.mFileDir + "/" + UPDATE_FILE_NAME);
            this.mServerIP = updateIP;
            this.mServerPort = updatePort;
            this.reWriteVersionInfo(this.mFileDir + "/" + UPDATE_FILE_NAME);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateConfig(String updateIP, String updatePort) {
        try {
            this.createVersionInfo(this.mFileDir + "/" + UPDATE_FILE_NAME);
            this.parseVersionInfo(this.mFileDir + "/" + UPDATE_FILE_NAME);
            if (!TextUtils.equals((CharSequence)updateIP, (CharSequence)this.mServerIP) || !TextUtils.equals((CharSequence)updatePort, (CharSequence)this.mServerPort)) {
                this.mServerIP = updateIP;
                this.mServerPort = updatePort;
                this.reWriteVersionInfo(this.mFileDir + "/" + UPDATE_FILE_NAME);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class GetFileTask
    extends AsyncTask<String, Integer, String> {
        private String fName = null;

        private GetFileTask() {
        }

        protected void onPreExecute() {
            if (AutoUpdate.this.mUpdateListener != null) {
                AutoUpdate.this.mUpdateListener.handlePreUpdate();
            }
        }

        protected String doInBackground(String ... params) {
            int fileListNum = AutoUpdate.this.mFileList.size();
            if (fileListNum == 0) {
                File file = new File(AutoUpdate.this.mFileDir + "/update_s.xml");
                file.delete();
                return "\u65e0\u6587\u4ef6\u66f4\u65b0";
            }
            block17: for (int i = 0; i < fileListNum; ++i) {
                FileInfo fi = (FileInfo)AutoUpdate.this.mFileList.get(i);
                this.fName = fi.getFilename();
                if (i == fileListNum - 1) {
                    SharedPreferences.Editor share = AutoUpdate.this.mContext.getSharedPreferences(AutoUpdate.SHARED_DATA, 0).edit();
                    share.putString("MainFileName", fi.getFilename());
                    share.putString("DeleteDb", AutoUpdate.this.mDeleteDb);
                    share.commit();
                }
                if (fi.getCsize() == 0 || fi.getCsize() == fi.getFilesize()) {
                    File file;
                    File fileDir = new File(DOWNLOAD_FILE);
                    if (!fileDir.exists()) {
                        fileDir.mkdirs();
                    }
                    if ((file = new File(DOWNLOAD_FILE + fi.getFilename())).exists()) {
                        try {
                            String code = UpdateFunc.getHash(AutoUpdate.this.mFileDir + "/" + fi.getFilename(), "MD5");
                            if (!code.equals(AutoUpdate.this.mCheckCode)) {
                                file.delete();
                                return "\u6587\u4ef6\u5185\u5bb9\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\uff01";
                            }
                            return null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (fi.getCsize() >= fi.getFilesize()) continue;
                File dF = new File(DOWNLOAD_FILE + fi.getFilename());
                if (dF.exists() && dF.length() != (long)fi.getCsize()) {
                    fi.setCsize((int)dF.length());
                }
                StringBuilder getfile = new StringBuilder();
                getfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                getfile.append("<Root>");
                getfile.append("<Req>getfile</Req>");
                getfile.append("<RPath>" + fi.getRpath() + "</RPath>");
                getfile.append("<LPath>" + fi.getLpath() + "</LPath>");
                getfile.append("<FName>" + fi.getFilename() + "</FName>");
                getfile.append("<FSize>" + fi.getFilesize() + "</FSize>");
                getfile.append("<FPos>" + fi.getCsize() + "</FPos>");
                if (!TextUtils.isEmpty((CharSequence)AutoUpdate.this.mBillStr)) {
                    getfile.append("<Version>4.0</Version>");
                    getfile.append("<BillInfo>" + AutoUpdate.this.mBillStr + "</BillInfo>");
                }
                getfile.append("</Root>");
                int nres = -1;
                if (AutoUpdate.this.sl == null) {
                    if (AutoUpdate.this.mServerIP.equals("")) {
                        return "\u5347\u7ea7\u670d\u52a1\u5668\u5730\u5740\u8bbe\u7f6e\u4e0d\u6b63\u786e";
                    }
                    if (AutoUpdate.this.mServerPort.equals("")) {
                        return "\u5347\u7ea7\u670d\u52a1\u5668\u7aef\u53e3\u8bbe\u7f6e\u4e0d\u6b63\u786e";
                    }
                    AutoUpdate.this.sl = new UpdateSocket(AutoUpdate.this.mServerIP, Integer.parseInt(AutoUpdate.this.mServerPort));
                    nres = AutoUpdate.this.sl.connect();
                    if (nres != 0) {
                        AutoUpdate.this.sl = null;
                        AutoUpdate.this.reWriteConfigInfo(AutoUpdate.this.mFileDir + "/update_s.xml");
                        return "\u8fde\u63a5\u7f51\u7edc\u5931\u8d25";
                    }
                }
                if ((nres = AutoUpdate.this.sl.sendData(getfile.toString())) != 0) {
                    AutoUpdate.this.reWriteConfigInfo(AutoUpdate.this.mFileDir + "/update_s.xml");
                    return "\u53d1\u9001\u4e0b\u8f7d\u5347\u7ea7\u6587\u4ef6\u8bf7\u6c42\u5931\u8d25";
                }
                String result = AutoUpdate.this.sl.recvData();
                if (result == null) {
                    AutoUpdate.this.reWriteConfigInfo(AutoUpdate.this.mFileDir + "/update_s.xml");
                    return "\u63a5\u6536\u5347\u7ea7\u6587\u4ef6\u914d\u7f6e\u53c2\u6570\u8d85\u65f6";
                }
                int res = AutoUpdate.this.parseConfirmInfo(result);
                boolean flag = true;
                File file = new File(AutoUpdate.this.mFileDir + "/update_s.xml");
                File tfile = new File(DOWNLOAD_FILE + fi.getFilename());
                switch (res) {
                    case 0: {
                        long startTime = System.currentTimeMillis();
                        while (fi.getCsize() < fi.getFilesize()) {
                            byte[] buf = new byte[10240];
                            int currentLen = 0;
                            try {
                                if (AutoUpdate.this.sl == null) {
                                    return "socket\u5173\u95ed";
                                }
                                currentLen = AutoUpdate.this.sl.sin.read(buf, 0, 10240);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return "\u63a5\u6536\u5347\u7ea7\u6587\u4ef6\u6570\u636e\u8d85\u65f6";
                            }
                            if (currentLen == 0) {
                                AutoUpdate.this.reWriteConfigInfo(AutoUpdate.this.mFileDir + "/update_s.xml");
                                return "\u63a5\u6536\u5347\u7ea7\u6587\u4ef6\u6570\u636e\u8d85\u65f6";
                            }
                            fi.setCsize(fi.getCsize() + currentLen);
                            long endTime = System.currentTimeMillis();
                            if (endTime - startTime > 1000L) {
                                startTime = endTime;
                                this.publishProgress(new Integer[]{(int)((float)fi.getCsize() / (float)fi.getFilesize() * 100.0f)});
                            }
                            FileOutputStream out = null;
                            try {
                                String tempStr = DOWNLOAD_FILE + fi.getFilename();
                                out = new FileOutputStream(tempStr, true);
                                out.write(buf, 0, currentLen);
                                out.flush();
                                out.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                tfile.delete();
                                fi.setState(0);
                                fi.setCsize(0);
                                AutoUpdate.this.reWriteConfigInfo(AutoUpdate.this.mFileDir + "/update_s.xml");
                                return "\u5347\u7ea7\u6587\u4ef6\u5199\u5165\u9519\u8bef";
                            }
                            if (fi.getCsize() >= fi.getFilesize()) {
                                fi.setState(2);
                                AutoUpdate.this.reWriteConfigInfo(AutoUpdate.this.mFileDir + "/update_s.xml");
                                try {
                                    String Code = UpdateFunc.getHash(DOWNLOAD_FILE + fi.getFilename(), "MD5");
                                    if (!Code.equals(AutoUpdate.this.mCheckCode)) {
                                        tfile.delete();
                                        fi.setState(0);
                                        fi.setCsize(0);
                                        AutoUpdate.this.reWriteConfigInfo(AutoUpdate.this.mFileDir + "/update_s.xml");
                                        return "\u6587\u4ef6\u5185\u5bb9\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\uff01";
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                continue block17;
                            }
                            fi.setState(1);
                            AutoUpdate.this.reWriteConfigInfo(AutoUpdate.this.mFileDir + "/update_s.xml");
                        }
                        continue block17;
                    }
                    case 1: {
                        file.delete();
                        return "\u6587\u4ef6\u4e0d\u5b58\u5728";
                    }
                    case 2: {
                        file.delete();
                        return "\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25";
                    }
                    case 3: {
                        file.delete();
                        return "\u6587\u4ef6\u5927\u5c0f\u4e0d\u9644";
                    }
                    case 4: {
                        file.delete();
                        return "\u6307\u5b9a\u504f\u79fb\u91cf\u65e0\u6548";
                    }
                    case 5: {
                        file.delete();
                        return "\u53c2\u6570\u4e0d\u5b8c\u6574";
                    }
                    case -1: {
                        return "\u89e3\u6790\u8fd4\u56de\u5347\u7ea7\u5931\u8d25";
                    }
                }
            }
            return null;
        }

        protected void onPostExecute(String obj) {
            String result;
            if (AutoUpdate.this.sl != null) {
                AutoUpdate.this.sl.close();
                AutoUpdate.this.sl = null;
            }
            if (!TextUtils.isEmpty((CharSequence)(result = obj))) {
                if (AutoUpdate.this.mUpdateListener != null) {
                    AutoUpdate.this.mUpdateListener.handleError(result);
                }
                return;
            }
            if (AutoUpdate.this.mUpdateListener != null) {
                AutoUpdate.this.mUpdateListener.handleUpdateSuccess();
            }
            for (int i = 0; i < AutoUpdate.this.mFileList.size(); ++i) {
                FileInfo fi = (FileInfo)AutoUpdate.this.mFileList.get(i);
                PackageManager pm = AutoUpdate.this.mContext.getPackageManager();
                PackageInfo info = pm.getPackageArchiveInfo(DOWNLOAD_FILE + fi.getFilename(), 1);
                ApplicationInfo appInfo = null;
                String packageName = "";
                if (info != null) {
                    appInfo = info.applicationInfo;
                    packageName = appInfo.packageName;
                }
                PackageUtils.installNormal(AutoUpdate.this.mContext, DOWNLOAD_FILE + fi.getFilename(), packageName);
            }
            File file = new File(AutoUpdate.this.mFileDir + "/update_s.xml");
            file.delete();
            VersionInfo ver = new VersionInfo();
            ver.setVersion(AutoUpdate.this.mVersion);
            ver.setDate(AutoUpdate.this.mDate);
            ver.setNote(AutoUpdate.this.mComment);
            AutoUpdate.this.mVersionList.add(ver);
            AutoUpdate.this.reWriteVersionInfo(AutoUpdate.this.mFileDir + "/ClientVer.xml");
        }

        protected void onProgressUpdate(Integer ... values) {
            if (AutoUpdate.this.mUpdateListener != null) {
                AutoUpdate.this.mUpdateListener.handleProgressUpdate(this.fName, values[0]);
            }
        }
    }

    private class CheckVerTask
    extends AsyncTask<String, Integer, String> {
        private CheckVerTask() {
        }

        protected void onPreExecute() {
            if (AutoUpdate.this.mUpdateListener != null) {
                AutoUpdate.this.mUpdateListener.handlePreCheck();
            }
        }

        protected String doInBackground(String ... params) {
            VersionInfo versionInfo;
            String verName;
            block18: {
                AutoUpdate.this.createVersionInfo(AutoUpdate.this.mFileDir + "/" + AutoUpdate.UPDATE_FILE_NAME);
                AutoUpdate.this.parseVersionInfo(AutoUpdate.this.mFileDir + "/" + AutoUpdate.UPDATE_FILE_NAME);
                verName = "";
                try {
                    verName = AutoUpdate.this.mContext.getPackageManager().getPackageInfo((String)AutoUpdate.this.mContext.getPackageName(), (int)0).versionName;
                }
                catch (PackageManager.NameNotFoundException e) {
                    e.printStackTrace();
                    if (AutoUpdate.this.mUpdateListener == null) break block18;
                    AutoUpdate.this.mUpdateListener.handleError(e.getMessage());
                }
            }
            if (AutoUpdate.this.mVersionList.size() > 0 && !verName.equals((versionInfo = (VersionInfo)AutoUpdate.this.mVersionList.get(AutoUpdate.this.mVersionList.size() - 1)).getVersion())) {
                AutoUpdate.this.mVersionList.remove(AutoUpdate.this.mVersionList.size() - 1);
                AutoUpdate.this.reWriteVersionInfo(AutoUpdate.this.mFileDir + "/" + AutoUpdate.UPDATE_FILE_NAME);
            }
            StringBuilder checkVer = new StringBuilder();
            checkVer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            checkVer.append("<Root>");
            checkVer.append("<PactVersion>4.2</PactVersion>");
            checkVer.append("<Req>checkver</Req>");
            checkVer.append("<Factory>" + AutoUpdate.this.mFactory + "</Factory>");
            checkVer.append("<OS>" + AutoUpdate.this.mOS + "</OS>");
            checkVer.append("<Mod>" + AutoUpdate.this.mMod + "</Mod>");
            checkVer.append("<Soft>" + AutoUpdate.this.mSoft + "</Soft>");
            checkVer.append("<UserName>" + AutoUpdate.this.mUserName + "</UserName>");
            checkVer.append("<Power/>");
            checkVer.append("<Vers>");
            checkVer.append("<Ver>");
            checkVer.append("<VerType>" + AutoUpdate.this.mContext.getPackageName() + "</VerType>");
            checkVer.append("<Version>" + verName + "</Version>");
            checkVer.append("<Date>" + AutoUpdate.this.getCurrentDate() + "</Date>");
            checkVer.append("</Ver>");
            checkVer.append("</Vers>");
            checkVer.append("</Root>");
            if (AutoUpdate.this.mServerIP.equals("")) {
                return "\u5347\u7ea7\u670d\u52a1\u5668\u5730\u5740\u8bbe\u7f6e\u4e0d\u6b63\u786e";
            }
            if (AutoUpdate.this.mServerPort.equals("")) {
                return "\u5347\u7ea7\u670d\u52a1\u5668\u7aef\u53e3\u8bbe\u7f6e\u4e0d\u6b63\u786e";
            }
            AutoUpdate.this.sl = new UpdateSocket(AutoUpdate.this.mServerIP, Integer.parseInt(AutoUpdate.this.mServerPort));
            int nres = AutoUpdate.this.sl.connect();
            if (nres != 0) {
                AutoUpdate.this.sl = null;
                return "\u8fde\u63a5\u7f51\u7edc\u5931\u8d25";
            }
            nres = AutoUpdate.this.sl.sendData(checkVer.toString());
            if (nres != 0) {
                return "\u53d1\u9001\u6570\u636e\u5931\u8d25";
            }
            String result = AutoUpdate.this.sl.recvData();
            if (result == null) {
                return "\u63a5\u6536\u5347\u7ea7\u786e\u8ba4\u4fe1\u606f\u8d85\u65f6";
            }
            nres = AutoUpdate.this.parseConfirmInfo(result);
            switch (nres) {
                case 0: {
                    result = AutoUpdate.this.sl.recvData();
                    if (result == null) {
                        return "\u63a5\u6536\u5347\u7ea7\u914d\u7f6e\u4fe1\u606f\u8d85\u65f6";
                    }
                    if (new File(AutoUpdate.this.mFileDir + "/update_s.xml").exists()) {
                        UpdateFunc.writeFile(AutoUpdate.this.mFileDir + "/update_temp.xml", result, false);
                        break;
                    }
                    UpdateFunc.writeFile(AutoUpdate.this.mFileDir + "/update_s.xml", result, false);
                    break;
                }
                case 1: {
                    return "\u65e0\u5347\u7ea7\u7248\u672c";
                }
                case 2: {
                    return "\u5f53\u524d\u7ec8\u7aef\u65e0\u914d\u7f6e\u4fe1\u606f";
                }
                case 3: {
                    return "\u67e5\u8be2\u5347\u7ea7\u914d\u7f6e\u5931\u8d25";
                }
                case 4: {
                    return "\u5347\u7ea7\u914d\u7f6e\u6587\u4ef6\u4e0d\u5b58\u5728";
                }
                case -1: {
                    return "\u65e0\u6cd5\u89e3\u6790\u5347\u7ea7\u786e\u8ba4\u4fe1\u606f";
                }
            }
            return null;
        }

        protected void onPostExecute(String obj) {
            if (obj != null) {
                if (AutoUpdate.this.sl != null) {
                    AutoUpdate.this.sl.close();
                }
                if (obj.contains("\u65e0\u5347\u7ea7\u7248\u672c")) {
                    if (AutoUpdate.this.mUpdateListener != null) {
                        AutoUpdate.this.mUpdateListener.handleNoVersion();
                    }
                } else if (AutoUpdate.this.mUpdateListener != null) {
                    AutoUpdate.this.mUpdateListener.handleError(obj);
                }
                return;
            }
            File file = new File(AutoUpdate.this.mFileDir + "/update_s.xml");
            File tempfile = new File(AutoUpdate.this.mFileDir + "/update_temp.xml");
            boolean res = AutoUpdate.this.parseConfigInfo("update_s.xml");
            if (!res) {
                file.delete();
                if (AutoUpdate.this.mUpdateListener != null) {
                    AutoUpdate.this.mUpdateListener.handleError("\u89e3\u6790\u5347\u7ea7\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
                }
                return;
            }
            if (tempfile.exists()) {
                if (AutoUpdate.this.parseTempInfo("update_temp.xml")) {
                    if (!(AutoUpdate.this.mTempVersion.equals(AutoUpdate.this.mVersion) && TextUtils.equals((CharSequence)AutoUpdate.this.mCheckCode, (CharSequence)AutoUpdate.this.mTempCheckCode) && TextUtils.equals((CharSequence)AutoUpdate.this.mDeleteDb, (CharSequence)AutoUpdate.this.mTempDeleteDb) && TextUtils.equals((CharSequence)AutoUpdate.this.mUpdatetag, (CharSequence)AutoUpdate.this.mTempUpdatetag))) {
                        File tfile;
                        file.delete();
                        SharedPreferences sharePre = AutoUpdate.this.mContext.getSharedPreferences(AutoUpdate.SHARED_DATA, 0);
                        String fname = sharePre.getString("MainFileName", "");
                        if (!TextUtils.isEmpty((CharSequence)fname) && (tfile = new File(AutoUpdate.this.mFileDir + "/" + fname)).exists()) {
                            boolean bl = tfile.delete();
                        }
                        tempfile.renameTo(file);
                        boolean rbool = AutoUpdate.this.parseConfigInfo("update_s.xml");
                        if (!rbool) {
                            file.delete();
                            if (AutoUpdate.this.mUpdateListener != null) {
                                AutoUpdate.this.mUpdateListener.handleError("\u89e3\u6790\u5347\u7ea7\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
                            }
                            return;
                        }
                    } else {
                        tempfile.delete();
                    }
                } else {
                    tempfile.delete();
                    if (AutoUpdate.this.mUpdateListener != null) {
                        AutoUpdate.this.mUpdateListener.handleError("\u89e3\u6790\u5347\u7ea7\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
                    }
                    return;
                }
            }
            if (AutoUpdate.this.mUpdateListener != null) {
                if (AutoUpdate.this.sl != null) {
                    AutoUpdate.this.sl.close();
                    AutoUpdate.this.sl = null;
                }
                AutoUpdate.this.mUpdateListener.handleHasVersion(AutoUpdate.this, AutoUpdate.this.mUpdatetag, AutoUpdate.this.mVersion, AutoUpdate.this.mComment);
            }
        }
    }
}

