/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.autoupdate;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import com.justsy.android.sdk.JustsyAppHelper;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class PackageUtils {
    public static final String TAG = "PackageUtils";
    public static final int APP_INSTALL_AUTO = 0;
    public static final int APP_INSTALL_INTERNAL = 1;
    public static final int APP_INSTALL_EXTERNAL = 2;
    public static final int DELETE_SUCCEEDED = 1;
    public static final int DELETE_FAILED_INVALID_PACKAGE = -3;

    public static boolean installNormal(Context context, String filePath, String packageName) {
        return PackageUtils.installNormal(context, filePath, packageName, INSTALLTYPE.SYSTEM);
    }

    public static boolean installNormal(Context context, String filePath, String packageName, int installType) {
        if (installType == INSTALLTYPE.SYSTEM) {
            Intent i = new Intent("android.intent.action.VIEW");
            File file = new File(filePath);
            if (file == null || !file.exists() || !file.isFile() || file.length() <= 0L) {
                return false;
            }
            i.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
            i.addFlags(0x10000000);
            context.startActivity(i);
        } else if (installType == INSTALLTYPE.SILENCE_XIAN) {
            JustsyAppHelper.install((Context)context, (String)packageName, (String)filePath);
        }
        return true;
    }

    public static boolean filterApp(ApplicationInfo info) {
        if ((info.flags & 0x80) != 0) {
            return true;
        }
        return (info.flags & 1) == 0;
    }

    public static int getLaunchCount(Context context, String packageName) {
        int aLaunchCount = 0;
        PackageManager pm = context.getPackageManager();
        Intent i = pm.getLaunchIntentForPackage(packageName);
        ComponentName aName = i.getComponent();
        try {
            Class<?> ServiceManager = Class.forName("android.os.ServiceManager");
            Method getService = ServiceManager.getMethod("getService", String.class);
            Object oRemoteService = getService.invoke(null, "usagestats");
            Class<?> cStub = Class.forName("com.android.internal.app.IUsageStats$Stub");
            Method asInterface = cStub.getMethod("asInterface", IBinder.class);
            Object oIUsageStats = asInterface.invoke(null, oRemoteService);
            Method getPkgUsageStats = oIUsageStats.getClass().getMethod("getPkgUsageStats", ComponentName.class);
            Object aStats = getPkgUsageStats.invoke(oIUsageStats, aName);
            Class<?> PkgUsageStats = Class.forName("com.android.internal.os.PkgUsageStats");
            aLaunchCount = PkgUsageStats.getDeclaredField("launchCount").getInt(aStats);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aLaunchCount;
    }

    public static boolean compareVersionByName(String oldVersion, String curVersion) {
        long oldVersion_ = 0L;
        long curVersion_ = 0L;
        try {
            oldVersion_ = Long.decode(oldVersion.replace(".", ""));
            curVersion_ = Long.decode(curVersion.replace(".", ""));
            return curVersion_ > oldVersion_;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean compareVersionByCode(int oldVersion, int curVersion) {
        return curVersion > oldVersion;
    }

    public static final int uninstall(Context context, String packageName) {
        return PackageUtils.uninstallNormal(context, packageName) ? 1 : -3;
    }

    public static boolean uninstallNormal(Context context, String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return false;
        }
        Intent i = new Intent("android.intent.action.DELETE", Uri.parse((String)new StringBuilder(32).append("package:").append(packageName).toString()));
        i.addFlags(0x10000000);
        context.startActivity(i);
        return true;
    }

    public static boolean isSystemApplication(Context context) {
        if (context == null) {
            return false;
        }
        return PackageUtils.isSystemApplication(context, context.getPackageName());
    }

    public static boolean isSystemApplication(Context context, String packageName) {
        if (context == null) {
            return false;
        }
        return PackageUtils.isSystemApplication(context.getPackageManager(), packageName);
    }

    public static boolean isSystemApplication(PackageManager packageManager, String packageName) {
        if (packageManager == null || packageName == null || packageName.length() == 0) {
            return false;
        }
        try {
            ApplicationInfo app = packageManager.getApplicationInfo(packageName, 0);
            return app != null && (app.flags & 1) > 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Boolean isTopActivity(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List tasksInfo = activityManager.getRunningTasks(1);
        if (tasksInfo == null || tasksInfo.size() == 0) {
            return false;
        }
        try {
            return packageName.equals(((ActivityManager.RunningTaskInfo)tasksInfo.get((int)0)).topActivity.getPackageName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int getAppVersionCode(Context context) {
        PackageManager pm;
        if (context != null && (pm = context.getPackageManager()) != null) {
            try {
                PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
                if (pi != null) {
                    return pi.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static String getAppVersionName(Context context) {
        PackageManager pm;
        if (context != null && (pm = context.getPackageManager()) != null) {
            try {
                PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
                if (pi != null) {
                    return pi.versionName;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static boolean isInstallInSDCard(Context context, String packageName) {
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 0);
            return (appInfo.flags & 0x40000) != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean isInstalled(Context context, String packageName) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            packageInfo = null;
        }
        return packageInfo != null;
    }

    public static void startInstalledAppDetails(Context context, String packageName) {
        Intent intent = new Intent();
        int sdkVersion = Build.VERSION.SDK_INT;
        if (sdkVersion >= 9) {
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)packageName, null));
        } else {
            intent.setAction("android.intent.action.VIEW");
            intent.setClassName("com.android.settings", "com.android.settings.InstalledAppDetails");
            intent.putExtra(sdkVersion == 8 ? "pkg" : "com.android.settings.ApplicationPkgName", packageName);
        }
        intent.addFlags(0x10000000);
        context.startActivity(intent);
    }

    public static List<ApplicationInfo> getInstalledApp(Context context) {
        ArrayList<ApplicationInfo> installedAppList = new ArrayList<ApplicationInfo>();
        List packages = context.getPackageManager().getInstalledPackages(8192);
        for (PackageInfo pkg : packages) {
            if ((pkg.applicationInfo.flags & 1) != 0) continue;
            ApplicationInfo info = pkg.applicationInfo;
            installedAppList.add(info);
        }
        return installedAppList;
    }

    public static interface OnInstallListener {
        public void onFinished(int var1);
    }

    public static final class INSTALLTYPE {
        public static int SYSTEM = 0;
        public static int SILENCE_XIAN = 1;
    }
}

