/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.autoupdate;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class UpdateSocket {
    private String ip = null;
    private int port = 0;
    private Socket conn = null;
    public InputStream sin = null;
    private OutputStream sou = null;
    private int mConnectTimeOut = 5000;
    private int mSoTimeOut = 60000;

    public UpdateSocket(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public void setConnectTimeOut(int timeOut) {
        this.mConnectTimeOut = timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.mSoTimeOut = timeOut;
    }

    public boolean isConnected() {
        return this.conn.isConnected();
    }

    public int connect() {
        try {
            this.conn = new Socket();
            InetSocketAddress address = new InetSocketAddress(this.ip, this.port);
            this.conn.connect(address, this.mConnectTimeOut);
            this.conn.setSoTimeout(this.mSoTimeOut);
            this.sin = this.conn.getInputStream();
            this.sou = this.conn.getOutputStream();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int sendData(String reqstr) {
        int dataLen = 0;
        byte[] data = null;
        try {
            dataLen = reqstr.getBytes("UTF-8").length;
            data = new byte[dataLen + 2];
            data[0] = (byte)(dataLen >> 8 & 0xFF);
            data[1] = (byte)(dataLen & 0xFF);
            System.arraycopy(reqstr.getBytes("UTF-8"), 0, data, 2, dataLen);
            this.sou.write(data);
            this.sou.flush();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public String recvData() {
        try {
            int tempLen;
            byte[] data = null;
            int dataLen = 0;
            int currentLen = 0;
            byte[] len = new byte[2];
            for (int headlen = this.sin.read(len); headlen < 2; headlen += tempLen) {
                tempLen = this.sin.read(len, headlen, 2 - headlen);
                if (tempLen != -1) continue;
                return null;
            }
            dataLen = UpdateSocket.Bytes2ToInt(len);
            data = new byte[dataLen];
            tempLen = 0;
            while (currentLen < dataLen && (tempLen = this.sin.read(data, currentLen, dataLen - currentLen)) != -1) {
                currentLen += tempLen;
            }
            return new String(data, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] recvDataNolength(int dataLen) {
        try {
            byte[] data = new byte[dataLen];
            for (int currentLen = 0; currentLen < dataLen; currentLen += this.sin.read(data, currentLen, dataLen - currentLen)) {
            }
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int Bytes2ToInt(byte[] b) {
        int mask = 255;
        int temp = 0;
        int res = 0;
        for (int i = 0; i < 2; ++i) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
        }
        return res;
    }

    public static byte[] IntToBytes2(int num) {
        byte[] b = new byte[2];
        for (int i = 0; i < 2; ++i) {
            b[i] = (byte)(num >> 8 - i * 8 & 0xFF);
        }
        return b;
    }

    public void close() {
        try {
            this.sin.close();
            this.sou.close();
            this.conn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

