/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.button;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class XDImageButton
extends LinearLayout {
    private int type;
    private int mBackgroundId;
    private Drawable mImage;
    private boolean mEnable = true;
    private boolean mClickable = true;
    private boolean mFocusable = true;
    private int mTextColor = -16777216;
    private CharSequence text;
    private float mTextSize;
    private ImageView mImageView;
    private TextView mTextView;
    private Drawable[] drawables_round = new Drawable[3];
    private Drawable[] drawables_square;
    private StateListDrawable mStateListDrawable;
    private Map<String, Integer> map;

    public XDImageButton(Context context) {
        this(context, null);
    }

    public XDImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.drawables_round[0] = this.get9ImageFromAssetsFile(context, "xdbutton_round_pressed.9.png");
        this.drawables_round[1] = this.get9ImageFromAssetsFile(context, "xdbutton_round.9.png");
        this.drawables_square = new Drawable[3];
        this.drawables_square[0] = this.get9ImageFromAssetsFile(context, "xdbutton_square_pressed.9.png");
        this.drawables_square[1] = this.get9ImageFromAssetsFile(context, "xdbutton_square.9.png");
        this.initMap();
        if (attrs != null) {
            block11: for (int i = 0; i < attrs.getAttributeCount(); ++i) {
                Integer obj = this.map.get(attrs.getAttributeName(i));
                if (obj == null) continue;
                int resourceId = attrs.getAttributeResourceValue(i, 0);
                switch (obj) {
                    case 0: {
                        this.type = Integer.parseInt(attrs.getAttributeValue(i));
                        continue block11;
                    }
                    case 1: {
                        this.mBackgroundId = resourceId;
                        continue block11;
                    }
                    case 2: {
                        if (resourceId > 0) {
                            this.text = this.getResources().getText(resourceId);
                            continue block11;
                        }
                        this.text = attrs.getAttributeValue(i);
                        continue block11;
                    }
                    case 3: {
                        if (resourceId <= 0) continue block11;
                        this.mTextColor = this.getResources().getColor(resourceId);
                        continue block11;
                    }
                    case 4: {
                        if (resourceId > 0) {
                            this.mTextSize = this.getResources().getDimension(resourceId);
                            continue block11;
                        }
                        this.mTextSize = Float.parseFloat(attrs.getAttributeValue(i));
                        continue block11;
                    }
                    case 5: {
                        if (resourceId <= 0) continue block11;
                        this.mImage = this.getResources().getDrawable(resourceId);
                        continue block11;
                    }
                    case 6: {
                        this.mEnable = Boolean.parseBoolean(attrs.getAttributeValue(i));
                        continue block11;
                    }
                    case 7: {
                        this.mFocusable = Boolean.parseBoolean(attrs.getAttributeValue(i));
                        continue block11;
                    }
                    case 8: {
                        this.mClickable = Boolean.parseBoolean(attrs.getAttributeValue(i));
                        continue block11;
                    }
                }
            }
        }
        this.mTextView = new TextView(context);
        this.mImageView = new ImageView(context);
        this.drawXDImageButton();
    }

    private void initMap() {
        this.map = new HashMap<String, Integer>();
        this.map.put("type", 0);
        this.map.put("background", 1);
        this.map.put("text", 2);
        this.map.put("textColor", 3);
        this.map.put("textSize", 4);
        this.map.put("image", 5);
        this.map.put("enabled", 6);
        this.map.put("focusable", 7);
        this.map.put("clickable", 8);
    }

    private void drawXDImageButton() {
        this.setOrientation(0);
        this.setGravity(17);
        this.removeAllViews();
        if (!this.mEnable) {
            this.setFocusable(false);
            this.setClickable(false);
        } else {
            this.setFocusable(this.mFocusable);
            this.setClickable(this.mClickable);
        }
        this.mTextView.setText(this.text);
        this.mTextView.setTextColor(this.mTextColor);
        this.mTextView.setTextSize(this.mTextSize);
        if (this.mImage != null) {
            this.mImageView.setBackgroundDrawable(this.mImage);
            this.addView((View)this.mImageView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.getTextHeight() + 2, this.getTextHeight() + 2));
        }
        switch (this.type) {
            case 0: {
                this.mStateListDrawable = this.setBg(this.drawables_square);
                break;
            }
            case 1: {
                this.mStateListDrawable = this.setBg(this.drawables_round);
                break;
            }
        }
        if (this.text != null) {
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        }
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)this.mImageView.getLayoutParams();
        ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)this.mTextView.getLayoutParams();
        if (params != null && param != null) {
            params.rightMargin = 6;
            params.leftMargin = 10;
            param.rightMargin = 10;
            params.topMargin = 5;
            params.bottomMargin = 5;
            param.bottomMargin = 5;
            param.topMargin = 5;
        } else if (param == null && params != null) {
            params.leftMargin = 10;
            params.rightMargin = 10;
            params.topMargin = 5;
            params.bottomMargin = 5;
        } else if (param != null && params == null) {
            param.leftMargin = 10;
            param.rightMargin = 10;
            param.bottomMargin = 5;
            param.topMargin = 5;
        }
        if (this.mBackgroundId > 0) {
            this.setBackgroundResource(this.mBackgroundId);
        } else {
            this.setBackgroundDrawable((Drawable)this.mStateListDrawable);
        }
    }

    private NinePatchDrawable get9ImageFromAssetsFile(Context context, String FileName) {
        try {
            InputStream stream = context.getAssets().open(FileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
            byte[] chunk = bitmap.getNinePatchChunk();
            boolean result = NinePatch.isNinePatchChunk((byte[])chunk);
            NinePatchDrawable patchy = null;
            if (result) {
                patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
            }
            return patchy;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private int getTextHeight() {
        TextPaint textPaint = this.mTextView.getPaint();
        return (int)(-textPaint.ascent() + textPaint.descent());
    }

    private StateListDrawable setBg(Drawable[] drawables) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(View.PRESSED_ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_STATE_SET, drawables[1]);
        bg.addState(View.FOCUSED_STATE_SET, drawables[0]);
        bg.addState(View.EMPTY_STATE_SET, drawables[1]);
        return bg;
    }

    public void setText(CharSequence text) {
        this.text = text;
        this.drawXDImageButton();
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(int resouceId) {
        this.text = this.getResources().getText(resouceId);
        this.drawXDImageButton();
    }

    public void setTextColor(int color) {
        this.mTextColor = color;
        this.drawXDImageButton();
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public void setTxtColor(int resouceId) {
        this.mTextColor = this.getResources().getColor(resouceId);
        this.drawXDImageButton();
    }

    public void setTextSize(float size) {
        this.mTextSize = size;
        this.drawXDImageButton();
    }

    public float getTextSize() {
        return this.mTextSize;
    }

    public void setTextSize(int resourceId) {
        this.mTextSize = this.getResources().getDimension(resourceId);
        this.drawXDImageButton();
    }

    public void setImage(Drawable drawable) {
        this.mImage = drawable;
        this.drawXDImageButton();
    }

    public void setImage(int resouceId) {
        this.mImage = this.getResources().getDrawable(resouceId);
        this.drawXDImageButton();
    }

    public Drawable getImage() {
        return this.mImage;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.drawXDImageButton();
    }

    public void setClickListener(View.OnClickListener listener) {
        if (!this.mEnable) {
            return;
        }
        if (!this.mClickable) {
            return;
        }
        this.setOnClickListener(listener);
    }
}

