/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Chronometer;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

public class XDProgressDialog {
    private AlertDialog dialog;
    private Chronometer mTimeView;
    private ProgressBar mProgress;
    private TextView mMessageView;
    private boolean mIndeterminate;
    private CharSequence mMessage;
    private CharSequence mTitle;
    private String mFormat;
    private DialogInterface.OnCancelListener onCancelListener;

    public void createDialog(Context context) {
        this.dialog = new AlertDialog.Builder(context).create();
        this.dialog.setCanceledOnTouchOutside(false);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        linearLayout.setPadding(30, 20, 30, 30);
        linearLayout.setOrientation(0);
        linearLayout.setGravity(16);
        this.mTimeView = new Chronometer(context);
        this.mTimeView.setTextColor(-1);
        LinearLayout.LayoutParams paramsTimeview = new LinearLayout.LayoutParams(-2, -2);
        paramsTimeview.bottomMargin = 5;
        this.mTimeView.setLayoutParams((ViewGroup.LayoutParams)paramsTimeview);
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        linearLayout2.setOrientation(1);
        this.mProgress = new ProgressBar(context);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.rightMargin = 20;
        this.mProgress.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mMessageView = new TextView(context);
        this.mMessageView.setTextColor(-1);
        LinearLayout.LayoutParams paramsMessage = new LinearLayout.LayoutParams(-2, -2);
        paramsMessage.topMargin = 5;
        this.mMessageView.setLayoutParams((ViewGroup.LayoutParams)paramsMessage);
        linearLayout2.addView((View)this.mTimeView);
        linearLayout2.addView((View)this.mMessageView);
        linearLayout.addView((View)this.mProgress);
        linearLayout.addView((View)linearLayout2);
        this.dialog.setView((View)linearLayout);
        this.dialog.setIcon(17301659);
        if (this.onCancelListener != null) {
            this.setOnCancelListener(this.onCancelListener);
        }
        if (this.mMessage != null) {
            this.setMessage(this.mMessage);
        }
        if (this.mTitle != null) {
            this.setTitle(this.mTitle);
        }
        if (this.mFormat != null) {
            this.setFormat(this.mFormat);
        }
        this.setIndeterminate(this.mIndeterminate);
    }

    public void setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        if (onCancelListener != null) {
            this.dialog.setOnCancelListener(onCancelListener);
        } else {
            this.onCancelListener = onCancelListener;
        }
    }

    public void show() {
        this.mTimeView.start();
        this.dialog.show();
    }

    public void dismiss() {
        this.mTimeView.stop();
        this.dialog.dismiss();
    }

    public void setIndeterminate(boolean indeterminate) {
        if (this.mProgress != null) {
            this.mProgress.setIndeterminate(indeterminate);
        } else {
            this.mIndeterminate = indeterminate;
        }
    }

    public void setMessage(CharSequence message) {
        if (this.mProgress != null) {
            this.mMessageView.setText(message);
        } else {
            this.mMessage = message;
        }
    }

    public void setTitle(CharSequence title) {
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        } else {
            this.mTitle = title;
        }
    }

    public void setFormat(String format) {
        if (this.mTimeView != null) {
            this.mTimeView.setFormat(format);
        } else {
            this.mFormat = format;
        }
    }
}

