/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.keyboard;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.ClipboardManager;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TabHost;
import android.widget.TabWidget;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.xdja.combox.R;
import com.xdja.combox.keyboard.EditInput;
import com.xdja.combox.keyboard.XDInputGirdView;
import java.io.IOException;
import java.io.InputStream;

public class InputSoftKeyBoard {
    private static Context mcontext = null;
    private static int textSize = 25;
    private static EditText editresult = null;
    private static EditText inputedit = null;
    private static PopupWindow mPopupWindow = null;
    private static View popupWindow = null;
    private static ButtonListener b = new ButtonListener();
    private static ButtonLongListener bl = new ButtonLongListener();
    private static String titlecontext = "";
    private static int Width = 0;
    private static XDInputGirdView girdview = null;
    private static IputGirdVeiw adapter = null;
    private static int lasttablocation = -1;
    private static int currenttablocation = 0;
    private static TabHost mtabhost = null;
    private static TabWidget mtabWidget = null;
    private static String[] province = new String[]{"\u4eac", "\u6d25", "\u6caa", "\u6e1d", "\u9ed1", "\u5409", "\u8fbd", "\u82cf", "\u6d59", "\u95fd", "\u7696", "\u8d63", "\u6e58", "\u664b", "\u5180", "\u9c81", "\u8c6b", "\u9102", "\u9655", "\u7518", "\u5b81", "\u8499", "\u65b0", "\u9752", "\u85cf", "\u5ddd", "\u8d35", "\u4e91", "\u6842", "\u7ca4", "\u743c", "\u6e2f", "\u6fb3", "\u53f0"};
    private static String[] number = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ".", "X"};
    private static String[] lowerletter = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "\u5927\u5199"};
    private static String[] upcaseletter = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "\u5c0f\u5199"};
    private static String[] operate = new String[]{"\u590d\u5236\u5168\u90e8", "\u5220\u9664", "\u786e\u5b9a"};
    private static final int sc_Id = 10001;
    private static final int qd_Id = 10002;
    private static final int fzqb_Id = 10003;
    private static String defaultPanel = "number";
    private static Boolean passwor = false;
    private static LinearLayout numLayout;
    private static LinearLayout letterLayout;
    private static LinearLayout provinceLayout;

    public static void InitInputSoftKeyBoard(Context _context, EditText _edit, String _inputstype, Boolean _passwor, String _title) {
        mcontext = _context;
        defaultPanel = _inputstype == null ? "number" : _inputstype;
        passwor = _passwor != null ? _passwor : Boolean.valueOf(false);
        titlecontext = _title;
        editresult = _edit;
        InputSoftKeyBoard.initshowTab();
        InputSoftKeyBoard.initPopuptWindow();
    }

    private static void initshowTab() {
        if (defaultPanel.equals("number")) {
            currenttablocation = 0;
        }
        if (defaultPanel.equals("letter")) {
            currenttablocation = 1;
        }
        if (defaultPanel.equals("province")) {
            currenttablocation = 2;
        }
    }

    private static void initPopuptWindow() {
        if (mPopupWindow == null) {
            mPopupWindow = new PopupWindow(mcontext);
        }
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)mcontext).getWindowManager().getDefaultDisplay().getMetrics(dm);
        Width = dm.widthPixels;
        textSize = Width >= 480 ? 35 : 25;
        popupWindow = InputSoftKeyBoard.initInputView(titlecontext);
        int contentTop = ((Activity)mcontext).getWindow().findViewById(0x1020002).getTop();
        int screenHeight = dm.heightPixels - contentTop;
        mPopupWindow.setContentView(popupWindow);
        mPopupWindow.setFocusable(true);
        mPopupWindow.setTouchable(true);
        mPopupWindow.setOutsideTouchable(false);
        ColorDrawable dw = new ColorDrawable(Color.argb((int)250, (int)0, (int)0, (int)0));
        mPopupWindow.setBackgroundDrawable((Drawable)dw);
        mPopupWindow.setWidth(-1);
        mPopupWindow.setHeight(screenHeight);
        mPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                String resultString = "" + editresult.getText();
                EditInput.setEdit(resultString);
                mPopupWindow = null;
            }
        });
        if (!mPopupWindow.isShowing()) {
            mPopupWindow.showAtLocation((View)editresult, 80, 0, 0);
        }
    }

    private static View initInputView(String text) {
        LinearLayout mlayout = new LinearLayout(mcontext);
        mlayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        mlayout.setOrientation(1);
        LinearLayout mEitdlayout = new LinearLayout(mcontext);
        mEitdlayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        mEitdlayout.setPadding(0, 10, 0, 10);
        mEitdlayout.setOrientation(0);
        TextView showtext = new TextView(mcontext);
        showtext.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        showtext.setText((CharSequence)(text + ": "));
        showtext.setTextSize(20.0f);
        showtext.setTextColor(-1);
        showtext.setGravity(16);
        inputedit = new EditText(mcontext);
        inputedit.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        inputedit.setBackgroundResource(R.drawable.shape_edittext_bg);
        inputedit.setTextColor(-16777216);
        inputedit.setTextSize(15.0f);
        inputedit.setHint((CharSequence)"\u8bf7\u8f93\u5165....");
        String alreadyinput = editresult.getText().toString().replace(" ", "");
        inputedit.setText((CharSequence)alreadyinput);
        inputedit.setSelection(alreadyinput.length());
        inputedit.setSingleLine();
        inputedit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InputMethodManager imm = (InputMethodManager)mcontext.getSystemService("input_method");
                imm.hideSoftInputFromWindow(((EditText)v).getWindowToken(), 2);
            }
        });
        inputedit.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                inputedit.requestFocus();
            }
        });
        if (passwor.booleanValue()) {
            inputedit.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
        }
        Editable etext = inputedit.getText();
        int position = etext.length();
        inputedit.requestFocus();
        Selection.setSelection((Spannable)etext, (int)position);
        mEitdlayout.addView((View)showtext);
        mEitdlayout.addView((View)inputedit);
        mlayout.addView((View)mEitdlayout);
        mlayout.addView((View)InputSoftKeyBoard.CreateTabHost());
        return mlayout;
    }

    private static void deleteEdit() {
        int start = inputedit.getSelectionStart();
        int end = inputedit.getSelectionEnd();
        Editable text = inputedit.getText();
        if (!text.equals("")) {
            if (start != end) {
                if (start > end) {
                    int temp = end;
                    end = start;
                    start = temp;
                }
                if (end != 0) {
                    text.delete(start, end);
                }
            } else if (end != 0) {
                text.delete(end - 1, end);
            }
        }
    }

    private static StateListDrawable setBg() {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(new int[]{16842919, 16842910}, (Drawable)InputSoftKeyBoard.get9ImageFromAssetsFile("buttondown.9.png"));
        bg.addState(new int[]{16842910, 16842910}, (Drawable)InputSoftKeyBoard.get9ImageFromAssetsFile("buttonnormal.9.png"));
        return bg;
    }

    private static StateListDrawable setBackSpace() {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(new int[]{16842919, 16842910}, InputSoftKeyBoard.getDrawable("backspace_press.png"));
        bg.addState(new int[]{16842910, 16842910}, InputSoftKeyBoard.getDrawable("backspace.png"));
        return bg;
    }

    private static View createTabView(String text) {
        LinearLayout mLinearLayout = new LinearLayout(mcontext);
        mLinearLayout.setGravity(17);
        mLinearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        mLinearLayout.setOrientation(1);
        mLinearLayout.setGravity(17);
        if (text != null) {
            TextView mtext = new TextView(mcontext);
            mtext.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            mtext.setTextSize((float)(textSize / 6 * 5));
            mtext.setTextColor(-1);
            mLinearLayout.addView((View)mtext);
            mtext.setText((CharSequence)text);
        }
        mLinearLayout.setBackgroundDrawable(InputSoftKeyBoard.getDrawable("tabunselect.png"));
        mLinearLayout.setBaselineAligned(true);
        return mLinearLayout;
    }

    private static TabHost CreateTabHost() {
        LinearLayout mtablayout = new LinearLayout(mcontext);
        mtablayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        mtablayout.setOrientation(1);
        mtabhost = new TabHost(mcontext);
        mtabhost.setId(0x1020012);
        LinearLayout.LayoutParams mtable = new LinearLayout.LayoutParams(-1, -2);
        mtable.setMargins(0, -4, 0, 0);
        mtabhost.setLayoutParams((ViewGroup.LayoutParams)mtable);
        mtabWidget = new TabWidget(mcontext);
        mtabWidget.setId(16908307);
        mtabWidget.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        FrameLayout content = new FrameLayout(mcontext);
        content.setId(0x1020011);
        InputSoftKeyBoard.initNumLayoutLayout();
        InputSoftKeyBoard.initletterLayout();
        InputSoftKeyBoard.initProvinceLayout();
        content.addView((View)numLayout, 0);
        content.addView((View)letterLayout, 1);
        content.addView((View)provinceLayout, 2);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
        lp.addRule(12, mtabhost.getId());
        HorizontalScrollView horizontalscroll = new HorizontalScrollView(mcontext);
        horizontalscroll.setLayoutParams((ViewGroup.LayoutParams)lp);
        horizontalscroll.setScrollBarStyle(0);
        horizontalscroll.addView((View)mtabWidget, (ViewGroup.LayoutParams)lp);
        mtablayout.addView((View)horizontalscroll);
        lp.addRule(3, horizontalscroll.getId());
        mtablayout.addView((View)content, (ViewGroup.LayoutParams)lp);
        mtabhost.addView((View)mtablayout);
        mtabhost.setup();
        mtabWidget.setStripEnabled(false);
        mtabWidget.setDividerDrawable((Drawable)InputSoftKeyBoard.get9ImageFromAssetsFile("tab_divider.9.png"));
        TabHost.TabSpec tab1 = mtabhost.newTabSpec("0");
        tab1.setIndicator(InputSoftKeyBoard.createTabView("\u6570\u5b57"));
        tab1.setContent(numLayout.getId());
        TabHost.TabSpec tab2 = mtabhost.newTabSpec("1");
        tab2.setIndicator(InputSoftKeyBoard.createTabView("\u5b57\u6bcd"));
        tab2.setContent(letterLayout.getId());
        TabHost.TabSpec tab3 = mtabhost.newTabSpec("2");
        tab3.setIndicator(InputSoftKeyBoard.createTabView("\u7701\u4efd"));
        tab3.setContent(provinceLayout.getId());
        mtabhost.addTab(tab1);
        mtabhost.addTab(tab2);
        mtabhost.addTab(tab3);
        mtabhost.setCurrentTab(currenttablocation);
        InputSoftKeyBoard.setSelect(currenttablocation);
        for (int i = 0; i < 3; ++i) {
            mtabWidget.getChildTabViewAt(i).setMinimumWidth(Width / 3);
        }
        mtabhost.setOnTabChangedListener(new TabHost.OnTabChangeListener(){

            public void onTabChanged(String tabId) {
                lasttablocation = currenttablocation;
                currenttablocation = mtabhost.getCurrentTab();
                InputSoftKeyBoard.setSelect(mtabhost.getCurrentTab());
            }
        });
        return mtabhost;
    }

    private static void setSelect(int selectab) {
        View vvv = mtabWidget.getChildTabViewAt(selectab);
        vvv.setBackgroundDrawable(InputSoftKeyBoard.getDrawable("tabselect.png"));
        if (lasttablocation > -1) {
            View vv = mtabWidget.getChildTabViewAt(lasttablocation);
            vv.setBackgroundDrawable(InputSoftKeyBoard.getDrawable("tabunselect.png"));
        }
    }

    private static LinearLayout initProvinceLayout() {
        provinceLayout = new LinearLayout(mcontext);
        provinceLayout.setOrientation(1);
        provinceLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        provinceLayout.setPadding(0, 10, 0, 0);
        ScrollView scroll = new ScrollView(mcontext);
        scroll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        scroll.setFillViewport(true);
        scroll.setScrollBarStyle(0x1000000);
        LinearLayout temp = new LinearLayout(mcontext);
        temp.setOrientation(1);
        temp.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        girdview = new XDInputGirdView(mcontext);
        girdview.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        WindowManager wm = (WindowManager)mcontext.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        if (dm.widthPixels > dm.heightPixels) {
            girdview.setNumColumns(6);
            adapter = new IputGirdVeiw(mcontext, province, Width, 6);
        } else {
            girdview.setNumColumns(5);
            adapter = new IputGirdVeiw(mcontext, province, Width, 5);
        }
        girdview.setHorizontalSpacing(10);
        girdview.setVerticalSpacing(15);
        girdview.setAdapter((ListAdapter)adapter);
        temp.addView((View)girdview);
        temp.addView((View)InputSoftKeyBoard.initTableLayout());
        scroll.addView((View)temp);
        provinceLayout.addView((View)scroll);
        provinceLayout.setVisibility(8);
        provinceLayout.setId(4);
        return provinceLayout;
    }

    private static LinearLayout initNumLayoutLayout() {
        numLayout = new LinearLayout(mcontext);
        numLayout.setOrientation(1);
        numLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        numLayout.setPadding(0, 10, 0, 0);
        ScrollView scroll = new ScrollView(mcontext);
        scroll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        scroll.setFillViewport(true);
        scroll.setScrollBarStyle(0x1000000);
        LinearLayout temp = new LinearLayout(mcontext);
        temp.setOrientation(1);
        girdview = new XDInputGirdView(mcontext);
        girdview.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        WindowManager wm = (WindowManager)mcontext.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        if (dm.widthPixels > dm.heightPixels) {
            LinearLayout.LayoutParams tempParams = new LinearLayout.LayoutParams(0, -1);
            tempParams.weight = 1.0f;
            temp.setLayoutParams((ViewGroup.LayoutParams)tempParams);
            girdview.setNumColumns(4);
            adapter = new IputGirdVeiw(mcontext, number, Width - 200, 4);
            girdview.setHorizontalSpacing(10);
            girdview.setVerticalSpacing(15);
            girdview.setAdapter((ListAdapter)adapter);
            temp.addView((View)girdview);
            temp.addView((View)InputSoftKeyBoard.initTableLayout());
            LinearLayout tempLy = new LinearLayout(mcontext);
            tempLy.setOrientation(0);
            tempLy.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            TextView tempTvLeft = new TextView(mcontext);
            tempTvLeft.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(100, -1));
            TextView tempTvRight = new TextView(mcontext);
            tempTvRight.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(100, -1));
            tempLy.addView((View)tempTvLeft);
            tempLy.addView((View)temp);
            tempLy.addView((View)tempTvRight);
            scroll.addView((View)tempLy);
        } else {
            temp.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            girdview.setNumColumns(3);
            adapter = new IputGirdVeiw(mcontext, number, Width, 3);
            girdview.setHorizontalSpacing(10);
            girdview.setVerticalSpacing(15);
            girdview.setAdapter((ListAdapter)adapter);
            temp.addView((View)girdview);
            temp.addView((View)InputSoftKeyBoard.initTableLayout());
            scroll.addView((View)temp);
        }
        numLayout.addView((View)scroll);
        numLayout.setVisibility(8);
        numLayout.setId(1);
        return numLayout;
    }

    private static LinearLayout initletterLayout() {
        letterLayout = new LinearLayout(mcontext);
        letterLayout.setOrientation(1);
        letterLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        letterLayout.setPadding(0, 10, 0, 0);
        ScrollView scroll = new ScrollView(mcontext);
        scroll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        scroll.setFillViewport(true);
        scroll.setScrollBarStyle(0x1000000);
        LinearLayout temp = new LinearLayout(mcontext);
        temp.setOrientation(1);
        temp.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        girdview = new XDInputGirdView(mcontext);
        girdview.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        WindowManager wm = (WindowManager)mcontext.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(dm);
        if (dm.widthPixels > dm.heightPixels) {
            girdview.setNumColumns(6);
            adapter = new IputGirdVeiw(mcontext, upcaseletter, Width, 6);
        } else {
            girdview.setNumColumns(5);
            adapter = new IputGirdVeiw(mcontext, upcaseletter, Width, 5);
        }
        girdview.setHorizontalSpacing(10);
        girdview.setVerticalSpacing(15);
        girdview.setAdapter((ListAdapter)adapter);
        temp.addView((View)girdview);
        temp.addView((View)InputSoftKeyBoard.initTableLayout());
        scroll.addView((View)temp);
        letterLayout.addView((View)scroll);
        letterLayout.setVisibility(8);
        letterLayout.setId(2);
        return letterLayout;
    }

    private static TableLayout initTableLayout() {
        TableLayout mtablelayout = new TableLayout(mcontext);
        mtablelayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        mtablelayout.setId(1);
        mtablelayout.setPadding(0, 15, 0, 0);
        mtablelayout.setOrientation(1);
        mtablelayout.setShrinkAllColumns(true);
        mtablelayout.setStretchAllColumns(true);
        TableRow mtableraw = new TableRow(mcontext);
        TableLayout.LayoutParams params = new TableLayout.LayoutParams(-1, -2);
        params.bottomMargin = 10;
        mtableraw.setLayoutParams((ViewGroup.LayoutParams)params);
        mtableraw.setOrientation(0);
        mtableraw.setGravity(80);
        for (int i = 0; i < operate.length; ++i) {
            Button button = new Button(mcontext);
            switch (i) {
                case 0: {
                    button.setId(10003);
                    break;
                }
                case 1: {
                    button.setId(10001);
                    break;
                }
                case 2: {
                    button.setId(10002);
                    break;
                }
            }
            button.setTextSize((float)textSize);
            TableRow.LayoutParams tablerow_layoutparams = new TableRow.LayoutParams(-2, -2);
            if (i == 0) {
                tablerow_layoutparams.rightMargin = 5;
            } else {
                tablerow_layoutparams.leftMargin = 5;
            }
            button.setLayoutParams((ViewGroup.LayoutParams)tablerow_layoutparams);
            button.setText((CharSequence)operate[i]);
            button.setBackgroundDrawable((Drawable)InputSoftKeyBoard.setBg());
            if (i == 1) {
                button.setOnLongClickListener((View.OnLongClickListener)bl);
            }
            button.setTextColor(-1);
            mtableraw.addView((View)button);
            button.setOnClickListener((View.OnClickListener)b);
        }
        mtablelayout.addView((View)mtableraw);
        return mtablelayout;
    }

    private static NinePatchDrawable get9ImageFromAssetsFile(String FileName) {
        try {
            InputStream stream = mcontext.getAssets().open(FileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream);
            byte[] chunk = bitmap.getNinePatchChunk();
            boolean result = NinePatch.isNinePatchChunk((byte[])chunk);
            NinePatchDrawable patchy = null;
            if (result) {
                patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
            }
            return patchy;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Drawable getDrawable(String FileName) {
        Drawable drawable2;
        try {
            InputStream stream = mcontext.getAssets().open(FileName);
            drawable2 = Drawable.createFromStream((InputStream)stream, (String)FileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return drawable2;
    }

    public static class IputGirdVeiw
    extends BaseAdapter {
        private Context mcontext = null;
        public String[] showtext = null;
        private int Weight = 0;
        private int girdNumColumns = 0;

        IputGirdVeiw(Context _context, String[] _showtext, int _Weight, int _girdNumColumns) {
            this.mcontext = _context;
            this.showtext = _showtext;
            this.Weight = _Weight;
            this.girdNumColumns = _girdNumColumns;
        }

        public int getCount() {
            return this.showtext.length;
        }

        public Object getItem(int position) {
            return position;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            Button mbutton = null;
            System.out.println("----------------------convertView-------------------------");
            System.out.println(convertView);
            mbutton = new Button(this.mcontext);
            if (this.showtext[position].equals("\u5927\u5199") || this.showtext[position].equals("\u5c0f\u5199")) {
                System.out.println("----------------------\u6539\u53d8-------------------------");
                mbutton.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams((this.Weight / this.girdNumColumns - 10) * 2, -2));
            } else {
                mbutton.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(this.Weight / this.girdNumColumns - 10, -2));
            }
            mbutton.setText((CharSequence)this.showtext[position]);
            mbutton.setTextColor(-1);
            mbutton.setTextSize((float)textSize);
            mbutton.setId(position);
            mbutton.setPadding(2, 2, 2, 2);
            System.out.println(position);
            if (this.showtext[position].equals("\u9000\u683c")) {
                mbutton.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        inputedit.setText((CharSequence)"");
                        return false;
                    }
                });
            }
            mbutton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (((Button)v).getText().toString().equals("\u5927\u5199")) {
                        IputGirdVeiw.this.showtext = upcaseletter;
                        IputGirdVeiw.this.notifyDataSetChanged();
                        System.out.println("----------------------\u5927\u5199-------------------------");
                    } else if (((Button)v).getText().toString().equals("\u5c0f\u5199")) {
                        IputGirdVeiw.this.showtext = lowerletter;
                        IputGirdVeiw.this.notifyDataSetChanged();
                        System.out.println("----------------------\u5c0f\u5199-------------------------");
                    } else {
                        int start = inputedit.getSelectionStart();
                        int end = inputedit.getSelectionEnd();
                        Editable text = inputedit.getText();
                        text.replace(start++, end, (CharSequence)IputGirdVeiw.this.showtext[position], 0, 1);
                        inputedit.setText((CharSequence)text);
                        inputedit.requestFocus();
                        inputedit.setSelection(start);
                    }
                }
            });
            mbutton.setBackgroundDrawable((Drawable)InputSoftKeyBoard.setBg());
            return mbutton;
        }
    }

    public static class ButtonLongListener
    implements View.OnLongClickListener {
        public boolean onLongClick(View v) {
            switch (v.getId()) {
                case 10001: {
                    inputedit.setText((CharSequence)"");
                    break;
                }
            }
            return false;
        }
    }

    public static class ButtonListener
    implements View.OnClickListener {
        public void onClick(View view) {
            switch (view.getId()) {
                case 10003: {
                    ClipboardManager cmb = (ClipboardManager)mcontext.getSystemService("clipboard");
                    try {
                        cmb.setText((CharSequence)("" + inputedit.getText()));
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 10001: {
                    InputSoftKeyBoard.deleteEdit();
                    break;
                }
                case 10002: {
                    String resultString = "" + inputedit.getText();
                    Log.v((String)"inputpanel", (String)"button is pressed!");
                    EditInput.setEdit(resultString);
                    mPopupWindow.dismiss();
                    mPopupWindow = null;
                    break;
                }
            }
        }
    }
}

