/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.combox.photo;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.combox.utils.DensityUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class XDPhotoBox
extends RelativeLayout
implements PreferenceManager.OnActivityResultListener {
    private ImageView PhotoButton;
    private ImageView DelClickButton;
    private ImageView PreClickButton;
    private ImageView NextClickButton;
    private ImageView photo;
    private Bitmap curPhoto;
    private int curPhotoNum = -1;
    private TextView textView;
    private Context mContext;
    private Vector<Bitmap> photoBitMaps = new Vector();
    private LinearLayout rll;
    private LinearLayout tblll;
    private TableLayout tbl;
    private Boolean isTakephotoShow = true;
    private Boolean isDeletShow = true;
    private int reqCode = -1;
    private int tempId = -1;
    private int imageWidth = 100;
    private int imageHeight = 100;
    private int btnId = -1;
    private String sdcardPath = "";
    private int buttonWidth = -2;
    private int buttonHeight = -2;
    private int photoWidth = 480;
    private int photoHeight = 320;
    private int maxNumber = 5;
    public View currentView = null;
    private HashMap<String, Integer> attrsMap = null;

    public XDPhotoBox(Context context) {
        super(context);
        this.mContext = context;
        this.init();
        this.InitPhoto();
    }

    public XDPhotoBox(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initialAttrMap(context);
        this.analysisAttrs(this.attrsMap, attrs);
        this.init();
        this.InitPhoto();
    }

    private void initialAttrMap(Context context) {
        this.attrsMap = new HashMap();
        this.attrsMap.put("image_width", 0);
        this.attrsMap.put("image_height", 1);
        this.attrsMap.put("box_width", 2);
        this.attrsMap.put("box_height", 3);
        this.attrsMap.put("button_width", 4);
        this.attrsMap.put("button_height", 5);
    }

    private int formatIntVlaue(String val) {
        int value = -1;
        if (val.endsWith("dp")) {
            val = val.substring(0, val.length() - 2);
            try {
                value = Integer.parseInt(val);
                value = DensityUtil.dp2px(this.mContext, value);
                Log.v((String)"pxValue", (String)(value + ""));
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u6570"));
            }
        } else {
            if (val.endsWith("px")) {
                val = val.substring(0, val.length() - 2);
            }
            try {
                value = Integer.parseInt(val);
                Log.v((String)"pxValue", (String)(value + ""));
            }
            catch (NumberFormatException ex) {
                Log.e((String)"NumberFormatException", (String)(val + "\u65e0\u6cd5\u8f6c\u6362\u4e3a\u6574\u6570"));
                Log.v((String)"pxValue", (String)(value + ""));
            }
        }
        return value;
    }

    private void analysisAttrs(HashMap<String, Integer> attrsMap, AttributeSet attrs) {
        int attrId = -1;
        if (attrs != null) {
            int attrsCount = attrs.getAttributeCount();
            DisplayMetrics dm = new DisplayMetrics();
            ((Activity)this.mContext).getWindowManager().getDefaultDisplay().getMetrics(dm);
            int width = dm.widthPixels;
            int height = dm.heightPixels;
            block8: for (int i = 0; i < attrsCount; ++i) {
                if (!attrsMap.containsKey(attrs.getAttributeName(i))) continue;
                attrId = attrsMap.get(attrs.getAttributeName(i));
                switch (attrId) {
                    case 0: {
                        this.imageWidth = this.formatIntVlaue(attrs.getAttributeValue(i));
                        continue block8;
                    }
                    case 1: {
                        this.imageHeight = this.formatIntVlaue(attrs.getAttributeValue(i));
                        continue block8;
                    }
                    case 2: {
                        int w = this.formatIntVlaue(attrs.getAttributeValue(i));
                        int h = (int)((float)w * 1.25f);
                        if (h < height) {
                            this.setSize(w, h);
                            continue block8;
                        }
                        this.setSize(w, -2);
                        continue block8;
                    }
                    case 3: {
                        int h1 = this.formatIntVlaue(attrs.getAttributeValue(i));
                        int w1 = (int)((float)h1 * 0.8f);
                        if (w1 < width) {
                            this.setSize(w1, h1);
                            continue block8;
                        }
                        this.setSize(-1, h1);
                        continue block8;
                    }
                    case 4: {
                        int w4;
                        this.buttonWidth = w4 = this.formatIntVlaue(attrs.getAttributeValue(i));
                        continue block8;
                    }
                    case 5: {
                        int h4;
                        this.buttonHeight = h4 = this.formatIntVlaue(attrs.getAttributeValue(i));
                        continue block8;
                    }
                }
            }
        }
    }

    public RelativeLayout create() {
        return this;
    }

    private void init() {
        this.sdcardPath = Environment.getExternalStorageDirectory() + "/test.jpg";
        Log.i((String)"path", (String)this.sdcardPath);
        this.rll = new LinearLayout(this.mContext);
        LinearLayout.LayoutParams llp = new LinearLayout.LayoutParams(-1, -2);
        this.rll.setLayoutParams((ViewGroup.LayoutParams)llp);
        this.tempId = Integer.parseInt(new SimpleDateFormat("HHmmss").format(new Date()));
        this.btnId = Integer.parseInt(new SimpleDateFormat("mmss").format(new Date()));
        this.rll.setId(this.tempId);
        this.tblll = new LinearLayout(this.mContext);
        this.textView = new TextView(this.mContext);
        this.textView.setText((CharSequence)"0 / 0");
        this.textView.setGravity(1);
        this.tblll.setId(this.btnId);
        this.tbl = new TableLayout(this.mContext);
        this.photo = new ImageView(this.mContext);
        Drawable defaultBgImage = this.getDrawableFromAssets(this.mContext, "xdphotobox_defaultimg.png");
        this.photo.setBackgroundDrawable(defaultBgImage);
        this.photo.setMinimumHeight(5);
        this.photo.setMinimumWidth(5);
        this.photo.setScaleType(ImageView.ScaleType.FIT_XY);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.imageWidth, this.imageHeight);
        this.photo.setLayoutParams((ViewGroup.LayoutParams)params);
        this.rll.addView((View)this.photo, this.imageWidth, this.imageHeight);
        this.rll.setGravity(1);
        this.addView((View)this.rll);
        this.PhotoButton = new ImageView(this.mContext);
        this.DelClickButton = new ImageView(this.mContext);
        this.PreClickButton = new ImageView(this.mContext);
        this.NextClickButton = new ImageView(this.mContext);
        this.setPaddingForButton(5);
        View.OnTouchListener otl = new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                XDPhotoBox.this.currentView = v;
                int action = event.getAction();
                if (action == 0) {
                    ColorMatrix cm = new ColorMatrix();
                    cm.setScale(0.6f, 0.6f, 0.6f, 0.8f);
                    ColorMatrixColorFilter cf = new ColorMatrixColorFilter(cm);
                    ((ImageView)v).setColorFilter((ColorFilter)cf);
                }
                if (action == 1 || action == 4) {
                    ((ImageView)v).clearColorFilter();
                }
                return false;
            }
        };
        this.PhotoButton.setOnTouchListener(otl);
        this.DelClickButton.setOnTouchListener(otl);
        this.PreClickButton.setOnTouchListener(otl);
        this.NextClickButton.setOnTouchListener(otl);
        Drawable d1 = XDPhotoBox.getImageFromAssetsFile(this.mContext, "assets/xdphotobox_take.9.png");
        Drawable d2 = XDPhotoBox.getImageFromAssetsFile(this.mContext, "assets/xdphotobox_pre.9.png");
        Drawable d3 = XDPhotoBox.getImageFromAssetsFile(this.mContext, "assets/xdphotobox_next.9.png");
        Drawable d4 = XDPhotoBox.getImageFromAssetsFile(this.mContext, "assets/xdphotobox_del.9.png");
        this.setImageButton(d1, d2, d3, d4);
        this.PreClickButton.setEnabled(false);
        this.setButtonGray(this.PreClickButton);
        this.NextClickButton.setEnabled(false);
        this.setButtonGray(this.NextClickButton);
        if (!this.isTakephotoShow.booleanValue()) {
            this.PhotoButton.setVisibility(8);
        }
        if (!this.isDeletShow.booleanValue()) {
            this.DelClickButton.setVisibility(8);
        }
        ViewGroup.LayoutParams tbr_params = new ViewGroup.LayoutParams(-1, -2);
        TableRow tbr = new TableRow(this.mContext);
        tbr.setLayoutParams(tbr_params);
        tbr.addView((View)this.PhotoButton, this.buttonWidth, this.buttonHeight);
        tbr.addView((View)this.PreClickButton, this.buttonWidth, this.buttonHeight);
        tbr.addView((View)this.NextClickButton, this.buttonWidth, this.buttonHeight);
        tbr.addView((View)this.DelClickButton, this.buttonWidth, this.buttonHeight);
        tbr.setGravity(1);
        this.tbl.addView((View)tbr);
        TableLayout.LayoutParams tblp = new TableLayout.LayoutParams(-1, -2);
        this.tbl.setLayoutParams((ViewGroup.LayoutParams)tblp);
        this.tbl.setGravity(1);
        RelativeLayout.LayoutParams mtextlayoutParams = new RelativeLayout.LayoutParams(-1, -2);
        mtextlayoutParams.addRule(3, this.tempId);
        LinearLayout.LayoutParams tblllp = new LinearLayout.LayoutParams(-1, -2);
        this.tblll.setLayoutParams((ViewGroup.LayoutParams)tblllp);
        this.tblll.setGravity(1);
        this.tblll.addView((View)this.tbl);
        this.addView((View)this.tblll, (ViewGroup.LayoutParams)mtextlayoutParams);
        RelativeLayout.LayoutParams tvParams = new RelativeLayout.LayoutParams(-1, -2);
        tvParams.addRule(3, this.btnId);
        this.addView((View)this.textView, (ViewGroup.LayoutParams)tvParams);
    }

    private void InitPhoto() {
        this.PhotoButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String status = Environment.getExternalStorageState();
                if (status.equals("mounted")) {
                    if (XDPhotoBox.this.photoBitMaps.size() < XDPhotoBox.this.maxNumber) {
                        try {
                            XDPhotoBox.this.reqCode = Integer.parseInt(new SimpleDateFormat("HHmmss").format(new Date()));
                            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                            intent.putExtra("output", (Parcelable)Uri.fromFile((File)new File(XDPhotoBox.this.sdcardPath)));
                            ((Activity)XDPhotoBox.this.mContext).startActivityForResult(intent, XDPhotoBox.this.reqCode);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        Toast.makeText((Context)XDPhotoBox.this.mContext, (CharSequence)("\u5df2\u8fbe\u7167\u7247\u62cd\u7167\u4e0a\u9650,\u7a0b\u5e8f\u8bbe\u7f6e\u6700\u591a\u53ef\u62cd " + XDPhotoBox.this.maxNumber + " \u5f20!"), (int)0).show();
                    }
                } else {
                    Toast.makeText((Context)XDPhotoBox.this.mContext, (CharSequence)"\u65e0sd\u5361", (int)0).show();
                }
            }
        });
        this.DelClickButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (XDPhotoBox.this.curPhotoNum == -1) {
                    return;
                }
                AlertDialog dlg = new AlertDialog.Builder(XDPhotoBox.this.mContext).setTitle((CharSequence)"\u63d0\u793a").setMessage((CharSequence)"\u662f\u5426\u5220\u9664\u5f53\u524d\u7167\u7247\uff1f").setPositiveButton((CharSequence)"\u662f", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dlg, int which) {
                        XDPhotoBox.this.deletPhoto(XDPhotoBox.this.curPhotoNum);
                        XDPhotoBox.this.curPhotoNum--;
                        if (XDPhotoBox.this.curPhotoNum < 0) {
                            int size = XDPhotoBox.this.photoBitMaps.size();
                            if (size == 0) {
                                XDPhotoBox.this.curPhoto = null;
                                XDPhotoBox.this.photo.setImageBitmap(XDPhotoBox.this.curPhoto);
                                XDPhotoBox.this.NextClickButton.setEnabled(false);
                                XDPhotoBox.this.setButtonGray(XDPhotoBox.this.NextClickButton);
                            } else {
                                XDPhotoBox.this.curPhotoNum = 0;
                                XDPhotoBox.this.curPhoto = (Bitmap)XDPhotoBox.this.photoBitMaps.get(0);
                                XDPhotoBox.this.photo.setImageBitmap(XDPhotoBox.this.curPhoto);
                                if (size == 1) {
                                    XDPhotoBox.this.NextClickButton.setEnabled(false);
                                    XDPhotoBox.this.setButtonGray(XDPhotoBox.this.NextClickButton);
                                }
                            }
                        } else {
                            XDPhotoBox.this.curPhoto = (Bitmap)XDPhotoBox.this.photoBitMaps.get(XDPhotoBox.this.curPhotoNum);
                            XDPhotoBox.this.photo.setImageBitmap(XDPhotoBox.this.curPhoto);
                            if (XDPhotoBox.this.curPhotoNum == 0) {
                                XDPhotoBox.this.PreClickButton.setEnabled(false);
                                XDPhotoBox.this.setButtonGray(XDPhotoBox.this.PreClickButton);
                            }
                        }
                        XDPhotoBox.this.updateTvNum();
                    }
                }).setNegativeButton((CharSequence)"\u5426", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dlg, int which) {
                        dlg.dismiss();
                    }
                }).show();
            }
        });
        this.PreClickButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XDPhotoBox.this.preImage();
            }
        });
        this.NextClickButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XDPhotoBox.this.nextImage();
            }
        });
    }

    private Bitmap getTakePhoto() throws IOException {
        File getPhoto = new File(this.sdcardPath);
        if (getPhoto.exists()) {
            FileInputStream is = new FileInputStream(getPhoto);
            byte[] buffer = new byte[1024];
            int len = -1;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            while ((len = ((InputStream)is).read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            byte[] data = outStream.toByteArray();
            outStream.close();
            ((InputStream)is).close();
            BitmapFactory.Options opt = new BitmapFactory.Options();
            opt.inJustDecodeBounds = true;
            getPhoto.delete();
            return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        }
        return null;
    }

    private void deletPhoto(int index) {
        this.photoBitMaps.remove(index);
    }

    private void preImage() {
        --this.curPhotoNum;
        Log.i((String)"next", (String)(this.curPhotoNum + ""));
        if (this.curPhotoNum == 0) {
            this.PreClickButton.setEnabled(false);
            this.setButtonGray(this.PreClickButton);
        }
        if (this.curPhotoNum < this.photoBitMaps.size() - 1) {
            this.NextClickButton.setEnabled(true);
            this.NextClickButton.clearColorFilter();
        }
        this.curPhoto = this.photoBitMaps.get(this.curPhotoNum);
        this.photo.setImageBitmap(this.photoBitMaps.get(this.curPhotoNum));
        this.updateTvNum();
    }

    private void nextImage() {
        ++this.curPhotoNum;
        Log.i((String)"next", (String)(this.curPhotoNum + ""));
        if (this.curPhotoNum > 0) {
            this.PreClickButton.setEnabled(true);
            this.PreClickButton.clearColorFilter();
        }
        if (this.curPhotoNum < this.photoBitMaps.size() - 1) {
            this.NextClickButton.setEnabled(true);
            this.NextClickButton.clearColorFilter();
        } else {
            this.NextClickButton.setEnabled(false);
            this.setButtonGray(this.NextClickButton);
        }
        this.curPhoto = this.photoBitMaps.get(this.curPhotoNum);
        this.photo.setImageBitmap(this.photoBitMaps.get(this.curPhotoNum));
        this.updateTvNum();
    }

    private void setCurrentIndex() {
        this.curPhotoNum = this.photoBitMaps.size() - 1;
        if (this.photoBitMaps.size() > 1) {
            if (this.curPhotoNum > 0) {
                this.PreClickButton.setEnabled(true);
                this.PreClickButton.clearColorFilter();
            }
            this.NextClickButton.setEnabled(false);
            this.setButtonGray(this.NextClickButton);
        }
    }

    public void setTakePhotoVisible(Boolean state) {
        if (state.booleanValue()) {
            this.PhotoButton.setVisibility(0);
        } else {
            this.PhotoButton.setVisibility(8);
        }
        this.isTakephotoShow = state;
    }

    public void setDeleteVisible(Boolean state) {
        if (state.booleanValue()) {
            this.DelClickButton.setVisibility(0);
        } else {
            this.DelClickButton.setVisibility(8);
        }
        this.isDeletShow = state;
    }

    public void setPhotoImage(List<Bitmap> pics) {
        if (pics != null && pics.size() > 0) {
            this.photoBitMaps.clear();
            for (Bitmap pic : pics) {
                this.photoBitMaps.add(pic);
            }
            this.photo.setImageBitmap(this.photoBitMaps.get(0));
            this.curPhoto = this.photoBitMaps.get(0);
            this.curPhotoNum = 0;
            this.updateTvNum();
            this.PreClickButton.setEnabled(false);
            this.setButtonGray(this.PreClickButton);
            this.NextClickButton.setEnabled(false);
            this.setButtonGray(this.NextClickButton);
            if (pics.size() > 1) {
                this.NextClickButton.setEnabled(true);
                this.NextClickButton.clearColorFilter();
            }
        }
    }

    public List<Bitmap> getPhotoImage() {
        ArrayList<Bitmap> temp = new ArrayList<Bitmap>();
        for (Bitmap pic : this.photoBitMaps) {
            temp.add(pic);
        }
        return temp;
    }

    public void setImageButton(Drawable takeButImg, Drawable PreButImg, Drawable nextButImg, Drawable delButImg) {
        this.PhotoButton.setImageDrawable(takeButImg);
        this.DelClickButton.setImageDrawable(delButImg);
        this.PreClickButton.setImageDrawable(PreButImg);
        this.NextClickButton.setImageDrawable(nextButImg);
    }

    private Drawable getDrawableFromAssets(Context cx, String imgName) {
        InputStream is = null;
        try {
            is = cx.getResources().getAssets().open(imgName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
        BitmapDrawable bd = new BitmapDrawable(bitmap);
        return bd;
    }

    private static Drawable getImageFromAssetsFile(Context context, String fileName) {
        Drawable drawable2 = null;
        try {
            InputStream stream = context.getClass().getClassLoader().getResourceAsStream(fileName);
            drawable2 = Drawable.createFromStream((InputStream)stream, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return drawable2;
    }

    private void setPhoto() {
        try {
            Bitmap pic = this.getBitmapzise(this.photoWidth, this.photoHeight);
            if (pic != null) {
                this.photoBitMaps.add(pic);
                this.setCurrentIndex();
                this.photo.setImageBitmap(pic);
                this.updateTvNum();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.reqCode && resultCode == -1) {
            this.setPhoto();
        }
        return true;
    }

    public void setPhotoSize(int w, int h) {
        this.imageWidth = w;
        this.imageHeight = h;
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.imageWidth, this.imageHeight);
        this.photo.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setPhotoSizeByRate(float wRate, float hRate) {
        if (wRate > 1.0f || hRate > 1.0f || wRate < 0.0f || hRate < 0.0f) {
            return;
        }
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)this.mContext).getWindowManager().getDefaultDisplay().getMetrics(dm);
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        this.imageWidth = (int)((float)width * wRate);
        this.imageHeight = (int)((float)height * hRate);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.imageWidth, this.imageHeight);
        this.photo.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setSize(int w, int h) {
        RelativeLayout.LayoutParams mtextlayoutParams = new RelativeLayout.LayoutParams(w, h);
        this.setLayoutParams((ViewGroup.LayoutParams)mtextlayoutParams);
    }

    private void setButtonGray(ImageView iv) {
        if (iv != null) {
            ColorMatrix cm = new ColorMatrix();
            cm.setSaturation(0.0f);
            ColorMatrixColorFilter cf = new ColorMatrixColorFilter(cm);
            iv.setColorFilter((ColorFilter)cf);
        }
    }

    public void setPaddingForButton(int paddingW) {
        this.PhotoButton.setPadding(paddingW, 0, paddingW, 0);
        this.DelClickButton.setPadding(paddingW, 0, paddingW, 0);
        this.PreClickButton.setPadding(paddingW, 0, paddingW, 0);
        this.NextClickButton.setPadding(paddingW, 0, paddingW, 0);
    }

    public void setDefaultBg(Drawable d) {
        this.photo.setBackgroundDrawable(d);
    }

    private void updateTvNum() {
        this.textView.setText((CharSequence)(this.curPhotoNum + 1 + " / " + this.photoBitMaps.size()));
    }

    public void setNoteVisible(boolean display) {
        if (display) {
            this.textView.setVisibility(0);
        } else {
            this.textView.setVisibility(8);
        }
    }

    public Bitmap getCurrentBitmap() {
        if (this.photoBitMaps.size() < 1 || this.curPhotoNum == -1) {
            return null;
        }
        return this.photoBitMaps.get(this.curPhotoNum);
    }

    private Bitmap getBitmapzise(int sizew, int sizeh) {
        BitmapFactory.Options o = new BitmapFactory.Options();
        o.inJustDecodeBounds = true;
        Bitmap bitmap = BitmapFactory.decodeFile((String)this.sdcardPath, (BitmapFactory.Options)o);
        int height = o.outHeight;
        int width = o.outWidth;
        o.inSampleSize = 1;
        o.inJustDecodeBounds = false;
        bitmap = BitmapFactory.decodeFile((String)this.sdcardPath, (BitmapFactory.Options)o);
        float scaleWidth = (float)sizew / (float)width;
        float scaleHeight = (float)sizeh / (float)height;
        Matrix matrix = new Matrix();
        matrix.postRotate(90.0f);
        matrix.postScale(scaleWidth, scaleHeight);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public void setPhotoBitmap(int sizew, int sizeh) {
        this.photoWidth = sizew;
        this.photoHeight = sizeh;
    }

    public void setMaxPhotosNumber(int num) {
        this.maxNumber = num;
    }

    private StateListDrawable setBackgroundWithStateListDrawable(Drawable[] drawables) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.EMPTY_STATE_SET, drawables[0]);
        return bg;
    }

    private Drawable getImageFromAssetsFile1(Context context, String fileName) {
        Drawable drawable2 = null;
        try {
            InputStream stream = context.getClass().getClassLoader().getResourceAsStream(fileName);
            drawable2 = Drawable.createFromStream((InputStream)stream, (String)"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return drawable2;
    }
}

