package com.xdja.combox.button;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

/**
 * 带图标的按钮
 * @author hhz
 *  
 */
public class XDImageButton extends LinearLayout {
	
	private int type;								//按钮的显示类型（通过xml获取）；
	private int mBackgroundId;						//按钮背景图片Id；
	private Drawable mImage;						//按钮上图片；
	private boolean mEnable = true;					//设置按钮是否可用；
	private boolean mClickable = true;				//设置按钮是否可点击；
	private boolean mFocusable = true;				//设置按钮是否可获取焦点；
	private int mTextColor = 0xFF000000;			//设置按钮文字颜色；
	private CharSequence text;						//设置按钮上文字内容；
	private float mTextSize;						//设置按钮上文字大小；
	private ImageView mImageView;					//按钮上的图片；
	private TextView mTextView;						//按钮上的文本；
	private Drawable[] drawables_round;				//圆形图片组；
	private Drawable[] drawables_square;			//方形图片组；
	private StateListDrawable mStateListDrawable;	//默认背景选择器；
	private Map<String, Integer> map;				//属性字典
	
	public XDImageButton(Context context) {
		this(context, null);
	}
	
	public XDImageButton(Context context, AttributeSet attrs) {
		super(context, attrs);
		/*
		 * 获取各种state状态时的圆角图片；
		 * 数组存储顺序pressed的图片、focused的图片、normal的图片
		 */
		drawables_round = new Drawable[3];
		drawables_round[0] = get9ImageFromAssetsFile(context, "xdbutton_round_pressed.9.png");
		drawables_round[1] = get9ImageFromAssetsFile(context, "xdbutton_round.9.png");
		
		/*
		 * 获取各种state状态时的圆角图片；
		 * 数组存储顺序pressed的图片、focused的图片、normal的图片
		 */
		drawables_square = new Drawable[3];
		drawables_square[0] = get9ImageFromAssetsFile(context, "xdbutton_square_pressed.9.png");
		drawables_square[1] = get9ImageFromAssetsFile(context, "xdbutton_square.9.png");
		
		initMap();
		
		/*
		 * 解析xml中控件的属性，获取他们的值；
		 */
		if (attrs != null) {
			for (int i = 0; i < attrs.getAttributeCount(); i ++) {
				Object obj = map.get(attrs.getAttributeName(i));
				if (obj != null) {
					int resourceId = attrs.getAttributeResourceValue(i, 0);
					switch((Integer)obj) {
					case 0:
						type = Integer.parseInt(attrs.getAttributeValue(i));
						break;
					case 1:
						mBackgroundId = resourceId;
						break;
					case 2:
						if (resourceId > 0) {
							text = getResources().getText(resourceId);
						} else {
							text = attrs.getAttributeValue(i);
						}
						break;
					case 3:
						if (resourceId > 0) {
							mTextColor = getResources().getColor(resourceId);
						}
						break;
					case 4:
						if (resourceId > 0) {
							mTextSize = getResources().getDimension(resourceId);
						} else {
							mTextSize = Float.parseFloat(attrs.getAttributeValue(i));
						}
						break;
					case 5:
						if (resourceId > 0) {
							mImage = getResources().getDrawable(resourceId);
						}
						break;
					case 6:
						mEnable = Boolean.parseBoolean(attrs.getAttributeValue(i));
						break;
					case 7:
						mFocusable = Boolean.parseBoolean(attrs.getAttributeValue(i));
						break;
					case 8:
						mClickable = Boolean.parseBoolean(attrs.getAttributeValue(i));
						break;
					default:
						break;
					}
				}
				
			}
		}
		
		mTextView = new TextView(context);
		mImageView = new ImageView(context);
		drawXDImageButton();
	}
	
	/*
	 * 初始化属性字典
	 */
	private void initMap() {
		map = new HashMap<String, Integer>();
		map.put("type", 0);
		map.put("background", 1);
		map.put("text", 2);
		map.put("textColor", 3);
		map.put("textSize", 4);
		map.put("image", 5);
		map.put("enabled", 6);
		map.put("focusable", 7);
		map.put("clickable", 8);
	}
	
	/*
	 * 绘制控件；
	 */
	private void drawXDImageButton() {
		
		this.setOrientation(LinearLayout.HORIZONTAL);
		this.setGravity(Gravity.CENTER);
		this.removeAllViews();
		if (!mEnable) {
			this.setFocusable(false);
			this.setClickable(false);
		} else {
			this.setFocusable(mFocusable);
			this.setClickable(mClickable);
		}
		
		mTextView.setText(text);
		mTextView.setTextColor(mTextColor);
		mTextView.setTextSize(mTextSize);
		if (mImage != null) {
			mImageView.setBackgroundDrawable(mImage);
			addView(mImageView, new LayoutParams(getTextHeight() + 2,
					getTextHeight() + 2));
		}
		switch (type) {
		case 0:
			this.mStateListDrawable = setBg(drawables_square);
			break;
		case 1:
			this.mStateListDrawable = setBg(drawables_round);
			break;
		default:
			break;
		}
		if (text != null) {
			addView(mTextView, new LayoutParams(LayoutParams.WRAP_CONTENT,
					LayoutParams.WRAP_CONTENT));
		}
		ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)mImageView.getLayoutParams();
		ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)mTextView.getLayoutParams();
		if (params != null && param != null) {
			params.rightMargin = 6;
			params.leftMargin = 10;
			param.rightMargin = 10;
			params.topMargin = 5;
			params.bottomMargin = 5;
			param.bottomMargin = 5;
			param.topMargin = 5;
		} else if (param == null && params != null) {
			params.leftMargin = 10;
			params.rightMargin = 10;
			params.topMargin = 5;
			params.bottomMargin = 5;
		} else if (param != null && params == null) {
			param.leftMargin = 10;
			param.rightMargin = 10;
			param.bottomMargin = 5;
			param.topMargin = 5;
		}
		/*
		 * 判断XDButton是否用默认的图片；
		 */
		if (mBackgroundId > 0) {
			this.setBackgroundResource(mBackgroundId);
		} else {
			this.setBackgroundDrawable(mStateListDrawable);
		}
	}
	

	/*
	 * 获取9.png的图片
	 */
	private NinePatchDrawable get9ImageFromAssetsFile(Context context,String FileName) {
		InputStream stream;
		try {
			stream = context.getAssets().open(FileName);
		    Bitmap bitmap = BitmapFactory.decodeStream(stream);  
		    byte[] chunk = bitmap.getNinePatchChunk();
		    boolean result = NinePatch.isNinePatchChunk(chunk);
		    NinePatchDrawable patchy = null;
		    if(result) {
		      patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
		    }
		    return patchy;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}
	
	private int getTextHeight() {
		TextPaint textPaint = mTextView.getPaint();
		return (int)(-(textPaint.ascent()) + textPaint.descent());
	}
		
	//构建状态选择器
	private StateListDrawable setBg(Drawable[] drawables) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(View.PRESSED_ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_STATE_SET, drawables[1]);
        bg.addState(View.FOCUSED_STATE_SET, drawables[0]);
        bg.addState(View.EMPTY_STATE_SET, drawables[1]);
        return bg;
    }
	
	public void setText(CharSequence text) {
		this.text = text;
		drawXDImageButton();
	}
	
	public CharSequence getText() {
		return this.text;
	}
	
	public void setText(int resouceId) {
		this.text = getResources().getText(resouceId);
		drawXDImageButton();
	}
	
	public void setTextColor(int color) {
		mTextColor = color;
		drawXDImageButton();
	}
	
	public int getTextColor() {
		return this.mTextColor;
	}
	
	public void setTxtColor(int resouceId) {
		mTextColor = getResources().getColor(resouceId);
		drawXDImageButton();
	}
	
	public void setTextSize(float size) {
		this.mTextSize = size;
		drawXDImageButton();
	}
	
	public float getTextSize() {
		return this.mTextSize;
	}
	
	public void setTextSize(int resourceId) {
		this.mTextSize = getResources().getDimension(resourceId);
		drawXDImageButton();
	}
	
	public void setImage(Drawable drawable) {
		mImage = drawable;
		drawXDImageButton();
	}
	
	public void setImage(int resouceId) {
		mImage = getResources().getDrawable(resouceId);
		drawXDImageButton();
	}
	
	public Drawable getImage() {
		return this.mImage;
	}

	public int getType() {
		return type;
	}

	public void setType(int type) {
		this.type = type;
		drawXDImageButton();
	}
	
	public void setClickListener(View.OnClickListener listener) {
		if (!mEnable) return;
		if (!mClickable) return;
		this.setOnClickListener(listener);
	}
	
}