package com.xdja.combox.datetime;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.ImageView.ScaleType;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TabHost;
import android.widget.TabWidget;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextSwitcher;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import android.widget.LinearLayout.LayoutParams;
import android.widget.TabHost.OnTabChangeListener;
import android.widget.TimePicker;

/**
 * 时间，日期选择对话框
 * 
 * @author wxl
 * 
 */
public class XDDateDialog extends AlertDialog implements
		android.view.View.OnClickListener {
	/** 上下文 */
	private Context mcontext = null;
	/** 仅显示日期 */
	public final static int SHOW_Date = 0;
	/** 仅显示时间 */
	public final static int SHOW_Time = 1;
	/** 显示日期和时间 */
	public final static int SHOW_Time_Date = 2;
	/** 控制显示方式变量 */
	private int DateDialogShowStyle = SHOW_Time_Date;
	/**日期的布局*/
	private RelativeLayout datelayout = null;
	/**时间的布局*/
	private RelativeLayout timelayout = null;
	/**显示的icon*/
	private Bitmap icon = null;
	/**对话框的显示文字*/
	private TextSwitcher title = null;
	/** 日期 */
	private String Date = "";
	/** 时间 */
	private String Time = "";
	private String Date_Time = "";
	/** 秒数 */
	private String second = null;
	/**传入的输入框*/
	private EditText edittext = null;
	private int Year = 0;
	private int Month = 0;
	private int Day = 0;
	private int Hour = 0;
	private int Minute = 0;
	private int Second = 0;
	/**记录传入的数据是否是符合格式的日期*/
	private Boolean isDateFormat=false;
    /**
     * 
     * @param context   上下文
     * @param ShowStyle  显示类型
     * @param _editText  填充的编辑对话框(控件里面，取的是Edittext的Tag值，如果程序中对控件进行赋值，则必须对Tag进行赋值)
     * @param _second   传入的指定的秒数 null 标识不显示秒数 ""(空字符串表示取系统默认时间)
     */
	public XDDateDialog(Context context, int ShowStyle, EditText _editText,String _second) {
		super(context);
		// TODO Auto-generated constructor stub
		mcontext = context;
		DateDialogShowStyle = ShowStyle;
		edittext = _editText;	
		second = _second;
		if(checkEditTextTag())
		{	
			if(!checkDateFormat())//检验传入的日期格式是否正确
			{
				isDateFormat=true;
			}
		}else{
			isDateFormat=true;
		}	
	}

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		if (SHOW_Time_Date == DateDialogShowStyle) {
			icon = getBitmap("xddatetime_clock.png");
			setContentView(InitLayout());
		} else {
			setContentView(setTimeorDateLayout());
		}
	}

	/**
	 * 功能：纯数字
	 */
	public String getTag() {
		String temStr = Date_Time.replace(" ", "");
		temStr = temStr.replace(":", "");
		temStr = temStr.replace("/", "");
		return temStr;
	}

	/**
	 * 功能：获取显示的时间格式 xxxx/xx/xx xx:xx:xx
	 */
	public String getText() {
		return Date_Time;
	}
	/**
	 * 检验Tag值是否赋过值
	 * @return
	 */
	private Boolean checkEditTextTag()
	{
		if(!edittext.getText().toString().trim().equals("")&&edittext.getTag()==null)
		{
			
			return false;
		}
		return true;
	}
	/**
	 * 检验EditText中Tag值是否符合格式
	 * @return
	 */
    private Boolean checkDateFormat()
    {
    	SimpleDateFormat sdf =null;  	
        switch(DateDialogShowStyle)
        {
        case SHOW_Date:
        	sdf= new SimpleDateFormat("yyyyMMdd");
        	break;
        case SHOW_Time:
        	if(second==null)
        	{
        	sdf= new SimpleDateFormat("HHmm");      	
        	}else{
        	sdf= new SimpleDateFormat("HHmmss");
        	}
        	break;
        case SHOW_Time_Date:
        	if(second==null)
        	{
        	sdf= new SimpleDateFormat("yyyyMMddHHmm");      	
        	}else{
        	sdf= new SimpleDateFormat("yyyyMMddHHmmss");
        	}
        	break;
        default :break;
        }
    	if(edittext.getTag()==null)
    	{
    		return true;	
    	}
    	int res=checkDateFormatAndValite(sdf,edittext.getTag().toString().trim());
    	if(res==1)
    	{
    		return true;	
    	}else{
				return false;
    	}
    }
	/**
	 * 功能：对话框布局
	 */
	private TabHost InitLayout() {
		/** TabHost参数设置 */
		final TabHost m_TabHost = new TabHost(mcontext);
		m_TabHost.setId(android.R.id.tabhost);
		LinearLayout.LayoutParams m_table = new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT);
		m_TabHost.setLayoutParams(m_table);
		ColorDrawable dw = new ColorDrawable(Color.argb(120, 00, 00, 00));
		m_TabHost.setBackgroundDrawable(dw);
		/** Linearlayout参数设置 */
		LinearLayout m_layout = new LinearLayout(mcontext);
		m_layout.setLayoutParams(new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
		m_layout.setOrientation(LinearLayout.VERTICAL);
		m_layout.addView(creatTitleView());
		FrameLayout content = new FrameLayout(mcontext);
		content.setId(android.R.id.tabcontent);
		LinearLayout.LayoutParams contentlp = new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.FILL_PARENT);
		contentlp.weight = 1.0f;
		content.setLayoutParams(contentlp);
		content.addView(DateLayout());
		content.addView(TimeLayout());
		/** TabWidget的布局参数设置，主要是设置其在外层LinearLayout的底部 */
		final TabWidget m_tabWidget = new TabWidget(mcontext);
		m_tabWidget.setId(android.R.id.tabs);
		RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.FILL_PARENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);
		m_tabWidget.setLayoutParams(lp);
		m_tabWidget.setStripEnabled(false);
		/** HorizontalScrollView的布局参数设置 */
		final HorizontalScrollView m_horizontalscroll = new HorizontalScrollView(
				mcontext);
		LinearLayout.LayoutParams horizontalscroll_layoutParams = new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		horizontalscroll_layoutParams.weight = 0.0f;
		m_horizontalscroll.setLayoutParams(horizontalscroll_layoutParams);
		m_horizontalscroll.setVerticalScrollBarEnabled(true);
		m_horizontalscroll.addView(m_tabWidget);
		m_layout.addView(m_horizontalscroll);
		m_layout.addView(content);
		m_layout.addView(setButton());
		m_TabHost.addView(m_layout);
		m_TabHost.setup();
		TabHost.TabSpec tab1 = m_TabHost.newTabSpec("0");
		tab1.setIndicator(createTabView("日期"));
		tab1.setContent(datelayout.getId());
		m_TabHost.addTab(tab1);
		TabHost.TabSpec tab2 = m_TabHost.newTabSpec("1");
		tab2.setIndicator(createTabView("时间"));
		tab2.setContent(timelayout.getId());
		m_TabHost.addTab(tab2);
		m_TabHost.setCurrentTab(0);
		setSelect(m_tabWidget, 0);
		DisplayMetrics dm = new DisplayMetrics();
		((Activity) mcontext).getWindowManager().getDefaultDisplay()
				.getMetrics(dm);
		int screenWidth = dm.widthPixels;
		int weight = (screenWidth / 7) * 6;
		setDialogWidth(weight);
		for (int i = 0; i < 2; i++) {
			m_tabWidget.getChildTabViewAt(i).setMinimumWidth(weight / 2);
		}
		m_TabHost.setOnTabChangedListener(new OnTabChangeListener() {
			@Override
			public void onTabChanged(String tabId) {
				// TODO Auto-generated method stub
				setSelect(m_tabWidget, m_TabHost.getCurrentTab());
			}
		});
		return m_TabHost;
	}

	/***
	 * 设置选择的tab标签
	 * 
	 * @param mtabWidget
	 * @param selectab
	 */
	private void setSelect(TabWidget mtabWidget, int selectab) {
		View vvv = mtabWidget.getChildTabViewAt(0);
		View vv = mtabWidget.getChildTabViewAt(1);
		if(selectab==0)
		{
		vvv.setBackgroundDrawable(getDrawable("tabselect.png"));
		vv.setBackgroundDrawable(getDrawable("tabunselect.png"));	
		}else{
		vvv.setBackgroundDrawable(getDrawable("tabunselect.png"));
		vv.setBackgroundDrawable(getDrawable("tabselect.png"));		
		}
	}

	/**
	 * 功能：初始化当前页面显示的tab数量 参数：
	 * 
	 * @param displayCount
	 *            设置一页显示的tab数量
	 */
	private void setDialogWidth(int Weight) {
		WindowManager.LayoutParams lp;
		lp = this.getWindow().getAttributes();
		lp.width = Weight;
		this.getWindow().setAttributes(lp);
	}

	/**
	 * 对话框标题参数
	 * 
	 * @return
	 */
	private LinearLayout creatTitleView() {
		LinearLayout m_layout = new LinearLayout(mcontext);
		m_layout.setLayoutParams(new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
		m_layout.setOrientation(LinearLayout.HORIZONTAL);
		m_layout.setPadding(5, 8, 0, 8);
		ImageView image = new ImageView(mcontext);
		image.setScaleType(ScaleType.CENTER_INSIDE);
		image.setImageBitmap(icon);
		m_layout.addView(image);
		title = new TextSwitcher(mcontext);
		title.setLayoutParams(new LinearLayout.LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT));
		title.setFactory(new ViewSwitcher.ViewFactory() {
			public View makeView() {
				TextView t = new TextView(mcontext);
				t.setTextColor(Color.WHITE);
				t.setTextSize(20);
				return t;
			}
		});
		Animation in = AnimationUtils.loadAnimation(mcontext,
				android.R.anim.fade_in);
		Animation out = AnimationUtils.loadAnimation(mcontext,
				android.R.anim.fade_out);
		title.setPadding(5, 0, 0, 0);
		title.setInAnimation(in);
		title.setOutAnimation(out);
		m_layout.addView(title);
		return m_layout;
	}

	private View createTabView(String text) {
		LinearLayout mLinearLayout = new LinearLayout(mcontext);
		mLinearLayout.setGravity(Gravity.CENTER);
		mLinearLayout.setLayoutParams(new LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
		mLinearLayout.setOrientation(LinearLayout.VERTICAL);
		mLinearLayout.setGravity(Gravity.CENTER);
		TextView mtext = new TextView(mcontext);
		mtext.setLayoutParams(new LayoutParams(LayoutParams.WRAP_CONTENT,
				LayoutParams.WRAP_CONTENT));
		mtext.setTextSize(18);
		mtext.setTextColor(Color.WHITE);
		mtext.setText(text);
		mtext.setPadding(0, 5, 0, 5);
		mLinearLayout.addView(mtext);
		mLinearLayout.setBaselineAligned(true);
		return mLinearLayout;
	}

	/**
	 * 仅有时间和日期的时候使用的布局
	 * 
	 * @return
	 */
	private LinearLayout setTimeorDateLayout() {
		DisplayMetrics dm = new DisplayMetrics();		((Activity) mcontext).getWindowManager().getDefaultDisplay()
				.getMetrics(dm);
		int screenWidth = dm.widthPixels;
		int weight = (screenWidth / 7) * 6;
		setDialogWidth(weight);
		LinearLayout m_layout = new LinearLayout(mcontext);
		m_layout.setLayoutParams(new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
		m_layout.setOrientation(LinearLayout.VERTICAL);
		if (DateDialogShowStyle == SHOW_Time) {
			icon = getBitmap("xddatetime_clock.png");
			m_layout.addView(creatTitleView());
			m_layout.addView(TimeLayout());
			m_layout.addView(setButton());
		}
		if (DateDialogShowStyle == SHOW_Date) {
			icon = getBitmap("xddatetime_clock.png");
			m_layout.addView(creatTitleView());
			m_layout.addView(DateLayout());
			m_layout.addView(setButton());
		}
		ColorDrawable dw = new ColorDrawable(Color.argb(120, 00, 00, 00));
		m_layout.setBackgroundDrawable(dw);
		return m_layout;
	}

	/**
	 * 选择日期的布局
	 * 
	 * @return
	 */
	private RelativeLayout DateLayout() {
		datelayout = new RelativeLayout(mcontext);
		RelativeLayout.LayoutParams datelayoutparams = null;
		if (DateDialogShowStyle != SHOW_Date) {
			datelayoutparams = new RelativeLayout.LayoutParams(
					LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT);
			datelayout.setLayoutParams(datelayoutparams);
		} else {
			datelayoutparams = new RelativeLayout.LayoutParams(
					LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
			datelayout.setLayoutParams(datelayoutparams);
		}
		DatePicker datepicker = new DatePicker(mcontext);
		float scale = mcontext.getResources().getDisplayMetrics().density;
		int size = (int) (100 * scale + 0.5f);
		ViewGroup.LayoutParams layoutParams = new LinearLayout.LayoutParams(size, LayoutParams.WRAP_CONTENT);
		int sdk_version = Integer.parseInt(android.os.Build.VERSION.SDK);
		if (sdk_version >= 14) {
			((ViewGroup)(((ViewGroup) datepicker.getChildAt(0)).getChildAt(0))).getChildAt(1).setLayoutParams(layoutParams);
		}
		RelativeLayout.LayoutParams datepickerlayoutparams = new RelativeLayout.LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		datepickerlayoutparams.addRule(RelativeLayout.CENTER_IN_PARENT);
		datepicker.setLayoutParams(datepickerlayoutparams);
		datelayout.setId(11);
		/** 获取当前的日期 */
	    if(edittext.getText().toString().replace(" ", "").equals("")||isDateFormat)
	    {
	    	Calendar c = Calendar.getInstance();
			Year = c.get(Calendar.YEAR);
			Month =c.get(Calendar.MONTH)+1;
			Day = c.get(Calendar.DAY_OF_MONTH);
			Date = Year + "/" + (Month < 10 ? ("0" + (Month)) : (Month))
					+ "/" + (Day < 10 ? ("0" + (Day)) : (Day));
	    }else{
	    	if(edittext.getTag().toString().length()>=8)
	    	{
	    	try{
	    	Year = Integer.valueOf(edittext.getTag().toString().substring(0, 4));
			Month = Integer.valueOf(edittext.getTag().toString().substring(4, 6));
			Day = Integer.valueOf(edittext.getTag().toString().substring(6, 8));
	    	}catch(Exception e)
	    	{
	    		e.printStackTrace();
	    		Calendar c = Calendar.getInstance();
				Year = c.get(Calendar.YEAR);
				Month =c.get(Calendar.MONTH)+1;
				Day = c.get(Calendar.DAY_OF_MONTH);
				Date = Year + "/" + (Month < 10 ? ("0" + (Month)) : (Month))
						+ "/" + (Day < 10 ? ("0" + (Day)) : (Day));
	    	}
			Date = Year + "/" + (Month < 10 ? ("0" + (Month )) : (Month))
					+ "/" + (Day < 10 ? ("0" + (Day)) : (Day));
	    	}
	    }
	    if (DateDialogShowStyle == SHOW_Date)
	    {   
	    	Date_Time=Date;
	    	title.setText(Date_Time);	
	    }
		datepicker.init(Year, Month-1, Day,
				new DatePicker.OnDateChangedListener() {
					public void onDateChanged(DatePicker arg0, int year,
							int month, int day) {
						Date = year
								+ "/"
								+ (month < 9 ? ("0" + (month + 1))
										: (month + 1)) + "/"
								+ (day < 10 ? ("0" + (day)) : (day));
						Date_Time = Date + " " + Time;
						title.setText(Date_Time);
					}
				});
		datepicker.setId(101);
		datelayout.addView(datepicker);
		if (DateDialogShowStyle != SHOW_Date) {
			datelayout.setVisibility(View.INVISIBLE);
		} 
		return datelayout;
	}

	/**
	 * 选择时间的布局
	 * 
	 * @return
	 */
	private RelativeLayout TimeLayout() {
		timelayout = new RelativeLayout(mcontext);
		RelativeLayout.LayoutParams timelayoutparams = null;
		if (DateDialogShowStyle != SHOW_Time) {
			timelayoutparams = new RelativeLayout.LayoutParams(
					LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT);
		} else {
			timelayoutparams = new RelativeLayout.LayoutParams(
					LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		}
		timelayout.setLayoutParams(timelayoutparams);
		/** 获取当前的日期 */
		Calendar c = Calendar.getInstance();
		if(edittext.getText().toString().replace(" ", "").equals("")||isDateFormat)//第一次取系统时间
		{
			Hour = c.get(Calendar.HOUR_OF_DAY);
			Minute = c.get(Calendar.MINUTE);
		}else{//解析已经选择的时间
			try{
			if (edittext.getTag().toString().length()<=6)
			{
			Hour = Integer.valueOf(edittext.getTag().toString().substring(0, 2));
			Minute = Integer.valueOf(edittext.getTag().toString().substring(2, 4));	
			}else{
				Hour = Integer.valueOf(edittext.getTag().toString().substring(8, 10));
				Minute = Integer.valueOf(edittext.getTag().toString().substring(10, 12));	
			}
			}catch(Exception e)
			{
				e.printStackTrace();
				Hour = c.get(Calendar.HOUR);
				Minute = c.get(Calendar.MINUTE);
			}
		}
		String temp="";
		if (second == null) {//根据传入的控制秒数的参数对秒进行处理
			Time = ""+ (Hour <= 9 ? ("0" + Hour): Hour)+ ":"+ (Minute <= 9 ? ("0" +Minute) : Minute);
		} else {
			if (second.equals("")) {
				Time = ""+ (Hour <= 9 ? ("0" +Hour) : Hour)+ ":"+ (Minute <= 9 ? ("0" + Minute) : Minute)+ ":"+ (c.get(Calendar.SECOND) <= 9 ? ("0" + c
								.get(Calendar.SECOND)) : c.get(Calendar.SECOND));
				temp=String.valueOf(c.get(Calendar.SECOND) <= 9 ? ("0" + c.get(Calendar.SECOND)) : c.get(Calendar.SECOND));
			} else {
				Time = ""+ (Hour <= 9 ? ("0" +Hour) :Hour)+ ":"+ (Minute <= 9 ? ("0" +Minute) : Minute)+":"+ (Second <= 9 ? ("0" +Second): Second) ;
				temp=String.valueOf((Second <= 9 ? ("0" +Second): Second) );
			}
		}
		final  String  secondvalue=temp;
		Date_Time=Date+" "+Time;
		if(DateDialogShowStyle==SHOW_Time)
		{
		title.setText(Date_Time);
		}
		if(DateDialogShowStyle==SHOW_Time_Date)
		{
			title.setText(Date_Time);
		}
		TimePicker timepicker = new TimePicker(mcontext);
		RelativeLayout.LayoutParams tiempickerlayoutparams = new RelativeLayout.LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		tiempickerlayoutparams.addRule(RelativeLayout.CENTER_IN_PARENT);
		timepicker.setLayoutParams(tiempickerlayoutparams);
		timepicker.setIs24HourView(true);
		timepicker.setCurrentHour(Hour);
		timepicker.setCurrentMinute(Minute);
		timepicker.setOnTimeChangedListener(new TimePicker.OnTimeChangedListener() {
					public void onTimeChanged(TimePicker arg0, int hour,
							int minute) {
						if(second == null)
						{
						Time = "" + (hour <= 9 ? ("0" + hour) : hour) + ":"
								+ (minute <= 9 ? ("0" + minute) : minute);
						}else{
							Time = "" + (hour <= 9 ? ("0" + hour) : hour) + ":"
									+ (minute <= 9 ? ("0" + minute) : minute)+":"+secondvalue;	
						}
						Date_Time = Date + " " + Time;
						title.setText(Date_Time);
					}
				});
		timelayout.setId(10);
		timelayout.addView(timepicker);
		if (DateDialogShowStyle != SHOW_Time) {
			timelayout.setVisibility(View.INVISIBLE);
		} 
		return timelayout;
	}

	/**
	 * 取9.png文件转化为Drawable
	 * 
	 * @param FileName
	 *            文件名
	 * @return
	 */
	private NinePatchDrawable get9ImageFromAssetsFile(String FileName) {
		InputStream stream;
		try {
			stream = mcontext.getAssets().open(FileName);
			Bitmap bitmap = BitmapFactory.decodeStream(stream);
			byte[] chunk = bitmap.getNinePatchChunk();
			boolean result = NinePatch.isNinePatchChunk(chunk);
			NinePatchDrawable patchy = null;
			if (result) {
				patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
			}
			return patchy;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 取Bitmap文件转化为Bitmap
	 * 
	 * @param context
	 * @param FileName
	 * @return
	 */
	private Bitmap getBitmap(String FileName) {
		InputStream stream;
		Bitmap bitmap;
		try {
			stream =mcontext.getAssets().open(FileName);
			bitmap = BitmapFactory.decodeStream(stream);
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
		return bitmap;
	}
	/**
	 * 取Bitmap文件转化为Drawable
	 * 
	 * @param context
	 * @param FileName
	 * @return
	 */
	private Drawable getDrawable(String FileName) {
		InputStream stream;
		Drawable drawable;
		try {
			stream = mcontext.getAssets().open(FileName);
			drawable = Drawable.createFromStream(stream, FileName);
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
		return drawable;
	}
	private TableLayout setButton() {
		String[] message = { "确认", "清空", "取消" };
		TableLayout mtablelayout = new TableLayout(mcontext);
		mtablelayout.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		mtablelayout.setId(1);
		mtablelayout.setOrientation(TableLayout.VERTICAL);
		mtablelayout.setShrinkAllColumns(true);
		mtablelayout.setStretchAllColumns(true);
		TableRow mtableraw = new TableRow(mcontext);
		mtableraw.setLayoutParams(new TableLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
		mtableraw.setOrientation(TableRow.HORIZONTAL);
		mtableraw.setGravity(Gravity.BOTTOM);
		for (int i = 0; i < message.length; i++) {
			Button button = new Button(mcontext);
			button.setId(i);
			button.setTextSize(18);
			button.setLayoutParams(new TableRow.LayoutParams(
					LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT));
			button.setText(message[i]);
			mtableraw.addView(button);
			button.setOnClickListener(this);
		}
		mtablelayout.addView(mtableraw);
		return mtablelayout;
	}

	@Override
	public void onClick(View v) {
		// TODO Auto-generated method stub
		switch (v.getId()) {
		case 0:
			edittext.setText(getText());
			edittext.setTag(getTag());
			edittext.setFocusable(true);
			edittext.requestFocus();
			this.dismiss();
			break;
		case 1:
			edittext.setText("");
			edittext.setTag("");
			edittext.setFocusable(true);
			edittext.requestFocus();
			this.dismiss();
			break;
		case 2:
			edittext.setFocusable(true);
			edittext.requestFocus();
			this.dismiss();
			break;
		}
	}
	/**
	 * 检验改字符串是否符合指定的日期格式
	 * @param format 日期格式
	 * @param temp   待检验的字符串
	 * @return 1 符合格式
	 *         -1  日期格式错误 
	 * 
	 */
	 private int checkDateFormatAndValite(SimpleDateFormat format ,String temp) {
	        //update it according to your requirement.
	        try {
	            Date ndate = format.parse(temp);
	            String str = format.format(ndate);
	            System.out.println(ndate);
	            System.out.println(str);
	            if (str.equals(temp))
	            {
	                return 1;	   
	            }
	            else
	            {
	                return 0;
	            }
	        } catch (Exception e){
	            e.printStackTrace();
	            //format error
	            return -1;
	        }
	    }
}
