package com.xdja.combox.datetime;

import java.io.InputStream;
import java.util.Calendar;

import android.app.DatePickerDialog;
import android.app.DatePickerDialog.OnDateSetListener;
import android.app.TimePickerDialog;
import android.app.TimePickerDialog.OnTimeSetListener;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TimePicker;

import com.xdja.combox.inputbutton.XDEditText;
import com.xdja.combox.inputbutton.XDEditTextButton;
import com.xdja.combox.utils.DensityUtil;

public class XDDateTimeText extends LinearLayout {

	private XDDateDialog dateDialog = null;
	private int TextShowType = 0; // 显示文本框类型（0：方角类型；1：圆角类型）
	private String dateFormatStr = null; // 格式化日期格式（“yyyy-MM-dd”或“HH：mm：ss”）
	private String dateFormat = null; // 显示日期或者时间（time 显示时间，date显示日期）
	private int buttonShowStyle = 0; // 按钮的 属性,内嵌还是外漏 (0:外漏 1：内嵌)
	private String textView_text = null; // TextView 的文本值
	private int textView_showStyle = 0; // 设置TextView 显示方式 0：外漏 1：内嵌
	private int textView_textColor = 0; // 设置TextView 的 文本颜色值
	private String textView_textSize = ""; // 设置TextView的 文本尺寸
	private String textView_width = ""; // 设置 TextView的宽度
	private int editText_background = 0; // 设置EditText 的背景图片
	private boolean textView_visiable; // 设置TextView 是否显示
	private int ImageButton_background = 0; // 设置日期时间按钮的背景色
	private Context mContext = null;
	private Calendar c;
	private int m_year, m_month, m_day; // 年月日
	private int m_hour, m_minute; // 时分秒
	private XDEditTextButton xdetb = null; // 文本按钮控件
	private int layoutHeight = -1;

	public XDDateTimeText(Context context) {
		super(context);
		mContext = context;
	}

	// 遍历XML文件为 属性赋值
	public XDDateTimeText(Context context, AttributeSet attrs) {
		super(context, attrs);

		mContext = context;
		xdetb = new XDEditTextButton(context, 1);

		if (attrs != null) {
			int attrsCount = attrs.getAttributeCount();
			for (int i = 0; i < attrsCount; i++) {
				// 显示文本框类型
				if (attrs.getAttributeName(i).equals("TextShowType")) {
					if (attrs.getAttributeValue(i) != null) {
						TextShowType = Integer.parseInt(attrs.getAttributeValue(i));
					}
					// 格式化日期格式
				} else if (attrs.getAttributeName(i).equals("dateFormatStr")) {
					if (attrs.getAttributeValue(i) != null) {
						dateFormatStr = attrs.getAttributeValue(i);
					}
					// 显示日期或者时间
				} else if (attrs.getAttributeName(i).equals("dateFormat")) {
					if (attrs.getAttributeValue(i) != null) {
						dateFormat = attrs.getAttributeValue(i);
					}
					// TextView 的文本值
				} else if (attrs.getAttributeName(i).equals("textView_text")) {
					if (attrs.getAttributeValue(i) != null) {
						textView_text = attrs.getAttributeValue(i);
					}
					// 按钮的 属性,内嵌还是外漏
				} else if (attrs.getAttributeName(i).equals("buttonShowStyle")) {
					if (attrs.getAttributeValue(i) != null) {
						buttonShowStyle = Integer.parseInt(attrs.getAttributeValue(i));
					}
					// 设置TextView 显示方式
				} else if (attrs.getAttributeName(i).equals("textView_showStyle")) {
					if (attrs.getAttributeValue(i) != null) {
						textView_showStyle = Integer.parseInt(attrs.getAttributeValue(i));
					}

				} else if (attrs.getAttributeName(i).equals("textView_textColor")) {
					if (attrs.getAttributeValue(i) != null) {
						textView_textColor = attrs.getAttributeResourceValue(i, -1);
					}
				} else if (attrs.getAttributeName(i).equals("editText_background")) {
					if (attrs.getAttributeValue(i) != null) {
						editText_background = attrs.getAttributeResourceValue(i, -1);
					}
				} else if (attrs.getAttributeName(i).equals("textView_textSize")) {
					if (attrs.getAttributeValue(i) != null) {
						textView_textSize = attrs.getAttributeValue(i);
					}
					// 设置 TextView的宽度
				} else if (attrs.getAttributeName(i).equals("textView_width")) {
					if (attrs.getAttributeValue(i) != null) {
						textView_width = attrs.getAttributeValue(i);
					}
					// 设置TextView 是否显示
				} else if (attrs.getAttributeName(i).equals("textView_visiable")) {
					if (attrs.getAttributeValue(i) != null) {
						textView_visiable = attrs.getAttributeBooleanValue(i, false);
					}
				} else if (attrs.getAttributeName(i).equals("image")) {
					if (attrs.getAttributeValue(i) != null) {
						ImageButton_background = attrs.getAttributeResourceValue(i, -1);
					}
				} else if (attrs.getAttributeName(i).equals("layout_height")) {
					this.layoutHeight = formatIntVlaue(attrs.getAttributeValue(i));
				}
			}
		}
		// 创建插件布局
		createPlus(context);
		// 初始化日期时间
		initDate();
	}

	// 初始化 各个控件的布局
	private void createPlus(final Context context) {
		setTextViewAttrs(xdetb); // 设置TextView各个属性
		xdetb.setEditText_enable(false);
		xdetb.setEditText_digits("0123456789/:-"); // 设置TextView的输入类型
		// xdetb.setEditText_maxLength(10); // 设置TextView 输入的最大长度
		xdetb.setEditText_enable(false);
		xdetb.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));

		xdetb.setButton_OnClickListener(new View.OnClickListener() {
			@Override
			public void onClick(View v) {
				if (dateDialog == null) {
					buildDateOrTimeDialog(context);
				}
				if (!dateDialog.isShowing()) {
					dateDialog.show();
				}
			}
		});
		xdetb.setControlSize(LayoutParams.FILL_PARENT, layoutHeight);
		addView(xdetb, new LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT));
	}

	// 创建日期或者 时间的Dialog
	private void buildDateOrTimeDialog(Context context) {
		// 判断显示的格式是 日期 还是时间，如果没有设置，默认使用 日期
		Log.i("type", "Type       =   " + dateFormat);
		if (dateFormat == null || dateFormat.equals("date")) {
			// new DatePickerDialog(context, dateListener, m_year, m_month,
			// m_day)
			// .show();
			dateDialog = new XDDateDialog(context, XDDateDialog.SHOW_Date, xdetb.getEditText(), null);
		} else if (dateFormat != null && dateFormat.equals("time")) {
			// new TimePickerDialog(context, timeListener, m_hour, m_minute,
			// true)
			// .show();
			dateDialog = new XDDateDialog(context, XDDateDialog.SHOW_Time, xdetb.getEditText(), "");
		} else if (dateFormat != null && dateFormat.equals("date_time")) {
			// new TimePickerDialog(context, timeListener, m_hour, m_minute,
			// true)
			// .show();
			// new XDDateDialog(context,
			// XDDateDialog.SHOW_Time, xdetb.getEditText(),"").show();

			dateDialog = new XDDateDialog(context, XDDateDialog.SHOW_Time_Date, xdetb.getEditText(), "00");
		}
	}

	// 日期监听事件，格式化日期显示格式
	private OnDateSetListener dateListener = new OnDateSetListener() {

		@Override
		public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
			m_year = year;
			m_month = monthOfYear;
			m_day = dayOfMonth;
			if (dateFormatStr != null && dateFormatStr.equals("yyyy-MM-dd")) {
				setText(year + "-" + (monthOfYear < 9 ? ("0" + (monthOfYear + 1)) : (monthOfYear + 1)) + "-"
						+ (dayOfMonth < 10 ? ("0" + (dayOfMonth)) : (dayOfMonth)));
			} else if (dateFormatStr != null && dateFormatStr.equals("yyyy/MM/dd")) {
				setText(year + "/" + (monthOfYear < 9 ? ("0" + (monthOfYear + 1)) : (monthOfYear + 1)) + "/"
						+ (dayOfMonth < 10 ? ("0" + (dayOfMonth)) : (dayOfMonth)));
			} else if (dateFormatStr != null && dateFormatStr.equals("yyyyMMdd")) {
				setText(year + "" + (monthOfYear < 9 ? ("0" + (monthOfYear + 1)) : (monthOfYear + 1))
						+ (dayOfMonth < 10 ? ("0" + (dayOfMonth)) : (dayOfMonth)));
			} else if (dateFormatStr != null && dateFormatStr.equals("yyMMdd")) {
				year = Integer.parseInt(("" + year).substring(2));
				setText(year + "" + (monthOfYear < 9 ? ("0" + (monthOfYear + 1)) : (monthOfYear + 1))
						+ (dayOfMonth < 10 ? ("0" + (dayOfMonth)) : (dayOfMonth)));
			} else {
				setText(year + "" + "-" + (monthOfYear + 1) + "" + "-" + dayOfMonth);
			}
		}
	};

	// 时间监听事件,格式化时间
	private OnTimeSetListener timeListener = new OnTimeSetListener() {
		@Override
		public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
			m_hour = hourOfDay;
			m_minute = minute;
			if (dateFormatStr != null && dateFormatStr.equals("HH:mm:ss")) {
				int m_second = Calendar.getInstance().get(Calendar.SECOND);
				setText("" + (m_hour < 10 ? ("0" + (m_hour)) : (m_hour)) + ":"
						+ (m_minute < 10 ? ("0" + (m_minute)) : (m_minute)) + ":"
						+ (m_second < 10 ? ("0" + (m_second)) : (m_second)));
			} else if (dateFormatStr != null && dateFormatStr.equals("HH:mm")) {
				setText("" + (m_hour < 10 ? ("0" + (m_hour)) : (m_hour)) + ":"
						+ (m_minute < 10 ? ("0" + (m_minute)) : (m_minute)));
			} else {
				setText("" + m_hour + ":" + m_minute);
			}
		}
	};

	// 初始化 年 月 日 小时 分钟
	private void initDate() {
		c = Calendar.getInstance();
		m_year = c.get(Calendar.YEAR);
		m_month = c.get(Calendar.MONTH);
		m_day = c.get(Calendar.DAY_OF_MONTH);
		m_hour = c.get(Calendar.HOUR);
		m_minute = c.get(Calendar.MINUTE);
	}

	// 获取文本控件中的日期或者时间文本
	public String getText() {
		Editable str = xdetb.getEditText_text();
		return str.toString();
	}

	// 设置文本控件中的日期或者时间文本
	public void setText(String str) {
		xdetb.setEditText_text(str);
	}

	// 得到assets目录的 9.png 资源
	private Drawable getDrawable(Context context) {
		InputStream is = null;
		if (dateFormat != null && dateFormat.equals("time")) { // 判断显示的是time 还是
																// date,选择相对应的图片资源
			is = context.getClass().getClassLoader().getResourceAsStream("assets/xddatetime_clock.png");

		} else {
			is = context.getClass().getClassLoader().getResourceAsStream("assets/xddatetime_clock.png");
		}
		Drawable dra = Drawable.createFromStream(is, "9.png");
		return dra;
	}

	private void setTextViewAttrs(XDEditTextButton xdetb) {
		xdetb.setTextView_visiable(textView_visiable); // 设置TextView是否显示
		if (textView_textSize != null && !textView_textSize.equals("")) {
			xdetb.setTextView_textSize(formatFloatVlaue(textView_textSize));
		}
		if (textView_textColor > 0) { // 判断是否有颜色值,有值的话设置值,没有则默认
			/*
			 * xdetb.setTextView_textColor(getContext().getResources().getColor(
			 * textView_textColor));
			 */
			xdetb.setTextView_textColor(textView_textColor);
		}
		switch (TextShowType) {
		case 0:
			xdetb.setDisplayType(0); // 设置EditView 显示方式 0：方角 1：圆角
			break;
		case 1:
			xdetb.setDisplayType(1); // 设置EditView 显示方式 0：方角 1：圆角
			break;
		}

		switch (buttonShowStyle) {
		case 0:
			xdetb.setLayoutType(0); // 设置Button 显示方式 0：外漏 1：内嵌
			break;
		case 1:
			xdetb.setLayoutType(1); // 设置Button 显示方式 0：外漏 1：内嵌
			break;
		}

		// if (textView_showStyle == 0) { // 设置TextView 显示方式 0：外漏 1：内嵌
		// xdetb.setInnerLayoutType(0);
		// } else {
		// xdetb.setInnerLayoutType(1);
		// }
		switch (textView_showStyle) { // 设置TextView 显示方式 0：外漏 1：内嵌
		case 0:
			xdetb.setInnerLayoutType(0);
			break;
		case 1:
			xdetb.setInnerLayoutType(1);
			break;
		default:
			break;
		}
		if (textView_text != null) { // 判断TextView是否有值，有的话设置
			xdetb.setTextView_text(textView_text);
		}
		if (textView_width != null && !textView_width.equals("")) { // 判断是否设置TextView的高，有则设置，没有不设置
			xdetb.setTextView_width(formatIntVlaue(textView_width + ""));
		}
		if (editText_background != 0) {
			xdetb.setEditText_background(editText_background);
		}
		if (ImageButton_background != 0) {
			xdetb.setImageButton_image(ImageButton_background);
		} else {
			xdetb.setImageButton_image(getDrawable(mContext)); // 选择时间或者日期的小图标
		}
	}

	// 得到EditText 对象
	public XDEditText getEditText() {
		return xdetb.getEditText();
	}

	// 得到ImageButton 对象
	public ImageButton getImageButton() {
		return xdetb.getImageButton();
	}

	/**
	 * 格式化xml布局文件中传入的宽度大小值为整数
	 * 
	 * @param val
	 *            传入的字符串
	 * @return 得到的整数结果
	 */
	private int formatIntVlaue(String val) {
		int value = -1;
		if (val.equals("wrap_content")) {
			value = -2;
		} else if (val.equals("fill_parent")) {
			value = -1;
		} else if (val.endsWith("dp") || val.endsWith("dip")) {
			if (val.endsWith("dp")) {
				val = val.substring(0, val.length() - 2);
			} else if (val.endsWith("dip")) {
				val = val.substring(0, val.length() - 5);
			}
			try {
				value = Integer.parseInt(val);
				value = DensityUtil.dp2px(mContext, (float) value);
				Log.v("pxValue", value + "");
			} catch (NumberFormatException ex) {
				Log.e("NumberFormatException", val + "无法转换为整数");
			}
		} else {
			if (val.endsWith("px")) {
				val = val.substring(0, val.length() - 2);
			}
			try {
				value = Integer.parseInt(val);
				Log.v("pxValue", value + "");
			} catch (NumberFormatException ex) {
				Log.e("NumberFormatException", val + "无法转换为整数");
				Log.v("pxValue", value + "");
			}
		}
		return value;
	}

	/**
	 * 格式化xml布局文件中传入的字体大小设置的值
	 * 
	 * @param val
	 *            传入的字符串
	 * @return 格式化得到的float类型值
	 */
	private float formatFloatVlaue(String val) {
		boolean isFormat = true;
		float value = (float) 14.0;
		if (val.endsWith("sp")) {
			val = val.substring(0, val.length() - 2);
		}
		try {
			value = Float.parseFloat(val);
		} catch (NumberFormatException e) {
			isFormat = false;
		}
		if (!isFormat) {
			try {
				value = (float) Integer.parseInt(val);
			} catch (NumberFormatException ex) {
				Log.e("NumberFormatException", val + "不能被转化为float类型");
			}
		}
		return value;
	}

}
