package com.xdja.combox.dialog;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;

public class MyAdapter extends BaseAdapter {
	private List<String> list;
	private Context context;
	public static List<Boolean> isSelected;
	private String str;
	
	public MyAdapter(List<String> list, Context context, String str) {
		this.list = list;
		this.context = context;
		this.str = str;
		init();
	}
	
	//初始化       
	private void init() {
		isSelected = new ArrayList<Boolean>();
		if (list != null) {
			for (int i = 0; i < list.size(); i ++) {
				isSelected.add(Boolean.valueOf(false));
			}
			if (str != null && !"".equals(str)) {
				String[] temps = str.split(",");
				for (int j = 0; j < temps.length; j ++) {
					for (int i = 0; i < list.size(); i ++) {
						if (temps[j].equals(list.get(i))) {
							isSelected.set(i, Boolean.valueOf(true));
							break;
						}
					}
				}
			}
		}
	}


	@Override
	public int getCount() {
		if (list != null) {
			return list.size();
		}
		return 0;
	}

	@Override
	public Object getItem(int position) {
		if (list != null) {
			return list.get(position);
		}
		return null;
	}

	@Override
	public long getItemId(int position) {
		return 0;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		if (list == null || list.size() <=0) {
			return null;
		}
		HolderView holderView = null;
		if (convertView == null) {
			holderView = new HolderView(context);
			LinearLayout paLayout = new LinearLayout(context);
			AbsListView.LayoutParams params = new AbsListView.LayoutParams(LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
			paLayout.setLayoutParams(params);
			paLayout.setPadding(10, 10, 10, 10);
			paLayout.setOrientation(LinearLayout.HORIZONTAL);
			paLayout.setGravity(Gravity.CENTER_VERTICAL);
			LinearLayout.LayoutParams textView_params = new LinearLayout.LayoutParams(0, LinearLayout.LayoutParams.WRAP_CONTENT);
			textView_params.weight = 1.0f;
			paLayout.addView(holderView.textView, textView_params);
			LinearLayout.LayoutParams checkbox_params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
			paLayout.addView(holderView.checkBox, checkbox_params);
			holderView.checkBox.setClickable(false);
			holderView.checkBox.setFocusable(false);
			holderView.checkBox.setFocusableInTouchMode(false);
			paLayout.setTag(holderView);
			convertView = paLayout;
		} else {
			holderView = (HolderView)convertView.getTag();
		}
		String temp = list.get(position);
		holderView.textView.setText(temp);
		holderView.textView.setTextColor(0xFF4E4E4E);
		holderView.checkBox.setChecked(isSelected.get(position));
		return convertView;
	}
	
	public class HolderView {
		public HolderView(Context context) {
			textView = new TextView(context);
			checkBox = new CheckBox(context);
		}
		public TextView textView;
		public CheckBox checkBox;
	}
}
