package com.xdja.combox.dialog;

import java.io.IOException;
import java.io.InputStream;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

public class XDAlertDialog {

	private AlertDialog ad; // 要创建的弹出窗体类
	private String title = "提示"; // 提示标题-默认为'提示'
	private String message; // 提示内容
	private int alert_type = 0; // 提示类型 0-正确 1-错误 2-提醒 3-警告
	private Context mCxt; //弹出框依附的窗体上下文
	private Drawable d1; // 要设置的图片-正确 alert_type=0
	private Drawable d2; // 要设置的图片-错误 alert_type=1
	private Drawable d3; // 要设置的图片-提醒 alert_type=2
	private Drawable d4; // 要设置的图片-警告 alert_type=3
	public static final int ALERT_RIGHT = 0; //正确
	public static final int ALERT_ERROR = 1; //错误
	public static final int ALERT_REMIND = 2; //提醒
	public static final int ALERT_WARNING = 3; //警告
	
	private LinearLayout main_layout;
	private LinearLayout text_layout;
	private LinearLayout img_layout;
	private LinearLayout more_layout;
	private TextView tv;
	private EditText et;
	private ImageView img;
	
	private Boolean imgbtnFlag = false;
	private int	imgbtnSize = 50;
	
	private XDRotater rotater;
	private XDScaler scaler;
	
	public XDAlertDialog(Context cx) {
		// TODO Auto-generated constructor stub
		mCxt = cx;
		
		//获取设置图片所要用的图片-4种类型
//		getIcon();
		
		ad = new AlertDialog.Builder(cx).create();
		ad.setTitle(title);
		ad.setMessage(message);
		d3 = getDrawableFromAssets(mCxt,"xddialog_remind.png"); //提醒 alert_type=2
		ad.setIcon(d3); //默认图标设置为提醒
//		ad.setButton(AlertDialog.BUTTON_POSITIVE, "确定",new DialogInterface.OnClickListener() {
//			
//			@Override
//			public void onClick(DialogInterface dialog, int which) {
//				// TODO Auto-generated method stub
//				
//			}
//		});
		
	}
	
	public void setButton(CharSequence text, DialogInterface.OnClickListener listener) {
		if (ad != null) {
			ad.setButton(text, listener);
		}
	}
	
	public void setButton2(CharSequence text, DialogInterface.OnClickListener listener) {
		if (ad != null) {
			ad.setButton2(text, listener);
		}
	}
	
	public void setButton3(CharSequence text, DialogInterface.OnClickListener listener) {
		if (ad != null) {
			ad.setButton3(text, listener);
		}
	}
	
	/**
	 * 生成中间显示提示内容的布局
	 * @param ctx 上下文
	 * @return 布局View
	 */
	private View InitView(Context ctx){
		
		final Context temp = ctx;
		//定义最外层布局LinearLayout
		main_layout = new LinearLayout(ctx);
		main_layout.setOrientation(LinearLayout.VERTICAL);
		main_layout.setPadding(5, 0, 5, 0);
		
		//定义显示简要信息的布局LinearLayout
		text_layout = new LinearLayout(ctx);
		tv = new TextView(ctx);
		tv.setTextColor(0xffffffff);
		tv.setTextSize(18);
		
		//设置详细信息按钮
		img = new ImageView(ctx);
		img.setBackgroundDrawable(getDrawableFromAssets(ctx,"xddialog_down.png"));
		
		
		text_layout.addView(tv,LayoutParams.WRAP_CONTENT,LayoutParams.WRAP_CONTENT);
		
		rotater = new XDRotater();
		scaler = new XDScaler();
		
		img.setOnClickListener(new View.OnClickListener(){

			@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				/*if(!imgbtnFlag){
					more_layout.setVisibility(View.VISIBLE);		
					img.setBackgroundDrawable(getDrawableFromAssets(temp,"xddialog_up.png"));
					imgbtnFlag = true;
				}else{
					more_layout.setVisibility(View.GONE);		
					img.setBackgroundDrawable(getDrawableFromAssets(temp,"xddialog_down.png"));
					imgbtnFlag = false;
				}*/
				if(!imgbtnFlag){
					
					rotater.create(0f, 180f).setDuration(800).rotate(img);
					more_layout.setClickable(false);
					more_layout.getChildAt(0).setEnabled(false);
					more_layout.getChildAt(0).setClickable(false);
			
					scaler.create(1f, 1f, 0f, 1f).setDuration(100).scale(more_layout);
					imgbtnFlag = true;
				}else{
					
					rotater.create(180f, 0f).setDuration(800).rotate(img);
					more_layout.setClickable(false);
					more_layout.getChildAt(0).setEnabled(false);
					more_layout.getChildAt(0).setClickable(false);
					
					scaler.create(1f, 1f, 0f, 1f).setDuration(800).disscale(more_layout);
					imgbtnFlag = false;
				}
			}
			
		});
		img_layout = new LinearLayout(ctx);
		img_layout.addView(img,imgbtnSize,imgbtnSize);
		img_layout.setGravity(Gravity.RIGHT);
		//text_layout.addView(img);
		
		more_layout = new LinearLayout(ctx);
		et = new EditText(ctx);
		et.setEnabled(false);
		et.setFocusable(false);
		et.setClickable(false);
		et.setTextSize(14);
		et.setBackgroundColor(Color.WHITE);
		et.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
		more_layout.addView(et,LayoutParams.WRAP_CONTENT,LayoutParams.WRAP_CONTENT);
		more_layout.setBackgroundColor(Color.WHITE);
		more_layout.setVisibility(View.GONE);
		more_layout.setClickable(false);
		
		
		main_layout.addView(text_layout,LayoutParams.FILL_PARENT,LayoutParams.WRAP_CONTENT);
		main_layout.addView(img_layout,LayoutParams.FILL_PARENT,LayoutParams.WRAP_CONTENT);
		main_layout.addView(more_layout,LayoutParams.FILL_PARENT,LayoutParams.WRAP_CONTENT);
		
		return main_layout;
		
	}
	
	/**
	 * 构造方法-默认带一个确定按钮的弹出框,需要调用show方法显示
	 * @param cx 上下文
	 * @param title 弹出框显示标题
	 * @param msg 弹出框显示内容
	 * @param alertType 弹出框类型 0-正确 1-错误 2-提醒 3-警告
	 */
	public XDAlertDialog(Context cx, String title, String msg, int alertType){
		
		mCxt = cx;
		
		//获取设置图片所要用的图片-4种类型
//		getIcon();
		
		if(!"".equals(title)){
			this.title = title;
		}
		message = msg;
		alert_type = alertType;
		
		ad = new AlertDialog.Builder(cx).create();
		ad.setTitle(title);
		ad.setMessage(message);
		
		setAlertType(alert_type);
		ad.setButton(AlertDialog.BUTTON_POSITIVE, "确定",new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				// TODO Auto-generated method stub
				
			}
		});
	}
	
	/**
	 * 构造方法-带简要信息和详细信息伸缩显示的弹出框
	 * @param cx 上下文
	 * @param title 弹出框标题
	 * @param alertType 弹出框类型
	 * @param brief 简要信息内容
	 * @param detail 详细信息内容
	 * @param isDisplayDetail 标识是否显示伸缩按钮标志,默认为true-- true:显示   false:隐藏
	 */
	public XDAlertDialog(Context cx, String title, int alertType, String brief, String detail, boolean isDisplayDetail){
		
		mCxt = cx;
		
		//获取设置图片所要用的图片-4种类型,后修改为初始化时不自动全部加载
//		getIcon();
		
		if(!"".equals(title)){
			this.title = title;
		}
		alert_type = alertType;
		
		ad = new AlertDialog.Builder(cx).create();
		ad.setTitle(title);
		
		setAlertType(alert_type);
		ad.setButton(AlertDialog.BUTTON_POSITIVE, "确定",new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				// TODO Auto-generated method stub
				
			}
		});
		
		//给弹出框应用自定义的布局
		ad.setView(InitView(cx));
		
		//设置简要信息显示
		setBriefText(brief);
		
		//设置详细信息显示
		setDetaillText(detail);
		
		//设置更多按钮显示状态
		setImageButtonDisplay(isDisplayDetail);
	}
	
	/**
	 * 构造方法-按所给弹出框类型直接打开显示一个弹出框
	 * @param cx 上下文
	 * @param title 标题
	 * @param message 显示内容
	 * @param type 弹出框类型 0-正确 1-错误 2-提醒 3-警告
	 */
	public static void openDialog(Context cx, String title, String message, int type){
		//获取设置图片所要用的图片-4种类型
		AlertDialog ad = new AlertDialog.Builder(cx).create();
		ad.setTitle(title);
		ad.setMessage(message);
		switch(type){
		case ALERT_RIGHT:
			Drawable d1 = getDrawableFromAssets(cx,"xddialog_right.png"); //正确 alert_type=0
			ad.setIcon(d1); //正确
			break;
		case ALERT_ERROR:
			Drawable d2 = getDrawableFromAssets(cx,"xddialog_error.png"); //错误 alert_type=1
			ad.setIcon(d2); //错误
			break;
		case ALERT_REMIND:
			Drawable d3 = getDrawableFromAssets(cx,"xddialog_remind.png"); //提醒 alert_type=2
			ad.setIcon(d3); //提醒
			break;
		case ALERT_WARNING:
			Drawable d4 = getDrawableFromAssets(cx,"xddialog_warning.png"); //警告alert_type=3
			ad.setIcon(d4); //警告
			break;
		default:
			Drawable d5 = getDrawableFromAssets(cx,"xddialog_remind.png"); //提醒 alert_type=2
			ad.setIcon(d5); //默认为提醒
			break;
		}
		ad.setButton(AlertDialog.BUTTON_POSITIVE, "确定",new DialogInterface.OnClickListener() {
			
			@Override
			public void onClick(DialogInterface dialog, int which) {
				// TODO Auto-generated method stub
				
			}
		});
		ad.show();
	}
	
	/**
	 * 设置确定按钮文字和监听
	 * @param buttonType 按钮的类型 (三种  -1:确定按钮,-2:否定按钮, -3:普通自定义按钮)
	 * @param msg 按钮上需显示的文本(为空字符串即是隐藏按钮)
	 * @param listener 点击事件(无任何相应事件可设置为null)
	 */
	public void setButton(int buttonType, String msg, DialogInterface.OnClickListener listener){
		
		//当按钮类型不属于这三种时,默认为确定按钮
		if(buttonType!=-1 && buttonType != -2 && buttonType != -3){
			buttonType = -1;
		}
		
		//确定:AlertDialog.BUTTON_POSITIVE_;取消:AlertDialog.BUTTON_NEGATIVE;普通:AlertDialog.BUTTON_NEUTRAL
		ad.setButton(buttonType, msg, listener);

	}
	
	/**
	 * 设置提示框左上角图片
	 * @param d 需要设置成的图片
	 */
	public void setIcon(Drawable d){
		ad.setIcon(d);
	}
	
	/**
	 * 设置弹出框标题
	 * @param t 标题文字
	 */
	public void setTitle(String t){
		ad.setTitle(t);
	}
	
	/**
	 * 设置文本内容
	 * @param msg 文本内容
	 */
	public void setMessage(String msg){
		ad.setMessage(msg);
	}
	
	/**
	 * 设置提示的错误类型,具体表现为图片
	 * @param type 错误类型代码  0-正确 1-错误 2-提醒 3-警告
	 */
	public void setAlertType(int type){

		switch(type){
		case ALERT_RIGHT:
			d1 = getDrawableFromAssets(mCxt,"xddialog_right.png"); //正确 alert_type=0
			ad.setIcon(d1); //正确
			break;
		case ALERT_ERROR:
			d2 = getDrawableFromAssets(mCxt,"xddialog_error.png"); //错误 alert_type=1
			ad.setIcon(d2); //错误
			break;
		case ALERT_REMIND:
			d3 = getDrawableFromAssets(mCxt,"xddialog_remind.png"); //提醒 alert_type=2
			ad.setIcon(d3); //提醒
			break;
		case ALERT_WARNING:
			d4 = getDrawableFromAssets(mCxt,"xddialog_warning.png"); //警告alert_type=3
			ad.setIcon(d4); //警告
			break;
		default:
			d3 = getDrawableFromAssets(mCxt,"xddialog_remind.png"); //提醒 alert_type=2
			ad.setIcon(d3); //默认为提醒
			break;
		}
	}
	
	/**
	 * 显示弹出框
	 */
	public void show(){
		ad.show();
	}
	
	/**
	 * 获取显示弹出提示框所用到的4种类型的图片
	 */
	/*public void getIcon(){
		d1 = getDrawableFromAssets(mCxt,"xddialog_right.png"); //正确 alert_type=0
		d2 = getDrawableFromAssets(mCxt,"xddialog_error.png"); //错误 alert_type=1
		d3 = getDrawableFromAssets(mCxt,"xddialog_remind.png"); //提醒 alert_type=2
		d4 = getDrawableFromAssets(mCxt,"xddialog_warning.png"); //警告alert_type=3
	}*/
	
	/**
 	 * 从Assets文件内获取9.png图片
 	 * @param context    调用窗体上下文
 	 * @param FileName   文件名称
 	 * @return  Drawable图片
 	 */
	public static NinePatchDrawable get9ImageFromAssetsFile(Context context,String FileName)
	{
		 InputStream stream;
			try {
			stream = context.getAssets().open(FileName);
		    Bitmap bitmap = BitmapFactory.decodeStream(stream);  
		    byte[] chunk = bitmap.getNinePatchChunk();  
		    boolean result = NinePatch.isNinePatchChunk(chunk);
		    NinePatchDrawable patchy = null;
		    if(result)
		    {
		      patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
		    }
		    return patchy;
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return null;
			}
	}
	
	/**
	 * 根据所给定的图片文件名获取到手机asserts目录下的图片
	 * @param cont 上下文
	 * @param fileName 文件名
	 * @return
	 */
	public static Bitmap getImageFromAssetsFile(Context cont,String fileName)
    {
        Bitmap image = null;
        AssetManager am = cont.getResources().getAssets();
        try
        {
            InputStream is = am.open(fileName);
            image = BitmapFactory.decodeStream(is);
            is.close();
        }
        catch (IOException e)
        {
            e.printStackTrace();
            return null;
        }

        return image;

    }
	
	/**
	 * 设置简要内容文字信息
	 * @param brief
	 */
	public void setBriefText(String brief){
		tv.setText(brief);
	}
	
	/**
	 * 设置详细内容文字信息
	 * @param detail
	 */
	public void setDetaillText(String detail){
		et.setText(detail);
	}
	
	/**
	 * 设置简要内容文字大小
	 * @param size
	 */
	public void setBriefTextSize(int size){
		tv.setTextSize(size);
	}
	
	/**
	 * 设置详细内容文字大小
	 * @param size
	 */
	public void setDetaillTextSize(int size){
		et.setTextSize(size);
	}
	
	/**
	 * 设置更多按钮是否显示
	 * @param display
	 */
	public void setImageButtonDisplay(Boolean display){
		if(display){
			img.setVisibility(View.VISIBLE);
		}else{
			img.setVisibility(View.GONE);
		}
	}
	
	public void setImageButtonSize(int size){
		
		img.setLayoutParams(new LinearLayout.LayoutParams(size, size));
	}

	
	/**
	 * 根据上下文和文件名获取到图片(Drawable)
	 * @param cx 上下文
	 * @param imgName 图片名称
	 * @return Drawable类型的图片
	 */
	public static Drawable getDrawableFromAssets(Context cx, String imgName){
		InputStream is = null;
		try {
			is = cx.getResources().getAssets().open(imgName);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Bitmap bitmap = BitmapFactory.decodeStream(is);
		BitmapDrawable bd = new BitmapDrawable(bitmap);
		return bd;
	}
}
