package com.xdja.combox.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnCancelListener;
import android.view.Gravity;
import android.view.WindowManager;
import android.view.ViewGroup.LayoutParams;
import android.view.Window;
import android.widget.Chronometer;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

public class XDProgressDialog {
	
	private AlertDialog dialog;				//弹出框
	private Chronometer mTimeView;			//记录加载的时间
	private ProgressBar mProgress;			//滚动bar	
	private TextView mMessageView;			//显示message
	private boolean mIndeterminate;			
	private CharSequence mMessage;			//弹出框内容	
	private CharSequence mTitle;			//显示标题
	private String mFormat;					//显示格式
	private OnCancelListener onCancelListener;
	
	/**
	 * 创建对话框
	 * @param context
	 */
	public void createDialog(Context context) {
		dialog = new AlertDialog.Builder(context).create();
//		dialog.getWindow().setType(
//				WindowManager.LayoutParams.FLAG_DIM_BEHIND);
		dialog.setCanceledOnTouchOutside(false);
//		WindowManager.LayoutParams lp = dialog.getWindow().getAttributes();
//		lp.flags = WindowManager.LayoutParams.FLAG_NOT_TOUCH_MODAL | WindowManager.LayoutParams.FLAG_NOT_FOCUSABLE;//是悬浮窗体失去焦点
//		dialog.getWindow().setAttributes(lp);
		LinearLayout linearLayout = new LinearLayout(context);
		linearLayout.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, 
				LayoutParams.FILL_PARENT));
		linearLayout.setPadding(30, 20, 30, 30);
		linearLayout.setOrientation(LinearLayout.HORIZONTAL);
		linearLayout.setGravity(Gravity.CENTER_VERTICAL);
		mTimeView = new Chronometer(context);
		mTimeView.setTextColor(0xffffffff);
		LinearLayout.LayoutParams paramsTimeview = new LinearLayout.LayoutParams(LayoutParams.WRAP_CONTENT, 
				LayoutParams.WRAP_CONTENT);
		paramsTimeview.bottomMargin = 5;
		mTimeView.setLayoutParams(paramsTimeview);
		LinearLayout linearLayout2 = new LinearLayout(context);
		linearLayout2.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT, 
				LayoutParams.WRAP_CONTENT));
		linearLayout2.setOrientation(LinearLayout.VERTICAL);
		mProgress = new ProgressBar(context);
		LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LayoutParams.WRAP_CONTENT, 
				LayoutParams.WRAP_CONTENT);
		params.rightMargin = 20;
		mProgress.setLayoutParams(params);
		mMessageView = new TextView(context);
		mMessageView.setTextColor(0xffffffff);
		LinearLayout.LayoutParams paramsMessage = new LinearLayout.LayoutParams(LayoutParams.WRAP_CONTENT, 
				LayoutParams.WRAP_CONTENT);
		paramsMessage.topMargin = 5;
		mMessageView.setLayoutParams(paramsMessage);
		linearLayout2.addView(mTimeView);
		linearLayout2.addView(mMessageView);
		linearLayout.addView(mProgress);
		linearLayout.addView(linearLayout2);
		dialog.setView(linearLayout);
		dialog.setIcon(android.R.drawable.ic_dialog_info);
		if (onCancelListener != null) {
			setOnCancelListener(onCancelListener);
		}
		if (mMessage != null) {
			setMessage(mMessage);
		}
		if (mTitle != null) {
			setTitle(mTitle);
		}
		if (mFormat != null) {
			setFormat(mFormat);
		}
		setIndeterminate(mIndeterminate);
	}
	
	public void setOnCancelListener(OnCancelListener onCancelListener) {
		if (onCancelListener != null) {
			dialog.setOnCancelListener(onCancelListener);
		} else {
			this.onCancelListener = onCancelListener;
		}
	}
	
	/**
	 * 显示dialog对话框
	 */
	public void show() {
		mTimeView.start();
		dialog.show();
	}
	/**
	 * 隐藏dialog对话框
	 */
	public void dismiss() {
		mTimeView.stop();
		dialog.dismiss();
	}
	
	public void setIndeterminate(boolean indeterminate) {
        if (mProgress != null) {
            mProgress.setIndeterminate(indeterminate);
        } else {
            mIndeterminate = indeterminate;
        }
    }
	
	/**
	 * 设置显示弹出框内容
	 * @param message
	 */
	public void setMessage(CharSequence message) {
        if (mProgress != null) {
        	mMessageView.setText(message);
        } else {
            mMessage = message;
        }
    }
	
	/**
	 * 弹出框标题；
	 * @param title
	 */
	public void setTitle(CharSequence title) {
		if (dialog != null) {
			dialog.setTitle(title);
		} else {
			mTitle = title;
		}
	}
	
	/**
	 * 设置时间
	 * @param format （文本  + %s）
	 */
	public void setFormat(String format) {
		if (mTimeView != null) {
			mTimeView.setFormat(format);
		} else {
			mFormat = format;
		}
	}
}
