package com.xdja.combox.dialog;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;

/**
 * 旋转效果
 * @author LHC
 *
 */
public class XDRotater{
	
	private static long TIME = 1000;  // 旋转持续时间
	
	Animation Animation_Rotate;       // 旋转动画
	
	/**
	 * 生成旋转动画
	 * @param start 旋转对于自身的开始角度
	 * @param end 旋转对于自身的结束角度
	 * @return 
	 */
	public XDRotater create(float start, float end){
		Animation_Rotate=new RotateAnimation(start, end,
				Animation.RELATIVE_TO_SELF,0.5f,Animation.RELATIVE_TO_SELF, 0.5f);
		Animation_Rotate.setDuration(TIME);
		Animation_Rotate.setFillAfter(true);
		
		return this;
	}
	
	/**
	 * 设置动画持续时间
	 * @param time
	 * @return
	 */
	public XDRotater setDuration(long time){
		TIME = time;
		
		if(null != Animation_Rotate)
			Animation_Rotate.setDuration(TIME);
		
		return this;
	}
	
	/**
	 * 旋转指定控件
	 * @param view
	 */
	public void rotate(View view){
		view.startAnimation(Animation_Rotate);
	}

}