package com.xdja.combox.dialog;


import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.ScaleAnimation;
import android.view.animation.Animation.AnimationListener;

/**
 * 伸缩效果
 * @author LHC
 *
 */
public class XDScaler{
	
	private static long TIME = 1000; // 动画持续时间(毫秒)
	
	Animation Animation_Scale;		// 拉伸效果
	Animation Animation_disScale;   // 收缩效果
	View vi;                        // 待伸缩控件的临时拷贝
	
	AnimationSet _animationSet;     // 动画设置
	
	/**
	 * 生成动画
	 * @param fromX X轴开始伸缩比例 0-1
	 * @param toX X轴结束伸缩比例 0-1
	 * @param fromY Y轴开始伸缩比例 0-1
	 * @param toY Y轴结束伸缩比例 0-1
	 * @return
	 */
	public XDScaler create(float fromX, float toX, float fromY, float toY){
		Animation_Scale =new ScaleAnimation(fromX, toX, fromY, toY,
				Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
		Animation_Scale.setDuration(TIME);
		Animation_Scale.setFillAfter(true);
		
		Animation_disScale =new ScaleAnimation(toX, fromX, toX, fromY,
				Animation.RELATIVE_TO_SELF, 0.5f, Animation.RELATIVE_TO_SELF, 0.5f);
		Animation_disScale.setDuration(TIME);
		Animation_disScale.setFillAfter(true);
		
		
		_animationSet = new AnimationSet(true);
		_animationSet.addAnimation(Animation_disScale);
		_animationSet.setFillAfter(true);

		_animationSet.setDuration(TIME);

		return this;

	}
	
	/**
	 * 设置动画持续时间（毫秒）
	 * @param time
	 * @return
	 */
	public XDScaler setDuration(int time){
		TIME = time;
		
		if(null != Animation_Scale)
			Animation_Scale.setDuration(TIME);
		
		return this;
	}
	
	/**
	 * 伸缩控件
	 * @param view
	 */
	public void scale(View view){
		vi = view;
		view.setVisibility(View.VISIBLE);
		view.startAnimation(Animation_Scale);
	}
	
	/**
	 * 按照伸缩效果进行反伸缩
	 * @param view
	 */
	public void disscale(final View view){
		vi = view;
		_animationSet.setAnimationListener(new AnimationListener(){
			@Override
			public void onAnimationEnd(Animation animation) {
				// TODO Auto-generated method stub	
				view.setVisibility(View.GONE);
			}
			@Override
			public void onAnimationRepeat(Animation animation) {
				// TODO Auto-generated method stub					
			}
			@Override
			public void onAnimationStart(Animation animation) {
				// TODO Auto-generated method stub				
			}
		});
		
		view.startAnimation(_animationSet);
	}
	
	
}