package com.xdja.combox.dialog;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Animation.AnimationListener;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.TextView;

/**
 * 滑动效果
 * @author LHC
 *
 */
public class XDTranslateBar{

	private float START_X = -100f;    // 移动开始X坐标
	private float END_X = 80f;      // 移动结束X坐标
	private float START_Y = 150f;    // 移动开始Y坐标
	private float END_Y = 150f;      // 移动结束Y坐标
	
	private int CURRENT_Y_POSITION = -100;  // 提示条实际位置离屏幕底部的距离
	private int _X = 20;           //偏移量
	private int TIME = 2000; // 提示条显示时间（毫秒）
	private int SPEED = 1000; // 提示条滑动效果持续时间
	private int DEFAULT_COLOR = Color.WHITE;
	
	private TextView NoticeBar;    // 提示条
	
	private Animation _animation_start;  // 开始动画
	private Animation _animation_end;    // 结束动画
	 
	private AnimationSet _animationSet;  

	private Context ctx;


	public XDTranslateBar(Context context){
		Init(context);
		ctx = context;
	}
	
	private void Init(Context context){
		NoticeBar = new TextView(context);	
		NoticeBar.setVisibility(View.GONE);
		NoticeBar.setBackgroundColor(DEFAULT_COLOR);
	}
	
	/**
	 * 设置移动参数
	 * @param fromXDelta 初始X轴位置
	 * @param toXDelta 移动后X轴位置
	 * @param fromYDelta 初始Y轴位置
	 * @param toYDelta 移动后Y轴位置
	 */
	public XDTranslateBar setMove(float fromXDelta, float toXDelta, float fromYDelta, float toYDelta){
		START_X = fromXDelta - _X;
		END_X = toXDelta;
		START_Y = fromYDelta;
		END_Y = toYDelta;
		return this;
	}
	
	/**
	 * 设置提示条文字信息
	 * @param notice
	 */
	public XDTranslateBar setNoticeText(String notice) {
		// TODO Auto-generated method stub
		NoticeBar.setText(notice);
		return this;
	}

	/**
	 * 设置提示条背景颜色
	 * @param color
	 */
	public XDTranslateBar setBarColor(int color) {
		// TODO Auto-generated method stub
		NoticeBar.setBackgroundColor(color);
		return this;
	}

	/**
	 * 设置提示条背景图片
	 * @param background
	 */
	public XDTranslateBar setBarDrawable(Drawable background) {
		// TODO Auto-generated method stub
		NoticeBar.setBackgroundDrawable(background);
		return this;
	}

	/**
	 * 设置提示条文字大小
	 * @param size
	 */
	public XDTranslateBar setTextSize(int size) {
		// TODO Auto-generated method stub
		NoticeBar.setTextSize(size);
		return this;
	}

	/**
	 * 播放提示条动画
	 */
	public void show() {
		// TODO Auto-generated method stub
		
		LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        params.setMargins(0, 0, 0,CURRENT_Y_POSITION);
		((Activity)ctx).addContentView(NoticeBar,params);
		NoticeBar.setVisibility(View.VISIBLE);
		NoticeBar.startAnimation(_animationSet);
	}

	/**
	 * 生成移动动画效果
	 * @param text 提示条文字信息
	 * @return
	 */
	public XDTranslateBar create(String text) {
		// TODO Auto-generated method stub
		
		NoticeBar.setText(text);
		
		START_X -= _X;  // 修改返回时的偏移量
		
		// 开始动画
		_animation_start = new TranslateAnimation(START_X, END_X, START_Y, END_Y);
		
		_animationSet = new AnimationSet(true);
		_animationSet.addAnimation(_animation_start);
		_animationSet.setFillAfter(true);
		_animationSet.setDuration(SPEED);
		_animationSet.setAnimationListener(new AnimationListener(){
			@Override
			public void onAnimationEnd(Animation animation) {
				// TODO Auto-generated method stub	
				try {
					Thread.sleep(TIME);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				NoticeBar.startAnimation(_animation_end);	

			}
			@Override
			public void onAnimationRepeat(Animation animation) {
				// TODO Auto-generated method stub					
			}
			@Override
			public void onAnimationStart(Animation animation) {
				// TODO Auto-generated method stub				
			}
		});
		
		// 结束动画
		_animation_end = new TranslateAnimation(END_X,START_X,END_Y,START_Y);
		_animation_end.setDuration(SPEED);
		_animation_end.setFillAfter(true);

		return this;
	}

	/**
	 * 返回提示条对象
	 * @return
	 */
	public View getView() {
		// TODO Auto-generated method stub
		return NoticeBar;
	}
	
	/**
	 * 设置提示条停留持续时间
	 * @param time 停留时间（毫秒）
	 */
	public XDTranslateBar setShowTime(int time){
		this.TIME = time;
		return this;
	}

	/**
	 * 设置提示条滑动速度
	 * @param speed 滑动持续的时间（毫秒）
	 */
	public XDTranslateBar setSpeed(int speed) {
		// TODO Auto-generated method stub
		this.SPEED = speed;
		return this;
	}

}