package com.xdja.combox.inputbutton;

import java.io.InputStream;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.EditText;

public class XDEditText extends EditText {
	private int displayType = 1; 										// 控件显示风格（0为方角；1为圆角）
	private Drawable[] drawables_round=null; 							// 圆形图片组；
	private Drawable[] drawables_square=null; 							// 方形图片组；
	private Context mContext = null;
	/**
	 * 获取控件显示风格（0：方角类型；1：圆角类型）
	 * 
	 * @return 显示风格代码
	 */
	public int getDisplayType() {
		return displayType;
	}

	/**
	 * 设置控件显示风格（0：方角类型；1：圆角类型）
	 * 
	 * @param displayType
	 *            显示风格代码
	 */
	public void setDisplayType(int displayType) {
		this.displayType = displayType;
		setBackgroundByType();
	}
	
	public XDEditText(Context context) {
		this(context, null);
	}
	public XDEditText(Context context, AttributeSet attrs) {
		super(context, attrs);
		mContext = context;
		this.setSingleLine(true);
		initialControl(context,attrs);
	}
	
	/**
	 * 为控件做初始化操作
	 * @param context 窗体句柄
	 * @param attrs	属性集合
	 */
	private void initialControl(Context context, AttributeSet attrs){
		String displayTypeStr = null;
		// 根据布局文件中设置的属性初始化控件
		if (attrs != null) {
			int attrsCount = attrs.getAttributeCount();
			for (int i = 0; i < attrsCount; i++) {
				if (attrs.getAttributeName(i).equals("displaytype")) { // 显示风格
					displayTypeStr = attrs.getAttributeValue(i);
				}
			}
		}
		if (displayTypeStr != null) {
			if (displayTypeStr.equals("0")) {
				this.displayType = 0;
			} else if (displayTypeStr.equals("1")) {
				this.displayType = 1;
			} else {
				Log.e("erro","显示类型代码不合法");
			}
			setBackgroundByType();
		}
	}
	/**
	 * 根据控件风格类型设置空间背景
	 */
	private void setBackgroundByType() {
		switch (displayType) {
		case 0:
			initialBackgroundByType(0);
			this.setBackgroundDrawable(setBackgroundWithStateListDrawable(drawables_square));
			break;
		case 1:
			initialBackgroundByType(1);
			this.setBackgroundDrawable(setBackgroundWithStateListDrawable(drawables_round));
			break;
		default:
			break;
		}
	}
	/**
	 * 根据类型代码，初始化相应的背景
	 * @param type 类型代码
	 */
	private void initialBackgroundByType(int type){
		if(type == 1){
			if(drawables_round == null){
				// 初始化圆角类型图片
				drawables_round = new Drawable[2];
				drawables_round[0] = getImageFromAssetsFile(mContext,
						"assets/xdedittextbutton_input_normal.9.png");
				drawables_round[1] = getImageFromAssetsFile(mContext,
						"assets/xdedittextbutton_input_fouce.9.png");
			}
		}
		else{
			if(drawables_square==null){
				// 初始化方角类型图片
				drawables_square = new Drawable[2];
				drawables_square[0] = getImageFromAssetsFile(mContext,
						"assets/xdedittextbutton_input2_normal.9.png");
				drawables_square[1] = getImageFromAssetsFile(mContext,
						"assets/xdedittextbutton_input2_fouce.9.png");
			}
		}
	}
	/**
	 * 构建控件的状态组背景
	 * 
	 * @param drawables
	 *            用到的drawable数组
	 * @return 状态组背景
	 */
	private StateListDrawable setBackgroundWithStateListDrawable(
			Drawable[] drawables) {
		StateListDrawable bg = new StateListDrawable();
		bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[1]);
		bg.addState(View.ENABLED_STATE_SET, drawables[0]);
		bg.addState(View.FOCUSED_STATE_SET, drawables[1]);
		bg.addState(View.EMPTY_STATE_SET, drawables[0]);
		return bg;
	}
	/**
	 * 获取assets文件夹中得图片
	 * 
	 * @param context
	 *            窗体句柄
	 * @param fileName
	 *            文件路径名
	 * @return 获取到得drawable
	 */
	private Drawable getImageFromAssetsFile(Context context,
			String fileName) {
		InputStream stream;
		Drawable drawable = null;
		try {
			stream = context.getClass().getClassLoader()
					.getResourceAsStream(fileName);
			drawable = Drawable.createFromStream(stream, "");
		} catch (Exception e) {

		}
		return drawable;
	}
}
