package com.xdja.combox.inputbutton;

import java.io.InputStream;
import java.util.HashMap;

import com.xdja.combox.utils.DensityUtil;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView.ScaleType;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;

public class XDEditTextButton extends RelativeLayout {
	private Context mContext = null;
	// 控件ID
//	private int edittextview = 0x00000003;
//	private int button = 0x00000004;
	private int layoutWidth = -1;
	private int layoutHeight = -2;
	private int textviewWidth = -2;		
	// 子控件布局方式代码（0：外漏；1：内嵌）
	private int layoutType = 1;
	// 复合控件整体风格代码（0为方角；1为圆角）
	private int displayType = 1;
	// 属性字典集合
	private HashMap<String, Integer> attrsMap = null;
	// 复合控件中的带文本显示的输入框
	private XDEditTextView mEditTextView = null;
	// 复合控件中的文本提示框
	private ImageButton mButton = null;
	LinearLayout ll = null;
	//按钮图片
	private Drawable[] draws = null;

	public XDEditTextButton(Context context, AttributeSet attrs) {
		super(context, attrs);
		mContext = context;
		// 初始化内部两个子控件
		mEditTextView = new XDEditTextView(context,1);
//		mEditTextView.setId(edittextview);
		mButton = new ImageButton(context);
		mButton.setPadding(2, 2, 2, 2);
		mButton.setAdjustViewBounds(false);
		mButton.setScaleType(ScaleType.FIT_CENTER);
//		mButton.setId(button);
		initialAttrMap(context);
		analysisAttrs(attrsMap, attrs);
		intialControl(context);
	}
	/**
	 * 初始化属性字典
	 * 
	 * @param context
	 */
	private void initialAttrMap(Context context) {
		// 初始化属性字典
		attrsMap = new HashMap<String, Integer>();
		attrsMap.put("displaytype", 0); // 显示风格
		attrsMap.put("edittext_background", 1); // 文本输入框背景
		attrsMap.put("textview_background", 2); // 文本显示框背景
		attrsMap.put("textview_textcolor", 3); // 文本显示框字体颜色
		attrsMap.put("edittext_textcolor", 4); // 文本输入框字体颜色
		attrsMap.put("edittext_textsize", 5); // 文本输入框字体大小
		attrsMap.put("textview_textsize", 6); // 文本显示框字体大小
		attrsMap.put("textview_text", 7); // 文本显示框文本
		attrsMap.put("edittext_text", 8); // 文本输入框文本
		attrsMap.put("textview_visiable", 9); // 文本显示框是否可见
		attrsMap.put("layouttype", 10); // 布局方式（0：外露，1：内嵌）
		attrsMap.put("edittext_enable", 12); // 文本输入框是否可用
		attrsMap.put("edittext_digits", 13); // 文本输入框输入内容过滤器
		attrsMap.put("edittext_maxlength", 14); // 文本输入框最大输入长度
		attrsMap.put("innerlayouttype", 15); // 内部控件EditTextView的布局方式
		attrsMap.put("image", 16); // 按钮上的图片
		attrsMap.put("button_background", 17); // 按钮的背景
		attrsMap.put("textview_width", 18); // 文本显示框的宽度
		attrsMap.put("layout_widht", 19);					// 控件宽度
		attrsMap.put("layout_height", 20); 					// 空间高度
	}

	/**
	 * 解析xml布局传递的属性参数
	 * 
	 * @param attrsMap
	 *            属性字典
	 * @param attrs 属性集合
	 */
	private void analysisAttrs(HashMap<String, Integer> attrsMap,
			AttributeSet attrs) {
		int attrId = -1;
		if (attrs != null) {
			int attrsCount = attrs.getAttributeCount();
			for (int i = 0; i < attrsCount; i++) {
				if (attrsMap.containsKey(attrs.getAttributeName(i))) {
					attrId = attrsMap.get(attrs.getAttributeName(i));
					switch (attrId) {
					case 0:
						setBackgroundByType(attrs.getAttributeValue(i));
						break;
					case 1:
						setEditText_background(attrs.getAttributeResourceValue(
								i, -1));
						break;
					case 2:
						setTextView_background(attrs.getAttributeResourceValue(
								i, -1));
						break;
					case 3:
						setTextView_textColor(attrs.getAttributeResourceValue(
								i, -1));
						break;
					case 4:
						setEditText_textColor(attrs.getAttributeResourceValue(
								i, -1));
						break;
					case 5:
						setEditText_textSize(formatFloatVlaue(attrs
								.getAttributeValue(i)));
						break;
					case 6:
						setTextView_textSize(formatFloatVlaue(attrs
								.getAttributeValue(i)));
						break;
					case 7:
						setTextView_text(attrs.getAttributeValue(i));
						break;
					case 8:
						setEditText_text(attrs.getAttributeValue(i));
						break;
					case 9:
						setTextView_visiable(attrs.getAttributeBooleanValue(i,
								true));
						break;
					case 10:
						this.layoutType = attrs.getAttributeIntValue(i, 1);
						break;
					case 12:
						setEditText_enable(attrs.getAttributeBooleanValue(i,
								true));
						break;
					case 13:
						setEditText_digits(attrs.getAttributeValue(i));
						break;
					case 14:
						setEditTextMaxLength(attrs.getAttributeIntValue(i, 100));
						break;
					case 15:
						this.mEditTextView.setLayoutType(attrs
								.getAttributeIntValue(i, -1));
						break;
					case 16:
						setImageButton_image(attrs.getAttributeResourceValue(i,
								-1));
						break;
					case 17:
						setButton_background(attrs.getAttributeResourceValue(i,
								-1));
						break;
					case 18:
						this.textviewWidth = formatIntVlaue(attrs
								.getAttributeValue(i));		
						this.mEditTextView
								.setTextView_width(textviewWidth);
						break;
					case 19:
						this.layoutWidth = formatIntVlaue(attrs
								.getAttributeValue(i));
						break;
					case 20:
						this.layoutHeight = formatIntVlaue(attrs
								.getAttributeValue(i));
						break;
					default:
						break;
					}
				}
			}
		}
	}
	/**
	 * 设置控件的宽和高
	 * @param width 宽度
	 * @param height 高度
	 */
	public void setControlSize(int width,int height){
		this.layoutHeight = height;
		this.layoutWidth = width;
		intialControl(this.mContext);
	}
	
	/**
	 * 初始化控件
	 * 
	 * @param context
	 *            窗体句柄
	 */
	private void intialControl(Context context) {
		this.setLayoutParams(new LayoutParams(layoutWidth,layoutHeight));
		this.removeAllViews();
		this.setPadding(0, 0, 0, 0);
		setGravity(Gravity.CENTER_VERTICAL);
		if (this.layoutType == 0) {
			if(ll != null && ll.getChildCount()>0){
				ll.removeAllViews();
			}
			ll= new LinearLayout(context);
			ll.setOrientation(LinearLayout.HORIZONTAL);
			ll.setLayoutParams(new RelativeLayout.LayoutParams(
					LayoutParams.FILL_PARENT, layoutHeight));
			LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(
					LayoutParams.FILL_PARENT, layoutHeight);
			lp.weight = 1;
			mEditTextView.setControlSize(LayoutParams.FILL_PARENT, layoutHeight);
			ll.addView(mEditTextView, lp);
			LinearLayout.LayoutParams lp1 = new LinearLayout.LayoutParams(
					layoutHeight, layoutHeight);
			ll.addView(mButton, lp1);
			this.addView(ll);
		} else if (this.layoutType == 1) {
			mEditTextView.setControlSize(LayoutParams.FILL_PARENT, layoutHeight);
			RelativeLayout.LayoutParams edittextViewLayoutParams=new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT,layoutHeight);
			this.addView(mEditTextView,edittextViewLayoutParams);
			RelativeLayout.LayoutParams buttonLayoutParams=new RelativeLayout.LayoutParams(layoutHeight,layoutHeight);
			buttonLayoutParams.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
			this.addView(mButton,buttonLayoutParams);
		}
	}

	/**
	 * 格式化xml布局文件中传入的字体大小设置的值
	 * 
	 * @param val
	 *            传入的字符串
	 * @return 格式化得到的float类型值
	 */
	private float formatFloatVlaue(String val) {
		boolean isFormat = true;
		float value = (float) 14.0;
		if (val.endsWith("sp")) {
			val = val.substring(0, val.length() - 2);
		}
		try {
			value = Float.parseFloat(val);
		} catch (NumberFormatException e) {
			isFormat = false;
		}
		if (!isFormat) {
			try {
				value = (float) Integer.parseInt(val);
			} catch (NumberFormatException ex) {
				Log.e("NumberFormatException", val + "不能被转化为float类型");
			}
		}
		return value;
	}

	/**
	 * 格式化xml布局文件中传入的宽度大小值为整数
	 * 
	 * @param val
	 *            传入的字符串
	 * @return 得到的整数结果
	 */
	private int formatIntVlaue(String val) {
		int value = -1;
		if (val.equals("wrap_content")) {
			value = -2;
		} else if (val.equals("fill_parent")) {
			value = -1;
		} else if (val.endsWith("dp")||val.endsWith("dip")) {
			if(val.endsWith("dp")){
				val = val.substring(0, val.length() - 2);
			}else if(val.endsWith("dip")){
				val = val.substring(0, val.length() - 5);
			}
			try {
				value = Integer.parseInt(val);
				value = DensityUtil.dp2px(mContext, (float) value);
				Log.v("pxValue", value + "");
			} catch (NumberFormatException ex) {
				Log.e("NumberFormatException", val + "无法转换为整数");
			}
		} else {
			if (val.endsWith("px")) {
				val = val.substring(0, val.length() - 2);
			}
			try {
				value = Integer.parseInt(val);
				Log.v("pxValue", value + "");
			} catch (NumberFormatException ex) {
				Log.e("NumberFormatException", val + "无法转换为整数");
				Log.v("pxValue", value + "");
			}
		}
		return value;
	}

	/**
	 * 根据风格类型设置控件背景
	 * 
	 * @param typeStr
	 */
	private void setBackgroundByType(String typeStr) {
		if (typeStr != null) {
			if (typeStr.equals("0")) {
				this.displayType = 0;
			} else if (typeStr.equals("1")) {
				this.displayType = 1;
			}
		}
		setDisplayType(this.displayType);
	}
	/**
	 * 获取assets文件夹中得图片
	 * 
	 * @param context
	 *            窗体句柄
	 * @param fileName
	 *            文件路径名
	 * @return 获取到得drawable
	 */
	private static Drawable getImageFromAssetsFile(Context context,
			String fileName) {
		InputStream stream;
		Drawable drawable = null;
		try {
			stream = context.getClass().getClassLoader()
					.getResourceAsStream(fileName);
			drawable = Drawable.createFromStream(stream, "");
		} catch (Exception e) {

		}
		return drawable;
	}
	@Override
	protected void onLayout(boolean changed, int l, int t, int r, int bottom) {
		super.onLayout(changed, l, t, r, bottom);
		if(layoutType == 1){
			mEditTextView.setEditText_PaddingRight(layoutHeight);
		}
	}
	/**
	 * 设置内部子控件EditTextView的布局方式
	 * 
	 * @param type
	 */
	public void setInnerLayoutType(int type) {
		this.mEditTextView.setLayoutType(type);
	}

	/**
	 * 设置最大输入长度
	 * 
	 * @param maxLength
	 */
	public void setEditTextMaxLength(int maxLength) {
		this.mEditTextView.setEditText_maxLength(maxLength);
	}

	public XDEditTextButton(Context context,int displayType) {
		this(context, null);
		this.setDisplayType(displayType);
	}

	/**
	 * 设置按钮的背景
	 * 
	 * @param resid
	 */
	public void setButton_background(int resid) {
		if (resid > 0) {
			this.mButton.setBackgroundResource(resid);
		}
	}

	/**
	 * 获取布局方式代码（0：外漏，1：内嵌）
	 * 
	 * @return 布局方式代码
	 */
	public int getLayoutType() {
		return layoutType;
	}

	/**
	 * 设置布局方式
	 * 
	 * @param layoutType
	 *            布局方式代码
	 */
	public void setLayoutType(int layoutType) {
			this.layoutType = layoutType;
			intialControl(mContext);
	}

	/**
	 * 设置是否显示文本显示框
	 * 
	 * @param visiable
	 *            true为显示，false为不显示
	 */
	public void setTextView_visiable(boolean visiable) {
		mEditTextView.setTextView_visiable(visiable);
	}

	/**
	 * 获取复合控件中文本输入框内的文本
	 * 
	 * @return 文本值
	 */
	public Editable getEditText_text() {
		return this.mEditTextView.getEditText_text();
	}

	/**
	 * 设置复合控件中文本输入框的文本
	 * 
	 * @param mEditText_text
	 *            目标文本
	 */
	public void setEditText_text(String mEditText_text) {
		this.mEditTextView.setEditText_text(mEditText_text);
	}

	/**
	 * 获取复合控件中文本显示框内的文本
	 * 
	 * @return 文本值
	 */
	public CharSequence getTextView_text() {
		return this.mEditTextView.getTextView_text();
	}

	/**
	 * 设置复合控件中文本显示框的文本
	 * 
	 * @param mTextView_text
	 *            目标文本
	 */
	public void setTextView_text(String mTextView_text) {
		this.mEditTextView.setTextView_text(mTextView_text);
	}

	/**
	 * 获取复合控件中文本显示框的文本大小
	 * 
	 * @return 获取到的文本大小值
	 */
	public float getTextView_textSize() {
		return this.mEditTextView.getTextView_textSize();
	}

	/**
	 * 设置符合控件中文本显示框的文本大小
	 * 
	 * @param mTextView_textSize
	 *            目标文本大小
	 */
	public void setTextView_textSize(float mTextView_textSize) {
		this.mEditTextView.setTextView_textSize(mTextView_textSize);
	}

	/**
	 * 获取复合控件中文本输入框的文本大小
	 * 
	 * @return 获取到的文本大小值
	 */
	public float getEditText_textSize() {
		return this.mEditTextView.getEditText_textSize();
	}

	/**
	 * 设置复合控件中文本输入框的文本大小
	 * 
	 * @param mEditText_textSize
	 *            目标文本大小
	 */
	public void setEditText_textSize(float mEditText_textSize) {
		this.mEditTextView.setEditText_textSize(mEditText_textSize);
	}

	/**
	 * 设置复合控件中文本输入框的文本颜色
	 * 
	 * @param mEditText_textColor
	 *            颜色值
	 */
	public void setEditText_textColor(int mEditText_textColor) {
		this.mEditTextView.setEditText_textColor(mEditText_textColor);
	}

	/**
	 * 设置复合控件中文本显示框的文本颜色
	 * 
	 * @param resourceId
	 *            颜色值
	 */
	public void setTextView_textColor(int resourceId) {
		boolean isFormat = true;
		if (resourceId > 0) {
			try {
				mEditTextView.setTextView_textColor(getContext().getResources().getColor(
						resourceId));
			} catch (Exception ex) {
				isFormat = false;
			}
		}
		if (!isFormat) {
			try {
				setTextView_textColor(resourceId);
			} catch (Exception e) {
				Log.e("错误的颜色值", resourceId + "为错误的颜色值");
			}
		}
	}

	/**
	 * 获取复合控件中文本显示框的背景
	 * 
	 * @return 文本显示框的背景
	 */
	public Drawable getTextView_background() {
		return this.mEditTextView.getTextView_background();
	}

	/**
	 * 设置复合控件中文本显示框的背景
	 * 
	 * @param resid
	 *            背景资源ID
	 */
	public void setTextView_background(int resid) {
		this.mEditTextView.setTextView_background(resid);
	}

	/**
	 * 获取复合控件中文本输入框的背景
	 * 
	 * @return 文本输入框的背景
	 */
	public Drawable getEditText_background() {
		return this.mEditTextView.getEditText_background();
	}

	/**
	 * 设置复合控件中文本输入框的背景
	 * 
	 * @param resid
	 *            背景资源ID
	 */
	public void setEditText_background(int resid) {
		this.mEditTextView.setEditText_background(resid);
	}

	/**
	 * 获取复合控件整体显示风格
	 * 
	 * @return 风格代码
	 */
	public int getDisplayType() {
		return displayType;
	}

	/**
	 * 设置复合控件整体显示风格
	 * 
	 * @param type
	 *            风格代码
	 */
	public void setDisplayType(int type) {
		this.displayType = type;
		this.mEditTextView.setDisplayType(type);
		if(draws == null){
			draws = new Drawable[2];
		}
		if(type==1){
			draws[0]= getImageFromAssetsFile(this.mContext,"assets/xdedittextbutton_btn_img.9.png");
			draws[1]= getImageFromAssetsFile(this.mContext,"assets/xdedittextbutton_btn_img_pressed.9.png");
			mButton.setBackgroundDrawable(
					setBackgroundWithStateListDrawable(draws));
		}
		else if(type == 0){
			draws[0]= getImageFromAssetsFile(this.mContext,"assets/xdedittextbutton_btn2_img.9.png");
			draws[1]= getImageFromAssetsFile(this.mContext,"assets/xdedittextbutton_btn2_img_pressed.9.png");
			mButton.setBackgroundDrawable(
					setBackgroundWithStateListDrawable(draws));
		}
	}
	/**
	 * 构建控件的状态组背景
	 * 
	 * @param drawables
	 *            用到的drawable数组
	 * @return 状态组背景
	 */
	private StateListDrawable setBackgroundWithStateListDrawable(
			Drawable[] drawables) {
		StateListDrawable bg = new StateListDrawable();
		bg.addState(View.PRESSED_ENABLED_STATE_SET, drawables[1]);
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.EMPTY_STATE_SET, drawables[0]);
		return bg;
	}

	/**
	 * 设置复合控件中的文本输入框是否可用
	 * 
	 * @param enable
	 *            true为可用false为不可用，默认为true
	 */
	public void setEditText_enable(boolean enable) {
		this.mEditTextView.setEditText_enable(enable);
	}

	/**
	 * 设置复合控件中的文本输入框输入类型
	 * 
	 * @param digits
	 *            输入类型
	 */
	public void setEditText_digits(String digits) {
		this.mEditTextView.setEditText_digits(digits);
	}

	/**
	 * 设置复合控件中的文本输入框的最大输入长度
	 * 
	 * @param maxLength
	 *            最大长度
	 */
	public void setEditText_maxLength(int maxLength) {
		mEditTextView.setEditText_maxLength(maxLength);
	}

	/**
	 * 设置按钮图片
	 * 
	 * @param bm
	 */
	public void setImageButton_image(Bitmap bm) {
		this.mButton.setImageBitmap(bm);
	}

	public void setImageButton_image(Drawable drawable) {
		this.mButton.setImageDrawable(drawable);
	}

	/**
	 * 设置按钮上的图片
	 * 
	 * @param resId
	 */
	public void setImageButton_image(int resId) {
		this.mButton.setImageResource(resId);
		mButton.setPadding(2, 2, 2, 2);
	}
	/**
	 * 设置文本显示框宽度
	 */
	public void setTextView_width(int width){
		this.mEditTextView.setTextView_width(width);
	}
	/**
	 * 获取复合控件中的文本输入框
	 * @return 获取到的EditText对象
	 */
	public XDEditText getEditText(){
		return this.mEditTextView.getEditText();
	}
	/**
	 * 获取复合控件中得图片按钮
	 * @return 获取的ImageButton对象
	 */
	public ImageButton getImageButton(){
		return this.mButton;
	}
	/*
	 * 为控件注册事件
	 */
	public void addEditText_TextChangedListener(TextWatcher watcher) {
		mEditTextView.addEditText_TextChangedListener(watcher);
	}

	public void setEditText_OnClickListener(View.OnClickListener l) {
		mEditTextView.setEditText_OnClickListener(l);
	}

	public void setEditText_OnTouchListener(View.OnTouchListener l) {
		mEditTextView.setEditText_OnTouchListener(l);
	}

	public void setEditText_OnLongClickListener(View.OnLongClickListener l) {
		mEditTextView.setEditText_OnLongClickListener(l);
	}

	public void setEditText_OnCreateContextMenuListener(
			View.OnCreateContextMenuListener l) {
		mEditTextView.setEditText_OnCreateContextMenuListener(l);
	}

	public void setEditText_OnFocusChangeListener(View.OnFocusChangeListener l) {
		mEditTextView.setEditText_OnFocusChangeListener(l);
	}

	public void setEditText_OnKeyListener(View.OnKeyListener l) {
		mEditTextView.setEditText_OnKeyListener(l);
	}

	public void setButton_OnClickListener(View.OnClickListener l) {
		mButton.setOnClickListener(l);
	}
}
