package com.xdja.combox.keyboard;

import java.io.IOException;
import java.io.InputStream;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.ClipboardManager;
import android.text.Editable;
import android.text.InputType;
import android.text.Selection;
import android.text.method.PasswordTransformationMethod;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.View.OnFocusChangeListener;
import android.view.View.OnLongClickListener;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.PopupWindow.OnDismissListener;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TabHost;
import android.widget.TabHost.OnTabChangeListener;
import android.widget.TabWidget;
import android.widget.TableRow;
import android.widget.TableLayout;
import android.widget.LinearLayout.LayoutParams;
import android.widget.TextView;
import android.app.Activity;

public class InputSoftKeyBoard {
	private static Context mcontext = null;
	private static int textSize = 25;
	private static int opearaTextSize = 20;
	private static EditText editresult = null;
	private static EditText inputedit = null;
	private static PopupWindow mPopupWindow = null;
	private static View popupWindow = null;
	private static ButtonListener b = new ButtonListener();
	private static ButtonLongListener bl = new ButtonLongListener();
	private static String titlecontext = "";
	private static int Width = 0;
	private static XDInputGirdView girdview = null;
	private static IputGirdVeiw adapter = null;
	private static int lasttablocation = -1;
	private static int currenttablocation = 0;
	private static TabHost mtabhost = null;
	private static TabWidget mtabWidget = null;
	private static String[] province = { "京", "津", "沪", "渝", "黑", "吉", "辽",
			"苏", "浙", "闽", "皖", "赣", "湘", "晋", "冀", "鲁", "豫", "鄂", "陕", "甘",
			"宁", "蒙", "新", "青", "藏", "川", "贵", "云", "桂", "粤", "琼", "港", "澳",
			"台" };
	private static String[] special= {"澳","超","挂","港","警","领","临时","使","试","学"};

	private static String[] number = { "1", "2", "3", "4", "5", "6", "7",
			"8", "9", "0", ".", "X" };
	private static String[] lowerletter = { "a", "b", "c", "d", "e", "f", "g",
			"h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t",
			"u", "v", "w", "x", "y", "z", "大写" };
	private static String[] upcaseletter = { "A", "B", "C", "D", "E", "F", "G",
			"H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T",
			"U", "V", "W", "X", "Y", "Z", "小写" };
	private static String[] operate = { "复制全部", "删除", "确定" };
	private static final int sc_Id = 10001;
	private static final int qd_Id = 10002;
	private static final int fzqb_Id = 10003;
	private static String defaultPanel = "number";
	private static Boolean passwor = false;
	private static LinearLayout numLayout;
	private static LinearLayout letterLayout;
	private static LinearLayout provinceLayout;
	private static LinearLayout specialLayout;

	/**
	 * 功能：构造函数 参数：
	 *
	 * @param _context 上下文
	 * @param _edit 调用改方法的EditText
	 * @param _inputstype 输入面板的初始化标识
	 * @param _passwor 是否是输入密码
	 * @param _title 输入的提示文字
	 */
	public static void InitInputSoftKeyBoard(Context _context, EditText _edit,
											 String _inputstype, Boolean _passwor, String _title) {
		mcontext = _context;
		if (_inputstype == null) {
			defaultPanel = "number";
		} else {
			defaultPanel = _inputstype;
		}
		if (_passwor != null) {
			passwor = _passwor;
		} else {
			passwor = false;
		}
		titlecontext = _title;
		editresult = _edit;
		initshowTab();
		initPopuptWindow();
	}

	/** 设置Tab的初始化标签 */
	private static void initshowTab() {
		if (defaultPanel.equals("number")) {
			currenttablocation = 0;
		}
		if (defaultPanel.equals("letter")) {
			currenttablocation = 1;
		}
		if (defaultPanel.equals("province")) {
			currenttablocation = 2;
		}
	}

	/*
	 * 创建PopupWindow
	 */
	private static void initPopuptWindow() {
		// 创建一个PopupWindow
		if(mPopupWindow==null){
			mPopupWindow = new PopupWindow(mcontext);
		}
		DisplayMetrics dm = new DisplayMetrics();
		((Activity) mcontext).getWindowManager().getDefaultDisplay()
				.getMetrics(dm);
		Width = dm.widthPixels;
		if (Width >= 480) {
			textSize = 35;
		} else {
			textSize = 25;
		}
		popupWindow = initInputView(titlecontext);
		int contentTop = ((Activity) mcontext).getWindow()
				.findViewById(Window.ID_ANDROID_CONTENT).getTop();
		int screenHeight = dm.heightPixels - contentTop;
		mPopupWindow.setContentView(popupWindow);
		mPopupWindow.setFocusable(true);
		mPopupWindow.setTouchable(true); // 设置PopupWindow可触摸
		// 设置PopupWindow外部区域是否可触摸
		mPopupWindow.setOutsideTouchable(false);
		// 加上下面两行可以用back键关闭popupwindow，否则必须调用dismiss();
		// android:background="#b0000000"
		ColorDrawable dw = new ColorDrawable(Color.argb(250, 00,00, 00));
		mPopupWindow.setBackgroundDrawable(dw);
		mPopupWindow.setWidth(LayoutParams.FILL_PARENT);
		mPopupWindow.setHeight(screenHeight);
		mPopupWindow.setOnDismissListener(new OnDismissListener() {
			@Override
			public void onDismiss() {
				String resultString = "" + editresult.getText();
				EditInput.setEdit(resultString);// 设定返回值，调用静态的函数
				mPopupWindow = null;
			}
		});
		if(!mPopupWindow.isShowing()){
			mPopupWindow.showAtLocation(editresult, Gravity.BOTTOM, 0, 0);
		}
	}

	/** 初始化设置popuwindow的布局 */
	private static View initInputView(String text) {
		LinearLayout mlayout = new LinearLayout(mcontext);
		mlayout.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT,
				LayoutParams.FILL_PARENT));
		mlayout.setOrientation(LinearLayout.VERTICAL);
		/** 输入框及提示文字的线性布局 **/
		LinearLayout mEitdlayout = new LinearLayout(mcontext);
		mEitdlayout.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT,
				LayoutParams.WRAP_CONTENT));
		mEitdlayout.setOrientation(LinearLayout.HORIZONTAL);
		/** 提示文字 **/
		TextView showtext = new TextView(mcontext);
		showtext.setLayoutParams(new LayoutParams(LayoutParams.WRAP_CONTENT,
				LayoutParams.WRAP_CONTENT));
		showtext.setText(text + ": ");
		showtext.setTextSize(20);
		showtext.setTextColor(Color.WHITE);
		showtext.setGravity(Gravity.CENTER_VERTICAL);
		/** 输入框布局 **/
		inputedit = new EditText(mcontext);
//		inputedit.setOnClickListener(new View.OnClickListener() {
//			public void onClick(View v) {
//				InputMethodManager imm = (InputMethodManager) mcontext
//						.getSystemService(Context.INPUT_METHOD_SERVICE);
//				imm.hideSoftInputFromWindow(((EditText) v).getWindowToken(), 0);
//			}
//		});
		inputedit.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT,
				LayoutParams.WRAP_CONTENT));
		inputedit.setHint("请输入....");
		/** 初始化输入框的显示文字（及传递过来的文字） **/
		String alreadyinput = editresult.getText().toString().replace(" ", "");
		inputedit.setText(alreadyinput); // 显示传过来的已经输入的信息
		inputedit.setSelection(alreadyinput.length());
		/** 输入框强单行设置 **/
		inputedit.setSingleLine();
//		inputedit.setInputType(InputType.TYPE_NULL);
		/** 输入框去掉输入法 **/
		inputedit.setOnClickListener(new View.OnClickListener() {
			public void onClick(View v) {
				InputMethodManager imm = (InputMethodManager) mcontext
						.getSystemService(Context.INPUT_METHOD_SERVICE);
				imm.hideSoftInputFromWindow(((EditText) v).getWindowToken(), InputMethodManager.HIDE_NOT_ALWAYS);
			}
		});
		inputedit.setOnFocusChangeListener(new OnFocusChangeListener() {
			@Override
			public void onFocusChange(View v, boolean hasFocus) {
				// TODO Auto-generated method stub
				inputedit.requestFocus();
			}
		});
		/** 根据password来确定EditText是否是输入密码 **/
		if (passwor) {
			inputedit.setTransformationMethod(PasswordTransformationMethod
					.getInstance());
		}
		Editable etext = inputedit.getText();
		int position = etext.length();
		inputedit.requestFocus();
		Selection.setSelection(etext, position);
		mEitdlayout.addView(showtext);
		mEitdlayout.addView(inputedit);
		mlayout.addView(mEitdlayout);
		/** 加载TabHost的布局 **/
		mlayout.addView(CreateTabHost());
		return mlayout;
	}

	private static void deleteEdit() {
		// TODO Auto-generated method stub
		int start = inputedit.getSelectionStart();
		int end = inputedit.getSelectionEnd();
		Editable text = inputedit.getText();
		if (!text.equals("")) {
			if (start != end) {
				if (start > end) {
					int temp = end;
					end = start;
					start = temp;
				}
				if (end != 0) {
					text.delete(start, end);
				}
			} else {
				if (end != 0) {
					text.delete(end - 1, end);
				}
			}
		}
	}

	public static class ButtonListener implements View.OnClickListener {
		public void onClick(View view) {
			switch (view.getId()) {
				case fzqb_Id:
					ClipboardManager cmb = (ClipboardManager) mcontext
							.getSystemService(Context.CLIPBOARD_SERVICE);
					try {
						cmb.setText("" + inputedit.getText());
					} catch (Exception e) {
					}
					break;
				case sc_Id: {
					deleteEdit();// 删除字符
					break;
				}
				case qd_Id:
					String resultString = "" + inputedit.getText();
					Log.v("inputpanel", "button is pressed!");
					EditInput.setEdit(resultString);// 设定返回值，调用静态的函数
					mPopupWindow.dismiss();
					mPopupWindow = null;
					break;
				default: {
					break;
				}
			}

		}
	}

	public static class ButtonLongListener implements View.OnLongClickListener {
		@Override
		public boolean onLongClick(View v) {
			// TODO Auto-generated method stub
			switch (v.getId()) {
				case sc_Id: {
					inputedit.setText("");
					break;
				}
				default: {
					break;
				}
			}
			return false;
		}
	}

	public static class IputGirdVeiw extends BaseAdapter {
		private Context mcontext = null;
		public String[] showtext = null;
		private int Weight = 0;
		private int girdNumColumns = 0;

		IputGirdVeiw(Context _context, String[] _showtext, int _Weight,
					 int _girdNumColumns) {
			mcontext = _context;
			showtext = _showtext;
			Weight = _Weight;
			girdNumColumns = _girdNumColumns;
		}

		@Override
		public int getCount() {
			// TODO Auto-generated method stub
			return showtext.length;
		}

		@Override
		public Object getItem(int position) {
			// TODO Auto-generated method stub
			return position;
		}

		@Override
		public long getItemId(int position) {
			// TODO Auto-generated method stub
			return position;
		}

		@Override
		public View getView(final int position, View convertView,
							ViewGroup parent) {
			// TODO Auto-generated method stub
			Button mbutton = null;
			System.out
					.println("----------------------convertView-------------------------");
			System.out.println(convertView);
			mbutton = new Button(mcontext);
			if (showtext[position].equals("大写")
					|| showtext[position].equals("小写")) {
				System.out
						.println("----------------------改变-------------------------");
				mbutton.setLayoutParams(new XDInputGirdView.LayoutParams(
						((Weight / girdNumColumns) - 10) * 2,
						XDInputGirdView.LayoutParams.WRAP_CONTENT));
			} else {
				mbutton.setLayoutParams(new XDInputGirdView.LayoutParams(
						(Weight / girdNumColumns) - 10,
						XDInputGirdView.LayoutParams.WRAP_CONTENT));
			}
			mbutton.setText(showtext[position]);
			mbutton.setTextColor(Color.WHITE);
			mbutton.setTextSize(textSize);
			mbutton.setId(position);
			mbutton.setPadding(2, 2, 2, 2);
			System.out.println(position);
			if (showtext[position].equals("退格")) {
				mbutton.setOnLongClickListener(new OnLongClickListener() {
					@Override
					public boolean onLongClick(View v) {
						// TODO Auto-generated method stub
						inputedit.setText("");
						return false;
					}
				});
			}
			mbutton.setOnClickListener(new OnClickListener() {
				@Override
				public void onClick(View v) {
					// TODO Auto-generated method stub
					if (((Button) v).getText().toString().equals("大写")) {
						showtext = upcaseletter;
						IputGirdVeiw.this.notifyDataSetChanged();
						System.out
								.println("----------------------大写-------------------------");
					} else if (((Button) v).getText().toString().equals("小写")) {
						showtext = lowerletter;
						IputGirdVeiw.this.notifyDataSetChanged();
						System.out
								.println("----------------------小写-------------------------");
					} else {
						int start = inputedit.getSelectionStart();
						int end = inputedit.getSelectionEnd();
						Editable text = inputedit.getText();
						text.replace(start++, end, showtext[position], 0, 1);
						inputedit.setText(text);
						inputedit.requestFocus();
						inputedit.setSelection(start);
					}
				}
			});
			mbutton.setBackgroundDrawable(setBg());
			return mbutton;
		}
	}

	// 构建状态选择器
	private static StateListDrawable setBg() {
		StateListDrawable bg = new StateListDrawable();
		bg.addState(new int[] { android.R.attr.state_pressed,
						android.R.attr.state_enabled },
				get9ImageFromAssetsFile("buttondown.9.png"));
		bg.addState(new int[] { android.R.attr.state_enabled,
						android.R.attr.state_enabled },
				get9ImageFromAssetsFile("buttonnormal.9.png"));
		return bg;
	}
	// 构建状态选择器
	private static StateListDrawable setBackSpace() {
		StateListDrawable bg = new StateListDrawable();
		bg.addState(new int[] { android.R.attr.state_pressed,
						android.R.attr.state_enabled },
				getDrawable("backspace_press.png"));
		bg.addState(new int[] { android.R.attr.state_enabled,
						android.R.attr.state_enabled },
				getDrawable("backspace.png"));
		return bg;
	}
	private static View createTabView(final String text) {
		LinearLayout mLinearLayout = new LinearLayout(mcontext);
		mLinearLayout.setGravity(Gravity.CENTER);
		mLinearLayout.setLayoutParams(new LayoutParams(
				LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT));
		mLinearLayout.setOrientation(LinearLayout.VERTICAL);
		mLinearLayout.setGravity(Gravity.CENTER);
		if (text != null) {
			TextView mtext = new TextView(mcontext);
			mtext.setLayoutParams(new LayoutParams(LayoutParams.WRAP_CONTENT,
					LayoutParams.WRAP_CONTENT));
			mtext.setTextSize((textSize / 6) * 5);
			mtext.setTextColor(Color.WHITE);
			mLinearLayout.addView(mtext);
			mtext.setText(text);
		}
		mLinearLayout
				.setBackgroundDrawable(getDrawable("tabunselect.png"));
		mLinearLayout.setBaselineAligned(true);
		return mLinearLayout;
	}

	private static TabHost CreateTabHost() {
		/** TabHost的布局外是一个Linearlayout **/
		LinearLayout mtablayout = new LinearLayout(mcontext);
		mtablayout.setLayoutParams(new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT));
		mtablayout.setOrientation(LinearLayout.VERTICAL);
		mtabhost = new TabHost(mcontext);
		mtabhost.setId(android.R.id.tabhost);
		LinearLayout.LayoutParams mtable = new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		mtable.setMargins(0, -4, 0, 0);
		mtabhost.setLayoutParams(mtable);
		mtabWidget = new TabWidget(mcontext);
		mtabWidget.setId(android.R.id.tabs);
		mtabWidget.setLayoutParams(new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT));
		FrameLayout content = new FrameLayout(mcontext);
		content.setId(android.R.id.tabcontent);
		/** FrameLayout中包含四个Linearlayout，其中各个linearlayout中都添加了ScrollView **/
		initNumLayoutLayout();
		initletterLayout();
		initProvinceLayout();
		initSpecialLayout();
		content.addView(numLayout, 0);
		content.addView(letterLayout, 1);
		content.addView(provinceLayout, 2);
		content.addView(specialLayout,3);
		RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.FILL_PARENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);
		lp.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, mtabhost.getId());
		HorizontalScrollView horizontalscroll = new HorizontalScrollView(mcontext);
		horizontalscroll.setLayoutParams(lp);
		horizontalscroll.setScrollBarStyle(HorizontalScrollView.SCROLLBARS_INSIDE_OVERLAY);
		horizontalscroll.addView(mtabWidget, lp);
		mtablayout.addView(horizontalscroll);
		lp.addRule(RelativeLayout.BELOW, horizontalscroll.getId());
		mtablayout.addView(content, lp);
		mtabhost.addView(mtablayout);
		mtabhost.setup();
		mtabWidget.setStripEnabled(false);
		mtabWidget.setDividerDrawable(get9ImageFromAssetsFile("tab_divider.9.png"));
		TabHost.TabSpec tab1 = mtabhost.newTabSpec("0");
		tab1.setIndicator(createTabView("数字"));
		tab1.setContent(numLayout.getId());
		TabHost.TabSpec tab2 = mtabhost.newTabSpec("1");
		tab2.setIndicator(createTabView("字母"));
		tab2.setContent(letterLayout.getId());
		TabHost.TabSpec tab3 = mtabhost.newTabSpec("2");
		tab3.setIndicator(createTabView("省份"));
		tab3.setContent(provinceLayout.getId());
		TabHost.TabSpec tab4=mtabhost.newTabSpec("3");
		tab4.setIndicator(createTabView("特殊"));
		tab4.setContent(specialLayout.getId());
		mtabhost.addTab(tab1);
		mtabhost.addTab(tab2);
		mtabhost.addTab(tab3);
		mtabhost.addTab(tab4);
		mtabhost.setCurrentTab(currenttablocation);
		setSelect(currenttablocation);
		for (int i = 0; i < 4; i++) {
			mtabWidget.getChildTabViewAt(i).setMinimumWidth((Width) / 4);
		}
		mtabhost.setOnTabChangedListener(new OnTabChangeListener() {
			@Override
			public void onTabChanged(String tabId) {
				// TODO Auto-generated method stub
				lasttablocation = currenttablocation;
				currenttablocation = mtabhost.getCurrentTab();
				setSelect(mtabhost.getCurrentTab());
			}
		});
		return mtabhost;
	}

	private static void setSelect(int selectab) {
		View vvv = mtabWidget.getChildTabViewAt(selectab);
		vvv.setBackgroundDrawable(getDrawable("tabselect.png"));
		if (lasttablocation > -1) {
			View vv = mtabWidget.getChildTabViewAt(lasttablocation);
			vv.setBackgroundDrawable(getDrawable("tabunselect.png"));
		}
	}

	/** 省份布局 **/
	private static LinearLayout initProvinceLayout() {
		provinceLayout = new LinearLayout(mcontext);
		provinceLayout.setOrientation(LinearLayout.VERTICAL);
		provinceLayout.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.FILL_PARENT));
		provinceLayout.setPadding(0, 10, 0, 0);
		ScrollView scroll = new ScrollView(mcontext);
		scroll.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		scroll.setFillViewport(true);
		scroll.setScrollBarStyle(ScrollView.SCROLLBARS_INSIDE_INSET);
		LinearLayout temp = new LinearLayout(mcontext);
		temp.setOrientation(LinearLayout.VERTICAL);
		temp.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.FILL_PARENT));
		girdview = new XDInputGirdView(mcontext);
		girdview.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		WindowManager wm = (WindowManager)mcontext.getSystemService(Context.WINDOW_SERVICE);
		DisplayMetrics dm = new DisplayMetrics();
		wm.getDefaultDisplay().getMetrics(dm);
		if (dm.widthPixels > dm.heightPixels) {
			girdview.setNumColumns(6);
			adapter = new IputGirdVeiw(mcontext, province, Width, 6);
		} else {
			girdview.setNumColumns(5);
			adapter = new IputGirdVeiw(mcontext, province, Width, 5);
		}
		girdview.setHorizontalSpacing(10);
		girdview.setVerticalSpacing(15);
		girdview.setAdapter(adapter);
		temp.addView(girdview);
		temp.addView(initTableLayout());
		scroll.addView(temp);
		provinceLayout.addView(scroll);
		provinceLayout.setVisibility(View.GONE);
		provinceLayout.setId(4);
		return provinceLayout;
	}
	/** 省份布局 **/
	private static LinearLayout initSpecialLayout() {
		specialLayout = new LinearLayout(mcontext);
		specialLayout.setOrientation(LinearLayout.VERTICAL);
		specialLayout.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.FILL_PARENT));
		specialLayout.setPadding(0, 10, 0, 0);
		ScrollView scroll = new ScrollView(mcontext);
		scroll.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		scroll.setFillViewport(true);
		scroll.setScrollBarStyle(ScrollView.SCROLLBARS_INSIDE_INSET);
		LinearLayout temp = new LinearLayout(mcontext);
		temp.setOrientation(LinearLayout.VERTICAL);
		temp.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.FILL_PARENT));
		girdview = new XDInputGirdView(mcontext);
		girdview.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		WindowManager wm = (WindowManager)mcontext.getSystemService(Context.WINDOW_SERVICE);
		DisplayMetrics dm = new DisplayMetrics();
		wm.getDefaultDisplay().getMetrics(dm);
		if (dm.widthPixels > dm.heightPixels) {
			girdview.setNumColumns(4);
			adapter = new IputGirdVeiw(mcontext, special, Width, 4);
		} else {
			girdview.setNumColumns(4);
			adapter = new IputGirdVeiw(mcontext, special, Width, 4);
		}
		girdview.setHorizontalSpacing(10);
		girdview.setVerticalSpacing(15);
		girdview.setAdapter(adapter);
		temp.addView(girdview);
		temp.addView(initTableLayout());
		scroll.addView(temp);
		specialLayout.addView(scroll);
		specialLayout.setVisibility(View.GONE);
		specialLayout.setId(5);
		return provinceLayout;
	}
	/** 数字布局 **/
	private static LinearLayout initNumLayoutLayout() {
		numLayout = new LinearLayout(mcontext);
		numLayout.setOrientation(LinearLayout.VERTICAL);
		numLayout.setLayoutParams(new ScrollView.LayoutParams(
				ScrollView.LayoutParams.FILL_PARENT,
				ScrollView.LayoutParams.WRAP_CONTENT));
		numLayout.setPadding(0, 10, 0, 0);
		ScrollView scroll = new ScrollView(mcontext);
		scroll.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		scroll.setFillViewport(true);
		scroll.setScrollBarStyle(ScrollView.SCROLLBARS_INSIDE_INSET);
		LinearLayout temp = new LinearLayout(mcontext);
		temp.setOrientation(LinearLayout.VERTICAL);
		girdview = new XDInputGirdView(mcontext);
		girdview.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		WindowManager wm = (WindowManager)mcontext.getSystemService(Context.WINDOW_SERVICE);
		DisplayMetrics dm = new DisplayMetrics();
		wm.getDefaultDisplay().getMetrics(dm);
		if (dm.widthPixels > dm.heightPixels) {
			LinearLayout.LayoutParams tempParams = new LinearLayout.LayoutParams(
					0,
					ScrollView.LayoutParams.FILL_PARENT);
			tempParams.weight = 1.0f;
			temp.setLayoutParams(tempParams);
			girdview.setNumColumns(4);
			adapter = new IputGirdVeiw(mcontext, number, Width - 200, 4);
			girdview.setHorizontalSpacing(10);
			girdview.setVerticalSpacing(15);
			girdview.setAdapter(adapter);
			temp.addView(girdview);
			temp.addView(initTableLayout());
			LinearLayout tempLy = new LinearLayout(mcontext);
			tempLy.setOrientation(LinearLayout.HORIZONTAL);
			tempLy.setLayoutParams(new ScrollView.LayoutParams(
					ScrollView.LayoutParams.FILL_PARENT,
					ScrollView.LayoutParams.FILL_PARENT));
			TextView tempTvLeft = new TextView(mcontext);
			tempTvLeft.setLayoutParams(new LinearLayout.LayoutParams(100, LinearLayout.LayoutParams.FILL_PARENT));
			TextView tempTvRight = new TextView(mcontext);
			tempTvRight.setLayoutParams(new LinearLayout.LayoutParams(100, LinearLayout.LayoutParams.FILL_PARENT));
			tempLy.addView(tempTvLeft);
			tempLy.addView(temp);
			tempLy.addView(tempTvRight);
			scroll.addView(tempLy);
		} else {
			temp.setLayoutParams(new ScrollView.LayoutParams(
					ScrollView.LayoutParams.FILL_PARENT,
					ScrollView.LayoutParams.FILL_PARENT));
			girdview.setNumColumns(3);
			adapter = new IputGirdVeiw(mcontext, number, Width, 3);
			girdview.setHorizontalSpacing(10);
			girdview.setVerticalSpacing(15);
			girdview.setAdapter(adapter);
			temp.addView(girdview);
			temp.addView(initTableLayout());
			scroll.addView(temp);
		}
		numLayout.addView(scroll);
		numLayout.setVisibility(View.GONE);
		numLayout.setId(1);
		return numLayout;
	}

	/** 小写字母布局 **/
	private static LinearLayout initletterLayout() {
		letterLayout = new LinearLayout(mcontext);
		letterLayout.setOrientation(LinearLayout.VERTICAL);
		letterLayout.setLayoutParams(new ScrollView.LayoutParams(
				ScrollView.LayoutParams.FILL_PARENT,
				ScrollView.LayoutParams.WRAP_CONTENT));
		letterLayout.setPadding(0, 10, 0, 0);
		ScrollView scroll = new ScrollView(mcontext);
		scroll.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		scroll.setFillViewport(true);
		scroll.setScrollBarStyle(ScrollView.SCROLLBARS_INSIDE_INSET);
		LinearLayout temp = new LinearLayout(mcontext);
		temp.setOrientation(LinearLayout.VERTICAL);
		temp.setLayoutParams(new ScrollView.LayoutParams(
				ScrollView.LayoutParams.FILL_PARENT,
				ScrollView.LayoutParams.FILL_PARENT));
		girdview = new XDInputGirdView(mcontext);
		girdview.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		WindowManager wm = (WindowManager)mcontext.getSystemService(Context.WINDOW_SERVICE);
		DisplayMetrics dm = new DisplayMetrics();
		wm.getDefaultDisplay().getMetrics(dm);
		if (dm.widthPixels > dm.heightPixels) {
			girdview.setNumColumns(6);
			adapter = new IputGirdVeiw(mcontext, upcaseletter, Width, 6);
		} else {
			girdview.setNumColumns(5);
			adapter = new IputGirdVeiw(mcontext, upcaseletter, Width, 5);
		}
		girdview.setHorizontalSpacing(10);
		girdview.setVerticalSpacing(15);
		girdview.setAdapter(adapter);
		temp.addView(girdview);
		temp.addView(initTableLayout());
		scroll.addView(temp);
		letterLayout.addView(scroll);
		letterLayout.setVisibility(View.GONE);
		letterLayout.setId(2);
		return letterLayout;
	}

	private static TableLayout initTableLayout() {
		TableLayout mtablelayout = new TableLayout(mcontext);
		mtablelayout.setLayoutParams(new LinearLayout.LayoutParams(
				LinearLayout.LayoutParams.FILL_PARENT,
				LinearLayout.LayoutParams.WRAP_CONTENT));
		mtablelayout.setId(1);
		mtablelayout.setPadding(0, 15, 0, 0);
		mtablelayout.setOrientation(TableLayout.VERTICAL);
		mtablelayout.setShrinkAllColumns(true);
		mtablelayout.setStretchAllColumns(true);
		TableRow mtableraw = new TableRow(mcontext);
		TableLayout.LayoutParams params = new TableLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		params.bottomMargin = 10;
		mtableraw.setLayoutParams(params);
		mtableraw.setOrientation(TableRow.HORIZONTAL);
		mtableraw.setGravity(Gravity.BOTTOM);

		for (int i = 0; i < operate.length; i++) {
			Button button = new Button(mcontext);
			switch (i) {
				case 0:
					button.setId(fzqb_Id);
					break;
				case 1:
					button.setId(sc_Id);
					break;
				case 2:
					button.setId(qd_Id);
					break;

				default:
					break;
			}
			button.setTextSize(opearaTextSize);
			TableRow.LayoutParams tablerow_layoutparams=new TableRow.LayoutParams(
					LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
			if (i == 0)
			{
				tablerow_layoutparams.rightMargin=5;
			}else{
				tablerow_layoutparams.leftMargin=5;
			}
			button.setLayoutParams(tablerow_layoutparams);
			button.setText(operate[i]);
			button.setBackgroundDrawable(setBg());
			if (i == 1) {
//				button.setBackgroundDrawable(setBackSpace());
				button.setOnLongClickListener(bl);
			}
			button.setTextColor(Color.WHITE);
			mtableraw.addView(button);
			button.setOnClickListener(b);
		}
		mtablelayout.addView(mtableraw);
		return mtablelayout;
	}

	private static NinePatchDrawable get9ImageFromAssetsFile(String FileName) {
		InputStream stream;
		try {
			stream = mcontext.getAssets().open(FileName);
			Bitmap bitmap = BitmapFactory.decodeStream(stream);
			byte[] chunk = bitmap.getNinePatchChunk();
			boolean result = NinePatch.isNinePatchChunk(chunk);
			NinePatchDrawable patchy = null;
			if (result) {
				patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
			}
			return patchy;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}
	private static Drawable getDrawable(String FileName) {
		InputStream stream;
		Drawable drawable;
		try {
			stream = mcontext.getAssets().open(FileName);
			drawable = Drawable.createFromStream(stream, FileName);
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
		return drawable;
	}

}
