package com.xdja.combox.spinner;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ImageView.ScaleType;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

public class XDSpinner extends Spinner {
    private Context mcontext = null;
    /**
     * 显示的属性
     */
    public String Styletype = "0";
    /**
     * Spinner各个状态下 传入的Drawable对象
     */
    private Drawable[] roundDrawable = null;
    private Drawable[] squareDrawable = null;
    private Drawable[] setDrawable = null;
    private Drawable defaultDrawable = null;
    private int layout_span = -1;
    private int layout_drop = -1;
    private int TextColor = Color.BLACK;
    private int TextSize = 18;
    private ArrayList<SpinnerItem> data = null;
    public final static int SHOW_TYPE = 0;
    public final static int SHOW_TYPE_RADIOBUTTON = 1;
    /**
     * 获取代码值
     */
    public final static String DATA_CODE = "1";
    /**
     * 获取文本值
     */
    public final static String DATA_TEXT = "0";

    public XDSpinner(Context context) {
        super(context);
        mcontext = context;
    }

    public XDSpinner(Context context, AttributeSet attrs) {
        super(context, attrs);
        mcontext = context;
        String temp = null;
        for (int i = 0; i < attrs.getAttributeCount(); i++) {
            if ("Styletype".equals(attrs.getAttributeName(i))) {
                temp = attrs.getAttributeValue(i);
            } else if ("background".equals(attrs.getAttributeName(i))) {
                int resourceId = attrs.getAttributeResourceValue(i, 0);
                if (resourceId > 0) {
                    defaultDrawable = getResources().getDrawable(resourceId);
                }
            } else if ("layoutspan".equals(attrs.getAttributeName(i))) {
                int resourceId = attrs.getAttributeResourceValue(i, 0);
                if (resourceId > 0) {
                    layout_span = resourceId;
                }
            } else if ("layoutdrop".equals(attrs.getAttributeName(i))) {
                int resourceId = attrs.getAttributeResourceValue(i, 0);
                if (resourceId > 0) {
                    layout_drop = resourceId;
                }
            }
        }
        if (defaultDrawable == null)// 用户没有设置android:background属性
        {
            if (temp != null)// 用户设置了Styletype属性
            {
                Styletype = temp;
                initDrawable(Styletype);
            } else {
                Styletype = "1";
                initDrawable(Styletype);
            }
        } else {
            this.setBackgroundDrawable(defaultDrawable);
        }
    }

    private static NinePatchDrawable get9ImageFromAssetsFile(Context context,
                                                             String FileName) {
        InputStream stream;
        try {
            stream = context.getAssets().open(FileName);
            Bitmap bitmap = BitmapFactory.decodeStream(stream);
            byte[] chunk = bitmap.getNinePatchChunk();
            boolean result = NinePatch.isNinePatchChunk(chunk);
            NinePatchDrawable patchy = null;
            if (result) {
                patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
            }
            return patchy;
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Bitmap getBitmap(Context context, String FileName) {
        InputStream stream;
        Bitmap bitmap;
        try {
            stream = context.getAssets().open(FileName);
            bitmap = BitmapFactory.decodeStream(stream);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return bitmap;
    }

    private void initDrawable(String Styletype) {
        if (Styletype.equals("1")) {
            /*
             * 获取各种state状态时的圆角图片； 数组存储顺序pressed的图片、focused的图片、normal的图片
			 */
            roundDrawable = new Drawable[3];
            roundDrawable[0] = get9ImageFromAssetsFile(mcontext,
                    "xdspinner_dropdown_normal.9.png");
            roundDrawable[1] = get9ImageFromAssetsFile(mcontext,
                    "xdspinner_dropdown_selected.9.png");
            roundDrawable[2] = get9ImageFromAssetsFile(mcontext,
                    "xdspinner_dropdown_selected.9.png");
            this.setBackgroundDrawable(setBg(roundDrawable));
        }
        if (Styletype.equals("2")) {
			/*
			 * 获取各种state状态时的方角图片； 数组存储顺序pressed的图片、focused的图片、normal的图片
			 */
            squareDrawable = new Drawable[3];
            squareDrawable[0] = get9ImageFromAssetsFile(mcontext,
                    "xdspinner_normal.9.png");
            squareDrawable[1] = get9ImageFromAssetsFile(mcontext,
                    "xdspinner_select.9.png");
            squareDrawable[2] = get9ImageFromAssetsFile(mcontext,
                    "xdspinner_select.9.png");
            this.setBackgroundDrawable(setBg(squareDrawable));
        }
    }

    // 构建状态选择器
    private StateListDrawable setBg(Drawable[] drawables) {
        StateListDrawable bg = new StateListDrawable();
        bg.addState(View.PRESSED_ENABLED_STATE_SET, drawables[0]);
        bg.addState(View.ENABLED_FOCUSED_STATE_SET, drawables[1]);
        bg.addState(View.ENABLED_STATE_SET, drawables[2]);
        return bg;
    }

    /**
     * 功能：填充数据 参数：
     *
     * @param temp     传入的数据集合
     * @param showtype 选择显示的风格 SHOW_TYPE_RADIOBUTTON 是Spinner默认的风格 SHOW_TYPE
     *                   是自定义的风格将RadioButton改为小对号
     */
    public void FillData(final ArrayList<SpinnerItem> temp, int showtype) {
        if (temp != null) {
            data = temp;
            if (!(showtype == 0) && !(showtype == 1)) {
                showtype = SHOW_TYPE_RADIOBUTTON;
            }
            if (showtype == SHOW_TYPE) {
                final Bitmap bmp = getBitmap(mcontext, "xdspinnerimage.png");
                ArrayAdapter<SpinnerItem> adapter = new ArrayAdapter<SpinnerItem>(
                        mcontext, android.R.layout.simple_spinner_item, temp) {
                    @Override
                    public View getDropDownView(int position, View convertView,
                                                ViewGroup parent) {
                        LinearLayout view = new LinearLayout(mcontext);
                        view.setOrientation(LinearLayout.HORIZONTAL); // 设置朝向
                        // 初始化ImageView
                        ImageView imageView = new ImageView(mcontext);
                        imageView.setImageBitmap(bmp);// 设置图片
                        imageView.setScaleType(ScaleType.CENTER_INSIDE);
                        imageView.setPadding(5, 2, 2, 2);
                        imageView.setVisibility(View.INVISIBLE);
                        // 初始化TextView
                        TextView tv = new TextView(mcontext);
                        tv.setText(temp.get(position).toString());// 设置内容
                        tv.setTextSize(TextSize);// 设置字体大小
                        tv.setTextColor(TextColor);// 设置字体颜色
                        tv.setPadding(5, 5, 2, 5);
                        view.addView(imageView);// 添加到LinearLayout中
                        view.addView(tv);// 添加到LinearLayout中
                        if (XDSpinner.this.getSelectedItemId() == position) {
                            imageView.setVisibility(View.VISIBLE);
                        }
                        return view;
                    }

                };
                this.setAdapter(adapter);
            }
            if (showtype == SHOW_TYPE_RADIOBUTTON) {

                // ArrayAdapter<SpinnerItem> adapter = new
                // ArrayAdapter<SpinnerItem>(mcontext,
                // android.R.layout.simple_spinner_item, temp);
                // this.setAdapter(adapter);
                Log.i("layout_span", layout_span + "*");
                Log.i("layout_drop", layout_drop + "*");
                if (layout_span == -1) {
                    ArrayAdapter<SpinnerItem> arrayAdapter = new ArrayAdapter<SpinnerItem>(
                            mcontext, android.R.layout.simple_spinner_item,
                            temp);
                    if (layout_drop == -1) {
                        arrayAdapter
                                .setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                    } else {
                        arrayAdapter.setDropDownViewResource(layout_drop);
                    }
                    this.setAdapter(arrayAdapter);
                } else {
                    ArrayAdapter<SpinnerItem> arrayAdapter = new ArrayAdapter<SpinnerItem>(
                            mcontext, layout_span, temp);
                    if (layout_drop == -1) {
                        arrayAdapter
                                .setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
                    } else {
                        arrayAdapter.setDropDownViewResource(layout_drop);
                    }
                    this.setAdapter(arrayAdapter);
                }
            }
        }
    }

    /**
     * 设置默认选择项 根据代码
     *
     * @return
     * @code 代码值
     */
    public void setDataCodeSelection(String code) {
        if (data == null) {
            return;
        }
        Boolean temp = false;
        for (int i = 0; i < data.size(); i++) {
            String text = ((SpinnerItem) data.get(i)).GetValue();
            if (text.equals(code)) {
                this.setSelection(i);
                temp = true;
                break;
            }
        }
        // if(!temp)
        // {
        // this.setSelection(1);
        // // this.setSelection(1, true);
        // }
    }

    /**
     * 设置默认选择项 根据文本
     *
     * @return
     * @valuetext 文本值
     */
    public void setDataTextSelection(String valuetext) {
        if (data == null) {
            return;
        }
        Boolean temp = false;
        for (int i = 0; i < data.size(); i++) {
            String text = ((SpinnerItem) data.get(i)).GetText();
            if (text.equals(valuetext)) {
                this.setSelection(i, true);
                temp = true;
                break;
            }
        }
        // if(!temp)
        // {
        // this.setSelection(1, true);
        // }
    }

    /**
     * 获取当前选择项 的信息
     *
     * @return
     * @flag 获取的值 1：code 代码值 0：text 显示值
     */
    public String getSpinnerCodeOrValue(String flag) {
        String temp = "";
        if (flag == null) {
            return "请输入有效的取值";
        }
        if (data != null) {
            int location = Integer.valueOf(String.valueOf(this
                    .getSelectedItemId()));
            if (flag.equals("1")) {
                temp = ((SpinnerItem) data.get(location)).GetValue();
            }
            if (flag.equals("0")) {
                temp = ((SpinnerItem) data.get(location)).GetText();
            }
        }
        return temp;
    }

    /**
     * 在SHOW_TYPE的显示状态下可以控制文本显示的大小
     *
     * @size 获取的值 1：code 代码值 0：text 显示值
     */
    public void setTextSize(int size) {
        if (size < -1) {
        } else {
            TextSize = size;
        }
    }

    /**
     * 在SHOW_TYPE的显示状态下可以控制文本显示的颜色
     *
     * @size color 文本的颜色
     */
    public void setTextColor(int color) {
        TextColor = color;
    }

    /**
     * 在动态生成控件时，设这控件在各个状态下的背景
     *
     * @showtype "1" 是圆角 "2" 是方角
     */
    public void setStyletype(String showtype) {
        Styletype = showtype;
        initDrawable(Styletype);
    }

    /**
     * 设置背景
     *
     * @normal 正常状态下背景图片
     * @select 选择状态下背景图片
     */
    public void setBackground(Drawable normal, Drawable select) {
        setDrawable = new Drawable[3];
        setDrawable[0] = normal;
        setDrawable[1] = select;
        setDrawable[2] = select;
        this.setBackgroundDrawable(setBg(setDrawable));
    }
}
