package com.xdja.combox.tabhost;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import com.xdja.combox.utils.DensityUtil;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.NinePatch;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.NinePatchDrawable;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v4.view.ViewPager.OnPageChangeListener;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.widget.ImageView.ScaleType;
import android.widget.TabHost;
import android.widget.TabHost.OnTabChangeListener;
import android.widget.TabHost.TabContentFactory;
import android.widget.TabHost.TabSpec;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TabWidget;
import android.widget.TextView;
import android.widget.Toast;

public class TabControl {
	/** 获取外部布局TabHost对象 **/
	private TabHost m_TabHost;
	private static Context m_context;
	/** 屏幕上显示的Tab数量 **/
	private int displayCount = 3;
	/** 屏幕上每一个Tab宽度 **/
	private int TabWidth = 0;
	/** 当前选择的tab位置 **/
	private int currenttablocation = 0;
	/** 记录上一次选择的tab位置 **/
	private int lasttablocation = -1;
	/** 监听器tab位置 **/
	private OnClickTabControl Tablistener = null;
	/** 每一个tab中的字体的大小 **/
	private static int textSize = 18;
	/** 每一个tab中的字体的颜色 **/
	private static int textColor = Color.WHITE;
	/** 每一个tab中的显示的文字 **/
	private String Tabshowtext[] = null;
	/** 每一个tab中的显示的图片 **/
	private List<Bitmap> showbmps = null;
	/** 每一个tabhost中的显示的子布局 **/
	private int showviewId[] = null;
	/** 每一个tab中的显示的图片 **/
	private static Drawable tabselect = null;
	/** 每一个tabhost中的显示图片 **/
	private static Drawable tabunselect = null;
	/** 每一个tab之间显示的图片 **/
	private static Drawable tabdivider = null;
	/** tabcontent内容 **/
	private View[] TabView = null;
	/** TabHost的页面标签 **/
	private TextView Lable = null;
	/** TabHost的页面标签字体大小 **/
	private int Lablesize = 18;
	/** TabHost的页面标签字体大小 **/
	private int LableColor = Color.BLACK;
	/** TabHost的页面标签背景 **/
	private Drawable LableBackground = null;
	private int LableBackgroundcolor = Color.WHITE;
	/** TabHost的页面显示带文字的标签 **/
	private Boolean ShowLable = false;
	/** TabHost的页面显示滑动的小圆点 **/
	private Boolean ShowPoint = false;
	/** TabHost的页面是否显示底部tab选项 **/
	private Boolean ShowTable = false;
	/** 圆点控件 */
	private JumpPoint point = null;
	private int radius = 10;

	/**
	 * 功能：构造函数 参数：
	 * 
	 * @param [context] 传入的Activity
	 * @param [listener] 传入的tab监听事件者
	 */
	public TabControl(Context context, final OnClickTabControl listener) {
		m_context = context;
		Tablistener = listener;
		initDrawable();
	}

	/**
	 * 功能：构造函数 参数：
	 * 
	 * @param [context] 传入的Activity
	 */
	public TabControl(Context context) {
		m_context = context;
		initDrawable();
	}

	/**
	 * 功能：初始化TabHost中每一个tab的视图 参数：
	 * 
	 * @param [tag] 传入的tab标识
	 * @param [text] 传入的显示文字
	 * @param [bmp] 传入的图片
	 * @param [viewId] 传入的TabHost的子布局
	 */
	private void setupTab(final String tag, final String text, Bitmap bmp) {
		View tabview = null;
		if (bmp == null) {
			tabview = createTabView(m_TabHost.getContext(), text, null);
		} else {
			tabview = createTabView(m_TabHost.getContext(), text, bmp);
		}
		TabSpec setContent = m_TabHost.newTabSpec(tag).setIndicator(tabview)
				.setContent(new TabContentFactory() {
					@Override
					public View createTabContent(String tag) {
						// TODO Auto-generated method stub
						return initLinearLayout();
					}
				});
		m_TabHost.addTab(setContent);
	}

	/**
	 * 功能：初始化TabHost中每一个Tab的布局 参数：
	 * 
	 * @param [context] 传入的系统上下文
	 * @param [text] 传入的显示文字
	 * @param [bmp] 传入的图片
	 */
	private static View createTabView(final Context context, final String text,
			Bitmap bmp) {
		LinearLayout mLinearLayout = new LinearLayout(context);
		mLinearLayout.setGravity(Gravity.CENTER);
		mLinearLayout.setLayoutParams(new LayoutParams(
				LayoutParams.FILL_PARENT, DensityUtil.dp2px(context, 63)));
		mLinearLayout.setOrientation(LinearLayout.VERTICAL);
		if (bmp != null) {
			ImageView mimage = new ImageView(context);
			mimage.setLayoutParams(new LayoutParams(DensityUtil.dp2px(context, 35),
					DensityUtil.dp2px(context, 35)));
			mimage.setScaleType(ScaleType.CENTER_INSIDE);
			mimage.setPadding(0,DensityUtil.dp2px(context, 5) , 0, 0);
			mimage.setImageBitmap(bmp);
			mLinearLayout.addView(mimage);
		}
		if (text != null) {
			TextView mtext = new TextView(context);
			mtext.setLayoutParams(new LayoutParams(LayoutParams.FILL_PARENT,
					LayoutParams.FILL_PARENT));
			mtext.setTextSize(textSize);
			mtext.setTextColor(textColor);
			mtext.setGravity(Gravity.CENTER_HORIZONTAL
					| Gravity.CENTER_VERTICAL);
			mtext.setPadding(0, DensityUtil.dp2px(context, 5), 0, 0);
			mLinearLayout.addView(mtext);
			mtext.setText(text);
		}
		if (tabunselect != null) {
			mLinearLayout.setBackgroundDrawable(tabunselect);
		}
		return mLinearLayout;
	}

	/**
	 * 功能：初始化当前页面显示的tab数量 参数：
	 * 
	 * @param displayCount
	 *            设置一页显示的tab数量
	 */
	private void setTabsNum(int displayCount) {
		// Get tab counts
		DisplayMetrics dm = new DisplayMetrics();
		((Activity) m_context).getWindowManager().getDefaultDisplay()
				.getMetrics(dm);
		int screenWidth = dm.widthPixels;
		TabWidth = dm.widthPixels / displayCount;
		TabWidget tabWidget = m_TabHost.getTabWidget();
		int count = tabWidget.getTabCount();
			for (int i = 0; i < count; i++) {
				tabWidget.getChildTabViewAt(i).setMinimumWidth(
						(screenWidth) / displayCount);			
		}
	}

	/**
	 * 功能：设置选中和未选中的背景切换 参数：
	 * 
	 * @param selectab
	 *            当前选中的tab位置
	 */
	private void setSelect(int selectab) {
		View vvv = m_TabHost.getTabWidget().getChildTabViewAt(selectab);
		if (tabselect != null) {
			vvv.setBackgroundDrawable(tabselect);
		}
		if (lasttablocation >= 0) {
			View vv = m_TabHost.getTabWidget().getChildTabViewAt(
					lasttablocation);
			if (tabunselect != null) {
				vv.setBackgroundDrawable(tabunselect);
			}
		}
	}

	/**
	 * 功能：设置每一个tab中字体的大小 参数：
	 * 
	 * @param size
	 *            tab中字体的大小
	 * 
	 */
	public void SetTabTextSize(int size) {
		textSize = size;
	}

	/**
	 * 功能：设置每一个tab中显示的图片 参数：
	 * 
	 * @param bmps
	 *            tab中图片集合
	 * 
	 */
	public void SetTabsBackground(List<Bitmap> bmps) {
		showbmps = bmps;
	}

	/**
	 * 功能：设置每一个tab中字体的颜色 参数：
	 * 
	 * @param _textColor
	 *            tab中字体的颜色
	 */
	public void SetTabTextColor(int _textColor) {
		textColor = _textColor;
	}

	/**
	 * 功能：设置每一页tab显示的个数 参数：
	 * 
	 * @param number
	 *            显示的数量
	 */
	public void SetTabDispaly(int number) {
		displayCount = number;
	}

	/**
	 * 功能：返回当前的tabid
	 */
	public int getCurrenttab() {
		return m_TabHost.getCurrentTab();
	}

	/**
	 * 功能：设置TabHost布局中标签Lable的字体大小
	 */
	public void SetLableSize(int size) {
		Lablesize = size;
	}

	/**
	 * 功能：设置TabHost布局中标签Lable的字体大小
	 */
	public void SetLableColor(int color) {
		LableColor = color;
	}

	/**
	 * 功能：设置TabHost布局中标签背景色
	 */
	public void SetLableBackground(Drawable bg) {
		LableBackground = bg;
	}

	/**
	 * 功能：设置TabHost布局中标签背景色
	 */
	public void SetLableBackground(int color) {
		LableBackgroundcolor = color;
	}

	/**
	 * 功能：加载定义的TabHost
	 * 
	 */
	public void ShowTabHost() {
		m_TabHost.setup();
		if (tabdivider != null) {
			m_TabHost.getTabWidget().setDividerDrawable(tabdivider);
		}
		int length = Tabshowtext.length;
		if (showbmps == null) {
			for (int i = 0; i < length; i++) {
				setupTab(String.valueOf(i), Tabshowtext[i], null);
			}
		} else {
			for (int i = 0; i < length; i++) {
				setupTab(String.valueOf(i), Tabshowtext[i], showbmps.get(i));
			}
		}
		lasttablocation = -1;
		setSelect(currenttablocation);
		setTabsNum(displayCount);
	}

	/**
	 * 功能：加载定义的TabHost的资源图片 参数：
	 * 
	 * @param [select] 传入的tab的选中图片
	 * @param [unselect] 传入的tab的未选中图片
	 * @param [divider] 传入的tab的未选中图片
	 */
	public void SetTabBitmap(Drawable select, Drawable unselect,
			Drawable divider) {
		tabselect = select;
		tabunselect = unselect;
		tabdivider = divider;
	}

	/**
	 * 功能：初始化默认的图片资源：
	 */
	private void initDrawable() {
		try {
			tabdivider = get9ImageFromAssetsFile("tabcontrol_tab_divider.9.png");
			tabunselect = getDrawableFromAssetsFile("tabcontrol_tab_unselect.png");
			tabselect = getDrawableFromAssetsFile("tabcontrol_tab_select.png");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("获取默认图片资源出错");
		}
	}

	/**
	 * 功能：获取默认的图片资源：
	 * 
	 * @param [FileName]图片名称
	 */
	private NinePatchDrawable get9ImageFromAssetsFile(String FileName) {
		InputStream stream;
		try {
			stream = m_context.getAssets().open(FileName);
			Bitmap bitmap = BitmapFactory.decodeStream(stream);
			byte[] chunk = bitmap.getNinePatchChunk();
			boolean result = NinePatch.isNinePatchChunk(chunk);
			NinePatchDrawable patchy = null;
			if (result) {
				patchy = new NinePatchDrawable(bitmap, chunk, new Rect(), null);
			}
			return patchy;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 功能：获取默认的图片资源（Drawable）：
	 * 
	 * @param [FileName]图片名称
	 */
	private Drawable getDrawableFromAssetsFile(String FileName) {
		InputStream stream;
		Drawable temp = null;
		try {
			stream = m_context.getAssets().open(FileName);
			Bitmap bitmap = BitmapFactory.decodeStream(stream);
			temp = new BitmapDrawable(bitmap);
			return temp;
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * 功能：添加tab标签
	 * 
	 * @param [_tabview] tabcontent内容
	 * @param [_text] tab显示的文字
	 */
	public TabHost AddTab(View[] _tabview, String[] _text) {
		TabView = _tabview;
		Tabshowtext = _text;
		for (int i = 0; i < TabView.length; i++) {
			TabView[i].setId(i);
		}
		return InitTabHost();
	}
	/**
	 * 功能：设置当前显示的tab
	 *       该函数在ShowTabHost()调用完后再调用
	 */
	public void setCurrenttab(int position) {
		 m_TabHost.setCurrentTab(position);
	}
	/**
	 * 功能：是否显示带文字的标签（此函数应该在AddTab之前调用设置）
	 * @param _showLable  true 显示带文字的标签   false 不显示带文字的标签
	 *        
	 */
	public void setShowLable(Boolean _showLable) {
		ShowLable = _showLable;
	}

	/**
	 * 功能：是否显示滑动的小圆点 （此函数应该在AddTab之前调用设置）
	 * @param _showPoint  true 显示小圆点 false 不显示小圆点
	 *                    在显示带文字的标签的情况下，设置该值无效
	 */
	public void setShowPoint(Boolean _showPoint) {
		ShowPoint = _showPoint;
		DisplayMetrics dm = new DisplayMetrics();
		((Activity) m_context).getWindowManager().getDefaultDisplay()
				.getMetrics(dm);
		int screenWidth = dm.widthPixels;
		radius = DensityUtil.dp2px(m_context, 6);
		/*if (screenWidth >= 480) {
			radius = DensityUtil.dp2px(m_context, 6);
		} else {
			if (screenWidth <= 320) {
				radius = DensityUtil.dp2px(m_context, 4);
				//radius = 3;
			}else {
				radius = DensityUtil.dp2px(m_context,5);
				//radius = 5;
				}
			}*/
	}
	/**
	 * 功能：是否显示底部的tab   （此函数应该在AddTab之前调用设置）
	 * @param _showtab  true 显示带文字的标签   false 不显示带文字的标签
	 * 
	 */
	public void setShowTable(Boolean _showtab) {
		ShowTable = _showtab;
	}
	/**
	 * 功能：初始化TabHost的布局
	 * 
	 */
	private TabHost InitTabHost() {
		/** TabHost参数设置 */
		m_TabHost = new TabHost(m_context);
		m_TabHost.setId(android.R.id.tabhost);
		LinearLayout.LayoutParams m_table = new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT);
		m_TabHost.setLayoutParams(m_table);
		/** Linearlayout参数设置 */
		LinearLayout m_layout = new LinearLayout(m_context);
		m_layout.setLayoutParams(new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.FILL_PARENT));
		m_layout.setOrientation(LinearLayout.VERTICAL);
		/** 标签页参数设置 */
		if (ShowLable) {
			LinearLayout m_Lablelayout = new LinearLayout(m_context);
			LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(
					LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
			layoutParams.topMargin = 4;
			layoutParams.bottomMargin = 6;
			m_Lablelayout.setLayoutParams(layoutParams);
			m_Lablelayout.setOrientation(LinearLayout.VERTICAL);
			if (LableBackground != null) {
				m_Lablelayout.setBackgroundDrawable(LableBackground);
			} else {
				m_Lablelayout.setBackgroundColor(LableBackgroundcolor);
			}
			Lable = new TextView(m_context);
			Lable.setLayoutParams(new LinearLayout.LayoutParams(
					LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT));
			m_Lablelayout.addView(Lable);
			Lable.setTextSize(Lablesize);
			Lable.setTextColor(LableColor);
			m_layout.addView(m_Lablelayout);
		}
		if (ShowPoint&&(!ShowLable)) {
			point = new JumpPoint(m_context, TabView.length, radius);
			//point.setBackgroundDrawable(m_context.getResources().getDrawable(R.drawable.tab_unselect));
			point.setBackgroundDrawable(Drawable.createFromStream(m_context.getClass().getClassLoader().getResourceAsStream("assets/XDTabHost_unselect.png"),"9.png"));
			point.setLayoutParams(new LinearLayout.LayoutParams(
					LayoutParams.FILL_PARENT,radius*4));
			m_layout.addView(point);
		}
		/** ViewPage的布局参数设置,主要是设置viewPager填满剩余的布局空间 */
		final ViewPager viewPage = new ViewPager(m_context);
		LinearLayout.LayoutParams viewPage_layoutParams = new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		viewPage_layoutParams.weight = 1.0f;
		viewPage.setLayoutParams(viewPage_layoutParams);
		m_layout.addView(viewPage);
		/** FrameLayout的布局参数设置,显示类型设置为GONE */
		FrameLayout m_framelayout = new FrameLayout(m_context);
		m_framelayout.setId(android.R.id.tabcontent);
		LinearLayout.LayoutParams framelayout_layoutParams = new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		framelayout_layoutParams.weight = 1.0f;
		m_framelayout.setVisibility(View.GONE);
		m_framelayout.setLayoutParams(framelayout_layoutParams);
		m_layout.addView(m_framelayout);
		/** TabWidget的布局参数设置，主要是设置其在外层LinearLayout的底部 */
		TabWidget m_tabWidget = new TabWidget(m_context);
		m_tabWidget.setId(android.R.id.tabs);
		RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.FILL_PARENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);
		lp.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
		m_tabWidget.setLayoutParams(lp);
		/** HorizontalScrollView的布局参数设置 */
		final HorizontalScrollView m_horizontalscroll = new HorizontalScrollView(
				m_context);
		LinearLayout.LayoutParams horizontalscroll_layoutParams = new LinearLayout.LayoutParams(
				LayoutParams.FILL_PARENT, LayoutParams.WRAP_CONTENT);
		horizontalscroll_layoutParams.weight = 0.0f;
		m_horizontalscroll.setLayoutParams(horizontalscroll_layoutParams);
		m_horizontalscroll.setVerticalScrollBarEnabled(true);
		m_horizontalscroll.setDrawingCacheBackgroundColor(0xffff0000);
		m_horizontalscroll.setFadingEdgeLength(0);
		m_horizontalscroll.addView(m_tabWidget);
		if(!ShowTable)	
		{
			m_horizontalscroll.setVisibility(View.GONE);
		}
		m_layout.addView(m_horizontalscroll);
		m_tabWidget.setStripEnabled(false);
		m_TabHost.addView(m_layout);
		m_TabHost.setOnTabChangedListener(new OnTabChangeListener() {
			@Override
			public void onTabChanged(String tabId) {
				// TODO Auto-generated method stub
				lasttablocation = currenttablocation;
				currenttablocation = m_TabHost.getCurrentTab();
				setSelect(m_TabHost.getCurrentTab());
				if (Tablistener != null) {
					Tablistener.OnClickTab(tabId);
				}
				/** 是否显示标签 */
				if (ShowLable) {
					Lable.setText(Tabshowtext[currenttablocation]);
				}
				/** TabHost滑动时让viewpage滑动 */
				viewPage.setCurrentItem(Integer.valueOf(tabId));
				if (ShowPoint&&(!ShowLable)) {
					point.setPageState(Integer.valueOf(tabId));
				}
			}
		});
		viewPage.setOnTouchListener(new View.OnTouchListener() {
			
			@Override
			public boolean onTouch(View v, MotionEvent event) {
				// TODO Auto-generated method stub
				if (Tablistener != null) {
					Tablistener.ChangeView();
				}
				return false;
			}
		});
		
		MyPagerAdapter myAdapter = new MyPagerAdapter();
		viewPage.setAdapter(myAdapter);
		viewPage.setOnPageChangeListener(new OnPageChangeListener() {

			@Override
			public void onPageSelected(int arg0) {
				/** ViewPage滑动时让TabHost改变当前的tab */
				m_TabHost.setCurrentTab(arg0);
				if (lasttablocation > arg0) {
					if (((arg0 % displayCount) + 1) >= displayCount) {
						m_horizontalscroll.scrollTo((arg0 - displayCount + 1)
								* TabWidth, 0);
					}
				}
				if (lasttablocation <= arg0) {
					if (arg0 >= displayCount) {
						m_horizontalscroll.scrollTo((arg0 - displayCount + 1)
								* TabWidth, 0);
					}
				}
				if (Tablistener != null) {
					Tablistener.ChangeView();
				}
			}

			@Override
			public void onPageScrolled(int arg0, float arg1, int arg2) {
			}

			@Override
			public void onPageScrollStateChanged(int arg0) {
			}
		});
		return m_TabHost;
	}

	private class MyPagerAdapter extends PagerAdapter {
		@Override
		public void destroyItem(View arg0, int arg1, Object arg2) {
			((ViewPager) arg0).removeView(TabView[arg1]);
		}

		@Override
		public void finishUpdate(View arg0) {
		}

		@Override
		public int getCount() {
			return TabView.length;
		}

		@Override
		public Object instantiateItem(View arg0, int arg1) {
			((ViewPager) arg0).addView(TabView[arg1], 0);
			return TabView[arg1];
		}

		@Override
		public boolean isViewFromObject(View arg0, Object arg1) {
			return arg0 == (arg1);
		}

		@Override
		public void restoreState(Parcelable arg0, ClassLoader arg1) {
		}

		@Override
		public Parcelable saveState() {
			return null;
		}

		@Override
		public void startUpdate(View arg0) {
		}
	}

	private static LinearLayout initLinearLayout() {
		LinearLayout tempLayout = new LinearLayout(m_context);
		return tempLayout;
	}
}
